/*
;;tbengine.hpp
;;
;;  TBEngine class, inherited from BEngine
;;
*/

#ifdef    I_TBENGINE
#else
#define   I_TBENGINE

#include  <cstring.h>

#include  <stdcpp.hpp>
#include  <kdbf.h>

typedef struct
{
  union
  {
    CBPROGRESSDesc rsltProgress;
    RESTCbDesc     rsltRestruct;
  } rsltUnion;
} TRsltCallback;

/*
;;class TBEngine
;;  : public BEngine
;;
;;  TBEngine, derived from BEngine
;;
*/
class TBEngine
  : public BEngine
{

  public:
                      TBEngine();

    // This constructor makes a C++ BEngine object and actually opens the
    // Paradox engine in the requested mode using default parameters.

                      TBEngine(BEngineType eType);

    // This constructor makes a C++ BEngine object and actually opens the
    // Paradox engine in the requested mode using suppiled parameters.

                      TBEngine(const BEnv& env);

    virtual           ~TBEngine();

/*
;;inline
;;virtual
;;const char*
;;TBEngine::getClassName()
;;
*/
    virtual const char* getClassName()
                        {
                          return ( "TBEngine" );
                        };

    virtual void      registerAllCallBacks( pfDBICallBack fnAll );

    void              setDebugLayerOptions( UINT16 opt, const char* fn = NULL );

    Retcode           setPrivateDirAndCheck(const char *Directory);
    //
    TRsltCallback*    bufCallBackData;
    int               maxSysLowMem;        //szCFGLOWMEMLIMIT      "LOW MEMORY USAGE LIMIT"
    long              maxSysBufSize;       //szCFGSYSMAXBUF        "MAXBUFSIZE"
    int               maxSysFileHandles;   //szCFGMAXFILEHANDLES   "MAXFILEHANDLES"
    string            prmSysLocalShare;    //szCFGSYSLOCALSHARE    "LOCAL SHARE"
    string            prmSysNetDir;        //szCFGSYSNETDIR        "NET DIR"
    string            prmSysNetType;       //szCFGSYSNETTYPE       "NET TYPE"
    string            prmSysVer;           //szCFGSYSVERSION       "VERSION"
    TRsltCallback     rsltCallback;        //Shared by all registered callbacks
    enum {            sizbufCallBackData = 100 };

  protected:
    virtual Retcode   checkExc();
    virtual void      init();
    virtual void      readCfgFile(pCHAR CfgPath, INT16 Level);
    void              throwExc( const char* fnArg,
                                const char* errArg = NULL,
                                const char* infoArg = NULL );

  private:
};

#endif//I_TBENGINE

