/*
;;tbdataba.hpp
;;
;;  TBDatabase class, inherited from BDatabase
;;
*/

#ifdef    I_TBDATABASE
#else
#define   I_TBDATABASE

#include  <kdbf.h>
#include  <tbengine.hpp>

/*
;;class
;;TSortTable
;;
;;  Struct to store sort-fields specifier for sortTable() function
*/
class
TSortTable
{
  public:
         TSortTable();
  //
  UINT16 ahSortFlds_[ DBIMAXFLDSINKEY ];
  UINT16 nSortFlds_;
};

/*
;;class
;;TSortTableFldName
;;
;;  Class to store sort-fields specifier for sortTable() function
;;  by field name
;;
*/
class
TSortTableFldName
{
public:
              TSortTableFldName();
              ~TSortTableFldName();
  //
  TSortTable* ptSortTable_;
  char*       psFldName_[ DBIMAXFLDSINKEY ];
};

class TBCursor;

/*
;;class
;;TBDatabase
;;  : public BDatabase
;;
;;  This class adds the following functionality beyond BDatabase:
;;    -New function CreateTableBorrow() creates an empty table, borrowing
;;      structure from a table in any open database. Typically used to
;;      create tables for local processing.
;;
*/
class
TBDatabase
  : public BDatabase
{
#if 0//950609
#else
  protected:
            TBDatabase( TBEngine *eng,
                       DBIOpenMode openMode = dbiREADWRITE,
                       DBIShareMode shareMode = dbiOPENSHARED);
                //This constructor present to avoid inheritence problems,
                //  and is protected since that is its only reason for existence
#endif 0//950609
  public:
#if 0//950609
            TBDatabase( TBEngine *eng,
                       const char *BDDriver,
                       const char *BDAlias = "",
                       const char *BDPassword = "",
                       DBIOpenMode openMode = dbiREADWRITE,
                       DBIShareMode shareMode = dbiOPENSHARED);
            TBDatabase( TBEngine *eng,
                       const char *BDDriver,
                       const char *BDAlias,
                       const char *BDPassword,
                       const char *BDUserName, //This is the new (SQL) parameter
                       DBIOpenMode openMode = dbiREADWRITE,
                       DBIShareMode shareMode = dbiOPENSHARED);
#endif 0//950609
            TBDatabase( TBEngine& eng,
                       DBIOpenMode openMode = dbiREADWRITE,
                       DBIShareMode shareMode = dbiOPENSHARED);
            TBDatabase( TBEngine& eng,
                       const char *BDDriver,
                       const char *BDAlias = "",
                       const char *BDPassword = "",
                       DBIOpenMode openMode = dbiREADWRITE,
                       DBIShareMode shareMode = dbiOPENSHARED);
            TBDatabase( TBEngine& eng,
                       const char *BDDriver,
                       const char *BDAlias,
                       const char *BDPassword,
                       const char *BDUserName, //This is the new (SQL) parameter
                       DBIOpenMode openMode = dbiREADWRITE,
                       DBIShareMode shareMode = dbiOPENSHARED);

    virtual ~TBDatabase();

    Retcode appendTable(const char *srcTableName,
                        const char *destTableName,
#if 0//950609
                        const char *destType = NULL,
                        const TBDatabase &db = NULL,
#else
                        const char *destType,
                        TBDatabase& dbDest,
#endif//950609
                        eBATMode xBatMode = batAPPEND );
    Retcode appendTable(const TBCursor& ptCsrSource,
                        const char *destTableName,
#if 0//950609
                        const char *destType = NULL,
                        const TBDatabase &db = NULL,
#else
                        const char *destType,
                        TBDatabase& dbDest,
#endif//950609
                        eBATMode xBatMode = batAPPEND );
    Retcode appendTable(const char* srcTableName,
                        TBCursor& ptCsrDest,
                        eBATMode xBatMode = batAPPEND );
    Retcode appendTable(const TBCursor& ptCsrSrc,
                        TBCursor& ptCsrDest,
                        eBATMode xBatMode = batAPPEND );
#if 0//950609
#else
    Retcode appendTable(const char *srcTableName,
                        const char *destTableName,
                        const char *destType,
                        eBATMode xBatMode = batAPPEND );
#endif//950609

    Retcode beginTransaction( eXILType tranType );
    Retcode beginTransaction(hDBIXact &tranHandle, eXILType tranType);

    Retcode createTable(const char *tableName,
                        int numFields, const FieldDesc *desc,
                        ValidityDesc *valDesc = NULL,
                        RefDesc *refDesc = NULL);

    Retcode createTableBorrow( const char* psTblName, const char* psBorrowFrom,
                               const TBDatabase& ptDbFrom = NULL );

    Retcode deleteTable( const char *tableName );

    Retcode deleteTableIfExists( const char* tblName );

    Retcode emptyTable(const char *tableName);

    Retcode endTransaction( eXEnd tranType );

    Retcode forceWrite();

    Retcode getDescVector( char *tableName,
                           int& numFields, FieldDesc*& desc ) const;

    bool  isRemote();

    string  getAliasName();

/*
;;inline
;;virtual
;;const char*
;;TBDatabase::getClassName() const
;;
*/
    virtual const char* getClassName() const
                        {
                          return ( "TBDatabase" );
                        };

    TBEngine*           getEngine()
                        {
                          return ( engine );
                        };

    Retcode query(const char *qryString, TBCursor &answer,
                  DBIQryLang qryLang = qrylangSQL);

    Retcode queryNoAnswer( const char *qryString,
                           DBIQryLang qryLang = qrylangSQL);

    Retcode sortTable( const char* psTblname, TSortTable& rtSortTable );
    Retcode sortTable( const char* psTblname, TSortTableFldName& rtSortTableFldName );

    BOOL    tableExists( const char *tableName );

  protected:
    Retcode query(const char *qryString, BCursor &answer,
                  DBIQryLang qryLang = qrylangSQL);

    void        throwExc( const char* fnArg,
                          const char* errArg = NULL,
                          const char* infoArg = NULL,
                          const char* aliasArg = NULL,
                          const char* tblArg = NULL ) const;
#if 0//950515
    TBEngine* ptEngine_;
#else
    TBEngine* engine;
#endif//950515

  private:
    friend class BStatement;
    friend class TBEngine;
    friend class TBCursor;
    friend class TBRecord;
    friend class TQuery;
};

#endif//I_TBDATABASE

