/*
;;blob.h
;;
    AUTHOR: Chris Smith, ccas@mcs.com


    OVERVIEW
    ========
    Class definitions for TBlob objects
*/

#if !defined(__Blob_h)
#define __Blob_h

//#include <owl\owlpch.h>
#include  <cstring.h>
#define BI_NO_BOOL//Until Borland C++ supports ANSI C++ 'bool' type
#include  <classlib\defs.h>

#include  <idapi.h>

#include "TBRecord.hpp"

//#pragma hdrstop

class TBRecord;

//=============================================================
//   CLASS TBlob  --  Helper Class for BLOB fields
//=============================================================

class TBlob
{
public:
//
//  Member Functions
//
    TBlob( const string & field_name, const string & init_data );
    TBlob( const TBlob & other );
    ~TBlob();

    TBlob & operator =  ( const TBlob & other );
    //
    //  Comparison Operators
    bool operator == ( TBlob & other )
        { return field==other.field && data==other.data; };
    bool operator != ( TBlob & other )
        { return ! (*this == other); };
    //
    //   Operations
    void Read( const TBRecord & rawRec );
    void Write( TBRecord & rawRec ) const;
    //
    //   Access Functions
    string     Field() const
                 { return field; };
    string     Data()  const
                 { return data; };
    string &   Data()
                 { return data; };


private:
//
//  Member Data
//
    const string  field;
    string        data;

};

class TBlobRO
{
  public:
  //
  //  Member Functions
  //
                  TBlobRO( const string& field_name, const TBRecord& rawRec );
                  TBlobRO( const TBlobRO& other );
                  ~TBlobRO();

/*
;;inline
;;unsigned char*
;;TBlobRO::Data()
;;
*/
    unsigned char* Data()
                  {
                    return data;
                  };

/*
;;inline
;;string
;;TBlobRO::Field() const
;;
*/
    string        Field() const
                  {
                    return field;
                  };

    UINT16        GetString( string& str, UINT16 maxLen = 0 ) const;

/*
;;inline
;;long
;;TBlobRO::Offset() const
;;
*/
    long          Offset() const
                  {
                    return ( offset );
                  };

    UINT16        Read() const;

/*
;;inline
;;const TBRecord&
;;TBlobRO::Rec() const
;;
*/
    const TBRecord& Rec() const
                  {
                    return ( *rec );
                  };

/*
;;inline
;;void
;;TBlobRO::SetOffset( long offsetArg ) const
;;
*/
    void          SetOffset( long offsetArg ) const
                  {
                    const_cast<TBlobRO*>(this)->offset = offsetArg;
                  };

/*
;;inline
;;void
;;TBlobRO::SetOffsetToEnd( long offsetArg ) const
;;
;;  Set offset to end (to append to blob)
;;
*/
    void          SetOffsetToEnd() const
                  {
                    const_cast<TBlobRO*>(this)->offset = sizeBlob;
                  };

/*
;;inline
;;long
;;TBlobRO::SizeBlob() const
;;
*/
    long          SizeBlob() const
                  {
                    return ( sizeBlob );
                  };

  private:
  //
  //  Member Data
  //
    unsigned char*  data;
    const string  field;
    UINT16        maxSegsize;
    long          offset;
    const TBRecord* rec;
    long          sizeBlob;
};

class TBlobRW
{
  public:
  //
  //  Member Functions
  //
                  TBlobRW( const string& field_name, TBRecord& rawRec );
                  TBlobRW( const TBlobRW& other );
                  ~TBlobRW();

/*
;;inline
;;unsigned char*
;;TBlobRW::Data()
;;
*/
    unsigned char* Data()
                  {
                    return data;
                  };

/*
;;inline
;;string
;;TBlobRW::Field() const
;;
*/
    string        Field() const
                  {
                    return field;
                  };

    UINT16        GetString( string& str, UINT16 maxLen = 0 ) const;

/*
;;inline
;;long
;;TBlobRW::Offset() const
;;
*/
    long          Offset() const
                  {
                    return ( offset );
                  };

    void          PutString( const string& str );

/*
;;inline
;;TBRecord&
;;TBlobRW::Rec()
;;
*/
    TBRecord&     Rec()
                  {
                    return ( *rec );
                  };

/*
;;inline
;;void
;;TBlobRW::SetOffset( long offsetArg ) const
;;
*/
    void          SetOffset( long offsetArg ) const
                  {
                    const_cast<TBlobRW*>(this)->offset = offsetArg;
                  };

/*
;;inline
;;void
;;TBlobRW::SetOffsetToEnd( long offsetArg ) const
;;
;;  Set offset to end (to append to blob)
;;
*/
    void          SetOffsetToEnd() const
                  {
                    const_cast<TBlobRW*>(this)->offset = sizeBlob;
                  };

    void          Write( unsigned char* str, UINT16 len );

  private:
  //
  //Member Data
  //
    unsigned char*  data;
    const string  field;
    UINT16        maxSegsize;
    long          offset;
    TBRecord*     rec;
    long          sizeBlob;
};

#endif

