// PXMSG.CPP  Returns error strings from error codes.
//
// For Windows, compile with -DWINDOWS so that error codes are converted
// to the ANSI character set.
//
// Note to translators: When translating these error messages, use ASCII,
// not ANSI, character set, even for Windows. For example, specify "dj"
// for "already".

// DBF - (C) Copyright 1994 by Borland International

#include "kdbf.h"
#pragma hdrstop

#ifdef __DLL__
   #define EXPORT _export
#else
   #define EXPORT
#endif

typedef struct
{
   int code;
   char far *msg;
} Message;

Message KnownMessages[] = {

    // DBF Error Messages
   {PXERR_INVENGINETYPE,   "Invalid Engine Type for this library"},
   {PXERR_ENGINEOPEN,      "Engine is already open"},
   {PXERR_ENGINENOTOPEN,   "Engine is not open"},
   {PXERR_DBALREADYOPEN,   "Database is already open"},
   {PXERR_DBNOTOPEN,       "Database is not open"},
   {PXERR_CURSORALREADYOPEN,"Cursor is already open"},
   {PXERR_CURSORNOTOPEN,    "Cursor is not open"},
   {PXERR_INVFIELDTYPE,     "Field type value supplied is invalid"}, 
   {PXERR_RECALREADYATT,    "Record is already attched to a Cursor"},
   {PXERR_RECNOTATT,        "Record is not attached to a Cursor"},
   {PXERR_INVCURRRECORD,    "Cursor is not positioned on a valid record"}, 
   {PXERR_TABLESDIFFER,     "Tables corresponding to Cursors are different"},
   {PXERR_INVKEYCOUNT,      "Invalid number of key values for current index"},  
   {PXERR_NOKEYMAP,         "Key map for compound key has not been specified"},  
   {PXERR_NOCLEARNULL,      "clearNull is not allowed on Generic Records"},
   {PXERR_DATACONV,         "Data conversion of a field's value failed"},   
   {PXERR_BLOBNOTOPEN,      "Blob field is not open"},

   // KDBF Error messages
   {PXERR_STATEMENTOPEN,    "Statement is open"},
   {PXERR_STATEMENTNOTOPEN, "Statement is not open" }
   };

#define KnownMsgSize ( sizeof(KnownMessages) / sizeof(KnownMessages[0]) )


// internal error >200
//
char far *interror = "Internal error no: ";
char far *undef    = "Undefined errorcode";


static char errMsg[DBIMAXMSGLEN * 5];   // Area in which a message is stored.

//
// Returns the error message text for a given error code.
//

char far * pascal far EXPORT PXOopErrMsg(Retcode errCode)
{
    int i;
    char far *pOemStr = NULL;
    DBIErrInfo ErrInfo;

    // Get DBF Error
    for (i = 0; i < KnownMsgSize; i++ )
    {
        if(KnownMessages[i].code == errCode)
        {
            pOemStr = KnownMessages[i].msg;
            break;
        }
    }

    // If not an old error message
    if (!pOemStr)
    {
        if ((errCode != DBIERR_CANTFINDODAPI) &&
            (errCode != DBIERR_NOTINITIALIZED))
        {
            DbiGetErrorInfo(TRUE, &ErrInfo);

            // Check if last error is not the error for which information
            // is desired - DbiGetErrInfo only return information on
            // the last Error....
            if (ErrInfo.iError == errCode)
            {
                sprintf(errMsg, "%s\r\n%s\r\n%s\r\n%s\r\n%s",
                        ErrInfo.szErrCode,
                        ErrInfo.szContext1, ErrInfo.szContext2,
                        ErrInfo.szContext3, ErrInfo.szContext4);
            }
            else
            {
                DbiGetErrorString(errCode, errMsg);
            }
        }
        else
        {
            if (errCode != DBIERR_NOTINITIALIZED)
            {
                strcpy(errMsg, "BDE Not Initialized");
            }
            else
            {
                strcpy(errMsg, "Can't find BDE DLLs");
            }
        }
        pOemStr = errMsg;
    }

    return pOemStr;
}

