// except.h
#if !defined(__KDBFEX_H)
#define __KDBFEX_H

#include <cstring.h>

class TXFBase : public xmsg {
  public:
    TXFBase(const string& msg);
    TXFBase(const TXFBase& src);
    virtual ~TXFBase();

    virtual TXFBase* Clone();
    virtual void Throw();

    static int InstanceCount;
};

class TXKdbf : public TXFBase {
  public:
    TXKdbf(const string& msg, DBIResult errVal = DBIERR_NONE);
    TXKdbf(DBIResult errVal);
   ~TXKdbf();

    TXKdbf* Clone();
    void Throw();
    unsigned GetErrorCode() const {return rslt;}
    TXKdbf& operator =(DBIResult rslt) {Set(rslt); return *this;}
    operator int() const {return rslt;}

  public:
    DBIResult rslt;

  protected:
    void Set(DBIResult errVal) { rslt = errVal; }
};

//
//
#if defined(_KDBF_EXCEPTIONS)
  #define TRY         try
  #define THROW(x)    throw x
  #define THROWX(x)   x.Throw()   // Classes derived from TXKdbf can use this
  #define RETHROW     throw
  #define CATCH(x)    catch x
#else
  #define TRY                     // try block is executed normally
  #define THROW(x)    abort()     // abort on any exception
  #define THROWX(x)   abort()
  #define RETHROW     return lastError; // only used in catch clauses
  #define CATCH(x)                // exception & code is arg to macro
#endif

#endif  // __KDBFEX_H
