/*
;;envdef.h
;;
;;  Changes and additions by //BR
;;
*/
/***********************************************************************
**                            ENVDEF.H
** This file contains structure, type and error definitions used
** throughout the object layer.
**
***********************************************************************/

// DBF - (C) Copyright 1994 by Borland International

#if !defined( ENVDEF_H )
#define ENVDEF_H
#ifdef WINDOWS
#include <windows.h>
#endif
#include <idapi.h>
#include <string.h>
#include <new.h>
#include <except.h>
#include "compat.h"

//BR BEG
#ifdef DBIDATE//950515
#else
typedef long      DBIDATE;
typedef DBIDATE   far *pDBIDATE;
#endif//950515
#ifdef DBIFLOAT//950515
#else
typedef double    DFLOAT;
typedef DFLOAT    far *pDFLOAT;      
#endif//950515
//BR END

#ifdef _MSC_VER
  #define _CLASSTYPE
#endif

// Global defines.

#define MAXNAMELEN      DBIMAXNAMELEN        // Name limit for tables, fields, etc.)
#define MAXPATHLEN      DBIMAXPATHLEN        // Length of DOS path.

// Engine type for Paradox -- Local, Network or Windows.

enum BEngineType {pxLocal=1, pxNet=2, pxWin=3};

// File Share mode for the DOS Paradox Engine (local or network).

// NetShare to share only network files; LocalShare to share lock local 
// and network files; with NoShare, neither local or network files 
// will be shared. 

enum PXDosShare {pxLocalShare=0, pxNetShare, pxNoShare}; 

// Lock mode for the Windows Paradox Engine; With SingleClient,
// no locking. 

enum PXWinShare {pxShared=0, pxSingleClient=1, pxExclusive=2};


// Sort order for the Paradox Engine;  

enum PXSortOrder {pxAscii=1,pxIntl,pxNorDan,pxNorDan4,pxSwedFin}; 

enum PXTabCrtMode {px35Fmt=3,px40Fmt=4,px50Fmt=5};
                                                            
// Table lock mode for the Paradox Engine.

enum PXTblLckMode {px40Lck=0,px35Lck=1};

// Modes for creating a new index on a table.

enum PXKeyCrtMode {pxPrimary=0, pxSecondary, pxIncSecondary};

// Modes for Paradox locks.

enum PXLockMode {pxFL=1, pxWL, pxPWL, pxPFL};

// Modes for Paradox searches.

enum PXSearchMode {pxSearchFirst=keySEARCHEQ, pxGreater=keySEARCHGT,
                   pxClosestRecord=keySEARCHGEQ, pxSearchNext=3};

// Modes for BLOB open.

enum PXBlobOpenMode {pxBlobRead = 0, pxBlobWrite};

// Values for a cursor's status.  

enum PXCursorStatus {atRecord = 0, atBegin, atEnd, atCrack}; 

// Environment structure for specifying engine's parameters.   

class _CLASSTYPE BEnv { 
public:
  BEngineType   engineType;
  int           bufSize;
  int           maxTables;
  int           maxRecBufs;
  int           maxLocks;
  int           maxFiles;
  PXSortOrder   sortOrder;
  PXTabCrtMode  tabCrtMode;

  // Fields relevant for Engine operation in network mode.

  PXDosShare    dosShare;
  char          netNamePath[MAXPATHLEN+1];
  char          userName[MAXNAMELEN+1];
  PXTblLckMode  tabLckMode;

  // Fields relevant for the Windows Paradox Engine.

  PXWinShare    winShare;
  char          clientName[MAXNAMELEN+1];
  DBIPATH       workingDirectory;
  DBIPATH       initializationFile;
  char          language[MAXNAMELEN+1];

// IDAPI
  INT16         tblMaxSize;
  char          reserved[18];       // Reserved for future use.

  BEnv() { memset(this,0,sizeof(BEnv)); }    // initialize to zeros 
  
  };
                  

// Error code returned by most functions.

typedef DBIResult Retcode;

typedef unsigned    FIELDNUMBER;            // Field number; 1 .. N
typedef hDBICur     TABLEHANDLE;            // Table handle
typedef hDBIDb      DATABASEHANDLE;         // Handle to a database
typedef UINT32      LOCKHANDLE;             // Lock handle
typedef INT32       RECORDNUMBER;           // Record number; 1 .. N
typedef pBYTE       RECORDHANDLE;           // Record handle
typedef int         BLOBHANDLE;             // BLOB handle
typedef pBYTE       BOOKMARK;               // Handle to a bookmark

// Field Description Structure.

enum PXFieldType
    {
    fldUnknown = 0, fldChar, fldDate, fldBlob, fldBool, fldShort, fldLong,
    fldDouble, fldBcd, fldCharIdapi, fldTime, fldTimeStamp, fldUInt16,
    fldUInt32, fldFloatIEEE, fldVarBytes, fldLockInfo
    };

enum PXFieldSubtype
    {
    fldstNone = 0, fldstPassword = 1, fldstMoney=21, fldstMemo=22,
    fldstBinary=23,  fldstFmtMemo=24, fldstOleObj=25, fldstGraphic=26,
    fldstDBSoleObj=27, fldstTypedBinary=28
    };
    
typedef struct {
  FIELDNUMBER    fldNum;                // Field number (1..n).
  char           fldName[MAXNAMELEN+1]; // Null-terminated field name.
  PXFieldType    fldType;               // Field type.
  PXFieldSubtype fldSubtype;            // Field Subtype.
  int            fldLen;                // Field Length; for BLOBs;
                                        // the header length.
  char           reserved[20];          // For future use.
  } FieldDesc;


// A custom record's field and map definition structure. Used in custom
// record subclasses of BRecord.    

typedef struct 
  { 
  int           useCnt;      // Number of instances using this descriptor.          
  int           fieldCnt;    // Count of fields in the custom record.
  FieldDesc     far *desc;   // Descriptor array for custom record's fields 
  FIELDNUMBER  *tblFldNbr;   // Array maps custom record field numbers 
                             // to table's fields. Elements that don't  
                             // have a corresponding table field must 
                             // be set to 0.                                                                               
  } CRFldMapdef; 


// Default Date structure.
typedef struct  {
  int     year;   
  char    month;  
  char    day;
} BDate;

typedef struct  {
  UINT16  hour;
  UINT16  minute;
  UINT16  milSec;
} BTime; 

typedef struct  {
  BDate BDay;
  BTime BHour;
} BTimeStamp;

typedef struct {
  UINT16    valChkCount;
  pCROpType cropType;
  pVCHKDesc vchkDesc;
  } ValidityDesc;

typedef struct {
  UINT16    rintCount;
  pCROpType cropType;
  pRINTDesc rintDesc;
  } RefDesc;


// the _CLASSTYPE macro is Borland C++ specific. It ensures
// proper declaration of the DBF classes for use in a DLL.
// For Microsoft C++, it is #defined to nothing at the top
// of this header file.

class _CLASSTYPE BDbObject;
class _CLASSTYPE BEngine;
class _CLASSTYPE BDatabase;
class _CLASSTYPE BCursor;
class _CLASSTYPE BRecord;
class _CLASSTYPE BStatement;

// The following error definitions are copied from PXENGINE.H. They
// are included here so that the Database Framework programmer does 
// not have to include PXENGINE.H. 

#ifndef PXSUCCESS
#define PXSUCCESS DBIERR_NONE 

// initialization errors

#define PXERR_NOTINITERR        DBIERR_NOTINITIALIZED    // Engine not initialized
#define PXERR_ALREADYINIT       DBIERR_MULTIPLEINIT    // Engine already initialized
#define PXERR_NOTLOGGEDIN       98   // Could not login on network (to PARADOX.NET)
#define PXERR_NONETINIT        107   // Engine not initialized with PXNetInit
#define PXERR_NETMULTIPLE       DBIERR_NETMULTIPLE    // multiple PARADOX.NET files
#define PXERR_CANTSHAREPDOXNET 134   // can't lock PARADOX.NET -- is SHARE.EXE loaded?
#define PXERR_WINDOWSREALMODE  135   // can't run Engine in Windows real mode


// hardware related errors

#define PXERR_DRIVENOTREADY     1    // Drive not ready
#define PXERR_DISKWRITEPRO      124  // Disk is write protected
#define PXERR_GENERALFAILURE    126  // General hardware error


// directory reg error codes

#define PXERR_DIRNOTFOUND       DBIERR_INVALIDDIR   // Directory not found
#define PXERR_DIRBUSY           DBIERR_DIRBUSY   // Sharing violation
#define PXERR_DIRLOCKED         DBIERR_DIRLOCKED   // Sharing violation
#define PXERR_DIRNOACCESS       DBIERR_DIRNOACCESS   // No access to directory
#define PXERR_DIRNOTPRIVATE     DBIERR_DIRNOTPRIVATE    // Single user, but directory is shared


// file oriented errors

#define PXERR_FILEBUSY          DBIERR_FILEBUSY    // File is busy
#define PXERR_FILELOCKED        DBIERR_LOCKED    // File is locked
#define PXERR_FILENOTFOUND      DBIERR_NOSUCHTABLE    // Could not find file


// table oriented errors

#define PXERR_TABLEBUSY        DBIERR_FILEBUSY    // Table is busy
#define PXERR_TABLELOCKED      DBIERR_LOCKED   // Table is locked
#define PXERR_TABLENOTFOUND    DBIERR_NOSUCHTABLE   // Table was not found
#define PXERR_TABLEOPEN        DBIERR_TABLEOPEN    // Unable to perform operation on open table
#define PXERR_TABLEINDEXED     DBIERR_NOTINDEXED   // Table is indexed
#define PXERR_TABLENOTINDEXED  DBIERR_NOTINDEXED     // Table is not indexed
#define PXERR_TABLEEMPTY       DBIERR_INVALIDTABLE    // Operation on empty table
#define PXERR_TABLEWRITEPRO    DBIERR_TABLEREADONLY   // Table is write protected
#define PXERR_TABLEPRE40       DBIERR_BADFORMAT    // Feature not available for pre Paradox 4.0 tables

#define PXERR_TABLECORRUPTED   DBIERR_FILECORRUPT   // Table is corrupted
#define PXERR_TABLEFULL        DBIERR_TABLEFULL  // Table is full
#define PXERR_TABLESQL         DBIERR_TABLESQL   // Table is SQL replica
#define PXERR_INSUFRIGHTS      DBIERR_NOTSUFFTABLERIGHTS    // Insufficient password rights
#define PXERR_CANTUPGRADE       92   // Table too old to upgrade, or
                                     // existing table header too small.
#define PXERR_LOCKTIMEOUT      DBIERR_LOCKTIMEOUT  // Timed out trying to achieve a lock.


// index oriented errors

#define PXERR_XCORRUPTED        DBIERR_INDEXCORRUPT     // Primary index is corrupted
#define PXERR_XOUTOFDATE        DBIERR_INDEXOUTOFDATE     // Primary index is out of date
#define PXERR_XSORTVERSION      DBIERR_DIFFSORTORDER   // Sort for index different from table

#define PXERR_SXCORRUPTED       DBIERR_INDEXCORRUPT   // Secondary index is corrupted
#define PXERR_SXOUTOFDATE       DBIERR_INDEXOUTOFDATE    // Secondary index is out of date
#define PXERR_SXNOTFOUND        DBIERR_NOSUCHINDEX  // Secondary index was not found
#define PXERR_SXOPEN            DBIERR_INDEXOPEN    // Not used-here for backwards compatability
#define PXERR_SXCANTUPDATE      136                 // Can't update table open on non-maintained secondary

#define PXERR_RECTOOBIG         DBIERR_RECTOOBIG   // Record too big for index


// record oriented errors

#define PXERR_RECDELETED       DBIERR_RECDELETED   // Another user deleted record
#define PXERR_RECLOCKED        DBIERR_ALREADYLOCKED   // Record is locked
#define PXERR_RECNOTFOUND      DBIERR_RECNOTFOUND   // Record was not found
#define PXERR_KEYVIOL          DBIERR_KEYVIOL   // Key violation

#define PXERR_ENDOFTABLE       DBIERR_EOF   // End of table
#define PXERR_STARTOFTABLE     DBIERR_BOF   // Start of table


// errors specific for Windows Engine DLL

#define PXERR_TOOMANYCLIENTS        DBIERR_CLIENTSLIMIT
    // Check mapping
#define PXERR_EXCEEDSCONFIGLIMITS   DBIERR_INVALIDCFGPARAM
#define PXERR_CANTREMAPFILEHANDLE   DBIERR_INVALIDHNDL


// resource errors

#define PXERR_OUTOFMEM          DBIERR_NOMEMORY   // Not enough memory to complete operation
#define PXERR_OUTOFDISK         DBIERR_NODISKSPACE   // Not enough disk space to complete operation
#define PXERR_OUTOFSTACK        DBIERR_NOMEMORY   // Not enough stack space to complete operation
#define PXERR_OUTOFSWAPBUF      DBIERR_NOMEMORY   // Not enough swap buffer space to complete operation

#define PXERR_OUTOFFILEHANDLES  DBIERR_NOFILEHANDLES   // No more file handles available
#define PXERR_OUTOFTABLEHANDLES DBIERR_CURSORLIMIT   // No more table handles available
#define PXERR_OUTOFRECHANDLES   DBIERR_NOMEMORY   // No more record handles available
#define PXERR_OUTOFLOCKHANDLES  DBIERR_LOCKFILELIMIT   // Too many locks on table

#define PXERR_NOMORETMPNAMES    ERRCODE_NOTEMPTBLSPACE   // No more temporary names available
#define PXERR_TOOMANYPASSW      DBIERR_PASSWORDLIMIT   // Too many passwords specified


// invalid parameters to functions

#define PXERR_TYPEMISMATCH      30   // Data type mismatch
#define PXERR_OUTOFRANGE        DBIERR_OUTOFRANGE   // Argument out of range
#define PXERR_INVPARAMETER      DBIERR_INVALIDPARAM   // Invalid argument
#define PXERR_INVDATE           DBIERR_INVALIDDATE   // Invalid date given

#define PXERR_INVFIELDHANDLE    DBIERR_INVALIDHNDL   // Invalid field handle
#define PXERR_INVRECHANDLE      DBIERR_INVALIDHNDL   // Invalid record handle
#define PXERR_INVTABLEHANDLE    DBIERR_INVALIDHNDL   // Invalid table handle
#define PXERR_INVLOCKHANDLE     DBIERR_INVALIDHNDL   // Invalid lock handle

#define PXERR_INVDIRNAME        DBIERR_INVALIDDIR   // Invalid directory name
#define PXERR_INVFILENAME       DBIERR_INVALIDFILENAME   // Invalid file name
#define PXERR_INVTABLENAME      DBIERR_INVALIDTABLENAME  // Invalid table name
#define PXERR_INVFIELDNAME      DBIERR_INVALIDFIELDNAME   // Invalid field name

#define PXERR_INVLOCKCODE      106   // Invalid lock code
#define PXERR_INVUNLOCK         DBIERR_UNLOCKFAILED   // Invalid unlock
#define PXERR_INVSORTORDER      DBIERR_DIFFSORTORDER   // Invalid sort order table
#define PXERR_INVPASSW          DBIERR_INVALIDPASSWORD   // Invalid password
#define PXERR_INVNETTYPE        DBIERR_UNKNOWNNETTYPE   // Invalid net type (PXNetInit)
#define PXERR_BUFTOOSMALL       DBIERR_BUFFTOOSMALL   // Buffer too small for result

#define PXERR_STRUCTDIFFER      DBIERR_DIFFERENTTABLES   // Table structures are different

#define PXERR_INVENGINESTATE    79   // Previous fatal error; cannot proceed


// Blob error codes

#define PXERR_BLOBMODE           51     // Operation not applicable for Blob's
                                        // open mode.
#define PXERR_BLOBOPEN           DBIERR_BLOBOPENED     // Blob already open.
#define PXERR_BLOBINVOFFSET      DBIERR_INVALIDBLOBOFFSET     // Invalid offset into Blob.
#define PXERR_BLOBINVSIZE        DBIERR_INVALIDBLOBLEN     // Invalid size for Blob.
#define PXERR_BLOBMODIFIED       DBIERR_BLOBMODIFIED     // Another user modified Blob.
#define PXERR_BLOBCORRUPT        DBIERR_MEMOCORRUPT      // Blob file corrupted.
#define PXERR_BLOBNOINDEX        DBIERR_INVALIDINDEXCREATE     // Cannot index on a Blob.
#define PXERR_BLOBINVHANDLE      DBIERR_INVALIDBLOBHANDLE     // Invalid Blob handle.
#define PXERR_BLOBNOSEARCH       60     // Can't search on a Blob field.


// Locking related error codes

#define PXERR_INUSEBYPDOX35      16     // Directory is in use by Paradox 3.5
                                        // or Paradox Engine 2.0

#endif 

// Database Framework function that returns the error message 
// corresponding to an error number.

char far *pascal far PXOopErrMsg(Retcode errCode);

// Database Framework errors.

#define PXERR_INVENGINETYPE     400
#define PXERR_ENGINEOPEN        401
#define PXERR_ENGINENOTOPEN     402
#define PXERR_DBALREADYOPEN     403
#define PXERR_DBNOTOPEN         404
#define PXERR_CURSORALREADYOPEN 405
#define PXERR_CURSORNOTOPEN     406
#define PXERR_RECALREADYATT     407
#define PXERR_RECNOTATT         408
#define PXERR_INVFIELDTYPE      409
#define PXERR_INVCURRRECORD     410
#define PXERR_TABLESDIFFER      411
#define PXERR_INVKEYCOUNT       412  
#define PXERR_NOKEYMAP          413
#define PXERR_NOCLEARNULL       414 
#define PXERR_DATACONV          415
#define PXERR_BLOBNOTOPEN       DBIERR_BLOBNOTOPENED
#define PXERR_STATEMENTOPEN     417
#define PXERR_STATEMENTNOTOPEN  418

// GENERATE Utility Errors 

#define PXERR_INCOMPLETESPEC    501 
#define PXERR_NOSPECFILE        502
#define PXERR_INVOPTION         503
#define PXERR_CANTCREATEFILE    504
#define PXERR_NOLEFTPAREN       505
#define PXERR_NOCOMMAORRP       506 
#define PXERR_INVCHARLEN        507 
#define PXERR_INVTYPEWARN       508 

#endif
