// DBF - (C) Copyright 1994 by Borland International

#ifndef __STATEMNT_H
#define __STATEMNT_H

#include "envdef.h"
#include "bdbobjec.h"
#include "bcursor.h"

class BStatement : public BDbObject {

public:
    Retcode lastError;
    BOOL    isOpen;

public:

    // BStatement constructor

    BStatement(BDatabase *db);

    // BStatement destructor

    ~BStatement();

    // Prepare the Query

    Retcode open(const char *QryString,
                 DBIQryLang QryLang = qrylangSQL);

    // Execute the query

    Retcode execute(BCursor &answer);

    // Release memory acquired by the statement

    Retcode close(void);

    // Properties specific to statements
    // Will Add specific function in the future for the individual properties
    //
    // stmtMAXPROPS        //ro UINT16        Number of defined properties
    // stmtPARAMETERCOUNT  //ro UINT16        Count of parameters
    // stmtPARAMETERDESCS  //ro aFLDDesc      Array of parameters
    // stmtUNIDIRECTIONAL  //rw BOOL          Cursor Unidirectional
    // stmtANSTYPE         //rw pBYTE         Table Type of Answer set
    // stmtLIVENESS        //rw LIVENESS      preference for canned/live
    //                                          answers
    // stmtQRYMODE         //rw QryEvalMode   execute on server or local or
    //                                          either
    // stmtBLANKS          //rw BOOL          True if blanks to be regarded as
    //                                          zeros.
    // stmtDATEFORMAT      //rw FMTDate       Date format
    // stmtNUMBERFORMAT    //rw FMTNumber     Number format
    // stmtAUXTBLS         //rw BOOL          True if QBE to create CHANGED,
    //                                          etc.
    // stmtTBLVECTOR       //ro UINT16        Vector of tables generated by
    //                                          query.
    // stmtALLPROPS        //rw QueryLowProps
    // stmtALLPROPSSIZE    //rw INT16         size of QueryLowProps
    // stmtANSNAME         //rw pBYTE         Answer Table Name.

    // Set a property of the query

    Retcode setProp(UINT32 prop, UINT32 value);

    // Set if the answer table is a dynaset
    
    Retcode setLive(LIVENESS live);

    // Get a property of the Query

    Retcode getProp(UINT32 prop, pVOID value, UINT16 maxLen,
                    UINT16 &retLen);
                            
    // Set the parameters of the query

    Retcode setParameters(UINT16 numFields, pFLDDesc fldDescs,
                          pBYTE recBuf);

    // Get the handle of the statement. WARNING: be carefull when using the
    // handle outside of the class.

    hDBIStmt getHandle(void);

    // Redefine pure virtuals from the BDbObject class.

    virtual char *nameOf() const;
    virtual void printOn(ostream& os);


protected:

    hDBIStmt        hStmt;
    BDatabase       *stmtDb;

    // Don't allow the copy constructor to be called unless specifically
    //   defined
    BStatement(BStatement &copyCur);
    // Don't allow the assignment opperator to be called unless specifically
    //   defined

    BStatement& operator=(BStatement &copyDB);
};

#endif