/*********************************************************************
**
**                    BLISTCUR.H
**
** Implement functions of the BEngine class.
**
*********************************************************************/

// DBF - (C) Copyright 1994 by Borland International

#ifndef __BLISTCUR_H
#define __BLISTCUR_H

#include "envdef.h"
#include "bdbobjec.h"
#include "intstrct.h"
#include "bcursor.h"
#include <string.h>

template<class T> class BListCursor : public BDbObject {

public:
    Retcode     lastError;
    BOOL        isOpen;

public:

    BListCursor();
    ~BListCursor();

    // Attach the BListCursor class to an existing TABLEHANDLE
    
    Retcode attach(TABLEHANDLE tableHandle);

    // Go to the beginning of the cursor

    Retcode gotoTop();

    // Go to the bottom of the cursor

    Retcode gotoBottom();

    // Get the next record

    Retcode getNextRecord(T &data);

    // Get the current record
    
    Retcode getRecord(T &data);

    // Close the table handle
    
    Retcode close();

    // Return the handle to the cursor. WARNING: be carefull when using
    // the handle outside of the class

    TABLEHANDLE getHandle();

    // Redefine pure virtuals from the BDbObject class.

    virtual char *nameOf() const { return "BListCursor"; }
    virtual void printOn(ostream& os) { os << nameOf()
                                           << " Open Status = "
                                           << (isOpen ? "TRUE" : "FALSE")
                                           << endl; }

protected:
    TABLEHANDLE tabH;
};

template<class T>
BListCursor<T>::BListCursor()
{
    tabH = NULL;
    isOpen = FALSE;
}

template<class T>
BListCursor<T>::~BListCursor()
{
    close();
    tabH = NULL;
    isOpen = FALSE;
}

template<class T>
Retcode BListCursor<T>::close()
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiCloseCursor(&tabH);

    isOpen = FALSE;
    tabH = NULL;

    return lastError;
}

template<class T>
Retcode BListCursor<T>::attach(TABLEHANDLE tableHandle)
{
    if (isOpen)
    {
        return (lastError = PXERR_CURSORALREADYOPEN);
    }

    if (tableHandle == NULL)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    tabH = tableHandle;
    isOpen = TRUE;
    lastError = DBIERR_NONE;

    return lastError;
}


template<class T>
Retcode BListCursor<T>::gotoTop()
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiSetToBegin(tabH);

    return lastError;
}

template<class T>
Retcode BListCursor<T>::gotoBottom()
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiSetToEnd(tabH);

    return lastError;
}
  
template<class T>
Retcode BListCursor<T>::getNextRecord(T &data)
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiGetNextRecord(tabH, dbiNOLOCK, (pBYTE)&data, NULL);

    return lastError;
}

template<class T>
Retcode BListCursor<T>::getRecord(T &data)
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiGetRecord(tabH, dbiNOLOCK, (pBYTE)&data, NULL);

    return lastError;
}

template<class T>
TABLEHANDLE BListCursor<T>::getHandle()
{
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return 0;
    }

    lastError = DBIERR_NONE;
    
    return tabH;
}


#endif
