/*********************************************************************
**
**                          BENGINE.H
**
** This file defines the interface of the BEngine class.
** This class contains methods for connecting to the IDAPI
** engine and performing engine-level operations.
**
*********************************************************************/

// DBF - (C) Copyright 1994 by Borland International

#ifndef BENGINE_H
#define BENGINE_H

#include "envdef.h"
#include "bdbobjec.h"
#include "blistcur.h"

class BEngine : public BDbObject {

    friend class BDatabase;
    friend class BCursor;

public:
    Retcode     lastError;
    BOOL        isOpen;
    BEngineType engineType;

public:
    
    // This constructor makes a C++ BEngine object without actually opening
    // the Paradox engine.

    BEngine();

    // This constructor makes a C++ BEngine object and actually opens the
    // Paradox engine in the requested mode using default parameters.

    BEngine(BEngineType eType);

    // This constructor makes a C++ BEngine object and actually opens the
    // Paradox engine in the requested mode using suppiled parameters.

    BEngine(const BEnv& env);

    // Destructor; Closes the engine if it's open.

    virtual ~BEngine();

    // Sets the engine type and various other parameters.

    virtual Retcode setDefaults(const BEnv& env);

    // Open the Paradox Engine based on a previously set  environment.

    virtual Retcode open(void);

    // Close the currently open engine.

    virtual Retcode close(void);

    // Get the current values of all engine configuration parameters.

    virtual void getDefaults(BEnv& env) const;

    // Enable or Disable the internal harware error handler.

    Retcode setHWHandler(BOOL ehEnable);

    // Add a password to the engine's password list.

    Retcode addPassword(char *password);

    // Set the maximum size of for tables created with this engine.

    Retcode setMaxTblSize(int maxSize);

    // Set the table create mode for the engine (3.5 or 4.0 file format).

    Retcode setTblCreateMode(PXTabCrtMode crtMode);

    // Delete a previously entered password.

    Retcode deletePassword(char *password);

    // Find the name of the current user in the shared environment.

    char *getUsername(void);

    // Get the error message corresponding to a error number.

    virtual char far *getErrorMessage(int errnbr);

    virtual Retcode getErrorContext(INT16 context, char far *message);
    virtual Retcode getErrorEntry(UINT16 entry, UINT32 &nativeCode,
                                  char far *message);
    virtual Retcode GetErrorInfo(DBIErrInfo &errorInfo);
    
    // Get the handle of the current session.
    
    hDBISes getHandle(void);

    // Session functions
  
    // Sets the private directory for the current session -
    // all temporary or auxiliary tables are created in this
    // directory.

    // Note - these functions are not fully supported by the
    //        KDBF. Closing one of the sessions will not
    //        automatically close the KDBF wrapper for child
    //        objects, such as BDatabase and BCursor objects.

    Retcode startSession(hDBISes &sessionHandle,
                         const char *netFile = NULL);
                                 
    Retcode getCurrSession(hDBISes &sessionHandle);
    
    Retcode setCurrSession(hDBISes &sessionHandle);

    Retcode closeSession(hDBISes &sessionHandle);

    Retcode getSessionInfo(SESInfo &sessionInfo);

    Retcode setPrivateDir(const char *Directory);

    Retcode getPrivateDir(char *Directory );

    Retcode getSysVersion(UINT16 &version1,
                          UINT16 &interfaceLevel,
//BR BEG
#if 0//950515
                          DATE &versionDate,
#else
                          DBIDATE &versionDate,
#endif//950515
//BR END
                          TIME &versionTime);

    Retcode getSysConfig(BOOL   &localShare, UINT16 &netProtocol,
                         BOOL   &netShare, CHAR   *netType,
                         CHAR   *userName, CHAR   *iniFile,
                         CHAR   *langDriver);

    Retcode getClientInfo(CHAR   *name,
                          UINT16 &sessions,
                          CHAR   *workingDirectory,
                          CHAR   *language);

    Retcode getSysInfo(UINT16 &bufferSpace,
                       UINT16 &heapSpace,
                       UINT16 &drivers,
                       UINT16 &clients,
                       UINT16 &sessions,
                       UINT16 &databases,
                       UINT16 &cursors);

    Retcode openDriverList(BListCursor<DRVType> &driverList);

    Retcode openDatabaseList(BListCursor<DBDesc> &databaseList);

    Retcode openTableTypesList(BListCursor<TBLType> &tableTypesList,
                               const char *driver = szPARADOX);

    Retcode openFieldTypesList(BListCursor<FLDType> &fieldTypesList,
                               const char *driver = szPARADOX,
                               const char *tableType = NULL);

    Retcode openIndexTypesList(BListCursor<IDXType> &indexTypesList,
                               const char *driver = szPARADOX);

    Retcode openLanguageDriverList(BListCursor<LDDesc> &langaugeDriverList);

    Retcode openUserList(BListCursor<USERDesc> &userList);

    Retcode openCfgInfoList(BListCursor<CFGDesc> &cfgList, const char *cfgPath,
                            hDBICfg cfgH = NULL,
                            DBIOpenMode openMode = dbiREADONLY,
                            CFGMode cfgMode = cfgPersistent);

    virtual Retcode useIdleTime(void);

    Retcode registerCallBack(CBType callBackType, UINT32 clientData,
                             UINT16 callBackBufferLength,
                             pVOID callBackBuffer,
                             pfDBICallBack callBackFunction);

    Retcode getCallBack(CBType callBackType, UINT32 &clientData,
                        UINT16 &callBackBufferLength,
                        ppVOID callBackBuffer,
                        ppfDBICallBack callBackFunction);


    // pure virtuals from the BDbObject class.

    virtual char *nameOf() const;
    virtual void printOn( ostream& os);

protected:
    // Don't allow the copy constructor to be called unless specifically
    // defined

    BEngine(BEngine &copyCur);

    // Don't allow the assignment opperator to be called unless specifically
    // defined

    BEngine& operator=(BEngine &copyEng);

private:
    void  *engobj;  // variable used to keep track of
                    // engine's objects.
};

#endif

