/*
;;utils.cpp
;;
;;	Non-class functions
;;
;;  Commenting conventions:
;;    NOTWIN32  This line is not Win32-compatible
;;
*/

#pragma		hdrstop

//RTL, Classlib includes
#include  <ctype.h>
#include  <dir.h>
#include  <dos.h>
#include  <errno.h>
#include	<stdio.h>
#include	<string.h>
#include	<time.h>
//#include	<owl\owlcore.h>

//3d party includes
#include	<stdcpp.hpp>

//Module-specific include
#include	<utils.hpp>

//Prototype for funct. in brecord.cpp
Retcode
strToTimeStamp(const char *str, BTimeStamp *dt);

/*
;;TIntString::TIntString( long n )
;;
;;  Convert int (or long int) to string type
;;
*/
TIntString::TIntString( long n )
{
  char buf[ 25 + 1 ]; //Allow for max sprintf %ld length
  sprintf(buf, "%ld", n );
  str = buf;
};

char
TUtil::sDateTimeString[] = {0};

/*
;;static int
;;TUtil::ChDir( const char* psPath )
;;
;;  Works with or without trailing backslash, unlike RTL chdir()
;;
;;  Returns 0 on success.
;;
*/
int
TUtil::ChDir( const char* psPath )
{
  string bufPath = psPath;
  if ( '\\' == bufPath.get_at( bufPath.length() - 1 ) )
      //? Trailing backslash
  {
    if ( ':' != bufPath.get_at( bufPath.length() - 2 ) )
        //Remove only if trailing backslash follows dirname (don't remove
        //  root dir backslash)
    {
      bufPath.put_at( bufPath.length() - 1, '\0' ); //Rmv trailing backslash
    }
  }
  return ( chdir( bufPath.c_str() ) );
}

/*
;;static bool
;;TUtil::CnvStrToUnix( const char* psdTime, long& rdTime )
;;
;;  Convert timestamp string to unix form time. The following forms
;;  are acceptable:
;;    MM/DD/YYYY HH:MM:SS
;;    HH:MM:SS MM/DD/YYYY
;;    MM/DD/YYYY          (00:00:00 assigned)
;;
*/
bool
TUtil::CnvStrToUnix( const char* psdTime, long& rdTime )
{
  BTimeStamp tdTimestamp;
  if ( DBIERR_NONE != strToTimeStamp( psdTime, &tdTimestamp ) )
  {
    return ( false );
  }
  return ( CnvTimestampToUnix( &tdTimestamp, rdTime ) );
}

/*
;;static bool
;;TUtil::CnvTimestampToUnix( BTimeStamp* pdTimestamp,
;;                           long& rdTime )
;;
;;  Convert BTimeStamp fmt to Unix fmt (secs. since 1970)
;;
*/
bool
TUtil::CnvTimestampToUnix( BTimeStamp* pdTimestamp, long& rdTime )
{
#if 1
  struct date tdDate;
  struct time tdTime;
  //
#if 0
  tdDate.da_year = pdTimestamp->BDay.year - 1980;   /* Year - 1980 */
#else
  tdDate.da_year = pdTimestamp->BDay.year;   /* Year - 1980 */
#endif//0
  tdDate.da_day = pdTimestamp->BDay.day;            /* Day of the month */
  tdDate.da_mon = pdTimestamp->BDay.month;          /* Month (1 = Jan) */
  tdTime.ti_min = pdTimestamp->BHour.minute;     /* Minutes */
  tdTime.ti_hour = pdTimestamp->BHour.hour;    /* Hours */
  tdTime.ti_hund = 0;    /* Hundredths of seconds */
  tdTime.ti_sec = pdTimestamp->BHour.milSec / 1000;     /* Seconds */
  rdTime = dostounix( &tdDate, &tdTime ); //NOTWIN32
#endif//0
  return ( true ); //OK
}

/*
;;static bool
;;TUtil::CnvTimestrToSec( const char* psdTime,
;;                        long& rdTime )
;;
;;  Convert 24hr. Timestring (hh:mm:ss) to seconds
;;
*/
bool
TUtil::CnvTimestrToSec( const char* psdTime, long& rdTime )
{
  int dHr;
  int dMin;
  int dSec;
  char sBuf[ 2 + 1 ];
  //
  if ( 0 == strlen( psdTime ) )
  {
    return ( false ); //Error
  }
  //Hr
  strncpy( sBuf, psdTime, 2 );
  sBuf[ 2 ] = '\0';
  dHr = atoi( sBuf );
  //Min
  strncpy( sBuf, psdTime + 3, 2 );
  sBuf[ 2 ] = '\0';
  dMin = atoi( sBuf );
  //Sec
  strncpy( sBuf, psdTime + 6, 2 );
  sBuf[ 2 ] = '\0';
  dSec = atoi( sBuf );
  //
  rdTime = (long) dHr * 3600 + dMin * 60 + dSec;
  return ( true ); //OK
}

/*
;;static bool
;;TUtil::CnvTimeToBTime( const char* psTime,
;;                       BTime& rBTime )
;;
;;  Converts time string 'hh:mm:ss' to BTime struct
;;  0-len time string returns 00:00:00
;;
*/
bool
TUtil::CnvTimeToBTime( const char* psTime, BTime& rBTime )
{
  if ( 0 == strlen( psTime ) )
  {
    rBTime.hour = 0;
    rBTime.minute = 0;
    rBTime.milSec = 0;
  }
  else
  {
    int n;
    n = ( *psTime - '0' ) * 10;
    ++psTime;
    n += ( *psTime - '0' );
    ++psTime;
    ++psTime; //:
    rBTime.hour = n;
    n = ( *psTime - '0' ) * 10;
    ++psTime;
    n += ( *psTime - '0' );
    ++psTime;
    ++psTime; //:
    rBTime.minute = n;
    n = ( *psTime - '0' ) * 10;
    ++psTime;
    n += ( *psTime - '0' );
    rBTime.milSec = n * 1000;
  }
  return ( true ); //Success
}

/*
;;static bool
;;TUtil::CnvUnixToStr( long dTime,
;;                     char* psTime )
;;
;;  Cnv unix-fmt datetime to sql-ready string
;;
*/
bool
TUtil::CnvUnixToStr( long dTime, char* psdTime )
{
#if 1
  struct date tdDate1;
  struct time tdTime1;
  //
  unixtodos( dTime, &tdDate1, &tdTime1 );
	sprintf( psdTime, " %02d/%02d/%4d  %02d:%02d:%02d ",
#if 0
				tDate1.da_mon, tDate1.da_day, tDate1.da_year + 1980,
#else
				tdDate1.da_mon, tdDate1.da_day, tdDate1.da_year,
#endif//0
				tdTime1.ti_hour, tdTime1.ti_min, tdTime1.ti_sec );
#endif//0
  return ( true ); //OK
}

/*
;;static string
;;TUtil::CnvUnixToString( long dTime )
;;
;;  Cnv unix-fmt datetime to sql-ready string
;;
*/
string
TUtil::CnvUnixToString( long dTime )
{
  struct date tdDate1;
  struct time tdTime1;
  char psdTime[ 6 * 10 + 20 + 1 ];
  string str;
  //
  unixtodos( dTime, &tdDate1, &tdTime1 );
	sprintf( psdTime, " %02d/%02d/%4d  %02d:%02d:%02d ",
				    tdDate1.da_mon, tdDate1.da_day, tdDate1.da_year,
				    tdTime1.ti_hour, tdTime1.ti_min, tdTime1.ti_sec );
  str = psdTime;
  return ( str );
}

/*
;;static int
;;TUtil::GetCWD( char* ps, int nBufLen )
;;
;;  Get cwd, including drive prefix, and ensure trailing '\' is in place
;;
;;  Return:
;;    0 on success, != 0 otherwise
;;
*/
int
TUtil::GetCWD( char* ps, int nBufLen )
{
  if ( NULL == getcwd( ps, nBufLen ) )
  {
    if ( 0 == errno )
    {
      return ( -1 ); //Unknown error
    }
    //Else return errno
    return ( errno );
  }
  if ( nBufLen < strlen( ps ) + 1 )
  {
    return ( ENOMEM ); //Buflen ovr
  }
  if ( '\\' != ps[ strlen( ps ) - 1 ] )
  {
    strcat( ps, "\\" );
  }
  return ( 0 ); //0 is OK
}

/*
;;static char*
;;TUtil::GetDateTime( int hours,
;;						 				int minutes,
;;						 				int seconds,
;;						 				time_t external_time )
;;
;;	Converts integer date/time values to timestamp string, formatted as:
;;		' mm/dd/yyyy hh:mm:ss '
;;
;;  Return:
;;    Pointer to static char*
;;
*/
char*
TUtil::GetDateTime( int hours, int minutes, int seconds, time_t external_time )
{
	time_t my_time;
	struct tm *thedate;
	//
	if( external_time == 0 )
	{
		time( &my_time );
		my_time = my_time + seconds + minutes * 60 + hours * 3600;
		thedate = localtime( &my_time );
	}
	else
	{
		external_time = external_time + seconds + minutes * 60 + hours * 3600;
		thedate = localtime( &external_time );
	}
	sprintf( sDateTimeString, " %02d/%02d/%4d  %02d:%02d:%02d ",
				thedate->tm_mon+1, thedate->tm_mday, thedate->tm_year + 1900,
				thedate->tm_hour, thedate->tm_min, thedate->tm_sec );
	return ( sDateTimeString );
}

/*
;;static long
;;TUtil::GetTimeFromMidnight()
;;
;;  Return:
;;    Number of seconds since midnight (local time)
;;
*/
long
TUtil::GetTimeFromMidnight()
{
	time_t dTime;
	struct tm *pdtTime;
	//
  time( &dTime );
	pdtTime = localtime( &dTime );
  return ( (long) pdtTime->tm_hour * 3600 + pdtTime->tm_min * 60 + pdtTime->tm_sec  );
}

/*
;;static bool
;;TUtil::IsValidPath( const char* path )
;;
;;  Works with or without trailing backslash
;;
*/
bool
TUtil::IsValidPath( const char* path )
{
  char buf[ MAXPATH ];
  bool isDir = (bool) TRUE; //Default exists
  //
  if ( NULL != GetCWD( buf, MAXPATH ) ) //Use TUtil::GetCWD(), not getcwd()
  {
    TTdbfExc::ThrowExc( "IsValidPath()", "GetCWD()" );
  }
  if ( 0 != ChDir( path ) ) //Try to change to specified dir.
  {
    isDir = (bool) FALSE; //Does not exist
  }
  if ( 0 != ChDir( buf ) ) //Try to change back to orig. working dir.
  {
    TTdbfExc::ThrowExc( "IsValidPath()", "ChDir()" );
  }
  return ( isDir );
}

/*
;;static int
;;TUtil::LookUp( char* key,
;;				char** table )
;;
;;	Lookup string key in table, return index to it
;;
*/
int
TUtil::LookUp( char* key, char** table )
{
	int i = 0;

	while( table[i][0] != 0 )
	{
		if( strcmp( key, table[i] ) == 0 )
		{
			return i;
		}
		i++;
	}
	return -1;
}

/*
;;static void
;;TUtil::MakePath( const char* psFrom, char* psTo )
;;
;;  Appends trailing '\\' to psTo if not present
;;
*/
void
TUtil::MakePath( const char* psFrom, char* psTo )
{
  strcpy( psTo, psFrom );
  int n = strlen( psTo ) - 1;
  if ( '\\' != psTo[ n ] )
  {
    strcat( psTo, "\\" );
  }
}

/*
;;static bool
;;TUtil::SetDriveAndCwd( const char* psPath )
;;
;;  Sets both current drive and working directory on that drive
;;    Works with or without trailing backslash
;;
*/
bool
TUtil::SetDriveAndCwd( const char* psPath )
{
  if ( '\0' == *psPath )
  {
    return ( true ); //OK
  }
  //Else have path string
  if ( ':' == *( psPath + 1 ) ) //? Drive prefix present
  {
    int gPath = toupper( *psPath ) - 'A';
    setdisk( gPath );
    if ( gPath != getdisk() )
    {
      return ( false ); //Error
    }
    psPath += 2;
  }
  return ( (bool) (0 == ChDir( psPath ) ) ); //OK/Error
}

/*
;;static char*
;;TUtil::TrimXStr( char* psBuf );
;;
;;  Strip any leading and trailing whitespace from string psBuf
;;    (Returns pointer to new start of string, which will differ from psBuf
;;    if leading whitespace was removed)
;;
;;  All control characters and 8bit ascii chrs are stripped (< 0x20, >0x7F)
;;
*/
unsigned char*
TUtil::TrimXStr( unsigned char* psBuf )
{
  unsigned char* begStr = psBuf;
  while ( '\0' != *begStr )
  {
    if ( 0x20 <= *begStr && 0x7F >= *begStr ) //? Valid chr
    {
      break;
    }
    //Else is whitespace or term null, inc.
    ++begStr;
  }
  unsigned char* endStr = begStr + strlen( (char*) begStr ) - 1;
  while ( '\0' != *endStr )                   //? Valid chr
  {
    if ( 0x20 <= *endStr && 0x7F >= *endStr )
    {
      break;
    }
    //Else is whitespace or term null, inc.
    --endStr;
  }
  *( endStr + 1 ) = '\0'; //Null-terminate
  return ( begStr );
}

/*
;;static void
;;TTdbfExc::ThrowExc( const char* fnArg,
;;                    const char* errArg = NULL,
;;                    const char* infoArg = NULL,
;;                    const char* classArg = NULL, //(Defaults to TUtil)
;;                    Retcode     lastErrorArg = -1,
;;                    const char* aliasArg = NULL,
;;                    const char* tblArg = NULL,
;;                    const char* fldArg = NULL )
;;
;;  Creates and throws TTdbfExc object, initializing data members as appr.
;;
*/
void
TTdbfExc::ThrowExc( const char* fnArg,
                    const char* errArg,
                    const char* infoArg,
                    const char* classArg,
                    Retcode     lastErrorArg,
                    const char* aliasArg,
                    const char* tblArg,
                    const char* fldArg )
{
  TTdbfExc excTdbf;
  if ( NULL != aliasArg )
  {
    excTdbf.aliasName = aliasArg;  //Alias name (if available)
  }
  if ( NULL != classArg )
  {
    excTdbf.className = classArg;
  }
  else
  {
    excTdbf.className = "TUtil";
  }
  if ( NULL != errArg )
  {
    excTdbf.errMsg = errArg;
  }
  if ( NULL != fldArg )
  {
    excTdbf.fldName = fldArg;
  }
  if ( NULL != fnArg )
  {
    excTdbf.fnName = fnArg;
  }
  if ( NULL != infoArg )
  {
    excTdbf.errInfo = infoArg;
  }
  excTdbf.lastError = lastErrorArg;
  if ( NULL != tblArg )
  {
    excTdbf.tblName = tblArg;
  }
  throw ( excTdbf );
}

