/*
;;tquery.cpp
;;
;;  **OBS--use tquery_2.cpp classes for all new design
;;
;;  Design notes:
;;
;;    950503
;;      o Nice option would be to pass opt. trx type to query
;;
*/

#pragma   hdrstop

//RTL, Classlib includes
#include  <strstrea.h>

//3d party includes
//#include  <kdbf.h>
#include  <stdcpp.hpp>
#include  <tdbf.hpp>

//Module-specific includes
//#include  <tquery.hpp>

#if 0//950520
extern strstream* winout;
#endif//950520

/*
;;TQuery::TQuery( TBEngine* ptEngineArg,
;;                TBDatabase* ptDatabaseArg )
;;
;;  **OBS--use TQueryAnswer and TQueryNoAnswer for all new design
;;
;;  Constructor for TQuery
;;
*/
TQuery::TQuery( TBEngine* ptEngineArg, TBDatabase* ptDatabaseArg )
  : lastError( DBIERR_NONE )
{
  ptCsr_ = 0;
  ptDatabase_ = ptDatabaseArg;
  ptEngine_ = ptEngineArg;
  ptRec_ = 0;
}

/*
;;virtual
;;TQuery::~TQuery()
;;
;;  **OBS--use TQueryAnswer and TQueryNoAnswer for all new design
;;
;;  Destructor for TQuery
;;
*/
TQuery::~TQuery()
{
  DELETE_SAFE( ptRec_ ); //Only if not using genericRec!
  DELETE_SAFE( ptCsr_ );
}

/*
;;Retcode
;;TQuery::Query( const char* psQuerystring,
;;               DBIQryLang xQryLang = qrylangSQL )
;;
;;  **OBS--use TQueryAnswer and TQueryNoAnswer for all new design
;;
;;  Use only for queries returning no answer (delete, etc.)
;;
;;    Will throw TTdbfExc exception if query returns (unexpected) answer cursor
;;
;;    Will also throw TTdbfExc exception on any other error (app should
;;      catch)--original query string included in TTdbfExc.errInfo member
;;
*/
Retcode
TQuery::Query( const char* psQuerystring,
               DBIQryLang xQryLang  )
{
  Retcode x;
  //
  try
  {
    x = ptDatabase_->queryNoAnswer( psQuerystring, xQryLang );
  }
  catch ( TTdbfExc excTdbf )
  {
    lastError = excTdbf.lastError;
    string buf;
    buf = excTdbf.fnName;
    buf += ": ";
    buf += excTdbf.errMsg;
    ThrowExc( "Query()", buf.c_str(), psQuerystring );
  }
  if ( DBIERR_NONE != x )
  {
    lastError = ptDatabase_->lastError;
    ThrowExc( "Query()", NULL, psQuerystring );
  }
  return ( lastError );
}

/*
;;Retcode
;;TQuery::Query( const char* psQuerystring, TBCursor*& rptCsrOut, TBRecord*& rptRecOut,
;;               DBIQryLang xQryLang  )
;;
;;  **OBS--use TQueryAnswer and TQueryNoAnswer for all new design
;;
;;    Will throw TTdbfExc exception if query does not return (expected) answer cursor
;;
;;    Will also throw TTdbfExc exception on any other error (app should
;;      catch)--original query string included in TTdbfExc.errInfo member
;;
*/
Retcode
TQuery::Query( const char* psQuerystring, TBCursor*& rptCsrOut, TBRecord*& rptRecOut,
               DBIQryLang xQryLang  )
{
  bool b = false;
  ptCsr_ = new TBCursor();
  Retcode x;
  //
  try
  {
    x = ptDatabase_->query( psQuerystring, *ptCsr_, xQryLang );
  }
  catch ( TTdbfExc excTdbf )
  {
    lastError = excTdbf.lastError;
    string buf;
    buf = excTdbf.fnName;
    buf += ": ";
    buf += excTdbf.errMsg;
    ThrowExc( "Query()", buf.c_str(), psQuerystring );
  }
  if ( DBIERR_NONE != x )
  {
    if( ptDatabase_->lastError == 9990 )
    {
      b = true;
    }
  }
  else
  {
    b = true;
  }
  if ( ! b )
  {
    DELETE_SAFE( ptCsr_ );
#if 0//950520
    *winout << "query error (DB) = " << ptDatabase_->lastError;
    *winout << " (ENG) = " << ptEngine_->lastError << " \n";
    *winout << ptEngine_->getErrorMessage( ptEngine_->lastError ) << "\n";
    *winout << "QUERY >> " << psQuerystring << "\n";
    //return ( kxFailure );
    throw ( ptDatabase_->lastError );
#else
    lastError = ptDatabase_->lastError;
    ThrowExc( "Query()", NULL, psQuerystring );
#endif//950520
  }
  //ptRec = ptCsr->genericRec;
  ptRec_ = new TBRecord( *ptCsr_ ); //Must be deleted by caller!
  rptCsrOut = ptCsr_;
  rptRecOut = ptRec_;
  return ( lastError );
}

/*
;;Retcode
;;TQuery::Query( strstream* ptQuerystream,
;;               DBIQryLang xQryLang = qrylangSQL )
;;
;;  **OBS--use TQueryAnswer and TQueryNoAnswer for all new design
;;
;;  Use only for queries returning no answer (delete, etc.)
;;
;;    Will throw TTdbfExc exception if query returns (unexpected) answer cursor
;;
;;    Will also throw TTdbfExc exception on any other error (app should
;;      catch)--original query string included in TTdbfExc.errInfo member
;;
*/
Retcode
TQuery::Query( strstream* sqlstr, DBIQryLang xQryLang )
{
  char sQuerybuffer[1024];
  //
  *sqlstr << ends;
  sqlstr->getline( sQuerybuffer, 1023, '\0' );

  if( sqlstr->peek() != EOF )
  {
    ThrowExc( "Query()", "SQL statement too large" );
  }

  return ( Query( sQuerybuffer, xQryLang ) );
}

/*
;;Retcode
;;TQuery::Query( strstream* ptQuerystream,
;;               TBCursor*& rptCsrOut,
;;               TBRecord*& rptRecOut,
;;               DBIQryLang xQryLang = qrylangSQL )
;;
;;  **OBS--use TQueryAnswer and TQueryNoAnswer for all new design
;;
;;    Will throw TTdbfExc exception if query does not return (expected) answer cursor
;;
;;    Will also throw TTdbfExc exception on any other error (app should
;;      catch)--original query string included in TTdbfExc.errInfo member
;;
*/
Retcode
TQuery::Query( strstream* sqlstr, TBCursor*& rptCsrOut, TBRecord*& rptRecOut,
               DBIQryLang xQryLang )
{
  char sQuerybuffer[1024];
  //
#if 0//950518
  sqlstr->getline( sQuerybuffer, 1023, ';' );
#else
  *sqlstr << ends;
  sqlstr->getline( sQuerybuffer, 1023, '\0' );
#endif//950518

  if( sqlstr->peek() != EOF )
  {
#if 0//950520
    *winout << "SQL statement too large !!";
    return ( -1 );
#else
    ThrowExc( "Query()", "SQL statement too large" );
#endif//950520
  }

//  *winout << querybuffer << "\n";

  return ( Query( sQuerybuffer, rptCsrOut, rptRecOut, xQryLang ) );
}

/*
;;Retcode
;;TQuery::Query( const char* psQuerystring,
;;               const char* psTblResult,
;;               TBDatabase* ptDbResult,
;;               DBIQryLang  xQryLang = qrylangSQL,
;;
;;  **OBS--use TQueryAnswer and TQueryNoAnswer for all new design
;;
;;    Will throw TTdbfExc exception if query does not return (expected) answer cursor
;;
;;    Will also throw TTdbfExc exception on any other error (app should
;;      catch)--original query string included in TTdbfExc.errInfo member
;;
*/
Retcode
TQuery::Query( const char* psQuerystring, const char* psTblResult,
               TBDatabase* ptDbResult, DBIQryLang xQryLang )
{
  int       n;
  TBCursor* ptCsr; //Dummy for call
  TBRecord* ptRec; //Dummy for call
  //
  n = Query( psQuerystring, ptCsr, ptRec, xQryLang );
  if ( DBIERR_NONE != n )
  {
    return ( n );
  }
#if 0//950523
  ptDbResult->deleteTable( psTblResult );
  switch ( ptDbResult->lastError )
  {
    case DBIERR_NONE :
    case DBIERR_NOSUCHFILE :
    case DBIERR_NOSUCHTABLE :
      break;
    default :
      ThrowExc( "Query()" );
  }
#else
  if ( DBIERR_NONE != ptDbResult->deleteTableIfExists( psTblResult ) )
  {
    ThrowExc( "Query()" );
  }
#endif//950523
  //if ( DBIERR_NONE != ptDatabase->appendTable( ptCsr, psTblResult, NULL, *ptDbResult, batCOPY ) )
  if ( DBIERR_NONE != ptDatabase_->appendTable( *ptCsr, psTblResult, szPARADOX, *ptDbResult, batCOPY ) )
  {
#if 0//950520
    *winout << "appendTable(): " << ptEngine_->getErrorMessage( ptDatabase_->lastError ) << "\n";
#else
    ThrowExc( "Query()" );
#endif//950520
  }
  return ( ptDatabase_->lastError );
}

/*
;;Retcode
;;TQuery::Query( strstream* sqlstr,
;;               const char* psTblResult,
;;               TBDatabase* ptDbResult,
;;               DBIQryLang xQryLang = qrylangSQL )
;;
;;  **OBS--use TQueryAnswer and TQueryNoAnswer for all new design
;;
;;    Will throw TTdbfExc exception if query does not return (expected) answer cursor
;;
;;    Will also throw TTdbfExc exception on any other error (app should
;;      catch)--original query string included in TTdbfExc.errInfo member
;;
*/
Retcode
TQuery::Query( strstream* sqlstr, const char* psTblResult,
               TBDatabase* ptDbResult, DBIQryLang xQryLang )
{
  char sQuerybuffer[1024];
  //
  sqlstr->getline( sQuerybuffer, 1023, ';' );

  if( sqlstr->peek() != EOF )
  {
#if 0//950520
    *winout << "SQL statement too large !!";
    return ( -1 );
#else
    ThrowExc( "Query()", "SQL statement too large" );
#endif//950520
  }

//  *winout << querybuffer << "\n";

  return ( Query( sQuerybuffer, psTblResult, ptDbResult, xQryLang ) );
}

/*
;;protected:
;;void
;;TQuery::ThrowExc( const char* fnArg,
;;                  const char* errArg = NULL,
;;                  const char* infoArg = NULL )
;;
;;  **OBS--use TQueryAnswer and TQueryNoAnswer for all new design
;;
*/
void
TQuery::ThrowExc( const char* fnArg,
                  const char* errArg,
                  const char* infoArg )
{
  TTdbfExc::ThrowExc( fnArg,
                   errArg,
                   infoArg,
                   "TQuery",
                   lastError,
                   ptDatabase_->Alias );
}

