/*
;;tdbf.hpp
;;
;;  Include file to use TBCursor, TBDatabase, TBEngine, TBRecord,
;;    TQuery
;;
;;  General TDBF notes:
;;
;;    x TTdbfExc exceptions are thrown to application for all errors except:
;;        x "normal" errors like EOF on getNextRecord()
;;
;;    x "constness" of functions ("const" suffix) is applied using the following
;;        rules:
;;
;;        x A TBCursor/TBDatabase/TBRecord/TQueryAnswer/TQueryNoAnswer function
;;            is regarded as "const" if it does not affect the underlying table,
;             database, or record.
;;
;;            Prerequisite writes to the IDAPI record buffer (in TBRecord) are
;;            regarded as "non-const" operations, as are functions whose express
;;            purpose is to prepare for a write (e.g., openBlobWrite() ).
;;
;;            lockRecord() and unlockRecord() are regarded as non-const.
;;
;;            Transaction operations (beginTransaction(), endTransaction() )
;;            are regarded as non-const, since beginning or ending a transaction
;;            does affect the database state.
;;
;;            As of 950607, only TBRecord, TQueryAnswer and TQueryNoAnswer have
;;            const functions assigned in this manner.
;;
;;        x Note that the TBCursor/TBDatabase/TBRecord/TQueryAnswer/TQueryNoAnswer
;;            object is NOT guaranteed not to be changed when the const suffix is
;;            present--constness with these classes is with regard to the DATABASE,
;;            not the WRAPPER around it. Changes to the WRAPPER object state are
;;            "casted" away (e.g., member data lastError) using the const_cast<>(this)
;;            operator.
;;
*/

#ifdef    I_TDBF
#else
#define   I_TDBF

//RTL includes
#define BI_NO_BOOL//Until Borland C++ supports ANSI C++ 'bool' type
#include  <classlib\defs.h>
#include  <string.h>

//3d-party includes
#define   WINDOWS//For envdef.h
#include  <kdbf.h>

//TDBF lib includes
#include  <blob.h>
#include  <heapptr.h>
#include  <tbcursor.hpp>
#include  <tbdataba.hpp>
#include  <tbengine.hpp>
#include  <tbrecord.hpp>
#include  <tquery.hpp>
#include  <tquery_2.hpp>
#include  <utils.hpp>

/*
;;class
;;TTdbfExc
;;
;;  Exception object thrown by all tdbf exceptions (incl. TUtil)
;;
;;  public:
;;    const string& AliasName() const
;;    const string& ClassName() const
;;    const string& ErrMsg() const
;;    const string& FldName() const
;;    const string& FnName() const
;;    const string& IdapiMsg() const
;;    Retcode       LastError() const
;;    const string& ErrInfo() const
;;    const string& TblName() const
;;
;;    const string& GetAliasName(); **OBS use AliasName()
;;    const string& GetClassName(); **OBS use ClassName()
;;    const string& GetErrMsg();    **OBS use ErrMsg()
;;    const string& GetFldName();   **OBS use FldName()
;;    const string& GetFnName();    **OBS use FnName()
;;    const string& GetIdapiMsg();  **OBS use IdapiMsg()
;;    Retcode       GetLastError(); **OBS use LastError()
;;    const string& GetErrInfo();   **OBS use ErrInfo()
;;    const string& GetTblName();   **OBS use TblName()
;;
;;    **OBS These data members will no longer be publicly accessable
;;                  in the future. Use the above selector functions instead.
;;;
;;    string  aliasName;  //Alias name (if available)
;;    string  className;  //Class name (Tutil, TBEngine, etc.)
;;    string  errMsg;     //Error message
;;    string  fldName;    //Field name (if available)
;;    string  fnName;     //Caller function in which error occurred
;;    Retcode lastError;  //IDAPI error code (if available)
;;    string  errInfo;    //Error message aux. info
;;    string  tblName;    //Table name (if available)
*/
class
TTdbfExc
{
  public:
    const string& AliasName() const
    {
      return ( aliasName );
    }
    const string& ClassName() const
    {
      return ( className );
    }
    const string& ErrMsg() const
    {
      return ( errMsg );
    }
    const string IdapiMsg() const
    {
      if ( 0x7FFF == lastError )
      {
        return ( "" );
      }
      else
      {
        return ( PXOopErrMsg( lastError ) );
      }
    }
    const string& FldName() const
    {
      return ( fldName );
    }
    const string& FnName() const
    {
      return ( fnName );
    }
    Retcode       LastError() const
    {
      return ( lastError );
    }
    const string& ErrInfo() const
    {
      return ( errInfo );
    }
    const string& TblName() const
    {
      return ( tblName );
    }

    const string& GetAliasName()
    {
      return ( aliasName );
    }
    const string& GetClassName()
    {
      return ( className );
    }
    const string& GetErrMsg()
    {
      return ( errMsg );
    }
    const string GetIdapiMsg()
    {
      if ( 0x7FFF == lastError )
      {
        return ( "" );
      }
      else
      {
        return ( PXOopErrMsg( lastError ) );
      }
    }
    const string& GetFldName()
    {
      return ( fldName );
    }
    const string& GetFnName()
    {
      return ( className );
    }
    Retcode       GetLastError()
    {
      return ( lastError );
    }
    const string& GetErrInfo()
    {
      return ( errInfo );
    }
    const string& GetTblName()
    {
      return ( tblName );
    }
    static void       ThrowExc( const char* fnArg,
                                const char* errArg = NULL,
                                const char* infoArg = NULL,
                                const char* classArg = NULL,
                                Retcode     lastErrorArg = 0x7FFF,
                                const char* aliasArg = NULL,
                                const char* tblArg = NULL,
                                const char* fldArg = NULL );
    //
    string  aliasName;  //Alias name (if available)
    string  className;  //Class name (Tutil, TBEngine, etc.)
    string  errMsg;     //Error message
    string  fldName;    //Field name (if available)
    string  fnName;     //Caller function in which error occurred
    Retcode lastError;  //IDAPI error code (if available)
    string  errInfo;    //Error message aux. info
    string  tblName;    //Table name (if available)
};

#endif//I_TDBF

