/*
;;tbcursor.hpp
;;
;;  TBCursor class, inherited from BCursor
;;
;;  Design notes
;;    950609
;;      x const TBCursor& = NULL not supported in arglists for TBCursor class
;;
*/

#ifdef    I_TBCURSOR
#else
#define   I_TBCURSOR

#include  <kdbf.h>

#include  <stdcpp.hpp>
#include  <tbdataba.hpp>

class TBRecord;

/*
;;class TBCursor
;;  : public BCursor
;;
;;  This class adds the following functionality beyond BCursor:
;;    -Throws exception to app for getRecord(), insertRec(), appendRec(),
;;      nextrec() errors other than 'usual' ones (EOF, locked by other
;;      user, etc.)
;;
*/
class TBCursor
  : public BCursor
{
  public:

    // Constructor. Make a BCursor object without opening any Paradox tables.

                    TBCursor();
                    TBCursor(TBDatabase& dbArg,
                              const char* tableName,
                              int indexID = 0,
                              BOOL saveEveryChange = FALSE,
                              DBIOpenMode openMode = dbiREADWRITE,
                              DBIShareMode shareMode = dbiOPENSHARED,
                              XLTMode xltMode = xltFIELD );
                    TBCursor(TBDatabase& dbArg,
                              const char* tableName,
                              const char *tableType,
                              int indexID,
                              DBIOpenMode openMode = dbiREADWRITE,
                              DBIShareMode shareMode = dbiOPENSHARED,
                              XLTMode xltMode = xltFIELD);
                    TBCursor(TBDatabase& dbArg,
                              const char* tableName,
                              const char* indexName,
                              DBIOpenMode openMode = dbiREADWRITE,
                              DBIShareMode shareMode = dbiOPENSHARED,
                              XLTMode xltMode = xltFIELD);
                    TBCursor(TBDatabase& dbArg,
                              const char* tableName,
                              const char* indexName,
                              const char* indexTagName,
                              DBIOpenMode openMode = dbiREADWRITE,
                              DBIShareMode shareMode = dbiOPENSHARED,
                              XLTMode xltMode = xltFIELD);

                    // Copy constructor: uses DBICloneCursor to duplicate cursor
                    TBCursor(const TBCursor &copyCur);

    // Destructor; closes the engine if it's open.
    virtual         ~TBCursor();

    // Assignment operator: Assign a new cursor to this one, duplicating it in
    //   the process.
    TBCursor& operator=(const TBCursor &copyCur);

    Retcode         appendRec();
    Retcode         appendRec( TBRecord& rec );
    Retcode         appendRec(const void far *buffer, int size);

    Retcode         attach( TBDatabase& dbArg, TABLEHANDLE tableHandle );

    Retcode         clearRec();
    Retcode         clearRec( TBRecord& rec );

    virtual Retcode  close();

    virtual Retcode   closeIfOpen();

    /*
;;inline
;;virtual
;;const char*
;;TBCursor::getClassName()
;;
*/
    virtual const char* getClassName() const
                        {
                          return "TBCursor";
                        };

    RECORDNUMBER    getCurRecNum() const;

    Retcode         getFirstRecord( TBRecord& rec ) const;
    Retcode         getFirstRecord() const;

    Retcode         getLastRecord( TBRecord& rec ) const;
    Retcode         getLastRecord() const;

    Retcode         getNextRecord( TBRecord& rec ) const;
    Retcode         getNextRecord() const;

    Retcode         getPreviousRecord( TBRecord& rec ) const;
    Retcode         getPreviousRecord() const;

    RECORDNUMBER    getRecCount() const;

    Retcode         getRecord( TBRecord& rec ) const;
    Retcode         getRecord() const;
    Retcode         getRecord( void far *buffer, int size );

    string          getTableName();

    Retcode         gotoBegin() const;

    Retcode         gotoEnd() const;

    Retcode         gotoRec( RECORDNUMBER recNum ) const;

    Retcode         gotoRecGet( RECORDNUMBER recNum ) const;
    Retcode         gotoRecGet( RECORDNUMBER recNum, TBRecord& rec  ) const;

    Retcode         insertRec();
    Retcode         insertRec( TBRecord& rec );
    Retcode         insertRec( const void far *buffer, int size );

    Retcode         open(TBDatabase& dbArg,
                         const char* tableName,
                         int indexID = 0,
                         BOOL saveEveryChange = FALSE,
                         DBIOpenMode openMode = dbiREADWRITE,
                         DBIShareMode shareMode = dbiOPENSHARED,
                         XLTMode xltMode = xltFIELD);
    Retcode         open(TBDatabase& dbArg,
                         const char* tableName,
                         const char* tableType,
                         int indexID,
                         DBIOpenMode openMode = dbiREADWRITE,
                         DBIShareMode shareMode = dbiOPENSHARED,
                         XLTMode xltMode = xltFIELD);
    Retcode         open(TBDatabase& dbArg,
                         const char* tableName,
                         const char* indexName,
                         DBIOpenMode openMode = dbiREADWRITE,
                         DBIShareMode shareMode = dbiOPENSHARED,
                         XLTMode xltMode = xltFIELD);
    Retcode         open(TBDatabase& dbArg,
                         const char* tableName,
                         const char* indexName,
                         const char* indexTagName,
                         DBIOpenMode openMode = dbiREADWRITE,
                         DBIShareMode shareMode = dbiOPENSHARED,
                         XLTMode xltMode = xltFIELD);

/*
;;inline
;;TBRecord&
;;TBRecord::Rec()
;;
*/
    TBRecord&       Rec()
                    {
                      if ( NULL == recGeneric )
                      {
                        throwExc( "Rec()" );
                      }
                      return ( *recGeneric );
                    }

/*
;;inline
;;TBRecord&
;;const TBRecord::RecRO() const
;;
*/
    const TBRecord& RecRO() const
                    {
                      if ( NULL == recGeneric )
                      {
                        throwExc( "RecRd()" );
                      }
                      return ( *recGeneric );
                    }

    Retcode         searchIndex( TBRecord& keyRec,
                                 PXSearchMode mode, int fldCnt = 1, bool doGetRecord = false ) const;

    Retcode         searchIndexRec( PXSearchMode mode, int fldCnt = 1, bool doGetRecord = false  ) const;

    Retcode         searchNonIndex( const char* psFldName, const char* psFldvalExpr,
                                    bool bLikePattern = false, bool doSearch = false );

    Retcode         updateRec();
    Retcode         updateRec( TBRecord& rec );
    Retcode         updateRec( const void far *buffer, int size );

  protected:
    Retcode         appendRec(BRecord *rec);
    Retcode         attach(BDatabase *dbArg, TABLEHANDLE tableHandle);
    Retcode         clearRec( BRecord* rec );
    Retcode         getNextRecord( BRecord *rec ) const;
    Retcode         getPreviousRecord( BRecord *rec ) const;
    Retcode         getRecord( BRecord *rec ) const;
    Retcode         insertRec( BRecord *rec );
    Retcode         open(BDatabase *dbArg,
                         const char *tableName,
                         int indexID = 0,
                         BOOL saveEveryChange = FALSE,
                         DBIOpenMode openMode = dbiREADWRITE,
                         DBIShareMode shareMode = dbiOPENSHARED,
                         XLTMode xltMode = xltFIELD);
    Retcode         open(BDatabase *dbArg,
                         const char *tableName,
                         const char *tableType,
                         int indexID,
                         DBIOpenMode openMode = dbiREADWRITE,
                         DBIShareMode shareMode = dbiOPENSHARED,
                         XLTMode xltMode = xltFIELD);
    Retcode         open(BDatabase *dbArg,
                         const char *tableName,
                         const char *indexName,
                         DBIOpenMode openMode = dbiREADWRITE,
                         DBIShareMode shareMode = dbiOPENSHARED,
                         XLTMode xltMode = xltFIELD);
    Retcode         open(BDatabase *dbArg,
                         const char *tableName,
                         const char *indexName,
                         const char *indexTagName,
                         DBIOpenMode openMode = dbiREADWRITE,
                         DBIShareMode shareMode = dbiOPENSHARED,
                         XLTMode xltMode = xltFIELD);

    Retcode         searchIndex( const BRecord* keyRec,
                                  PXSearchMode mode, int fldCnt );
    Retcode         searchIndex(PXSearchMode mode, int fldCnt, ...);


    void            throwExc( const char* fnArg,
                              const char* errArg = NULL,
                              const char* infoArg = NULL ) const;

    Retcode         updateRec( BRecord *rec );

    //
    TBDatabase*     db;
    TBRecord*       recGeneric;

  private:
    friend class TBDatabase;
    friend class TBRecord;

};

#endif//I_TBCURSOR

