/*
;;brecord.cpp
;;
;;  Changes and additions by //BR
;;
*/
/*******************************************************************
**
**                          BRECORD.CPP
**
** This file contains the member functions of the BRecord class.
**
*********************************************************************/

// DBF - (C) Copyright 1994 by Borland International

#include "kdbf.h"
#pragma hdrstop

#ifdef __DLL__
   #define EXPORT _export
#else
   #define EXPORT
#endif

//
// prototypes for utility functions
//

Retcode EXPORT addRecord(curdef *, BRecord *);
void    EXPORT deleteRecord(curdef *, BRecord *);
Retcode EXPORT addBlob(recdef *, blbdef *);
Retcode EXPORT convertFld(void *, PXFieldType, int,  // Source value
                   void *, PXFieldType, int);        // destination.
Retcode EXPORT strToDate(const char *str, BDate *dt);
Retcode EXPORT strToTime(const char *str, BTime *dt);
Retcode EXPORT strToTimeStamp(const char *str, BTimeStamp *dt);
Retcode EXPORT dateToStr(const BDate *dt, char *str);
Retcode EXPORT timeToStr(const BTime *dt, char *str);
Retcode EXPORT timeStampToStr(const BTimeStamp *dt, char *str);

// Constructor for making a generic record object for an open cursor.

BRecord::BRecord(BCursor *cursor)
{
    CURProps    curProps;

    recdef *ro;

    try
    {
        ro = new recdef;                // See the INTSTRCT.H file.
    }
    catch(xalloc)
    {
        lastError = DBIERR_NOMEMORY;
        recH = NULL;
        curH = 0;
        return;
    }

    lastError = DBIERR_NONE;
    ro->handleCnt = 0;
    recH = NULL;
    recobj = (void *)ro;
    curH = cursor;
    if (!cursor)                  // Null cursor ->  unattached record.
    {
        return;
    }
    if (!cursor->isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
    }
    else
    {
        if ((lastError = DbiGetCursorProps(curH->tabH, &curProps))
            != DBIERR_NONE)
        {
            return;
        }

        try
        {
            recH = new BYTE[curProps.iRecBufSize];
        }
        catch(xalloc)
        {
            lastError = DBIERR_NOMEMORY;
            recH = NULL;
            return;
        }

        iRecBufSize = curProps.iRecBufSize;
        addRecord((curdef *)cursor->curobj, this);
        clear();
    }
}

//BR BEG
#if 0//950627
#else
/*
;;BRecord::BRecord( const BRecord& other )
;;
;;  Copy constructor
;;
*/
BRecord::BRecord( const BRecord& other )
{
  CloneInternals( other );
}

/*
;;BRecord&
;;BRecord::operator =( const BRecord & other )
;;
;;  Assignment Operator
;;
*/
BRecord&
BRecord::operator =( const BRecord & other )
{
  if (this == &other)    // Watch for self assignment
    return *this;
  //
  //  Close the old record if one open
  if ( recH != NULL )
  {
    detach();
  }
  //
  //  Duplicate the input to make the new cursor
  CloneInternals( other );
  return *this;
}

/*
;;private:
;;void
;;BRecord::CloneInternals( const BRecord & other )
;;
;;  Internal cloning for copy ctor & assignment
;;
*/
void
BRecord::CloneInternals( const BRecord& other )
{
    //CURProps    curProps;

    recdef* ro;
    //recdef* other_ro = (recdef *)other.recobj;

    try
    {
        ro = new recdef;                // See the INTSTRCT.H file.
    }
    catch(xalloc)
    {
        lastError = DBIERR_NOMEMORY;
        recH = NULL;
        curH = 0;
        return;
    }

    lastError = DBIERR_NONE;
    ro->handleCnt = 0; //No blobs presently open
    recH = NULL;
    recobj = (void *)ro;
    curH = other.curH;
    if ( ! curH )                  // Null cursor ->  unattached record.
    {
        return;
    }
    if ( ! curH->isOpen )
    {
        lastError = PXERR_CURSORNOTOPEN;
    }
    else
    {
#if 0
        if ((lastError = DbiGetCursorProps( curH->tabH, &curProps ) )
            != DBIERR_NONE)
        {
            return;
        }

        try
        {
            recH = new BYTE[ curProps.iRecBufSize ];
        }
        catch(xalloc)
        {
            lastError = DBIERR_NOMEMORY;
            recH = NULL;
            return;
        }

        iRecBufSize = curProps.iRecBufSize;
        addRecord( (curdef* ) curH->curobj, this);
        clear();
#else
        iRecBufSize = other.iRecBufSize;
        if ( other.recH != NULL )
        {
          recH = new BYTE[ iRecBufSize ];
          addRecord( (curdef* ) curH->curobj, this);
          clear();
#if 0//950705
          memmove( recH, other.recH, iRecBufSize );
#endif//950705
        }
#endif//0
    }
}
#endif//950524
//BR END

// Destructor for BRecord objects.

BRecord::~BRecord()
{
    detach();

    recdef *ro  = (recdef *)recobj;

    if (ro)
    {
        if (ro->handleCnt)
        {
            delete [] ro->recblb;
            ro->recblb = NULL;
        }
        delete ro;
        ro = NULL;
    }
}

// Delete the record's association with the cursor.

Retcode BRecord::detach()
{
    curdef *co;
    recdef *ro;

    if (!recH)
    {
        return lastError = DBIERR_INVALIDHNDL;
    }

    if (curH == 0)
    {
        return lastError = PXERR_RECNOTATT;
    }

    co = (curdef *)curH->curobj;
    ro = (recdef *)recobj;

    // Mark BLOB status as closed. The resources allocated for all
    // BLOBs will be freed by the Paradox Engine with a RecBufClose call.

    for (int i=0; i < ro->handleCnt; i++)
    {
        if (ro->recblb[i].blbRecH == recH)
        {
            ro->recblb[i].state = blbClosed;
            lastError = DbiFreeBlob(curH->tabH, recH, 0);
            if (lastError != DBIERR_NONE)
            {
                // If BLOB's previously closed, does not matter
                if (lastError == DBIERR_BLOBNOTOPENED)
                {
                    lastError = DBIERR_NONE;
                }
            }
        }
    }

    deleteRecord(co, this);

    delete recH;
    recH = NULL;

    return lastError;
}

// Attach the record object to an open cursor.

Retcode BRecord::attach(BCursor *cur)
{
    CURProps    curProps;

    if (recH)
    {
        return (lastError = PXERR_RECALREADYATT);
    }

    if (!cur->isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    curH = cur;

    if ((lastError = DbiGetCursorProps(curH->tabH, &curProps))
        != DBIERR_NONE)
    {
        return lastError;
    }

    try
    {
        recH = new BYTE[(curProps.iRecBufSize)];
    }
    catch(xalloc)
    {
        recH = NULL;
        lastError = DBIERR_NOMEMORY;
        return lastError;
    }

    iRecBufSize = curProps.iRecBufSize;
    addRecord((curdef *)cur->curobj, this);
    clear();

    return (lastError = DBIERR_NONE);
}

// Clear the record buffer and set fields to "empty" values.
// RecBufEmpty will fail if a BLOB is open. This function
// doesn't perform operations on BLOBs.

Retcode BRecord::clear()
{
     if (!recH)
     {
          return (lastError = DBIERR_INVALIDHNDL);
     }

     return (lastError = DbiInitRecord(curH->tabH, recH));
}

// For the descriptor in use, return the field handle for a
// given name. For generic records, the table descriptor and
// record descriptor are the same.

FIELDNUMBER BRecord::getFieldNumber(const char *fldName) const
{
    curdef *co = (curdef *)curH->curobj;
    if (! recH)
    {
        const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL;
        return 0;
    }

    const_cast<BRecord*>( this )->lastError = DBIERR_NONE;
    for (int i=0; i < co->fieldCnt; i++)
    {
        if ( ! _fstrcmp(co->desc[i].fldName, (char far *) fldName))
        {
            const_cast<BRecord*>( this )->lastError = DBIERR_NONE;
            return i+1;
        }
    }
    const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDFIELDNAME;
    
    return 0;
}

// Get the table field number for the record. For generic
// records, there is no difference between record and
// table field numbers.

FIELDNUMBER BRecord::getTblFieldNumber(FIELDNUMBER fldnbr) const
{
    const_cast<BRecord*>( this )->lastError = DBIERR_NONE;
    return fldnbr;
}

// For the generic table (and record) descriptor in use,
// return its field count.

int BRecord::getFieldCount() const
{
    curdef *co = (curdef *)curH->curobj;
    if (!recH)
    {
        const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL;
        return 0;
    }
    const_cast<BRecord*>( this )->lastError = DBIERR_NONE;
    return co->fieldCnt;
}

// Given a field handle, return a field descriptor describing
// the field's name, type, length, and so on. For generic
// records, use the field descriptor in the cursor. (Table and
// record descriptors are the same).

Retcode BRecord::getFieldDesc(FIELDNUMBER fldnbr, FieldDesc& desc) const
{
    curdef *co = (curdef *)curH->curobj;
    if (!recH)
    {
        const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL;
        return lastError;
    }
    if (fldnbr > co->fieldCnt || fldnbr < 1)
    {
        const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL;
        return lastError;
    }
    desc = co->desc[fldnbr-1];

    return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
}

// This function performs the same operation as the previous
// function except this signature returns the field type,
// subtype, and length.

Retcode BRecord::getFieldDesc(FIELDNUMBER fldnbr,
                              PXFieldType &fldType, PXFieldSubtype &fldSubtype,
                              int &fldLen) const
{
    curdef *co = (curdef *)curH->curobj;
    if (!recH)
    {
        const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL;
        return lastError;
    }
    if (fldnbr > co->fieldCnt || fldnbr < 1)
    {
        const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL;
        return lastError;
    }
    fldType    = co->desc[fldnbr-1].fldType;
    fldSubtype = co->desc[fldnbr-1].fldSubtype;
    fldLen     = co->desc[fldnbr-1].fldLen;

    return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
}

// Copy the contents of a record, one field at a time, to
// compatible fields of another record.

Retcode BRecord::copyTo(BRecord *destRec) const
{
    BOOL custom = strcmp(nameOf(), "BRecord") ||
                  strcmp(destRec->nameOf(), "BRecord");

    // custom record may have undefined recH and it is not fatal.
    if (!recH || !destRec->recH || !_fmemcpy(destRec->recH, recH,
                                             iRecBufSize))
    {
        if (!custom)                       // See the BRECORD.H file.
        {
            return const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL;
        }
    }

    // Register the fact that the BLOBs in the destRec are now closed.

    recdef *ro = (recdef *)destRec->recobj;
    for (int i=0;i < ro->handleCnt; i++)
    {
        if (ro->recblb[i].blbRecH == destRec->recH)
        {
            ro->recblb[i].state = blbClosed;
            const_cast<BRecord*>( this )->lastError = DbiFreeBlob(curH->tabH, recH, 0);
            if (lastError != DBIERR_NONE)
            {
                // If BLOB's previously closed, does not matter
                if (lastError == DBIERR_BLOBNOTOPENED)
                {
                    const_cast<BRecord*>( this )->lastError = DBIERR_NONE;
                }
            }
        }
    }

    // If either the source or the destination record is a custom record,
    // transfer values to or from custom record fields, one field at a time.

    if (custom)
    {
        char *buf;
        try
        {
            buf = new char[256];
        }
        catch(xalloc)
        {
            return ( const_cast<BRecord*>( this )->lastError = DBIERR_NOMEMORY);
        }

        Retcode         ret;
        PXFieldType     fldType1, fldType2;
        PXFieldSubtype  fldSubtype;
        int             fldLen1, fldLen2;
        BOOL            fNull;

        int cnt = destRec->getFieldCount();
        for (int i=1; i <= cnt; i++)
        {
            if (isNull(i))
            {
                destRec->setNull(i);
                continue;
            }
            destRec->clearNull(i);
            getFieldDesc(i,fldType1,fldSubtype,fldLen1);
            destRec->getFieldDesc(i,fldType2,fldSubtype,fldLen2);
            if (fldType2 == fldBlob)
            {
                continue;                     // BLOB handling is separate.
            }

            if ((ret = getField(i, (void *) buf, 255, fNull)) == DBIERR_NONE)
            {
                if (fldType1 != fldType2)
                {
                    ret = convertFld((void *)buf,fldType1, fldLen1,
                                     (void *)buf,fldType2, fldLen2);
                    if (ret == DBIERR_NONE)
                    {
                        ret = destRec->putField(i, (void *) buf);
                    }
                }
                if (ret)
                {
                    delete buf;
                    buf = NULL;
                    return ( const_cast<BRecord*>( this )->lastError = ret);
                }
            }
        }
        delete buf;
        buf = NULL;
    }
    return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
}

//  Copy the contents of srcRec, one field at a time, to compatible
//  fields in this record.

Retcode BRecord::copyFrom(BRecord *srcRec)
{
    if (!recH ||!srcRec->recH)
    {
        lastError = DBIERR_INVALIDHNDL;
    }

    return (lastError = srcRec->copyTo(this));
}

// Obtain values for fields of a generic record; store the
// field as a character string regardless of its base type.

Retcode BRecord::getField(FIELDNUMBER fldnbr, char *buf,
                          int bufLen, BOOL& fNull) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;

    if (( const_cast<BRecord*>( this )->lastError = getField(fldnbr, (void *) buf, bufLen, fNull))
        != DBIERR_NONE)
    {
        return lastError;
    }
    if (fNull)
    {
        strcpy(buf, "");
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
    }

    getFieldDesc(fldnbr,fldType,fldSubtype,fldLen);

    return ( const_cast<BRecord*>( this )->lastError = convertFld((void *)buf, fldType, fldLen,
                                   (void *)buf, fldChar, bufLen));
}

//BR BEG
/*
;;Retcode
;;BRecord::getField(FIELDNUMBER fldnbr, void *buf,
;;                          int bufLen, BOOL& fNull) const
;;
;;  950327
;;    x fNull was not set when field type was BLOB
;;
*/
//BR END
// Get the field's value in its native format and return a pointer to
// the value as a void pointer.
Retcode BRecord::getField(FIELDNUMBER fldnbr, void *buf,
                          int bufLen, BOOL& fNull) const
{
    BDate       *dt = (BDate *)buf;
    BTime       *tm = (BTime *)buf;
    BTimeStamp  *ts = (BTimeStamp *)buf;
    UINT16      m,d;
    INT16       y;
    UINT16      h;
    UINT16      min;
    UINT16      ms;
    curdef      *co = (curdef *)curH->curobj;
    UINT32      n;
    pCHAR       ps = (pCHAR) buf;

    if (!recH)
    {
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL);
    }

    if (fldnbr > co->fieldCnt || fldnbr < 1)
    {
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL);
    }
    FieldDesc far &desc = co->desc[fldnbr-1];

    switch (desc.fldType)
    {
        case fldChar:
        case fldCharIdapi:
        case fldVarBytes:
            if (desc.fldLen > bufLen ) //? Len (max) of fld > buffer
            {
                const_cast<BRecord*>( this )->lastError = DBIERR_BUFFTOOSMALL;
                return lastError;
            }
            const_cast<BRecord*>( this )->lastError = DbiGetField(curH->tabH, fldnbr, recH, (pBYTE)buf,
                                    &fNull);
            if (fNull)
            {
                strcpy((char *)buf, "");
                return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
            }
            return lastError;
        case fldBool:
            const_cast<BRecord*>( this )->lastError = DbiGetField(curH->tabH, fldnbr, recH, (pBYTE)buf,
                                    &fNull);
            if (fNull)
            {
                *(BOOL *)buf = FALSE;
                return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
            }
            return lastError;
        case fldBlob :
            openBlobRead(fldnbr);
            if (lastError != DBIERR_NONE)
            {
                return (lastError);
            }

            n = getBlobSize( fldnbr ) + 1; //Incl. required term. null
            if (lastError != DBIERR_NONE)
            {
                return lastError;
            }
//BR BEG
#if 0//950327
#else
            fNull = ( 0 == n );               //Ensure fNull set appr. for BLOB
#endif//950327
//BR END
            //? Blob smaller than alloc buf
            if (n < bufLen)
            {
                bufLen = (int)n;
            }

            //Leave rm for term. null
            getBlob(fldnbr, bufLen - 1, 0, buf);
            if (lastError != DBIERR_NONE)
            {
                return lastError;
            }

            *(ps + bufLen - 1) = '\0';

            //941103 only FALSE does DbiFreeBlob!
            closeBlob(fldnbr, FALSE);
            if (lastError != DBIERR_NONE)
            {
                return lastError;
            }

            //? Blob larger than alloc buf
            if ( n > bufLen )
            {
                const_cast<BRecord*>( this )->lastError = DBIERR_BUFFTOOSMALL;
            }

            return lastError;
        case fldShort:
        case fldUInt16:
            if (bufLen < sizeof(INT16))
            {
                return ( const_cast<BRecord*>( this )->lastError = DBIERR_BUFFTOOSMALL);
            }
            const_cast<BRecord*>( this )->lastError = DbiGetField(curH->tabH, fldnbr, recH, (pBYTE)buf, &fNull);
            if (fNull)
            {
                *(INT16 *)buf = 0;
                return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
            }
            return lastError;
        case fldLong:
        case fldUInt32:
            if (bufLen < sizeof(INT32))
            {
                return ( const_cast<BRecord*>( this )->lastError = DBIERR_BUFFTOOSMALL);
            }
            const_cast<BRecord*>( this )->lastError = DbiGetField(curH->tabH, fldnbr, recH, (pBYTE)buf, &fNull);
            if (fNull)
            {
                *(INT32 *)buf = 0L;
                return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
            }
            return lastError;
        case fldDouble:
            if (bufLen < sizeof(FLOAT))
            {
                return ( const_cast<BRecord*>( this )->lastError = DBIERR_BUFFTOOSMALL);
            }
            const_cast<BRecord*>( this )->lastError = DbiGetField(curH->tabH, fldnbr, recH, (pBYTE)buf, &fNull);
            if (fNull)
            {
                *(FLOAT *)buf = 0L;
                return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
            }
            return lastError;
        case fldDate:
            const_cast<BRecord*>( this )->lastError = DbiGetField(curH->tabH, fldnbr, recH, (pBYTE)buf, &fNull);
            if (fNull)
            {
                memset(buf, 0, sizeof(BDate));
                return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
            }
            if (lastError == DBIERR_NONE)
            {
//BR BEG
#if 0//950515
                DbiDateDecode(*((pDATE)buf), &m, &d, &y);
#else
                DbiDateDecode(*((pDBIDATE)buf), &m, &d, &y);
#endif//950515
//BR END
                dt->month = m;
                dt->day = d;
                dt->year = y;
            }
            return lastError;
        case fldTime:
            const_cast<BRecord*>( this )->lastError = DbiGetField(curH->tabH, fldnbr, recH, (pBYTE)buf, &fNull);
            if (fNull)
            {
                memset(buf, 0, sizeof(BTime));
                return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
            }
            if (lastError == DBIERR_NONE)
            {
                DbiTimeDecode(*((pTIME)buf), &h, &min, &ms);
                tm->hour = h;
                tm->minute = min;
                tm->milSec = ms;
            }
            return lastError;
        case fldTimeStamp:
            const_cast<BRecord*>( this )->lastError = DbiGetField(curH->tabH, fldnbr, recH, (pBYTE)buf, &fNull);
            if ((fNull) && (lastError != DBIERR_NONE))
            {
                memset(buf, 0, sizeof(BTime));
                return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
            }
            if (lastError == DBIERR_NONE)
            {
//BR BEG
#if 0//950515
                DATE tempDate;
#else
                DBIDATE tempDate;
#endif//950515
//BR END
                TIME tempTime;
                
                DbiTimeStampDecode(*((pTIMESTAMP)buf), &tempDate, &tempTime); 

                DbiDateDecode(tempDate, &m, &d, &y);
                ts->BDay.month = m;
                ts->BDay.day = d;
                ts->BDay.year = y;

                DbiTimeDecode(tempTime, &h, &min, &ms);
                ts->BHour.hour = h;
                ts->BHour.minute = min;
                ts->BHour.milSec = ms;                   
            }
            return lastError;
        case fldBcd:
            const_cast<BRecord*>( this )->lastError = DBIERR_NOTSUPPORTED;
            return lastError;
        default:
            return ( const_cast<BRecord*>( this )->lastError = PXERR_TYPEMISMATCH);
    }   
}

Retcode BRecord::getField(FIELDNUMBER fldnbr, double& val, BOOL& fNull) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (( const_cast<BRecord*>( this )->lastError = getField(fldnbr, (void *) buf, 30, fNull)) != DBIERR_NONE)
    {
        return lastError;
    }

    if (fNull)
    {
        val = 0;
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
    }

    getFieldDesc(fldnbr,fldType,fldSubtype,fldLen);

    return ( const_cast<BRecord*>( this )->lastError = convertFld((void *)buf,  fldType,  30,
                                   (void *) &val, fldDouble, sizeof(double)));
}

Retcode BRecord::getField(FIELDNUMBER fldnbr, INT16& val, BOOL& fNull) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (( const_cast<BRecord*>( this )->lastError = getField(fldnbr, (void *)buf, 30, fNull)) != DBIERR_NONE)
    {
        return lastError;
    }

    if (fNull)
    {
        val = 0;
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
    }

    getFieldDesc(fldnbr,fldType,fldSubtype,fldLen);

    return ( const_cast<BRecord*>( this )->lastError = convertFld((void *)buf, fldType, 30,
                                   (void *) &val, fldShort, sizeof(INT16)));
}

Retcode BRecord::getField(FIELDNUMBER fldnbr, INT32& val, BOOL& fNull) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (( const_cast<BRecord*>( this )->lastError = getField(fldnbr, (void *) buf, 30, fNull)) != DBIERR_NONE)
    {
        return lastError;
    }

    if (fNull)
    {
        val = 0;
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
    }

    getFieldDesc(fldnbr,fldType,fldSubtype,fldLen);

    return ( const_cast<BRecord*>( this )->lastError = convertFld((void *)buf, fldType, 30,
                                   (void *) &val, fldLong, sizeof(INT32)));
}

Retcode BRecord::getField(FIELDNUMBER fldnbr, UINT16& val, BOOL& fNull) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (( const_cast<BRecord*>( this )->lastError = getField(fldnbr, (void *) buf, 30, fNull)) != DBIERR_NONE)
    {
        return lastError;
    }

    if (fNull)
    {
        val = 0;
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
    }

    getFieldDesc(fldnbr,fldType,fldSubtype,fldLen);

    return ( const_cast<BRecord*>( this )->lastError = convertFld((void *)buf, fldType, 30,
                                   (void *) &val, fldUInt16, sizeof(UINT16)));
}

Retcode BRecord::getField(FIELDNUMBER fldnbr, UINT32& val, BOOL& fNull) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (( const_cast<BRecord*>( this )->lastError = getField(fldnbr, (void *) buf, 30, fNull)) != DBIERR_NONE)
    {
        return lastError;
    }

    if (fNull)
    {
        val = 0;
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
    }

    getFieldDesc(fldnbr,fldType,fldSubtype,fldLen);

    return ( const_cast<BRecord*>( this )->lastError = convertFld((void *)buf, fldType, 30,
                                   (void *) &val, fldLong, sizeof(UINT32)));
}

Retcode BRecord::getField(FIELDNUMBER fldnbr, FMTBcd& val, BOOL& fNull) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[51];

    if (( const_cast<BRecord*>( this )->lastError = getField(fldnbr, (void *) buf, 50, fNull)) != DBIERR_NONE)
    {
        return lastError;
    }

    if (fNull)
    {
        memset(&val, 0, sizeof(FMTBcd));
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
    }

    getFieldDesc(fldnbr, fldType, fldSubtype, fldLen);

    return ( const_cast<BRecord*>( this )->lastError = convertFld((void *)buf, fldType, 30,
                                   (void *) &val, fldBcd, sizeof(FMTBcd)));
}

Retcode BRecord::getField(FIELDNUMBER fldnbr, BDate& val, BOOL& fNull) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (( const_cast<BRecord*>( this )->lastError = getField(fldnbr, (void *) buf, 30, fNull)) != DBIERR_NONE)
    {
        return lastError;
    }

    if (fNull)
    {
        memset((void *)&val, 0, sizeof(BDate));
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
    }

    getFieldDesc(fldnbr,fldType,fldSubtype,fldLen);

    return ( const_cast<BRecord*>( this )->lastError = convertFld((void *)buf, fldType, 30,
                                   (void *) &val, fldDate, sizeof(BDate)));
}

Retcode BRecord::getField(FIELDNUMBER fldnbr, BTime& val, BOOL& fNull) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (( const_cast<BRecord*>( this )->lastError = getField(fldnbr, (void *) buf, 30, fNull)) != DBIERR_NONE)
    {
        return lastError;
    }

    if (fNull)
    {
        memset((void *)&val, 0, sizeof(BDate));
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
    }

    getFieldDesc(fldnbr,fldType,fldSubtype,fldLen);

    return ( const_cast<BRecord*>( this )->lastError = convertFld((void *)buf, fldType, 30,
                                   (void *) &val, fldTime, sizeof(BTime)));
}

Retcode BRecord::getField(FIELDNUMBER fldnbr, BTimeStamp& val, BOOL& fNull) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[61];

    if (( const_cast<BRecord*>( this )->lastError = getField(fldnbr, (void *) buf, 60, fNull)) != DBIERR_NONE)
    {
        return lastError;
    }

    if (fNull)
    {
        memset((void *)&val, 0, sizeof(BDate));
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_NONE);
    }

    getFieldDesc(fldnbr,fldType,fldSubtype,fldLen);

    return ( const_cast<BRecord*>( this )->lastError = convertFld((void *)buf, fldType, 60,
                                   (void *) &val, fldTimeStamp,
                                   sizeof(BTimeStamp)));
}

Retcode BRecord::getField(char *fldName, char *buf, int bufLen, BOOL& fNull) const
{
    FIELDNUMBER fld;
    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::getField(fld, buf, bufLen,fNull));
}

Retcode BRecord::getField(char *fldName, void *buf, int bufLen, BOOL& fNull) const
{
    FIELDNUMBER fld;
    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::getField(fld, buf, bufLen, fNull));
}

Retcode BRecord::getField(char *fldName, double& val, BOOL& fNull) const
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::getField(fld, val, fNull));
}

Retcode BRecord::getField(char *fldName, INT16& val, BOOL& fNull) const
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::getField(fld, val, fNull));
}

Retcode BRecord::getField(char *fldName, INT32& val, BOOL& fNull) const
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::getField(fld, val, fNull));
}

Retcode BRecord::getField(char *fldName, UINT16& val, BOOL& fNull) const
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::getField(fld, val, fNull));
}

Retcode BRecord::getField(char *fldName, UINT32& val, BOOL& fNull) const
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::getField(fld, val, fNull));
}

Retcode BRecord::getField(char *fldName, FMTBcd& val, BOOL& fNull) const
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::getField(fld, val, fNull));
}

Retcode BRecord::getField(char *fldName, BDate& val, BOOL& fNull) const
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::getField(fld, val, fNull));
}

Retcode BRecord::getField(char *fldName, BTime& val, BOOL& fNull) const
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::getField(fld, val, fNull));
}

Retcode BRecord::getField(char *fldName, BTimeStamp& val, BOOL& fNull) const
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::getField(fld, val, fNull));
}

//BR BEG
/*
;;Retcode
;;BRecord::putField(FIELDNUMBER fldnbr, const char *buf)
;;
;;  950411
;;    x putField() to blob now works when existing blob is non-null
;;        (calls setNull() first)
;;
*/
//BR END
// The following putField functions provide counterpart
// operations to getField functions.
Retcode BRecord::putField(FIELDNUMBER fldnbr, const char *buf)
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           tempBuf[31];

    int len = strlen(buf);

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (getFieldDesc(fldnbr,fldType,fldSubtype,fldLen))
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (fldType == fldBlob && fldSubtype == fldstMemo)
    {
        openBlobWrite(fldnbr, 0, FALSE);
        if (lastError != DBIERR_NONE)
        {
            return lastError;
        }
//BR BEG
#if 0//950411
#else
        if ( DBIERR_NONE != setNull( fldnbr ) ) //Ensure existing BLOB is null before writing new value
        {
          return ( lastError );
        }
#endif//950411
//BR END
        //Term-null not incl.
        putBlob(fldnbr, strlen(buf), 0, (void*) buf);
        if (lastError != DBIERR_NONE)
        {
            return lastError;
        }

        closeBlob(fldnbr);
        return lastError;
    }
    else if ((fldType != fldChar) && (fldType != fldCharIdapi))
    {
        if ((lastError = convertFld((void *)buf, fldChar, len,
                                    (void *)tempBuf,fldType, 30))
            != DBIERR_NONE)
        {
            return lastError;
        }

        return (lastError = BRecord::putField(fldnbr, (void *)tempBuf));
    }
    else
    {
        return (lastError = BRecord::putField(fldnbr, (void *)buf));
    }
}

Retcode BRecord::putField(FIELDNUMBER fldnbr, const void *buf)
{
    BDate       *dt = (BDate *)buf;
    BTime       *tm = (BTime *)buf;
    BTimeStamp  *ts = (BTimeStamp *)buf;
    curdef      *co = (curdef *)curH->curobj;

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (fldnbr > co->fieldCnt || fldnbr < 1)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    FieldDesc far &desc = co->desc[fldnbr-1];

    switch (desc.fldType)
    {
        case fldChar:
        case fldCharIdapi:
        case fldBool:
        case fldVarBytes:
        case fldShort:
        case fldUInt16:
        case fldUInt32:
        case fldDouble:
        case fldLong:
            lastError = DbiPutField(curH->tabH, fldnbr, recH, (pBYTE)buf);
            return lastError;
        case fldDate:
            if ((lastError = DbiDateEncode((UINT16)dt->month, (UINT16)dt->day,
//BR BEG
#if 0//950515
                                           (int)dt->year,  (pDATE)buf))
#else
                                           (int)dt->year,  (pDBIDATE)buf))
#endif//950515
//BR END
                 == DBIERR_NONE)
            {
                lastError = DbiPutField(curH->tabH, fldnbr, recH, (pBYTE)buf);
            }
            return lastError;
        case fldTime:
            if ((lastError = DbiTimeEncode((UINT16)tm->hour, (UINT16)tm->minute,
//BR BEG
#if 0//950515
                                           (UINT16)tm->milSec,  (pDATE)buf))
#else
                                           (UINT16)tm->milSec,  (pDBIDATE)buf))
#endif//950515
//BR END
                 == DBIERR_NONE)
            {
                lastError = DbiPutField(curH->tabH, fldnbr, recH, (pBYTE)buf);
            }
            return lastError;
        case fldTimeStamp:
//BR BEG
#if 0//950515
            DATE   tempDate;
#else
            DBIDATE   tempDate;
#endif//950515
//BR END
            TIME   tempTime;

            if ((lastError = DbiDateEncode((UINT16)ts->BDay.month,
                                           (UINT16)ts->BDay.day,
                                           (int)ts->BDay.year,  &tempDate))
                 != DBIERR_NONE)
            {
                return lastError;
            }
            if ((lastError = DbiTimeEncode((UINT16)ts->BHour.hour,
                                           (UINT16)ts->BHour.minute,
                                           (UINT16)ts->BHour.milSec,
                                           &tempTime))
                 != DBIERR_NONE)
            {
                return lastError;
            }
            if ((lastError = DbiTimeStampEncode(tempDate, tempTime,
                                                (pTIMESTAMP)buf))
                 == DBIERR_NONE)
            {
                lastError = DbiPutField(curH->tabH, fldnbr, recH, (pBYTE)buf);
            }
            return lastError;
        case fldBcd:
            lastError = DBIERR_NOTSUPPORTED;
            return lastError;
        default:
            return (lastError = PXERR_TYPEMISMATCH);
    }
}

Retcode BRecord::putField(FIELDNUMBER fldnbr, double val)
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (getFieldDesc(fldnbr,fldType,fldSubtype,fldLen))
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if ((lastError = convertFld((void *)&val, fldDouble, sizeof(double),
                                (void *)buf,fldType, 30)) != DBIERR_NONE)
    {
        return lastError;
    }

    return (lastError = BRecord::putField(fldnbr, (void *) buf));
}

Retcode BRecord::putField(FIELDNUMBER fldnbr, INT16 val)
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (getFieldDesc(fldnbr,fldType,fldSubtype,fldLen))
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if ((lastError = convertFld((void *)&val, fldShort, sizeof(short),
                                (void *)buf,fldType, 30)) != DBIERR_NONE)
    {
        return lastError;
    }

    return (lastError = BRecord::putField(fldnbr, (void *) buf));
}

Retcode BRecord::putField(FIELDNUMBER fldnbr, INT32 val)
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (getFieldDesc(fldnbr, fldType, fldSubtype, fldLen))
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if ((lastError = convertFld((void *)&val, fldLong, sizeof(long),
                                (void *)buf, fldType, 30)) != DBIERR_NONE)
    {
        return lastError;
    }

    return (lastError = BRecord::putField(fldnbr, (void *) buf));
}

Retcode BRecord::putField(FIELDNUMBER fldnbr, UINT16 val)
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (getFieldDesc(fldnbr, fldType, fldSubtype, fldLen))
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if ((lastError = convertFld((void *)&val, fldUInt16, sizeof(int),
                                (void *)buf, fldType, 30)) != DBIERR_NONE)
    {
        return lastError;
    }

    return (lastError = BRecord::putField(fldnbr, (void *) buf));
}

Retcode BRecord::putField(FIELDNUMBER fldnbr, UINT32 val)
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (getFieldDesc(fldnbr,fldType,fldSubtype,fldLen))
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if ((lastError = convertFld((void *)&val, fldLong, sizeof(long),
                                (void *)buf, fldType, 30)) != DBIERR_NONE)
    {
        return lastError;
    }

    return (lastError = BRecord::putField(fldnbr, (void *) buf));
}

Retcode BRecord::putField(FIELDNUMBER fldnbr, FMTBcd val)
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (getFieldDesc(fldnbr,fldType,fldSubtype,fldLen))
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if ((lastError = convertFld((void *)&val, fldBcd, sizeof(FMTBcd),
                                (void *)buf, fldType, 30)) != DBIERR_NONE)
    {
        return lastError;
    }

    return (lastError = BRecord::putField(fldnbr, (void *) buf));
}

Retcode BRecord::putField(FIELDNUMBER fldnbr, const BDate& val)
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (getFieldDesc(fldnbr,fldType,fldSubtype,fldLen))
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if ((lastError = convertFld((void *)&val, fldDate, sizeof(BDate),
                                (void *)buf,fldType, 30)) != DBIERR_NONE)
    {
        return lastError;
    }

    return (lastError = BRecord::putField(fldnbr, (void *) buf));
}

Retcode BRecord::putField(FIELDNUMBER fldnbr, const BTime& val)
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[31];

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (getFieldDesc(fldnbr,fldType,fldSubtype,fldLen))
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if ((lastError = convertFld((void *)&val, fldTime, sizeof(BTime),
                                (void *)buf, fldType, 30)) != DBIERR_NONE)
    {
        return lastError;
    }

    return (lastError = BRecord::putField(fldnbr, (void *) buf));
}

Retcode BRecord::putField(FIELDNUMBER fldnbr, const BTimeStamp& val)
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;
    char           buf[51];

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (getFieldDesc(fldnbr, fldType, fldSubtype, fldLen))
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if ((lastError = convertFld((void *)&val, fldTimeStamp, sizeof(BTimeStamp),
                                (void *)buf, fldType, 30)) != DBIERR_NONE)
    {
        return lastError;
    }

    return (lastError = BRecord::putField(fldnbr, (void *) buf));
}

Retcode BRecord::putField(char *fldName, const char *buf)
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::putField(fld, buf));
}

Retcode BRecord::putField(char *fldName, const void *buf)
{
    FIELDNUMBER fld;
    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::putField(fld, buf));
}

Retcode BRecord::putField(char *fldName, double val)
{
    FIELDNUMBER fld;
    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::putField(fld, val));
}

Retcode BRecord::putField(char *fldName, INT16 val)
{
    FIELDNUMBER fld;
    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::putField(fld, val));
}

Retcode BRecord::putField(char *fldName, INT32 val)
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::putField(fld, val));
}

Retcode BRecord::putField(char *fldName, UINT16 val)
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::putField(fld, val));
}

Retcode BRecord::putField(char *fldName, UINT32 val)
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::putField(fld, val));
}

Retcode BRecord::putField(char *fldName, FMTBcd val)
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::putField(fld, val));
}

Retcode BRecord::putField(char *fldName, const BDate& val)
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::putField(fld, val));
}

Retcode BRecord::putField(char *fldName, const BTime& val)
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::putField(fld, val));
}

Retcode BRecord::putField(char *fldName, const BTimeStamp& val)
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (BRecord::putField(fld, val));
}

// Test if a field is null.

BOOL BRecord::isNull(FIELDNUMBER fldnbr) const
{
    BOOL blank;

    if (( const_cast<BRecord*>( this )->lastError = DbiGetField(curH->tabH, fldnbr, recH, NULL,
                                    &blank)) != DBIERR_NONE)
    {
        return FALSE;
    }

    return blank;
}

BOOL BRecord::isNull(const char *fldname) const
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldname)) == 0)
    {
        return FALSE;
    }

    return (isNull(fld));
}

//BR BEG
/*
;;Retcode
;;BRecord::setNull(FIELDNUMBER fldnbr)
;;
;;  950414
;;    x openBlobWrite() called if necessary (if not previously called by
;;        app)
;;  950119
;;    Changes by //BR
;;      -dbiTruncateBlob() now called for BLOB fields
;;        For BLOB fields, openBlobWrite() must have been called prior
;;
*/
//BR END
// Set a field to blank.
Retcode BRecord::setNull(FIELDNUMBER fldnbr)
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;

    if (!recH)
    {
        return (lastError = PXERR_RECNOTATT);
    }

    getFieldDesc(fldnbr, fldType, fldSubtype, fldLen);

    if (fldType != fldBlob)
    {
        lastError = DbiPutField(curH->tabH, fldnbr, recH, NULL);
    }
    else
    {
//BR BEG
#if 0//950119
        recdef *ro = (recdef *)recobj;

        for (int i=0; i < ro->handleCnt; i++)
        {
            if (ro->recblb[i].fldnbr == fldnbr && !((int) ro->recblb[i].state))
            {
                break;
            }
        }

        if (i == ro->handleCnt)
        {
            return lastError = PXERR_BLOBOPEN;
        }

        dropBlob(fldnbr);
#else
#if 0//950414
      lastError = DbiTruncateBlob(curH->tabH, recH, fldnbr, 0 );
      return ( lastError );
#else
      lastError = DbiTruncateBlob(curH->tabH, recH, fldnbr, 0 );
      if ( DBIERR_BLOBNOTOPENED == lastError ) //? Retryable error
      {
        if ( DBIERR_NONE != openBlobWrite( fldnbr,  0, FALSE ) ) //So DbiTruncateBlob() can be called
        {
          return ( lastError );
        }
        lastError = DbiTruncateBlob(curH->tabH, recH, fldnbr, 0 );
      }
      return ( lastError );
#endif//950414
#endif//950119
//BR END
    }

    return lastError;
}

Retcode BRecord::setNull(const char *fldName)
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (setNull(fld));
}

Retcode BRecord::clearNull(FIELDNUMBER fldnbr)
{
    curdef *co = (curdef *)curH->curobj;

    if (!recH)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    if (fldnbr > co->fieldCnt || fldnbr < 1)
    {
        return (lastError = DBIERR_INVALIDHNDL);
    }

    return (PXERR_NOCLEARNULL);
}

Retcode BRecord::clearNull(const char *fldName)
{
    FIELDNUMBER fld;

    if ((fld = BRecord::getFieldNumber(fldName)) == 0)
    {
        return lastError;
    }

    return (clearNull(fld));
}

RECORDHANDLE BRecord::getHandle() const
{

    if (!recH)
    {
        const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL;
        return 0;
    }

    const_cast<BRecord*>( this )->lastError = DBIERR_NONE;

    return recH;
}


// Open a BLOB for subsequent read or write operations based on mode.

Retcode BRecord::openBlobRead(FIELDNUMBER fldnbr, BOOL usePrivateCopy) const
{
    blbdef blb;

    if (!recH)
    {
        return ( const_cast<BRecord*>( this )->lastError = PXERR_RECNOTATT);
    }
    
     // Use the field number of the BLOB in the table, not the
    // custom record. That way, this function does not need
    // to be duplicated in custom record classes.

    FIELDNUMBER tblfld = getTblFieldNumber(fldnbr);
/*
         if (usePrivateCopy)
         {

                         if ((lastError = PXBlobClone(recH, tblfld)) != DBIERR_NONE)
                         {
                                         return lastError;
                         }

          }
*/
    if (( const_cast<BRecord*>( this )->lastError = DbiOpenBlob(curH->tabH, recH, tblfld, dbiREADONLY)) != DBIERR_NONE)
    {
        return lastError;
    }

    blb.fldnbr      = fldnbr;
    blb.privateBlb  = usePrivateCopy;
    blb.state       = blbOpenRead;
    blb.blbRecH     = recH;
     // IDAPI stores BLOB handle internally
    blb.blbH        = tblfld;

     return ( const_cast<BRecord*>( this )->lastError = addBlob((recdef *)recobj, &blb));
}

#pragma argsused
Retcode BRecord::openBlobWrite(FIELDNUMBER fldnbr, long size, BOOL copyOld)
{
    blbdef blb;

    if (!recH)
    {
        return (lastError = PXERR_RECNOTATT);
    }

    FIELDNUMBER tblfld = getTblFieldNumber(fldnbr);

    if ((lastError = DbiOpenBlob(curH->tabH, recH, tblfld, dbiREADWRITE))
        != DBIERR_NONE)
    {
        return lastError;
    }

    blb.fldnbr      = fldnbr;
    blb.privateBlb  = FALSE;
    blb.state       = blbOpenWrite;
    blb.blbRecH     = recH;

    // IDAPI stored BLOB handle internally
    blb.blbH        = tblfld;
    lastError       = addBlob((recdef *)recobj, &blb);

    return lastError;
}

// Get a BLOB Header.

#pragma argsused
Retcode BRecord::getBlobHeader(FIELDNUMBER fldnbr, int size,
                               void *buffer, int& bytesRead) const
{
    if (!recH)
    {
        return ( const_cast<BRecord*>( this )->lastError = PXERR_RECNOTATT);
    }

    curdef *co = (curdef *)curH->curobj;
    if (!recH)
    {
        const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL;
        return lastError;
    }

    if (!strcmp(curH->tabtype, szPARADOX))
    {
        fldnbr = getTblFieldNumber(fldnbr);

        if (size < (co->desc[fldnbr].fldLen - 1))
        {
            const_cast<BRecord*>( this )->lastError = DBIERR_BUFFTOOSMALL;
            return lastError;
        }

        const_cast<BRecord*>( this )->lastError = DbiGetBlobHeading(curH->tabH, fldnbr, recH, (pBYTE)buffer);
    }
    else
    {
        const_cast<BRecord*>( this )->lastError = openBlobRead(fldnbr, FALSE);
        if (lastError != DBIERR_NONE)
        {
            return lastError;
        }
        getBlob(fldnbr, size, 0, buffer);
        if (lastError != DBIERR_NONE)
        {
            closeBlob(fldnbr, TRUE);
            return lastError;
        }
        const_cast<BRecord*>( this )->lastError = closeBlob(fldnbr, TRUE);
        if (lastError != DBIERR_NONE)
        {
            closeBlob(fldnbr, TRUE);
            return lastError;
        }
    }

    return lastError;
}

//  Get the size of an open BLOB.

unsigned long BRecord::getBlobSize(FIELDNUMBER fld) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;

    if (!recH)
    {
        return ( const_cast<BRecord*>( this )->lastError = PXERR_RECNOTATT);
    }

    if (getFieldDesc(fld, fldType, fldSubtype, fldLen))
    {
        const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL;
        return 0L;
    }

    if (fldType != fldBlob)
    {
        const_cast<BRecord*>( this )->lastError = PXERR_TYPEMISMATCH;
        return 0L;
    }

    recdef *ro = (recdef *) recobj;
    unsigned long size;

    for (int i=0;i < ro->handleCnt; i++)
    {
        if (ro->recblb[i].fldnbr == fld && (BOOL) ro->recblb[i].state)
        {
            break;
        }
    }

    if (i == ro->handleCnt)
    {
        const_cast<BRecord*>( this )->lastError = PXERR_BLOBNOTOPEN;
        return 0L;
    }

    if (( const_cast<BRecord*>( this )->lastError = DbiGetBlobSize(curH->tabH, recH, ro->recblb[i].blbH, &size))
        != DBIERR_NONE)
    {
        return 0L;
    }

    return size;
}

// Read a segment of an open BLOB.
Retcode BRecord::getBlob(FIELDNUMBER fld, unsigned int size,
                         long offset, void far *buffer) const
{
    PXFieldType     fldType;
    PXFieldSubtype  fldSubtype;
    int             fldLen;
    UINT32          bytesRead;

    if (!recH)
    {
        return ( const_cast<BRecord*>( this )->lastError = PXERR_RECNOTATT);
    }

    if (getFieldDesc(fld, fldType, fldSubtype, fldLen))
    {
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL);
    }

    if (fldType != fldBlob)
    {
        return ( const_cast<BRecord*>( this )->lastError = PXERR_TYPEMISMATCH);
    }

    recdef *ro = (recdef *) recobj;

    for (int i=0;i < ro->handleCnt; i++)
    {
        if (ro->recblb[i].fldnbr == fld && (int) ro->recblb[i].state)
        {
            break;
        }
    }

    if (i == ro->handleCnt)
    {
        return ( const_cast<BRecord*>( this )->lastError = PXERR_BLOBNOTOPEN);
    }

    const_cast<BRecord*>( this )->lastError = DbiGetBlob(curH->tabH, recH, ro->recblb[i].blbH, offset,
                           size, (pBYTE)buffer, &bytesRead);

    return lastError;
}

//BR BEG
#if 0//950531
#else
/*
;;protected:
;;UINT32
;;TBRecord::getBlob1(FIELDNUMBER fld, unsigned int size,
;;                         long offset, void far *buffer) const
;;
;;  Differs from getBlob() as follows:
;;    x Returns bytesRead rather than Retcode
;;    x Uses getBlobSize() to check blob size, returning smaller than
;;        parameter "size" if blob is smaller (rather than "BLOB EOF" error)
;;    x All errors throw a Retcode exception)
;;
*/
UINT32
BRecord::getBlob1(FIELDNUMBER fld, unsigned int size,
                         long offset, void far *buffer) const
{
    PXFieldType     fldType;
    PXFieldSubtype  fldSubtype;
    int             fldLen;
    UINT32          bytesRead;

    if (!recH)
    {
        throw ( const_cast<BRecord*>( this )->lastError = PXERR_RECNOTATT );
    }

    if (getFieldDesc(fld, fldType, fldSubtype, fldLen))
    {
        throw ( const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL );
    }

    if (fldType != fldBlob)
    {
        throw ( const_cast<BRecord*>( this )->lastError = PXERR_TYPEMISMATCH );
    }

    recdef *ro = (recdef *) recobj;

    for (int i=0;i < ro->handleCnt; i++)
    {
        if (ro->recblb[i].fldnbr == fld && (int) ro->recblb[i].state)
        {
            break;
        }
    }

    if (i == ro->handleCnt)
    {
        throw ( const_cast<BRecord*>( this )->lastError = PXERR_BLOBNOTOPEN );
    }

    UINT32 n = getBlobSize( fld );
    if ( size > n )
    {
      size = (UINT16) n; //Respecify size to be size of the blob if blob is smaller
                //  so "BLOB EOF" error does not occur
    }

    const_cast<BRecord*>( this )->lastError = DbiGetBlob(curH->tabH, recH, ro->recblb[i].blbH, offset,
                           size, (pBYTE)buffer, &bytesRead);
    if ( DBIERR_NONE != lastError )
    {
      throw ( lastError );
    }
    return bytesRead;
}
#endif//950531
//BR END

// Close an open BLOB handle; closes both private and public BLOBs.
// For a field, at most, one BLOB can be open at any time.

// Note - accept does not do anything

Retcode BRecord::closeBlob(FIELDNUMBER fld, BOOL accept) const
{
    PXFieldType    fldType;
    PXFieldSubtype fldSubtype;
    int            fldLen;

    if (!recH)
    {
        return ( const_cast<BRecord*>( this )->lastError = PXERR_RECNOTATT);
    }

    if (getFieldDesc(fld, fldType, fldSubtype, fldLen))
    {
        return ( const_cast<BRecord*>( this )->lastError = DBIERR_INVALIDHNDL);
    }

    if (fldType != fldBlob)
    {
        return ( const_cast<BRecord*>( this )->lastError = PXERR_TYPEMISMATCH);
    }

    recdef *ro = (recdef *) recobj;

    for (int i=0; i < ro->handleCnt; i++)
    {
        if (ro->recblb[i].fldnbr == fld && (int) ro->recblb[i].state)
        {
            break;
        }
    }

    if (i == ro->handleCnt)
    {
        return const_cast<BRecord*>( this )->lastError = PXERR_BLOBNOTOPEN;
    }

    if (accept == FALSE)
    {
        dropBlob(fld);
        ro->recblb[i].state = blbClosed;
    }

    ro->recblb[i].privateBlb = FALSE;

    return lastError;
}

// Write a segment of an open BLOB.

Retcode BRecord::putBlob(FIELDNUMBER fld, unsigned long size,
                         unsigned long offset, void far *buffer)
{
     PXFieldType    fldType;
     PXFieldSubtype fldSubtype;
     int            fldLen;

     if (!recH)
     {
          return (lastError = PXERR_RECNOTATT);
     }

     if (getFieldDesc(fld, fldType, fldSubtype, fldLen))
     {
          return (lastError = DBIERR_INVALIDHNDL);
     }

     if (fldType != fldBlob)
     {
          return (lastError = PXERR_TYPEMISMATCH);
     }

     recdef *ro = (recdef *) recobj;

     for (int i=0;i < ro->handleCnt; i++)
     {
          if (ro->recblb[i].fldnbr == fld && (int) ro->recblb[i].state)
          {
                break;
          }
     }

     if (i == ro->handleCnt)
     {
          return (lastError = PXERR_BLOBNOTOPEN);
     }

     if ((lastError = DbiPutBlob(curH->tabH, recH, ro->recblb[i].blbH,
                                 offset, (UINT32)size, (pBYTE)buffer))
          != DBIERR_NONE)
     {
          return lastError;
     }

     clearNull(fld);                // Clear the null bit in Custom records.

     return (lastError = DBIERR_NONE);
}

// Drop a BLOB field from a record.

Retcode BRecord::dropBlob(FIELDNUMBER fldnbr) const
{
    const_cast<BRecord*>( this )->lastError = DbiFreeBlob(curH->tabH, recH, fldnbr);
    return lastError;
}

// This function provides a place holder for preprocessing
// routines.

Retcode BRecord::preprocess()
{
    return (lastError = DBIERR_NONE);
}

// This function provides a place holder for postprocessing
// routines.

Retcode BRecord::postprocess()
{
    return (lastError = DBIERR_NONE);
}

// Redefine pure virtuals from the BDbObject class.

char * BRecord::nameOf() const
{
    return ("BRecord");
}

void BRecord::printOn( ostream& os)
{
    FieldDesc  desc;
    char *buf;
    
    try
    {
        buf = new char[256];
    }
    catch(xalloc)
    {
        lastError = DBIERR_NOMEMORY;
        return;
    }

     BOOL fNull;

    int cnt = getFieldCount();

    os << nameOf() << " { \n";

    for (int i=1; i <= cnt; i++)
    {
        getFieldDesc(i, desc);
        getField(i, buf, 256, fNull);
        os << "     " << desc.fldName << " = ";
        if (desc.fldType == fldBlob)
        {
            os << "Blob Field";
        }
        else
        {
            if (fNull)
            {
                os << "Null" ;
            }
            else
            {
                os << buf ;
            }
        }
        os << "\n";
    }

    os << "}\n";
    delete buf;
    buf = NULL;
}

// The following two routines are used to maintain a list of records
// for a cursor. The Database Framework does not assume the presence
// of any Class library (not even Borland's container library Classlib).
// Consequently, no List class is used.

Retcode addRecord(curdef *cur, BRecord *rec)
{
  // Add this record object to the record vector in the cursor.

    int i;

    BRecord **newvec;

    for (i = 0; i < cur->handleCnt; i++)
    {
        if (! cur->recList[i])            // empty slot ?
        {
            cur->recList[i] = rec;
            return DBIERR_NONE;
        }
    }
    
    try
    {
        newvec = new BRecord *[cur->handleCnt+4];    // Four more handles.
    }
    catch(xalloc)
    {           
        return DBIERR_NOMEMORY;
    }


     for (i = 0; i < cur->handleCnt; i++)
     {
        newvec[i] = cur->recList[i];
     }

    newvec[i++] = rec;
    newvec[i] = newvec[i+1] = newvec[i+2] = NULL;
    if (cur->handleCnt)
    {
        delete [] cur->recList;
        cur->recList;
    }

    cur->handleCnt += 4;
    cur->recList = newvec;
    return DBIERR_NONE;
}

// Delete the record from the Open Record list of its cursor.

void deleteRecord(curdef *cur, BRecord *rec)
{
    for (int i = 0; i < cur->handleCnt; i++)
    {
        if (cur->recList[i] == rec)
        {
            cur->recList[i] = NULL;
            return;
        }
    }
}

// Add the BLOB to the Open BLOB list of its record.

Retcode addBlob(recdef *rec, blbdef *blb)
{
  // Add this BLOB definition to the Record object.
    int i;
    blbdef *newvec;

    for (i = 0; i < rec->handleCnt; i++)
    {
        if (rec->recblb[i].fldnbr == blb->fldnbr)  // BLOB field already has
        {                                          // a slot.
            rec->recblb[i] = *blb;
            return DBIERR_NONE;
        }
    }

    try
    {
        // One more handle.
        newvec = new blbdef[rec->handleCnt+1];
    }
    catch(xalloc)
    {
        return DBIERR_NOMEMORY;
    }

    for (i = 0; i < rec->handleCnt; i++)
    {
        newvec[i] = rec->recblb[i];
    }

    newvec[i] = *blb;

    if (rec->handleCnt)
    {
        delete [] rec->recblb;
        rec->recblb = NULL;
    }

    rec->handleCnt += 1;
    rec->recblb = newvec;

    return DBIERR_NONE;
}

// Convert value in source pointed to by srcPtr and leave
// the result in destPtr;

Retcode convertFld(void *srcPtr, PXFieldType srcType, int srcLen,
                   void *destPtr, PXFieldType destType, int destLen)
{
    char buf[31];
    BDate dt;
    long ld;
    double db;
    Retcode ret = DBIERR_NONE;
    BTime tTime;
    BTimeStamp tTimestamp;

    switch(destType)
    {
        case fldChar:
        case fldVarBytes:
        case fldCharIdapi:
            switch(srcType)
            {
                case fldChar:
                case fldVarBytes:
                case fldCharIdapi:
                    if (srcPtr == destPtr)            // Nothing to copy.
                    {
                        return (ret);
                    }
                    break;
                case fldShort:
                    srcLen = sprintf(buf,"%d",*((pINT16) srcPtr));
                    srcPtr = buf;
                    break;
                case fldUInt16:
                    srcLen = sprintf(buf,"%u",*((pUINT16) srcPtr));
                    srcPtr = buf;
                    break;
                case fldLong:
                    srcLen = sprintf(buf,"%ld",*((pINT32) srcPtr));
                    srcPtr = buf;
                    break;
                case fldUInt32:
                    srcLen = sprintf(buf,"%lU",*((pUINT32) srcPtr));
                    srcPtr = buf;
                    break;
                case fldDouble:
//BR BEG
#if 0//950515
                    srcLen = sprintf(buf,"%G",*((pFLOAT) srcPtr));
#else
                    srcLen = sprintf(buf,"%G",*((pDFLOAT) srcPtr));
#endif//950515
//BR END
                    srcPtr = buf;
                    break;
                case fldBool:
                    if (*(pBOOL)srcPtr == 1)
                    {
                        srcLen = sprintf(buf,"%s", "TRUE");
                    }
                    else
                    {
                        srcLen = sprintf(buf,"%s", "TRUE");
                    }
                    srcPtr = buf;
                    break;
                case fldDate:
                    dateToStr((BDate *) srcPtr, buf);
                    srcPtr = buf;
                    break;
                case fldTime:
                    timeToStr((BTime *) srcPtr, buf);
                    srcPtr = buf;
                    break;
                case fldTimeStamp:
                    timeStampToStr((BTimeStamp *) srcPtr, buf);
                    srcPtr = buf;
                    break;
                case fldBlob:
                    // Nothing to copy.
                    if (srcPtr == destPtr)
                    {
                        return ret;
                    }
                                        break;
                case fldBcd:
                case fldFloatIEEE:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                default:
                    return (PXERR_INVFIELDTYPE);
            }
            if (srcLen > destLen && strlen((char *) srcPtr) > destLen)
            {
                ret = DBIERR_BUFFTOOSMALL;
                strncpy((char *) destPtr, (char *) srcPtr, destLen);
            }
            else
            {
                strcpy((char *) destPtr, (char *) srcPtr);
            }
            break;

        case fldShort:
            switch(srcType)
            {
                case fldChar:
                case fldVarBytes:
                case fldCharIdapi:
                    if (sscanf((char *) srcPtr,"%lf",&db) < 1)
                    {
                        ret = PXERR_DATACONV;
                    }
                    if (db < SHRT_MIN || db > SHRT_MAX)
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    *((INT16 *) destPtr) = (INT16) db;
                    break;
                case fldShort:
                    *((INT16 *) destPtr) = *((INT16 *) srcPtr);
                    break;
                case fldUInt16:
                    if ((*((UINT16 *)srcPtr) > SHRT_MAX))
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    *((INT16 *) destPtr) = *((INT16 *) srcPtr);
                    break;
                case fldLong:
                    ld = *((INT32 *) srcPtr);
                    if (ld < SHRT_MIN || ld > SHRT_MAX)
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    *((INT16 *) destPtr) = (INT16) ld;
                    break;
                case fldUInt32:
                    ld = *((UINT32 *) srcPtr);
                    if (ld < SHRT_MIN || ld > SHRT_MAX)
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    *((UINT32 *) destPtr) = (UINT32) ld;
                    break;
                case fldDouble:
                    db = *((FLOAT *) srcPtr);
                    if (db < SHRT_MIN || db > SHRT_MAX)
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    else
                    {
                        *((short *) destPtr) = (short) db;
                    }
                    break;
                case fldDate:
                case fldTime:
                case fldTimeStamp:
                case fldBcd:
                case fldBlob:
                case fldFloatIEEE:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                default:
                    ret = PXERR_INVFIELDTYPE;
                    break;
            }
            break;

        case fldUInt16:
            switch(srcType)
            {
                case fldChar:
                case fldVarBytes:
                case fldCharIdapi:
                    if (sscanf((char *) srcPtr,"%lf",&db) < 1)
                    {
                        ret = PXERR_DATACONV;
                    }
                    if (db < 0 || db > USHRT_MAX)
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    *((UINT16*) destPtr) = (UINT16) db;
                    break;
                case fldShort:
                    if ( (*( (INT16 *) srcPtr) ) < 0)
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    *((UINT16 *) destPtr) = *((INT16 *) srcPtr);
                    break;
                case fldUInt16:
                    *((UINT16 *) destPtr) = *((UINT16 *) srcPtr);
                    break;
                case fldLong:
                    ld = *((INT32 *) srcPtr);
                    if (ld < SHRT_MIN || ld > USHRT_MAX)
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    *((UINT16 *) destPtr) = (UINT16) ld;
                    break;
                case fldUInt32:
                    ld = *((UINT32 *) srcPtr);
                    if (ld > USHRT_MAX)
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    *((UINT16 *) destPtr) = (UINT16) ld;
                    break;
                case fldDouble:
                    db = *((FLOAT *) srcPtr);
                    if ((db < 0) || (db > USHRT_MAX))
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    else
                    {
                        *((UINT16 *) destPtr) = (UINT16) db;
                    }
                    break;
                case fldDate:
                case fldTime:
                case fldTimeStamp:
                case fldBcd:
                case fldBlob:
                case fldFloatIEEE:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                default:
                    ret = PXERR_INVFIELDTYPE;
                    break;
            }
            break;

        case fldDouble:
            switch(srcType)
            {
                case fldChar:
                case fldVarBytes:
                case fldCharIdapi:
                    if (sscanf((CHAR *) srcPtr,"%lf",&db) < 1)
                    {
                        ret = PXERR_DATACONV;
                    }
                    *((FLOAT *) destPtr) = db;
                   break;
                case fldShort:
                    *((FLOAT *) destPtr) = *((INT16 *) srcPtr);
                    break;
                case fldUInt16:
                    *((FLOAT *) destPtr) = *((UINT16 *) srcPtr);
                    break;
                case fldLong:
                    *((FLOAT *) destPtr) = *((INT32 *) srcPtr);
                    break;
                case fldUInt32:
                    *((FLOAT *) destPtr) = *((UINT32 *) srcPtr);
                    break;
                case fldDouble:
                    *((FLOAT *) destPtr) = *((FLOAT *) srcPtr);
                    break;
                case fldDate:
                case fldTime:
                case fldTimeStamp:
                case fldBcd:
                case fldBlob:
                case fldFloatIEEE:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                default:
                    ret = PXERR_INVFIELDTYPE;
                    break;
            }
            break;

        case fldLong:
            switch(srcType)
            {
                case fldChar:
                case fldVarBytes:
                case fldCharIdapi:
                    if (sscanf((char *) srcPtr,"%lf",&db) < 1)
                    {
                        ret = PXERR_DATACONV;
                    }
                    if (db < LONG_MIN || db > LONG_MAX)
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    *((INT32 *) destPtr) = (INT32) db;
                    break;
                case fldShort:
                   *((INT32 *) destPtr) = *((INT16 *) srcPtr);
                    break;
                case fldUInt16:
                   *((INT32 *) destPtr) = *((INT16 *) srcPtr);
                    break;
                case fldLong:
                    *((INT32 *) destPtr) = *((INT32 *) srcPtr);
                    break;
                case fldUInt32:
                    *((INT32 *) destPtr) = *((UINT32 *) srcPtr);
                    break;
                case fldDouble:
                    db = *((FLOAT *) srcPtr);
                    if (db < LONG_MIN || db > LONG_MAX)
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    else
                    {
                        *((INT32 *) destPtr) = (INT32) db;
                    }
                    break;
                case fldDate:
                case fldTime:
                case fldTimeStamp:
                case fldBcd:
                case fldBlob:
                case fldFloatIEEE:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                default:
                    ret = PXERR_INVFIELDTYPE;
                    break;
            }
            break;

        case fldUInt32:
            switch(srcType)
            {
                case fldChar:
                case fldVarBytes:
                case fldCharIdapi:
                    if (sscanf((char *) srcPtr,"%lf",&db) < 1)
                    {
                        ret = PXERR_DATACONV;
                    }
                    if ((db < 0) || (db > ULONG_MAX))
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    *((UINT32 *) destPtr) = (UINT32) db;
                    break;
                case fldShort:
                    if ((*((INT16 *) srcPtr) < 0))
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                   *((UINT32 *) destPtr) = *((INT16 *) srcPtr);
                    break;
                case fldUInt16:
                   *((UINT32 *) destPtr) = *((UINT16 *) srcPtr);
                    break;
                case fldLong:
                    if ((*((INT32 *) srcPtr) < 0))
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    *((UINT32 *) destPtr) = *((INT32 *) srcPtr);
                    break;
                case fldUInt32:
                    *((UINT32 *) destPtr) = *((UINT32 *) srcPtr);
                    break;
                case fldDouble:
                    db = *((FLOAT *) srcPtr);
                    if (db < LONG_MIN || db > LONG_MAX)
                    {
                        ret = DBIERR_OUTOFRANGE;
                    }
                    else
                    {
                        *((UINT32 *) destPtr) = (INT32) db;
                    }
                    break;
                case fldDate:
                case fldTime:
                case fldTimeStamp:
                case fldBcd:
                case fldBlob:
                case fldFloatIEEE:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                default:
                    ret = PXERR_INVFIELDTYPE;
                    break;
            }
            break;
            
        case fldDate:
            switch(srcType)
            {
                case fldChar:
                case fldVarBytes:
                case fldCharIdapi:
                    ret = strToDate((char *) srcPtr, &dt);
                                    *((BDate *) destPtr) = dt;
                    break;
                case fldShort:
                case fldUInt16:
                case fldLong:
                case fldUInt32:
                case fldDouble:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                case fldDate:
                    *((BDate *) destPtr) = *((BDate *) srcPtr);
                    break;
                case fldTimeStamp:
                    *((BDate *) destPtr) = (((BTimeStamp *)srcPtr)->BDay);
                    break;
                case fldTime:
                case fldBcd:
                case fldBlob:
                case fldFloatIEEE:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                default:
                    ret = PXERR_INVFIELDTYPE;
                    break;
             }
             break;
             
        case fldTime:
            switch(srcType)
            {
                case fldChar:
                case fldVarBytes:
                case fldCharIdapi:
                    ret = strToTime((char *) srcPtr, &tTime);
                                    *((BTime *) destPtr) = tTime;
                    break;
                case fldShort:
                case fldUInt16:
                case fldLong:
                case fldUInt32:
                case fldDouble:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                case fldTime:
                    *((BTime *) destPtr) = *((BTime *) srcPtr);
                    break;
                case fldTimeStamp:
                    *((BTime *) destPtr) = (BTime(((BTimeStamp *)srcPtr)->BHour));
                    break;
                case fldDate:
                case fldBcd:
                case fldBlob:
                case fldFloatIEEE:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                default:
                    ret = PXERR_INVFIELDTYPE;
                    break;
            }
            break;
                    
        case fldTimeStamp:
            switch(srcType)
            {
                case fldChar:
                case fldVarBytes:
                case fldCharIdapi:
                   ret = strToTimeStamp((char *) srcPtr, &tTimestamp);
                                        *((BTimeStamp *) destPtr) = tTimestamp;
                   break;
                case fldShort:
                case fldUInt16:
                case fldLong:
                case fldUInt32:
                case fldDouble:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                case fldDate:
                {
                    BTime temp = { 0, 0, 0};
                    (((BTimeStamp *) destPtr)->BDay) = *((BDate *)srcPtr);
                    (((BTimeStamp *) destPtr)->BHour) = temp;
                    break;
                }
                case fldTime:
                {
                    BDate temp = { 0, 0, 0};
                    (((BTimeStamp *) destPtr)->BHour) = *((BTime *) srcPtr);
                    (((BTimeStamp *) destPtr)->BDay) = temp;
                    break;
                }
                case fldTimeStamp:
                    *((BTimeStamp *) destPtr) = (*(BTimeStamp *)srcPtr);
                    break;
                case fldBcd:
                case fldBlob:
                case fldFloatIEEE:
                    ret = PXERR_TYPEMISMATCH;
                    break;
                default:
                    ret = PXERR_INVFIELDTYPE;
                    break;
            }
            break;

        default:
            ret = PXERR_INVFIELDTYPE;
            break;
    }
    return ret;
}

//BR BEG
/*
;;Retcode
;;strToTime(const char *str,
;;          BTime *dt)
;;
;;  Additions by //BR
;;    941123
;;      -Blank string returns DBIERR_NONE, 00:00:00. Useful when
;;        converting 'date' types to 'timestamp' types
;;
*/
//BR END
// Format of string is: 'hh:mm:ss'
Retcode
strToTime (const char *str, BTime *dt)
{
    TIME dTime;

    while (!isdigit(*str))
    {
//BR BEG
#if 0//941123
        if (*str != '\0')
        {
            return DBIERR_INVALIDTIME;
#else
        if ( *str == '\0' )
        {
          dt->hour = 0;
          dt->minute = 0;
          dt->milSec = 0; //00:00:00
          return ( DBIERR_NONE );
#endif//0
//BR END
        }
        ++str;
    }

    //Have 1st digit
    //Hour:
    dt->hour = (*str - '0') * 10;
    ++str;
    dt->hour += (*str - '0');
    ++str;
    if (*str != ':')
    {
        return DBIERR_INVALIDTIME;
    }

    ++str;

    //Minute:
    dt->minute = (*str - '0') * 10;
    ++str;
    dt->minute += (*str - '0');
    ++str;

    if (*str != ':')
    {
        return DBIERR_INVALIDTIME;
    }
        ++str;

    //MilSec:
    dt->milSec = (*str - '0') * 10;
    ++str;
    dt->milSec += (*str - '0');
    dt->milSec *= 1000;

    return DbiTimeEncode((UINT16)dt->hour, (UINT16)dt->minute, dt->milSec,
                         &dTime);
}

//BR BEG
/*
;;Retcode
;;strToTimeStamp (const char *str, BTimeStamp *dt)
;;
;;  950119
;;    -Accepts alternative format: hh:mm:ss, mm/dd/yyyy
;;      (Orig. fmt. mm/dd/yyyy hh:mm:ss still works as well)
;;
;;      This allows a getField( , char*, )'s returned value
;;      to be used in a putField( , char* ) where the field types
;;      are each of type timestamp. Invalid date error occurred
;;      in call to putField() when the string was formatted
;;      with time first (as returned by getField).
;;  941123
;;    -Null time string converted to 00:00:00
;;
*/
//BR END
#pragma argsused
// Format of string is: ' mm/dd/yyyy hh:mm:ss '
Retcode
strToTimeStamp (const char *str, BTimeStamp *dt)
{
    int             n;
    const char* ps = str;

    while (!isdigit(*ps))
    {
        if (*ps == '\0')
        {
            return DBIERR_INVALIDDATE;
                }
        ++ps;
    }

    //Have 1st digit in string
//BR BEG
#if 0//951119
#else
    const char* ps1 = strstr( ps, ":" );
    if ( NULL != ps1 && 2 >= ps1 - ps ) //? Time first
    {
      n = strToTime(ps, &dt->BHour);
      if (n != DBIERR_NONE)
      {
        return n;
      }
      while (*ps != ' ')
      {
        if (*ps == '\0')
        {
          return ( DBIERR_INVALIDDATE );
        }
        ++ps;
      }
      //Have 1st blank after time, assume date follows
      return ( strToDate( ps, &dt->BDay ) );
    }
    //Else date is first
#endif//951119
//BR END
    n = strToDate(ps, &dt->BDay);
    if (n != DBIERR_NONE)
    {
                return n;
    }
    while (*ps != ' ')
        {
        if (*ps == '\0')
                {
//BR BEG
#if 0//941123
          return DBIERR_INVALIDTIME;
#else
          break; //strToTime() will convert null time string to 00:00:00
#endif//0
//BR END
        }
        ++ps;
    }

        //Have 1st blank after date, assume time follows
        return strToTime(ps, &dt->BHour);
}

//BR BEG
/*
;;Retcode
;;strToDate(const char *str, BDate *dt)
;;
;;  950119
;;    -Leading space no longer causes invalid date error
;;
*/
//BR END
//  Convert String to Date. The string must be in the format
//  MM/DD/YYYY. You may rewrite this function to handle a
//  variety of different Date formats.
Retcode
strToDate(const char *str, BDate *dt)
{
    int     i;
//BR BEG
#if 0//950515
    DATE    Date;
#else
    DBIDATE    Date;
#endif//950515
#if 0//950119
    if (!isdigit(*str))
    {
        return DBIERR_INVALIDDATE;
    }
#else
    while ( ! isdigit( *str ) )
    {
      if ( '\0' == *str )
      {
        return ( DBIERR_INVALIDDATE );
      }
      ++str;
    }
    //str-> 1st digit
#endif//950119
//BR END

    dt->month = *str++ - '0';
    if (isdigit(*str))
    {
        dt->month = dt->month * 10 + (*str++ - '0');     // 2-digit month.
    }

    if (*str++ != '/')
    {
        return DBIERR_INVALIDDATE;
    }

    if (!isdigit(*str))
    {
        return DBIERR_INVALIDDATE;
    }

    dt->day = *str++ - '0';
    if (isdigit(*str))
    {
        dt->day = dt->day * 10 + (*str++ - '0');         // 2-digit day.
    }

    if (*str++ != '/')
    {
        return DBIERR_INVALIDDATE;
    }

    if (!isdigit(*str))
    {
        return DBIERR_INVALIDDATE;
    }

    i = *str++ - '0';
    if (!isdigit(*str))
    {
        return DBIERR_INVALIDDATE;
    }

    i = i * 10 + (*str++ - '0');
    if (!isdigit(*str ))
    {
        i += 1900;
    }
    else
    {
        if (!isdigit(*str))
        {
            return DBIERR_INVALIDDATE;
        }
        i = i * 10 + *str++ - '0';

        if (!isdigit(*str))
        {
            return DBIERR_INVALIDDATE;
        }

        i = i * 10 + (*str++ - '0');                     // 4-digit year.

        if (isdigit( *str ))
        {
            return DBIERR_INVALIDDATE;
        }
    }

    dt->year = i;

    return DbiDateEncode((UINT16)dt->month, (UINT16)dt->day, dt->year, &Date);
}
    
// Convert Date to String. The string will be output in the format
// MM/DD/YYYY. You may rewrite this function to handle a variety of
// different Date formats.

//=====================================================================
//  Code:   dateToStr (BDate Date, pCHAR szDate)
//
//  Input:  Date     - Date which needs to be formatted
//          szDate   - String to contain the formatted date
//
//  Return: Result returned from DbiDateDecode().
//
//  Description:
//          This function is used to format date fields according to the
//          settings in the IDAPI.CFG file.
//=====================================================================
Retcode
dateToStr (const BDate *Date, pCHAR szDate)
{
    DBIResult   rslt;       // Return Value from IDAPI
    FMTDate     fmtDate;    // Date Format
    UINT16      uDay;       // Day portion of date
    UINT16      uMonth;     // Month portion of date
    INT16       iYear;      // Year portion of date
                
    // Get the formatting of the Date
    rslt = DbiGetDateFormat(&fmtDate);
    if (rslt != DBIERR_NONE)
    {
        return rslt;
    }

    uDay    = Date->day;
    uMonth  = Date->month;
    iYear   = Date->year;

    // Determine if date should be displayed year based
    if (!(fmtDate.bFourDigitYear) &&
        (fmtDate.bYearBiased))
    {
        iYear = iYear + 1900;
    }

    if (!(fmtDate.bFourDigitYear))
    {
        iYear = iYear - 1900;
    }

    // Make certain the seperator is not the
    // escape character.
    if (!strcmp(fmtDate.szDateSeparator, "\\"))
    {
        strcpy(fmtDate.szDateSeparator, "/");
    }

    // Format the date
    switch(fmtDate.iDateMode)
    {
        // MM/DD/YY - Month, Day, Year
        case 0:
            sprintf(szDate,
                    "%0*d%s%0*d%s%0*d",
                    1 + fmtDate.bMonthLeadingZero,
                    uMonth,
                    fmtDate.szDateSeparator,
                    1 + fmtDate.bDayLeadingZero,
                    uDay,
                    fmtDate.szDateSeparator,
                    2,
                    iYear);
            break;
        // DD/MM/YY - Day, Month, Year
        case 1:
            sprintf(szDate,
                    "%0*d%s%0*d%s%0*d",
                    1 + fmtDate.bDayLeadingZero,
                    uDay,
                    fmtDate.szDateSeparator,
                    1 + fmtDate.bMonthLeadingZero,
                    uMonth,
                    fmtDate.szDateSeparator,
                    2,
                    iYear);
            break;
        // YY/MM/DD - Year, Month, Day
        case 2:
            sprintf(szDate,
                    "%0*d%s%0*d%s%0*d",
                    2,
                    iYear,
                    fmtDate.szDateSeparator,
                    1 + fmtDate.bMonthLeadingZero,
                    uMonth,
                    fmtDate.szDateSeparator,
                    1 + fmtDate.bDayLeadingZero,
                    uDay);
            break;
    }
    return rslt;
}

//BR BEG
/*
;;Retcode
;;timeToStr (const BTime *Time, pCHAR szTime)
;;
;;  950119
;;    Changes by //BR
;;      x If IDAPI specifies 24 hr. time format, always put leading 0 for hour
;;
*/
//BR END
//=====================================================================
//  Code:   timeToStr (BTime Time, pCHAR szTime)
//
//  Input:  Time     - Time which needs to be formatted
//          szTime   - String to contain the formatted time
//
//  Return: Result returned from DbiTimeDecode().
//
//  Description:
//          This function is used to format time fields according to
//          the settings in the IDAPI.CFG file.
//=====================================================================
Retcode
timeToStr (const BTime *Time, pCHAR szTime)
{
    DBIResult   rslt;       // Return value from IDAPI functions
    FMTTime     fmtTime;    // Time format
    UINT16      uHour;      // Hour portion of the time
    UINT16      uMinute;    // Minute portion of the time
    UINT16      uMilSec;    // Second portion (in ms) of the time
    UINT16      uIsAm;      // Is Time AM?
    CHAR        szTemp[10]; // Temp buffer, used for AM, PM string

    // Get the formatting of the Time
    rslt = DbiGetTimeFormat(&fmtTime);
    if (rslt != DBIERR_NONE)
    {
        return rslt;
    }

    uHour   = Time->hour;
    uMinute = Time->minute;
    uMilSec = Time->milSec;

    // Make certain the seperator is not the
    // escape character.
    if (fmtTime.cTimeSeparator == '\\')
    {
        fmtTime.cTimeSeparator  = '/';
    }

    // Check if time should be displayed in 12 or 24 hour format
    if (fmtTime.bTwelveHour)
    {
        // Temporary variable used to determine if the time is AM or PM
        uIsAm = uHour;
        uHour = uHour % 12;
        if (uHour == 0)
        {
            uHour = 12;
        }
        // If AM, set uIsAm to TRUE, else set uIsAm to 0
        if (uIsAm == uHour)
        {
            uIsAm = 1;
        }
        else
        {
            uIsAm = 0;
        }
    }

    // Format the hour and minute of the time
//BR BEG
#if 0//950119
    sprintf(szTime, "%2u%c%02u",
             uHour,
             fmtTime.cTimeSeparator,
             uMinute);
#else//Format 24 hour with leading 0 for hour always
    if ( fmtTime.bTwelveHour )
    {
      sprintf(szTime, "%2u%c%02u",
              uHour,
              fmtTime.cTimeSeparator,
              uMinute);
    }
    else//24 hr.
    {
      sprintf(szTime, "%02u%c%02u",
              uHour,
              fmtTime.cTimeSeparator,
              uMinute);
    }
#endif//950119
//BR END

    // Determine if seconds are to be displayed
    if (fmtTime.bSeconds)
    {
        sprintf(szTemp, "%c%02u",
                fmtTime.cTimeSeparator,
                (uMilSec / 1000));

        strcat(szTime, szTemp);

        // Determine if milliseconds are to be displayed
        if (fmtTime.bMilSeconds)
        {
            sprintf(szTemp, "%c%03u",
                    fmtTime.cTimeSeparator,
                    (uMilSec % 1000));
            strcat(szTime, szTemp);
        }
    }

    // Add a string to the time if the time is 12-hour
    if (fmtTime.bTwelveHour)
    {
        // Add a space to the format
        strcat(szTime, " ");
        // If AM
        if (uIsAm)
        {
            // Copy the AM string
            strcat(szTime, fmtTime.szAmString);
        }
        else // otherwise it's PM
        {
            // Copy the PM string
            strcat(szTime, fmtTime.szPmString);
        }
    }

    return rslt;
}

//=====================================================================
//  Code:   timeStampToStr (TIMESTAMPE TimeStamp, pCHAR szTime)
//
//  Input:  TIME     - Time which needs to be formatted
//          szTime   - String to contain the formatted time
//
//  Return: Result returned from DbiTimeStampDecode().
//
//  Description:
//          This function is used to format TimeStamp fields according
//          to the settings in the IDAPI.CFG file. It calls the
//          FormatDate and FormatTime functions which are defined
//          above.
//=====================================================================
DBIResult
timeStampToStr (const BTimeStamp *TimeStamp, pCHAR szTimeStamp)
{
    DBIResult   rslt;       // Return value from IDAPI functions
    CHAR        szDate[15]; // Date string
    CHAR        szTime[20]; // Time String

    rslt = dateToStr(&(TimeStamp->BDay), szDate);

    if (rslt != DBIERR_NONE)
    {
        return rslt;
    }

    // Get the Time format
    rslt = timeToStr(&(TimeStamp->BHour), szTime);
    if (rslt != DBIERR_NONE)
    {
        return rslt;
    }

    // Format the TimeStamp
    sprintf(szTimeStamp, "%s, %s", szTime, szDate);

    return rslt;
}

Retcode
BRecord::getField(FIELDNUMBER fldnbr, char *buf,
                  int bufLen ) const
{
        return getField( fldnbr, buf, bufLen, (BOOL) bLastNull);
}

Retcode
BRecord::getField(FIELDNUMBER fldnbr, void *buf,
                  int bufLen) const
{
        return getField( fldnbr, buf, bufLen, (BOOL) bLastNull);
}

Retcode
BRecord::getField(FIELDNUMBER fldnbr, double& val) const
{
        return getField( fldnbr, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(FIELDNUMBER fldnbr, INT16& val) const
{
        return getField( fldnbr, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(FIELDNUMBER fldnbr, INT32& val) const
{
        return getField( fldnbr, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(FIELDNUMBER fldnbr, UINT16& val) const
{
        return getField( fldnbr, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(FIELDNUMBER fldnbr, UINT32& val) const
{
        return getField( fldnbr, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(FIELDNUMBER fldnbr, FMTBcd& val) const
{
        return getField( fldnbr, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(FIELDNUMBER fldnbr, BDate& val) const
{
        return getField( fldnbr, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(FIELDNUMBER fldnbr, BTime& val) const
{
        return getField( fldnbr, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(FIELDNUMBER fldnbr, BTimeStamp& val) const
{
        return getField( fldnbr, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(const char *fldName, char *buf, int bufLen) const
{
        return getField( (char*) fldName, buf, bufLen, (BOOL) bLastNull);
}

Retcode
BRecord::getField(const char *fldName, void *buf, int bufLen) const
{
        return getField( (char*) fldName, buf, bufLen, (BOOL) bLastNull);
}

Retcode
BRecord::getField(const char *fldName, double& val) const
{
        return getField( (char*) fldName, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(const char *fldName, INT16& val) const
{
        return getField( (char*) fldName, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(const char *fldName, INT32& val) const
{
        return getField( (char*) fldName, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(const char *fldName, UINT16& val) const
{
        return getField( (char*) fldName, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(const char *fldName, UINT32& val) const
{
        return getField((char*) fldName, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(const char *fldName, FMTBcd& val) const
{
        return getField((char*) fldName, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(const char *fldName, BDate& val) const
{
        return getField((char*) fldName, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(const char *fldName, BTime& val) const
{
        return getField((char*) fldName, val, (BOOL) bLastNull);
}

Retcode
BRecord::getField(const char *fldName, BTimeStamp& val) const
{
        return getField((char*)fldName, val, (BOOL) bLastNull);
}

Retcode
BRecord::openBlobRead(const char* psFldName,
                      BOOL bUsePrivateCopy) const
{
        FIELDNUMBER hFld;

        if ((hFld = BRecord::getFieldNumber(psFldName)) == 0)
        {
                return (lastError);
        }

        return openBlobRead(hFld, bUsePrivateCopy);
}

Retcode
BRecord::openBlobWrite(const char* psFldName,
                       long nSize,
                       BOOL bCopyOld)
{
        FIELDNUMBER hFld;
        
        if ((hFld = BRecord::getFieldNumber(psFldName)) == 0)
        {
                return (lastError);
        }

        return openBlobWrite(hFld, nSize, bCopyOld);
}

Retcode
BRecord::getBlobHeader(const char* psFldName,
                       int nSize,
                       void* pvBuffer,
                       int& rnBytesRead) const
{
        FIELDNUMBER hFld;
        
        if ((hFld = BRecord::getFieldNumber(psFldName)) == 0 )
        {
                return (lastError);
        }

        return getBlobHeader(hFld, nSize, pvBuffer, rnBytesRead);
}

unsigned long
BRecord::getBlobSize(const char* psFldName) const
{
        FIELDNUMBER hFld;
        //
        if ((hFld = BRecord::getFieldNumber(psFldName)) == 0)
        {
                return (lastError);
        }

        return getBlobSize(hFld);
}

Retcode
BRecord::getBlob(const char* psFldName,
                 unsigned int nSize,
                 long nOffset,
                 void far *pvBuffer) const
{
        FIELDNUMBER hFld;
        
        if ((hFld = BRecord::getFieldNumber(psFldName)) == 0)
        {
                return (lastError);
        }

        return getBlob(hFld, nSize, nOffset, pvBuffer);
}

Retcode
BRecord::closeBlob(const char* psFldName,
                   BOOL bAccept) const
{
        FIELDNUMBER hFld;

        if ((hFld = BRecord::getFieldNumber(psFldName)) == 0)
        {
                return (lastError);
        }

        return closeBlob(hFld, bAccept);
}

Retcode
BRecord::putBlob(const char* psFldName,
                                 unsigned long nSize,
                                 unsigned long nOffset,
                                 void far *pvBuffer)
{
    FIELDNUMBER hFld;

    if ((hFld = BRecord::getFieldNumber(psFldName)) == 0)
    {
        return (lastError);
    }

        return putBlob(hFld, nSize, nOffset, pvBuffer);
}

Retcode
BRecord::dropBlob(const char* psFldName) const
{
        FIELDNUMBER hFld;

        if ((hFld = BRecord::getFieldNumber(psFldName)) == 0)
        {
                return (lastError);
        }
        return dropBlob(hFld);
}


