/*
;;bcursor.cpp
;;
;;  Changes and additions by //BR
;;
*/
/*********************************************************************
**
**                          BCURSOR.CPP
**
** This file contains member functions of the BCursor class.
**  
**
*********************************************************************/

// DBF - (C) Copyright 1994 by Borland International

#include <kdbf.h>
#pragma hdrstop

#ifdef __DLL__
   #define EXPORT _export
#else
   #define EXPORT
#endif

Retcode EXPORT addCursor(dbdef *, BCursor *);    // Prototype for utility 
                                                 // function.

void EXPORT deleteCursor(dbdef *, BCursor *);    // Prototype for utility
                                                 // function.

Retcode getDesc(TABLEHANDLE,int&, FieldDesc far *);  // Prototype utility
                                                     // function in BDatabas.

Retcode EXPORT convertFld(void *, PXFieldType, int,  // Source value.
                          void *, PXFieldType, int); // Destination.

int getPdxRecSize(FieldDesc far *desc, int numFields);

// Make only the object, not any Paradox cursors.
BCursor::BCursor()
{
    genericRec = 0;
    curdef *co = 0;

    try
    {
        co = new curdef;       // See the INTSTRCT.H file.
        lastError = DBIERR_NONE;
        lastChange = 0;
        co->handleCnt = 0;
        co->fieldCnt = 0;
        co->recList = 0;
        curobj = (void *)co;
        co->dbH = 0;
        isOpen = FALSE;
        curStatus = atBegin;
        masterTabH = NULL;
        tabname = NULL;
        tabH = NULL;
    }
    catch(xalloc)
    {
        if (co)
        {
            delete co;
        }
        lastError = DBIERR_NOMEMORY;
        return;
    }

}

//BR BEG
/*
;;BCursor::BCursor(BDatabase *db,
;;                 const char *tableName,
;;                 int indexID,
;;                 BOOL saveEveryChange,
;;                 DBIOpenMode openMode,
;;                 DBIShareMode shareMode,
;;                 XLTMode xltMode)
;;
;;  Changes by //BR
;;    950503
;;      x Changed from using C-style 'malloc' to C++-style 'new'
;;
;;          This allows application to assume all KDBF far heap memory is allocated
;;          via operators new and delete, and to handle mem alloc errors more
;;          consistently (via catching xalloc exception or using
;;          set_new_handler() ).
;;
;;        (Changed all occurrences in bcursor.cpp)
;;
*/
//BR END
// Create the object and open a table of the same type as the database
// (by default)
BCursor::BCursor(BDatabase *db,
                 const char *tableName,
                 int indexID,
                 BOOL saveEveryChange,
                 DBIOpenMode openMode,
                 DBIShareMode shareMode,
                 XLTMode xltMode)
{
    curdef       *co = 0;
    CHAR         tblType[DBIMAXNAMELEN + 1];
    FieldDesc    *fldDescs = 0;

    tabH = 0;
    tabname = 0;

    try
    {
        co = new curdef;         // See the INTSTRCT.H file.

        co->handleCnt = 0;
        co->recList = 0;
        co->indexID = indexID;
        co->fieldCnt = 0;
        co->saveEveryChange = saveEveryChange;
        curobj = (void *)co;
        isOpen = FALSE;
        curStatus = atBegin;
        co->dbH = 0;
        masterTabH = NULL;

        if (!db->isOpen)
        {
            lastError = PXERR_DBNOTOPEN;
            throw lastError;
        }

        strcpy(tblType, db->Driver);

        // Open the table

        lastError = openTable(db, tableName, tblType, indexID,
                              openMode, shareMode, xltMode);

        if (lastError != DBIERR_NONE)
        {
            throw lastError;
        }

        isOpen = TRUE;

        tabname = new char[(strlen(tableName)+1)];

        strcpy(tabname, tableName);
        strcpy(tabtype, tblType);

        // Allocate descriptors, add this cursor to the database, and create a
        // generic record. If any of these result in error, close the cursor
        // and return an error.

        genericRec = new BRecord(this);
        if (genericRec->lastError != DBIERR_NONE)
        {
            lastError = genericRec->lastError;
            delete genericRec;
            genericRec = 0;
        }
        else if ((lastError = addCursor((dbdef *)db->dbobj, this)) ==
                  DBIERR_NONE)
        {
            co->dbH = db;
            co->fieldCnt = db->getFieldCount(tableName);
//BR BEG
#if 0//950503
            co->desc = (FieldDesc far *) _fmalloc(sizeof(FieldDesc) *
                                                  co->fieldCnt);
            if (!co->desc)
            {
                lastError = DBIERR_NOMEMORY;
                throw lastError;
            }
            else
            {
                lastError = getDesc(tabH, co->fieldCnt, co->desc);
            }
#else
            co->desc = new FieldDesc[ co->fieldCnt ];
            lastError = getDesc(tabH, co->fieldCnt, co->desc);
#endif//950503
//BR END
        }
        if (lastError)
        {
            DbiCloseCursor(&tabH);
            delete tabname;
            isOpen = FALSE;
        }
    }
    catch(xalloc)
    {
        if (tabname)
        {
            delete tabname;
        }
        if (fldDescs)
        {
            delete fldDescs;
        }
        lastError = DBIERR_NOMEMORY;
        isOpen = FALSE;
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        return;
    }
    catch(Retcode)
    {
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        if (fldDescs)
        {
            delete fldDescs;
        }
        if (tabname)
        {
            delete tabname;
        }
        isOpen = FALSE;
        return;
    }
}

BCursor::BCursor(BDatabase *db,
                 const char *tableName,
                 const char *tableType,
                 int indexID,
                 DBIOpenMode openMode,
                 DBIShareMode shareMode,
                 XLTMode xltMode)
{
    curdef       *co = 0;
    CHAR         tblType[DBIMAXNAMELEN + 1];
    FieldDesc    *fldDescs = NULL;

    tabH = 0;
    tabname = 0;

    try
    {
        co = new curdef;         // See the INTSTRCT.H file.

        co->handleCnt = 0;
        co->recList = 0;
        co->indexID = indexID;
        co->fieldCnt = 0;
        co->saveEveryChange = TRUE;
        curobj = (void *)co;
        isOpen = FALSE;
        curStatus = atBegin;
        co->dbH = 0;
        masterTabH = NULL;
        
        if (!db->isOpen)
        {
            lastError = PXERR_DBNOTOPEN;
            throw lastError;
        }

        if (tableType == NULL)
        {
            strcpy(tblType, db->Driver);
        }
        else
        {
            strcpy(tblType, tableType);
        }

        // Open the table
        lastError = openTable(db, tableName, tblType, indexID,
                              openMode, shareMode, xltMode);

        if (lastError != DBIERR_NONE)
        {
            throw lastError;
        }
        
        isOpen = TRUE;

        tabname = new char[(strlen(tableName)+1)];
        strcpy(tabname, tableName);
        strcpy(tabtype, tblType);

        // Allocate descriptors, add this cursor to the database, and create a
        // generic record. If any of these result in error, close the cursor
        // and return an error.

        genericRec = new BRecord(this);

        if (genericRec->lastError != DBIERR_NONE)
        {
            lastError = genericRec->lastError;
            delete genericRec;
            genericRec = 0;
        }
        else if ((lastError = addCursor((dbdef *)db->dbobj, this)) ==
                                        DBIERR_NONE)
        {
            co->dbH = db;
            co->fieldCnt = db->getFieldCount(tableName);
//BR BEG
#if 0//950503
            co->desc = (FieldDesc far *) _fmalloc(sizeof(FieldDesc) *
                                                  co->fieldCnt);
            if (!co->desc)
            {
                lastError = DBIERR_NOMEMORY;
                throw lastError;
            }
            else
            {
                lastError = getDesc(tabH, co->fieldCnt, co->desc);
            }
#else
            co->desc = new FieldDesc[ co->fieldCnt ];
            lastError = getDesc(tabH, co->fieldCnt, co->desc);
#endif//950503
//BR END
        }
        if (lastError)
        {
            DbiCloseCursor(&tabH);
            delete tabname;
            isOpen = FALSE;
        }
    }
    catch(xalloc)
    {
        if (tabname)
        {
            delete tabname;
        }

        if (fldDescs)
        {
            delete fldDescs;
        }
        lastError = DBIERR_NOMEMORY;
        isOpen = FALSE;
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        return;
    }
    catch(Retcode)
    {
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        if (tabname)
        {
            delete tabname;
        }

        if (fldDescs)
        {
            delete fldDescs;
        }
        isOpen = FALSE;
        return;
    }
}

BCursor::BCursor(BDatabase *db,
                 const char *tableName,
                 const char *indexName,
                 DBIOpenMode openMode,
                 DBIShareMode shareMode,
                 XLTMode xltMode)
{
    curdef       *co = 0;
    CHAR         tblType[DBIMAXNAMELEN + 1];
    CHAR         idxName[DBIMAXNAMELEN + 1];
//BR BEG
#if 0//950515
    unsigned int indexSeqNo;
#else
    UINT16       indexSeqNo;
#endif//950515
//BR END
    FieldDesc    *fldDescs = NULL;
    IDXDesc      idxDesc;

    tabH = 0;
    tabname = 0;

    try
    {
        co = new curdef;         // See the INTSTRCT.H file.

        co->handleCnt = 0;
        co->recList = 0;
        co->indexID = 0;
        co->fieldCnt = 0;
        co->saveEveryChange = TRUE;
        curobj = (void *)co;
        isOpen = FALSE;
        curStatus = atBegin;
        co->dbH = 0;
        masterTabH = NULL;
        
        if (!db->isOpen)
        {
            lastError = PXERR_DBNOTOPEN;
            throw lastError;
        }

        strcpy(tblType, db->Driver);

        // Open the table on the given index. Method depends on table type.

        if (!strcmp(tblType, szDBASE))
        {
            strcpy(idxName, tableName);
            strncat(idxName, ".MDX", DBIMAXNAMELEN);
            idxName[DBIMAXNAMELEN] = 0;
            
            lastError = DbiOpenTable(db->hDb, (pCHAR)tableName, (pCHAR)tblType,
                                     (pCHAR)idxName, (pCHAR)indexName,
                                     0, openMode, shareMode,
                                     xltMode, FALSE, NULL, &tabH);
        }
        else
        {
            lastError = DbiOpenTable(db->hDb, (pCHAR)tableName, (pCHAR)tblType,
                                     (pCHAR)indexName, NULL, 0,
                                     openMode, shareMode, xltMode,
                                     FALSE, NULL, &tabH);
        }

        if (lastError != DBIERR_NONE)
        {
            throw lastError;
        }

        isOpen = TRUE;

        // Get information about the index.

        if (!strcmp(tblType, szPARADOX))
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)indexName, NULL, NULL,
                                         &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }
        else if (!strcmp(tblType, szDBASE))
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)idxName,
                                         (pCHAR)indexName,
                                         NULL, &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }
        else
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)indexName, NULL,
                                         NULL, &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }

        tabname = new char[(strlen(tableName)+1)];
        strcpy(tabname, tableName);
        strcpy(tabtype, tblType);

        // Allocate descriptors, add this cursor to the database, and create a
        // generic record. If any of these result in error, close the cursor
        // and return an error.

        genericRec = new BRecord(this);

        if (genericRec->lastError != DBIERR_NONE)
        {
            lastError = genericRec->lastError;
            delete genericRec;
            genericRec = 0;
        }
        else if ((lastError = addCursor((dbdef *)db->dbobj, this)) ==
                                        DBIERR_NONE)
        {
            co->dbH = db;
            co->fieldCnt = db->getFieldCount(tableName);
//BR BEG
#if 0//950503
            co->desc = (FieldDesc far *) _fmalloc(sizeof(FieldDesc) *
                                                  co->fieldCnt);
            if (!co->desc)
            {
                lastError = DBIERR_NOMEMORY;
                throw lastError;
            }
            else
            {
                lastError = getDesc(tabH, co->fieldCnt, co->desc);
            }
#else
            co->desc = new FieldDesc[ co->fieldCnt ];
            lastError = getDesc(tabH, co->fieldCnt, co->desc);
#endif//950503
//BR END
        }
        if (lastError)
        {
            DbiCloseCursor(&tabH);
            delete tabname;
            isOpen = FALSE;
        }
    }
    catch(xalloc)
    {
        if (tabname)
        {
            delete tabname;
        }

        if (fldDescs)
        {
            delete fldDescs;
        }
        lastError = DBIERR_NOMEMORY;
        isOpen = FALSE;
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        return;
    }
    catch(Retcode)
    {
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        if (tabname)
        {
            delete tabname;
        }

        if (fldDescs)
        {
            delete fldDescs;
        }
        isOpen = FALSE;
        return;
    }
}

BCursor::BCursor(BDatabase *db,
                 const char *tableName,
                 const char *indexName,
                 const char *indexTagName,
                 DBIOpenMode openMode,
                 DBIShareMode shareMode,
                 XLTMode xltMode)
{
    curdef       *co = 0;
    CHAR         tblType[DBIMAXNAMELEN + 1];
//BR BEG
#if 0//950515
    unsigned int indexSeqNo;
#else
    UINT16       indexSeqNo;
#endif//950515
//BR END
    FieldDesc    *fldDescs = NULL;
    IDXDesc      idxDesc;

    tabH = 0;
    tabname = 0;

    try
    {
        co = new curdef;         // See the INTSTRCT.H file.

        co->handleCnt = 0;
        co->recList = 0;
        co->indexID = 0;
        co->fieldCnt = 0;
        co->saveEveryChange = TRUE;
        curobj = (void *)co;
        isOpen = FALSE;
        curStatus = atBegin;
        co->dbH = 0;
        masterTabH = NULL;
        
        if (!db->isOpen)
        {
            lastError = PXERR_DBNOTOPEN;
            throw lastError;
        }

        strcpy(tblType, db->Driver);

        // Open the table on the specified index. Note that the method
        //   depends on the table format.

        if (!strcmp(tblType, szDBASE))
        {
            lastError = DbiOpenTable(db->hDb, (pCHAR)tableName, (pCHAR)tblType,
                                     (pCHAR)indexName, (pCHAR)indexTagName,
                                     0, openMode, shareMode,
                                     xltMode, FALSE, NULL, &tabH);
        }
        else
        {
            lastError = DbiOpenTable(db->hDb, (pCHAR)tableName, (pCHAR)tblType,
                                     (pCHAR)indexName, NULL, 0,
                                     openMode, shareMode, xltMode,
                                     FALSE, NULL, &tabH);
        }

        if (lastError != DBIERR_NONE)
        {
            throw lastError;
        }

        isOpen = TRUE;

        // Get information about the index.

        if (!strcmp(tblType, szPARADOX))
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)indexName, NULL, NULL,
                                         &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }
        else if (!strcmp(tblType, szDBASE))
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)indexName,
                                         (pCHAR)indexTagName,
                                         NULL, &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }
        else
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)indexName, NULL,
                                         NULL, &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }
       
        tabname = new char[(strlen(tableName)+1)];
        strcpy(tabname, tableName);
        strcpy(tabtype, tblType);

        // Allocate descriptors, add this cursor to the database, and create a
        // generic record. If any of these result in error, close the cursor
        // and return an error.

        genericRec = new BRecord(this);

        if (genericRec->lastError != DBIERR_NONE)
        {
            lastError = genericRec->lastError;
            delete genericRec;
            genericRec = 0;
        }
        else if ((lastError = addCursor((dbdef *)db->dbobj, this)) ==
                                        DBIERR_NONE)
        {
            co->dbH = db;
            co->fieldCnt = db->getFieldCount(tableName);
//BR BEG
#if 0//950503
            co->desc = (FieldDesc far *) _fmalloc(sizeof(FieldDesc) *
                                                  co->fieldCnt);
            if (!co->desc)
            {
                lastError = DBIERR_NOMEMORY;
                throw lastError;
            }
            else
            {
                lastError = getDesc(tabH, co->fieldCnt, co->desc);
            }
#else
            co->desc = new FieldDesc[ co->fieldCnt ];
            lastError = getDesc(tabH, co->fieldCnt, co->desc);
#endif//950503
//BR END
        }
        if (lastError)
        {
            DbiCloseCursor(&tabH);
            delete tabname;
            isOpen = FALSE;
        }
    }
    catch(xalloc)
    {
        if (tabname)
        {
            delete tabname;
        }

        if (fldDescs)
        {
            delete fldDescs;
        }
        lastError = DBIERR_NOMEMORY;
        isOpen = FALSE;
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        return;
    }
    catch(Retcode)
    {
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        if (tabname)
        {
            delete tabname;
        }

        if (fldDescs)
        {
            delete fldDescs;
        }
        isOpen = FALSE;
        return;
    }
}

//BR BEG
#if 0//950524
#else
/*
;;BCursor::BCursor(const BCursor & other)
;;
;;  Copy constructor
;;
*/
BCursor::BCursor(const BCursor & other)
{
  CloneInternals( other );
}

/*
;;BCursor&
;;BCursor::operator =( const BCursor & other )
;;
;;  Assignment Operator
;;
*/
BCursor&
BCursor::operator =( const BCursor & other )
{
  if (this == &other)    // Watch for self assignment
    return *this;
  //
  //  Close the old cursor
  if (isOpen)
  {
    close();
  }
  //
  //  Duplicate the input to make the new cursor
  CloneInternals( other );
  return *this;
}

/*
;;private:
;;void
;;BCursor::CloneInternals(const BCursor & other)
;;
;;  Internal cloning for copy ctor & assignment
;;
*/
void
BCursor::CloneInternals(const BCursor & other)
{
    curdef * co = 0;
    curdef * other_co = (curdef *)other.curobj;

    try
    {
        co = new curdef;         // See the INTSTRCT.H file.
        co->dbH             = other_co->dbH;
        co->indexID         = other_co->indexID;
        co->saveEveryChange = other_co->saveEveryChange;
        co->handleCnt       = 0;    // not used
        co->recList         = 0;    // not used
        co->fieldCnt        = other_co->fieldCnt;
        co->desc            = NULL;
        strncpy( co->indexName, other_co->indexName, DBIMAXNAMELEN );
        strncpy( co->indexTag,  other_co->indexTag,  DBIMAXNAMELEN );
        //
        //  Member Initialization
        genericRec = NULL;
        lastError  = other.lastError;
        isOpen     = other.isOpen;
        tabH       = 0;
        masterTabH = NULL;
        curStatus  = other.curStatus;
        curobj     = (void *)co;
        lastChange = other.lastChange;

        if ( other.isOpen ) //? Only if copy-from cursor is open
        {
          tabname = new char[(strlen(other.tabname)+1)];
          strcpy( tabname,  other.tabname );
          strncpy( tabtype, other.tabtype, DBIMAXNAMELEN+1 );
          //
          //  Duplicate the other cursor & properties
          lastError = DbiCloneCursor(other.tabH, FALSE, FALSE, &(tabH));
          if (lastError == DBIERR_NONE)
            {
            // Allocate descriptors, add this cursor to the database, and create a
            // generic record. If any of these result in error, close the cursor
            // and return an error.
            genericRec = new BRecord(this);

            if (genericRec->lastError != DBIERR_NONE)
            {
              lastError = genericRec->lastError;
              delete genericRec;
              genericRec = 0;
            }
            else if ((lastError = addCursor((dbdef *)co->dbH->dbobj, this)) ==
                                          DBIERR_NONE)
            {
              co->desc = new FieldDesc[ co->fieldCnt ];
              lastError = getDesc(tabH, co->fieldCnt, co->desc);
            }
          }
          if (lastError)
          {
            DbiCloseCursor(&tabH);
            delete tabname;
            isOpen = FALSE;
          }
        }
    }
    catch(xalloc)
    {
        if (tabname)
        {
            delete tabname;
        }

        lastError = DBIERR_NOMEMORY;
        isOpen = FALSE;
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        return;
    }
    catch(Retcode)
    {
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        if (tabname)
        {
            delete tabname;
        }
        isOpen = FALSE;
        return;
    }
}
#endif//950524
//BR END

// Destructor that closes the cursor if it's open.
BCursor::~BCursor()
{
    if (isOpen)
    {
        close();
    }

    curdef *co  = (curdef *)curobj;
    if (co)
    {
        if (co->handleCnt)
        {
            delete [] co->recList;    // Delete the array of record handles.
        }

        if (co->dbH)                // If database object exists, disconnect
        {
            deleteCursor((dbdef *)    // cursor from the database.
                         co->dbH->dbobj, this);
        }
        delete co;
    }
}

// Open a cursor on the specified table. indexID specifies the index to use,
// with 0 representing the primary index.

Retcode BCursor::open(BDatabase *db,
                      const char *tableName,
                      int indexID,
                      BOOL saveEveryChange,
                      DBIOpenMode openMode,
                      DBIShareMode shareMode,
                      XLTMode xltMode)
{
    CHAR              tblType[DBIMAXNAMELEN + 1];
    curdef            *co = (curdef *)curobj;
    FieldDesc         *fldDescs = NULL;

    if (isOpen)
    {
        lastError = PXERR_CURSORALREADYOPEN;
        return lastError;
    }

    if (!db->isOpen)
    {
        lastError = PXERR_DBNOTOPEN;
        return lastError;
    }

    tabH = NULL;
    tabname = NULL;

    try
    {
        strcpy(tblType, db->Driver);

        // Open the table

        lastError = openTable(db, tableName, tblType, indexID,
                              openMode, shareMode, xltMode);

        if (lastError != DBIERR_NONE)
        {
            throw lastError;
        }

        isOpen = TRUE;

        curStatus = atBegin;
        if (co->dbH != db)
        {
            // If the database for the cursor is changed, delete old context
            // and add the new one.

            if (co->dbH)                        // If database object exists,
            {
                deleteCursor((dbdef *)              // delete cursor from list.
                             co->dbH->dbobj, this);
            } 
            addCursor((dbdef *) db->dbobj, this);
        }
        co->dbH = db;
        co->indexID = indexID;
        co->saveEveryChange = saveEveryChange;

        tabname = new char[strlen(tableName)+1];
        strcpy(tabname, tableName);
        strcpy(tabtype, tblType);

        // Create generic record and store the table description
        // with every open cursor so that:
        //
        // 1. All records for a cursor share the same table description.
        //
        // 2. The BDE is not called for the type of a field
        //    with every Get and Put field operation performed on generic
        //    and custom records.

        genericRec = new BRecord(this);
        if (genericRec->lastError != DBIERR_NONE)
        {
            lastError = genericRec->lastError;
            delete genericRec;
            genericRec = 0;
        }
        else
        {
            co->fieldCnt = db->getFieldCount(tableName);
//BR BEG
#if 0//950503
            co->desc = (FieldDesc far *) _fmalloc(sizeof(FieldDesc) *
                                                  co->fieldCnt);
            if (!co->desc)
            {
                lastError = DBIERR_NOMEMORY;
                throw lastError;
            }
            else
            {
                lastError = getDesc(tabH, co->fieldCnt, co->desc);
            }
#else
            co->desc = new FieldDesc[ co->fieldCnt ];
            lastError = getDesc(tabH, co->fieldCnt, co->desc);
#endif//950503
//BR END
        }
        if (lastError)
        {
            DbiCloseCursor(&tabH);
            delete tabname;
            isOpen = FALSE;
        }
    }
    catch(xalloc)
    {
        if (tabname)
        {
            delete tabname;
        }
        if (fldDescs)
        {
            delete fldDescs;
        }
        lastError = DBIERR_NOMEMORY;
        isOpen = FALSE;
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        return lastError;
    }
    catch(...)
    {
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        if (tabname)
        {
            delete tabname;
        }
        if (fldDescs)
        {
            delete fldDescs;
        }
        isOpen = FALSE;
        return lastError;
    }

    return lastError;
}

Retcode BCursor::open(BDatabase *db,
                      const char *tableName,
                      const char *tableType,
                      int indexID,
                      DBIOpenMode openMode,
                      DBIShareMode shareMode,
                      XLTMode xltMode)
{
    char              tblType[DBIMAXNAMELEN+1];
    curdef            *co = (curdef *)curobj;

    if (isOpen)
    {
        lastError = PXERR_CURSORALREADYOPEN;
        return lastError;
    }

    if (!db->isOpen)
    {
        return lastError;
    }

    tabH = NULL;
    tabname = NULL;

    try
    {
        if (tableType == NULL)
        {
            strcpy(tblType, db->Driver);
        }
        else
        {
            strcpy(tblType, tableType);
        }

        // Open the table
        lastError = openTable(db, tableName, tblType, indexID,
                              openMode, shareMode, xltMode);

        if (lastError != DBIERR_NONE)
        {
            throw lastError;
        }
        
        isOpen = TRUE;

        curStatus = atBegin;
        if (co->dbH != db)
        {
            // If the database for the cursor is changed, delete old context
            // and add the new one.

            if (co->dbH)                         // If database object exists,
            {
                deleteCursor((dbdef *)              // delete cursor from list.
                             co->dbH->dbobj, this);
            }
            addCursor((dbdef *) db->dbobj, this);
        }
        co->dbH = db;
        co->saveEveryChange = TRUE;
        tabname = new char[strlen(tableName)+1];
        strcpy(tabname, tableName);
        strcpy(tabtype, tblType);

        // Create generic record and store the table description
        // with every open cursor so that:
        //
        // 1. All records for a cursor share the same table description.
        //
        // 2. The Paradox Engine is not called for the type of a field
        //    with every Get and Put field operation performed on generic
        //    and custom records.

        genericRec = new BRecord(this);
        
        if (genericRec->lastError != DBIERR_NONE)
        {
            lastError = genericRec->lastError;
            delete genericRec;
            genericRec = 0;
        }
        else
        {
            co->fieldCnt = db->getFieldCount(tableName);
//BR BEG
#if 0//950503
            co->desc = (FieldDesc far *) _fmalloc(sizeof(FieldDesc) *
                                                  co->fieldCnt);
            if (!co->desc)
            {
                lastError = DBIERR_NOMEMORY;
                throw lastError;
            }
            else
            {
                lastError = getDesc(tabH, co->fieldCnt, co->desc);
            }
#else
            co->desc = new FieldDesc[ co->fieldCnt ];
            lastError = getDesc(tabH, co->fieldCnt, co->desc);
#endif//950503
//BR END
        }
        if (lastError)
        {
            DbiCloseCursor(&tabH);
            delete tabname;
            isOpen = FALSE;
        }
    }
    catch(xalloc)
    {
        if (tabname)
        {
            delete tabname;
        }
        lastError = DBIERR_NOMEMORY;
        isOpen = FALSE;
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        return lastError;
    }
    catch(...)
    {
        if ((lastError == PXERR_CURSORALREADYOPEN) ||
            (lastError == PXERR_DBNOTOPEN))
        {
            return lastError;
        }
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        if ((tabname) && (isOpen))
        {
            delete tabname;
        }
        isOpen = FALSE;
        return lastError;
    }

    return lastError;
}

Retcode BCursor::open(BDatabase *db,
                      const char *tableName,
                      const char *indexName,
                      DBIOpenMode openMode,
                      DBIShareMode shareMode,
                      XLTMode xltMode)
{
    CHAR              tblType[DBIMAXNAMELEN+1];
    CHAR              idxName[DBIMAXNAMELEN+1];
    curdef            *co = (curdef *)curobj;
//BR BEG
#if 0//950515
    unsigned int      indexSeqNo;
#else
    UINT16            indexSeqNo;
#endif//950515
//BR END
    IDXDesc           idxDesc;

    if (isOpen)
    {
        lastError = PXERR_CURSORALREADYOPEN;
        return lastError;
    }

    if (!db->isOpen)
    {
        return lastError;
    }

    tabH = NULL;
    tabname = NULL;

    try
    {                        
        strcpy(tblType, db->Driver);

        // Open the table. Index used depends on the type of the table
        if (!strcmp(tblType, szDBASE))
        {
            strcpy(idxName, tableName);
            strncat(idxName, ".MDX", DBIMAXNAMELEN);
            idxName[DBIMAXNAMELEN] = 0;
            lastError = DbiOpenTable(db->hDb, (pCHAR)tableName, (pCHAR)tblType,
                                     (pCHAR)idxName, (pCHAR)indexName,
                                     NULL, openMode, shareMode,
                                     xltMode, FALSE, NULL, &tabH);
        }
        else
        {
            lastError = DbiOpenTable(db->hDb, (pCHAR)tableName, (pCHAR)tblType,
                                     (pCHAR)indexName, NULL, NULL,
                                     openMode, shareMode, xltMode,
                                     FALSE, NULL, &tabH);
        }

        if (lastError != DBIERR_NONE)
        {
            throw lastError;
        }

        isOpen = TRUE;

        // Get information about the index. Depends on table type
        if (!strcmp(tblType, szPARADOX))
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)indexName, NULL, NULL,
                                         &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }
        else if (!strcmp(tblType, szDBASE))
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)idxName,
                                         (pCHAR)indexName,
                                         NULL, &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }
        else
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)indexName, NULL,
                                         NULL, &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }

        curStatus = atBegin;
        if (co->dbH != db)
        {
            // If the database for the cursor is changed, delete old context
            // and add the new one.

            if (co->dbH)                         // If database object exists,
            {
                deleteCursor((dbdef *)              // delete cursor from list.
                             co->dbH->dbobj, this);
            }
            addCursor((dbdef *) db->dbobj, this);
        }
        co->dbH = db;
        co->saveEveryChange = TRUE;
        tabname = new char[strlen(tableName)+1];
        strcpy(tabname, tableName);
        strcpy(tabtype, tblType);

        // Create generic record and store the table description
        // with every open cursor so that:
        //
        // 1. All records for a cursor share the same table description.
        //
        // 2. The Paradox Engine is not called for the type of a field
        //    with every Get and Put field operation performed on generic
        //    and custom records.

        genericRec = new BRecord(this);
        
        if (genericRec->lastError != DBIERR_NONE)
        {
            lastError = genericRec->lastError;
            delete genericRec;
            genericRec = 0;
        }
        else
        {
            co->fieldCnt = db->getFieldCount(tableName);
//BR BEG
#if 0//950503
            co->desc = (FieldDesc far *) _fmalloc(sizeof(FieldDesc) *
                                                  co->fieldCnt);
            if (!co->desc)
            {
                lastError = DBIERR_NOMEMORY;
                throw lastError;
            }
            else
            {
                lastError = getDesc(tabH, co->fieldCnt, co->desc);
            }
#else
            co->desc = new FieldDesc[ co->fieldCnt ];
            lastError = getDesc(tabH, co->fieldCnt, co->desc);
#endif//950503
//BR END
        }
        if (lastError)
        {
            DbiCloseCursor(&tabH);
            delete tabname;
            isOpen = FALSE;
        }
    }
    catch(xalloc)
    {
        if (tabname)
        {
            delete tabname;
        }
        lastError = DBIERR_NOMEMORY;
        isOpen = FALSE;
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        return lastError;
    }
    catch(...)
    {
        if ((lastError == PXERR_CURSORALREADYOPEN) ||
            (lastError == PXERR_DBNOTOPEN))
        {
            return lastError;
        }
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        if ((tabname) && (isOpen))
        {
            delete tabname;
        }
        isOpen = FALSE;
        return lastError;
    }

    return lastError;
}

Retcode BCursor::open(BDatabase *db,
                      const char *tableName,
                      const char *indexName,
                      const char *indexTagName,
                      DBIOpenMode openMode,
                      DBIShareMode shareMode,
                      XLTMode xltMode)
{
    char              tblType[DBIMAXNAMELEN+1];
    curdef            *co = (curdef *)curobj;
//BR BEG
#if 0//950515
    unsigned int      indexSeqNo;
#else
    UINT16            indexSeqNo;
#endif//950515
//BR END
    IDXDesc           idxDesc;

    if (isOpen)
    {
        lastError = PXERR_CURSORALREADYOPEN;
        return lastError;
    }

    if (!db->isOpen)
    {
        return lastError;
    }

    tabH = NULL;
    tabname = NULL;

    try
    {                        
        strcpy(tblType, db->Driver);

        // Open the table. Index depends on data source.
        if (!strcmp(tblType, szDBASE))
        {
            lastError = DbiOpenTable(db->hDb, (pCHAR)tableName, (pCHAR)tblType,
                                     (pCHAR)indexName, (pCHAR)indexTagName,
                                     NULL, openMode, shareMode,
                                     xltMode, FALSE, NULL, &tabH);
        }
        else
        {
            lastError = DbiOpenTable(db->hDb, (pCHAR)tableName, (pCHAR)tblType,
                                     (pCHAR)indexName, NULL, NULL,
                                     openMode, shareMode, xltMode,
                                     FALSE, NULL, &tabH);
        }

        if (lastError != DBIERR_NONE)
        {
            throw lastError;
        }

        isOpen = TRUE;

        // Get information about the index. Method depends on data source.

        if (!strcmp(tblType, szPARADOX))
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)indexName, NULL, NULL,
                                         &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }
        else if (!strcmp(tblType, szDBASE))
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)indexName,
                                         (pCHAR)indexTagName,
                                         NULL, &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }
        else
        {
            lastError = DbiGetIndexSeqNo(tabH, (pCHAR)indexName, NULL,
                                         NULL, &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    strcpy(co->indexName, idxDesc.szName);
                    strcpy(co->indexTag, idxDesc.szTagName);
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }

        curStatus = atBegin;
        if (co->dbH != db)
        {
            // If the database for the cursor is changed, delete old context
            // and add the new one.

            if (co->dbH)                         // If database object exists,
            {
                deleteCursor((dbdef *)              // delete cursor from list.
                             co->dbH->dbobj, this);
            }
            addCursor((dbdef *) db->dbobj, this);
        }
        co->dbH = db;
        co->saveEveryChange = TRUE;
        tabname = new char[strlen(tableName)+1];
        strcpy(tabname, tableName);
        strcpy(tabtype, tblType);

        // Create generic record and store the table description
        // with every open cursor so that:
        //
        // 1. All records for a cursor share the same table description.
        //
        // 2. The Paradox Engine is not called for the type of a field
        //    with every Get and Put field operation performed on generic
        //    and custom records.

        genericRec = new BRecord(this);
        
        if (genericRec->lastError != DBIERR_NONE)
        {
            lastError = genericRec->lastError;
            delete genericRec;
            genericRec = 0;
        }
        else
        {
            co->fieldCnt = db->getFieldCount(tableName);
//BR BEG
#if 0//950503
            co->desc = (FieldDesc far *) _fmalloc(sizeof(FieldDesc) *
                                                  co->fieldCnt);
            if (!co->desc)
            {
                lastError = DBIERR_NOMEMORY;
                throw lastError;
            }
            else
            {
                lastError = getDesc(tabH, co->fieldCnt, co->desc);
            }
#else
            co->desc = new FieldDesc[ co->fieldCnt ];
            lastError = getDesc(tabH, co->fieldCnt, co->desc);
#endif//950503
//BR END
        }
        if (lastError)
        {
            DbiCloseCursor(&tabH);
            delete tabname;
            isOpen = FALSE;
        }
    }
    catch(xalloc)
    {
        if (tabname)
        {
            delete tabname;
        }
        lastError = DBIERR_NOMEMORY;
        isOpen = FALSE;
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        return lastError;
    }
    catch(...)
    {
        if ((lastError == PXERR_CURSORALREADYOPEN) ||
            (lastError == PXERR_DBNOTOPEN))
        {
            return lastError;
        }
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        if ((tabname) && (isOpen))
        {
            delete tabname;
        }
        isOpen = FALSE;
        return lastError;
    }

    return lastError;
}

Retcode BCursor::attach(BDatabase *db, TABLEHANDLE tableHandle)
{
    CURProps    curProps;

    if (isOpen)
    {
        lastError = PXERR_CURSORALREADYOPEN;
        return lastError;
    }

    if (!db->isOpen)
    {
        lastError = PXERR_DBNOTOPEN;
        return lastError;
    }

    tabH = NULL;
    tabname = NULL;

    try
    {
        if ((lastError = DbiCloneCursor(tableHandle, FALSE, FALSE, &tabH))
             != DBIERR_NONE)
        {
            throw lastError;
        }

        lastError = DbiGetCursorProps(tabH, &curProps);
        if (lastError)
        {
            throw lastError;
        }

        isOpen = TRUE;

        curStatus = atBegin;
        curdef *co = (curdef *)curobj;
        if (co->dbH != db)
        {
            // If the database for the cursor is changed, delete old context
            // and add the new one.

            if (co->dbH)  // If database object exists,
            {
                deleteCursor((dbdef *) // delete cursor from list.
                             co->dbH->dbobj, this);
            } 
            addCursor((dbdef *) db->dbobj, this);
        }
        co->dbH = db;
        co->indexID = 0;
        co->saveEveryChange = TRUE;

        tabname = new char[strlen(curProps.szName)+1];
        strcpy(tabname, curProps.szName);
        strcpy(tabtype, curProps.szTableType);

        // Create generic record and store the table description
        // with every open cursor so that:
        //
        // 1. All records for a cursor share the same table description.
        //
        // 2. The Paradox Engine is not called for the type of a field
        //    with every Get and Put field operation performed on generic
        //    and custom records.

        genericRec = new BRecord(this);
        if (genericRec->lastError != DBIERR_NONE)
        {
            lastError = genericRec->lastError;
            delete genericRec;
            genericRec = 0;
        }
        else
        {
            co->fieldCnt = curProps.iFields;
//BR BEG
#if 0//950503
            co->desc = (FieldDesc far *) _fmalloc(sizeof(FieldDesc) *
                                                  co->fieldCnt);
            if (!co->desc)
            {
                lastError = DBIERR_NOMEMORY;
                throw lastError;
            }
            else
            {
                lastError = getDesc(tabH, co->fieldCnt, co->desc);
            }
#else
            co->desc = new FieldDesc[ co->fieldCnt ];
            lastError = getDesc(tabH, co->fieldCnt, co->desc);
#endif//950503
//BR END
        }
        if (lastError)
        {
            DbiCloseCursor(&tabH);
            delete tabname;
            isOpen = FALSE;
        }
    }
    catch(xalloc)
    {
        if (tabname)
        {
            delete tabname;
        }
        lastError = DBIERR_NOMEMORY;
        isOpen = FALSE;
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        return lastError;
    }
    catch(...)
    {
        if ((lastError == PXERR_CURSORALREADYOPEN) ||
            (lastError == PXERR_DBNOTOPEN))
        {
            return lastError;
        }
        if (tabH)
        {
            DbiCloseCursor(&tabH);
        }
        if ((tabname) && (isOpen))
        {
            delete tabname;
        }
        isOpen = FALSE;
        return lastError;
    }

    return lastError;
}

//BR BEG
/*
;;Retcode
;;BCursor::close()
;;
;;  Changes by //BR
;;    950503
;;      x Changed from using C-style 'free' to C++-style 'delete'
;;
*/
//BR END
// Closes the cursor if it's open.
Retcode
BCursor::close()
{
    int i;

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

//BR BEG
#if 0//950710
#else
    clearRec(); //Ensure all open blobs asso. w. this cursor are closed
#endif//950710
//BR END

    curdef *co = (curdef *) curobj;
    for (i=0; i < co->handleCnt; i++)
    {
        if (co->recList[i])
        {
            co->recList[i]->detach();
        }
    }

    if ((lastError = DbiCloseCursor(&tabH)) != DBIERR_NONE)
    {
        return lastError;
    }
    isOpen = FALSE;
    curStatus = atEnd;
    tabH = 0;
//BR BEG
#if 0//950516
    delete genericRec;
    genericRec = 0;
#else
    if ( 0 != genericRec ) //Allow for destruction by derivative class (TBCursor)
    {
      delete genericRec;
      genericRec = 0;
    }
#endif//950516
//BR END
    if (co->fieldCnt != 0)
    {
//BR BEG
#if 0//950503
#if 0//950515
        _ffree(co->desc);   // Delete previous descriptor.
#else
        free(co->desc);   // Delete previous descriptor.
#endif//950515
#else
        delete [] co->desc;   // Delete previous descriptor.
#endif//950503
//BR END
        co->fieldCnt = 0;
    }
    delete tabname;
    tabname = 0;

    return lastError;
}


//  Append a record to the end of the table using regular and raw I/O.

Retcode BCursor::appendRec(BRecord *rec)
{
    int i;

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if ((lastError = rec->preprocess()) != DBIERR_NONE)
    {
        return lastError;
    }

    // Transfer field values from custom fields if this is a custom record.

    if (strcmp(rec->nameOf(),"BRecord"))
    {
        // Transfer data to custom record's fields.

        char *buf;
        try
        {
            buf = new char[256];
        }
        catch(xalloc)
        {
            return (lastError = DBIERR_NOMEMORY);
        }

        PXFieldType    fldType1, fldType2;

        PXFieldSubtype fldSubtype;
        int            fldLen1, fldLen2;
        int            tblFld;
        BOOL           fNull;

        int cnt = rec->getFieldCount();
        for (i=1; i <= cnt; i++)
        {
            if ((tblFld = rec->getTblFieldNumber(i)) > 0)
            {
                if (rec->isNull(i))
                {
                    lastError = rec->BRecord::setNull(tblFld);
                    continue;
                }

                // Get Paradox table generic record and custom descriptors.

                rec->BRecord::getFieldDesc(tblFld,fldType2,fldSubtype,fldLen2);
                rec->getFieldDesc(i,fldType1,fldSubtype,fldLen1);

                if (fldType1 == fldBlob)
                {
                    continue;                      // BLOB handling is separate.
                }
                // To transfer values from a custom record to Paradox, the
                // record handle associated with the BRecord class is used
                // rather than the genericRec of Cursor. This is done because
                // any BLOBs that were constructed for the record are
                // associated with BRecord's record handle.

                if ((lastError = rec->getField(i,(void *) buf, 255, fNull))
                     == DBIERR_NONE)
                {
                    if (fldType1 != fldType2)
                    {
                        lastError = convertFld((void *)buf,fldType1,fldLen1,
                                               (void *)buf,fldType2,fldLen2);
                    }
                    if (!lastError)
                    {
                        lastError = rec->BRecord::putField(tblFld, (void *)buf);
                    }
                }
            }
            if (lastError)
            {
                delete buf;
                return lastError;
            }            
        }
        delete buf;
    }

    if ((lastError = DbiAppendRecord(tabH, rec->recH)) == DBIERR_NONE)
    {
        curStatus = atRecord;
    }

    curdef *co = (curdef *)curobj;

    for (i = 0; i < co->fieldCnt; i++)
    {
        if  (co->desc[i].fldType == fldBlob)
        {
            rec->closeBlob((i + 1), FALSE);
        }
    }
 
    return lastError;
}

Retcode BCursor::appendRec(const void far *buffer, int size)
{
    XLTMode     xltState;
    UINT16      iLen;
    DBIResult   tmpRslt = DBIERR_NONE;

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    // Save the current translation mode
    getProp(curXLTMODE, &xltState, sizeof(XLTMode), iLen);
    if (lastError)
    {
        return lastError;
    }

    if (xltState != xltNONE)
    {
        // Change the translation mode to xltNONE to do Raw I/O
        setProp(curXLTMODE, xltNONE);
        if (lastError)
        {
            return lastError;
        }
    }

    memcpy((pVOID)(genericRec->recH), buffer, size);

    if ((lastError = DbiAppendRecord(tabH, genericRec->recH)) == DBIERR_NONE)
    {
        curStatus = atRecord;
    }

    curdef *co = (curdef *)curobj;

    for (int i = 0; i < co->fieldCnt; i++)
    {
        if  (co->desc[i].fldType == fldBlob)
        {
            genericRec->closeBlob((i + 1), FALSE);
        }
    }

    // Reset the translate mode. Note that we need to store the error value.

    tmpRslt = lastError;

    setProp(curXLTMODE, xltState);

    lastError = tmpRslt;

    return lastError;
}

Retcode BCursor::insertRec()
{
  return insertRec(genericRec);
}

// Insert a record to the table using regular and raw I/O.

Retcode BCursor::insertRec(BRecord *rec)
{

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (curStatus == atBegin && getRecCount() > 0)
    {
        if ((lastError = DbiSetToBegin(tabH)) != DBIERR_NONE)
        {
            return lastError;
        }
    }

    if ((lastError = rec->preprocess()) != DBIERR_NONE)
    {
        return lastError;
    }

    // Transfer field values from custom fields if this is a custom record.

    if (strcmp(rec->nameOf(),"BRecord"))
    {
        // Transfer data to the custom record's fields.

        char *buf;
        try
        {
            buf = new char[256];
        }
        catch(xalloc)
        {
            return (lastError = DBIERR_NOMEMORY);
        }

        PXFieldType    fldType1, fldType2;
        PXFieldSubtype fldSubtype;
        int            fldLen1, fldLen2;
        int            tblFld;
        BOOL           fNull;

        int cnt = rec->getFieldCount();
        for (int i=1; i <= cnt; i++)
        {
            if ((tblFld = rec->getTblFieldNumber(i)) > 0)
            {
                if (rec->isNull(i))
                {
                    lastError = rec->BRecord::setNull(tblFld);
                      continue;
                }
                // Get the Paradox table generic record and custom descriptors.

                rec->BRecord::getFieldDesc(tblFld,fldType2,fldSubtype,fldLen2);
                rec->getFieldDesc(i,fldType1,fldSubtype,fldLen1);
                if (fldType1 == fldBlob)
                {
                    continue;                  // BLOB handling is separate.
                }
              
                // To transfer values from a custom record to Paradox, we use
                // the record handle associated with the BRecord class rather
                // than the genericRec of Cursor. This is done because any BLOBs
                // that were constructed for the record are associated with
                // BRecord's record handle.

                if ((lastError = rec->getField(i,(void *) buf,
                                               255, fNull))==DBIERR_NONE)
                {
                    if (fldType1 != fldType2)
                    {
                        lastError = convertFld((void *)buf,fldType1,fldLen1,
                                               (void *)buf,fldType2,fldLen2);
                    }
                    if (!lastError)
                    {
                        lastError = rec->BRecord::putField(tblFld, (void *)buf);
                    }
                }
                if (lastError)
                {
                    delete buf;
                    return lastError;
                }
            }
        }
        delete buf;
    }
    if (curStatus == atEnd)
    {
        lastError = DbiAppendRecord(tabH, rec->recH);
    }
    else
    {
        lastError = DbiInsertRecord(tabH, dbiNOLOCK, rec->recH);
    }

    if (lastError == DBIERR_NONE)
    {
        curStatus = atRecord;
    }

    curdef *co = (curdef *)curobj;

    for (int i = 0; i < co->fieldCnt; i++)
    {
        if  (co->desc[i].fldType == fldBlob)
        {
            rec->closeBlob((i + 1), FALSE);
        }
    }

    return lastError;
}

Retcode BCursor::insertRec(const void far *buffer, int size)
{
    XLTMode     xltState;
    UINT16      iLen;
    DBIResult   tmpRslt;

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (curStatus == atBegin && getRecCount() > 0)
    {
        if ((lastError = DbiSetToBegin(tabH)) != DBIERR_NONE)
        {
            return lastError;
        }
    }

    // Save the current translation mode
    getProp(curXLTMODE, &xltState, sizeof(XLTMode), iLen);
    if (lastError)
    {
        return lastError;
    }

    if (xltState != xltNONE)
    {
        // Change the translation mode to xltNONE to do Raw I/O
        setProp(curXLTMODE, xltNONE);
        if (lastError)
        {
            return lastError;
        }
    }

    memcpy((pVOID)(genericRec->recH), buffer, size);

    if (curStatus == atEnd)
    {
        lastError = DbiAppendRecord(tabH, genericRec->recH);
    }
    else
    {
        lastError = DbiInsertRecord(tabH, dbiNOLOCK, genericRec->recH);
    }

    if (!lastError)
    {
        curStatus = atRecord;
    }

    curdef *co = (curdef *)curobj;

    for (int i = 0; i < co->fieldCnt; i++)
    {
        if (co->desc[i].fldType == fldBlob)
        {
            genericRec->closeBlob((i + 1), FALSE);
        }
    }

    tmpRslt = lastError;

    // Reset the translate mode to the origional state.
    setProp(curXLTMODE, xltState);

    lastError = tmpRslt;

    return lastError;
}

// Delete the current record of the cursor.

Retcode BCursor::deleteRec()
{
    PXCursorStatus cs;

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (curStatus != atRecord)
    {
        return (lastError = PXERR_INVCURRRECORD);
    }

    if (getRecCount() == getCurRecNum())           // Last record ?
    {
        cs = atEnd;
    }
    else
    {
        cs = atCrack;
    }

    if ((lastError = DbiDeleteRecord(tabH, NULL)) == DBIERR_NONE)
    {
        curStatus = cs;
    }

    return lastError;
}

Retcode BCursor::updateRec()
{
    return updateRec(genericRec);
}

// Update the current record of the cursor using regular and raw I/O.

Retcode BCursor::updateRec(BRecord *rec)
{                
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (curStatus != atRecord)
    {
        return (lastError = PXERR_INVCURRRECORD);
    }

    if ((lastError = rec->preprocess()) != DBIERR_NONE)
    {
        return lastError;
    }

    // Transfer field values from custom fields if this is a custom record.

    if (strcmp(rec->nameOf(),"BRecord"))
    {
        // Transfer data to the custom record's fields.

        char *buf;
        try
        {
            buf = new char[256];
        }
        catch(xalloc)
        {
            return (lastError = DBIERR_NOMEMORY);
        } 

        PXFieldType    fldType1, fldType2;
        PXFieldSubtype fldSubtype;
        int            fldLen1, fldLen2;
        int            tblFld;
        BOOL           fNull;

        int cnt = rec->getFieldCount();
        for (int i=1; i <= cnt; i++)
        if ((tblFld = rec->getTblFieldNumber(i)) > 0)
        {
            if (rec->isNull(i))
            {
                lastError = rec->BRecord::setNull(tblFld);
                continue;
            }

            // Get the Paradox table generic record and custom descriptors.

            rec->BRecord::getFieldDesc(tblFld,fldType2,fldSubtype,fldLen2);
            rec->getFieldDesc(i,fldType1,fldSubtype,fldLen1);
            if (fldType1 == fldBlob)
            {
                continue;                  // BLOB handling is separate.
            }

            // To transfer values from a custom record to Paradox, the
            // record handle associated with the BRecord class is used rather
            // than the genericRec of Cursor. This is done because any BLOBs
            // that were constructed for the record are associated with
            // BRecord's record handle.

            if ((lastError = rec->getField(i, (void *) buf, 255, fNull))
                 == DBIERR_NONE)
            {
                if (fldType1 != fldType2)
                {
                    lastError = convertFld((void *)buf,fldType1,fldLen1,
                                           (void *)buf,fldType2,fldLen2);
                }

                if (!lastError)
                {
                    lastError = rec->BRecord::putField(tblFld, (void *)buf);
                }
            }
            if (lastError)
            {
                delete buf;
                return (lastError);
            }

        }
        delete buf;
    }

    lastError = DbiModifyRecord(tabH, rec->recH, FALSE);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    curdef *co = (curdef *)curobj;

    for (int i = 0; i < co->fieldCnt; i++)
    {
        if  (co->desc[i].fldType == fldBlob)
        {
            rec->closeBlob((i + 1), FALSE);
        }
    }

    return lastError;
}

Retcode BCursor::updateRec(const void far *buffer, int size)
{
    XLTMode     xltState;
    UINT16      iLen;
    DBIResult   tmpRslt;

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (curStatus != atRecord)
    {
        return (lastError = PXERR_INVCURRRECORD);
    }

    // Save the current translation mode
    getProp(curXLTMODE, &xltState, sizeof(XLTMode), iLen);
    if (lastError)
    {
        return lastError;
    }

    // Set the translate mode to xltNONE in order to use Raw I/O
    if (xltState != xltNONE)
    {
        setProp(curXLTMODE, xltNONE);
    }
    
    memcpy((pVOID)(genericRec->recH), buffer, size);

    lastError = DbiModifyRecord(tabH, genericRec->recH, FALSE);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    curdef *co = (curdef *)curobj;

    for (int i = 0; i < co->fieldCnt; i++)
    {
        if  (co->desc[i].fldType == fldBlob)
        {
            genericRec->closeBlob((i + 1), FALSE);
        }
    }

    tmpRslt = lastError;

    // Reset the translate mode to the origional state.
    setProp(curXLTMODE, xltState);

    lastError = tmpRslt;

    return lastError;
}

// Position before the first record of the table. This function
// is provided, instead of gotoFirst, to maintain compatibility
// with future Borland database products.

Retcode BCursor::gotoBegin() const
{
    if (!isOpen)
    {
        return ( const_cast<BCursor*>(this)->lastError = PXERR_CURSORNOTOPEN);
    }

    const_cast<BCursor*>(this)->lastError = DbiSetToBegin(tabH);
    if (lastError == DBIERR_NONE)
    {
        const_cast<BCursor*>(this)->curStatus = atBegin;
    }

    return lastError;
}

// Go to the end of the table.

Retcode BCursor::gotoEnd() const
{
    if (!isOpen)
    {
        return (const_cast<BCursor*>(this)->lastError = PXERR_CURSORNOTOPEN);
    }

    const_cast<BCursor*>(this)->lastError = DbiSetToEnd(tabH);
    if (lastError == DBIERR_NONE)
    {
        const_cast<BCursor*>(this)->curStatus = atEnd;
    }

    return lastError;
}

// Go to a specific record number in the table.

Retcode BCursor::gotoRec(RECORDNUMBER recNum) const
{
    if (!isOpen)
    {
        return (const_cast<BCursor*>(this)->lastError = PXERR_CURSORNOTOPEN);
    }

    if (!strcmp((((curdef *)curobj)->dbH)->Driver, szPARADOX))
    {
        if ((const_cast<BCursor*>(this)->lastError = DbiSetToSeqNo(tabH, recNum)) == DBIERR_NONE)
        {
            const_cast<BCursor*>(this)->curStatus = atRecord;
        }
    }
    else if (!strcmp((((curdef *)curobj)->dbH)->Driver, szDBASE))
    {
        if ((const_cast<BCursor*>(this)->lastError = DbiSetToRecordNo(tabH, recNum)) == DBIERR_NONE)
        {
            const_cast<BCursor*>(this)->curStatus = atRecord;
        }
    }
    else
    {
        const_cast<BCursor*>(this)->lastError = DBIERR_NOTSUPPORTED;
        return lastError;
    }

    return lastError;
}

// Go to the next record of the table.

Retcode BCursor::gotoNext() const
{
    if (!isOpen)
    {
        return (const_cast<BCursor*>(this)->lastError = PXERR_CURSORNOTOPEN);
    }

    if (curStatus == atBegin)
    {
        if ((const_cast<BCursor*>(this)->lastError = DbiGetNextRecord(tabH, dbiNOLOCK, NULL, NULL))
            == DBIERR_NONE)
        {
            const_cast<BCursor*>(this)->curStatus = atRecord;
        }

        return lastError;
    }

    if (curStatus == atEnd)
    {
        return (const_cast<BCursor*>(this)->lastError = DBIERR_EOF);
    }

    // Go to the next record.
    if ((const_cast<BCursor*>(this)->lastError = DbiGetNextRecord(tabH, dbiNOLOCK, NULL, NULL))
        == DBIERR_NONE)                               
    {
        const_cast<BCursor*>(this)->curStatus = atRecord;
    }
    else if (lastError == DBIERR_EOF)
    {
        DbiGetPriorRecord(tabH, dbiNOLOCK, NULL, NULL);
    }

    return lastError;
}

// Go to the previous record of the table.

Retcode BCursor::gotoPrev() const
{
    if (!isOpen)
    {
        return (const_cast<BCursor*>(this)->lastError = PXERR_CURSORNOTOPEN);
    }

    if (curStatus == atEnd)
    {
        if ((const_cast<BCursor*>(this)->lastError = DbiGetPriorRecord(tabH, dbiNOLOCK, NULL, NULL))
            == DBIERR_NONE)
        {
            const_cast<BCursor*>(this)->curStatus = atRecord;
        }

        return lastError;
    }

    if (curStatus == atBegin)
    {
        return (const_cast<BCursor*>(this)->lastError = DBIERR_BOF);
    }

    if ((const_cast<BCursor*>(this)->lastError = DbiGetPriorRecord(tabH, dbiNOLOCK, NULL, NULL))
        == DBIERR_NONE)
    {
        const_cast<BCursor*>(this)->curStatus = atRecord;
    }
    else if (lastError == DBIERR_BOF)
    {
        DbiGetNextRecord(tabH, dbiNOLOCK, NULL, NULL);
    }

    return lastError;
}

// Get the record number of the current record. 

RECORDNUMBER BCursor::getCurRecNum()
{
    RECORDNUMBER recNum = 0;
    RECProps recProps;

    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return 0;
    }

    if (curStatus != atRecord)
    {
        lastError = PXERR_INVCURRRECORD;
        return 0;
    }

    if (!strcmp((((curdef *)curobj)->dbH)->Driver, szPARADOX))
    {
        lastError = DbiGetSeqNo(tabH, (pUINT32)&recNum);
    }
    else if (!strcmp((((curdef *)curobj)->dbH)->Driver, szDBASE))
    {
        lastError = DbiGetRecord(tabH, dbiNOLOCK, NULL, &recProps);
        recNum = recProps.iPhyRecNum;
    }
    else
    {
        lastError = DBIERR_NOTSUPPORTED;
    }

    return recNum;
}

// Get the current record of the cursor. The three different
// signatures of the getRecord function are the following:
//
//   1. User-supplied record object.
//
//   2. Cursor's generic record object.
// 
//   3. Raw I/O.

Retcode BCursor::getRecord(BRecord *rec) const
{
    int i;
    if (!isOpen)
    {
        return ( const_cast<BCursor*>(this)->lastError = PXERR_CURSORNOTOPEN);
    }

    if (curStatus != atRecord)
    {
        return (const_cast<BCursor*>(this)->lastError = PXERR_INVCURRRECORD);
    }

    if (rec->clear())
    {
        return rec->lastError;
    }

    if (( const_cast<BCursor*>(this)->lastError = DbiGetRecord(tabH, dbiNOLOCK, rec->recH, NULL))
        != DBIERR_NONE)
    {
        return lastError;
    }

    // Register the fact that the BLOBs in the record are now closed.

    recdef *ro = (recdef *) rec->recobj;
    for (i=0;i < ro->handleCnt; i++)
    {
        if (ro->recblb[i].blbRecH == rec->recH)
        {
            ro->recblb[i].state = blbClosed;
            const_cast<BCursor*>(this)->lastError = DbiFreeBlob(tabH, rec->recH, 0);
            if (lastError != DBIERR_NONE)
            {
                // If BLOB's previously closed, does not matter
                if (lastError == DBIERR_BLOBNOTOPENED)
                {
                    const_cast<BCursor*>(this)->lastError = DBIERR_NONE;
                }
            }
        }
    }

    if (!strcmp(rec->nameOf(), "BRecord"))     // Nothing else to do
    {
        const_cast<BCursor*>(this)->lastError = rec->postprocess();
        curChange();
        return lastError;  // for generic records.
    }

    // Transfer data to the custom record's fields.

    char *buf;
    try
    {
        buf = new char[256];
    }
    catch(xalloc)
    {
        return ( const_cast<BCursor*>(this)->lastError = DBIERR_NOMEMORY);
    }

    PXFieldType    fldType1, fldType2;
    PXFieldSubtype fldSubtype;
    int            fldLen1, fldLen2;
    int            tblFld;
    BOOL           fNull;

    int cnt = rec->getFieldCount();
    for (i=1; i <= cnt; i++)
    {
        if ((tblFld = rec->getTblFieldNumber(i)) > 0)
        {
            // Force getField to get data by calling the Paradox Engine.

            if (rec->BRecord::isNull(tblFld))
            {
                rec->setNull(i);
                continue;
            }
            rec->clearNull(i);

            // Get the Paradox table generic record and custom descriptors.

            rec->BRecord::getFieldDesc(tblFld,fldType2,fldSubtype,fldLen2);
            rec->getFieldDesc(i,fldType1,fldSubtype,fldLen1);
            if (fldType1 == fldBlob)
            {
                continue;     // BLOB handling is separate.
            }

            if (( const_cast<BCursor*>(this)->lastError = rec->BRecord::getField(tblFld, (void *) buf,
                255, fNull)) == DBIERR_NONE)
            {
                if (fldType1 != fldType2)
                {
                    const_cast<BCursor*>(this)->lastError = convertFld((void *)buf,fldType2,fldLen2,
                                           (void *)buf,fldType1,fldLen1);
                }
                if (!lastError)
                {
                    const_cast<BCursor*>(this)->lastError = rec->putField(i, (void *) buf);
                }
            }
            if (lastError)
            {
                delete buf;
                return lastError;
            }
        }
    }
    delete buf;

    const_cast<BCursor*>(this)->lastError = rec->postprocess();

    curChange();

    return lastError;
}

Retcode BCursor::getRecord() const
{
  return getRecord(genericRec);
}

Retcode BCursor::getRecord(void far *buffer, int size)
{
    XLTMode     xltState;
    UINT16      iLen;
    DBIResult   tmpRslt;

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (curStatus != atRecord)
    {
        return (lastError = PXERR_INVCURRRECORD);
    }

    // Save the current translation mode
    getProp(curXLTMODE, &xltState, sizeof(XLTMode), iLen);
    if (lastError)
    {
        return lastError;
    }

    if (xltState != xltNONE)
    {
        // Change the translation mode to xltNONE to do Raw I/O
        setProp(curXLTMODE, xltNONE);
        if (lastError)
        {
            return lastError;
        }
    }

    if (genericRec->clear())
    {
        return genericRec->lastError;
    }

    if ((lastError = DbiGetRecord(tabH, dbiNOLOCK, genericRec->recH, NULL))
        != DBIERR_NONE)
    {
        return lastError;
    }

    memcpy(buffer, genericRec->recH, size);

    lastError = DbiFreeBlob(tabH, genericRec->recH, 0);
    if (lastError != DBIERR_NONE)
    {
        // If BLOB's previously closed, does not matter
        if (lastError == DBIERR_BLOBNOTOPENED)
        {
            lastError = DBIERR_NONE;
        }
    }

    curdef *co = (curdef *)curobj;

    for (int i = 0; i < co->fieldCnt; i++)
    {
        if  (co->desc[i].fldType == fldBlob)
        {
            ((recdef *)(genericRec->recobj))->recblb[i].state = blbClosed;
        }
    }

    tmpRslt = lastError;

    setProp(curXLTMODE, xltState);

    lastError = tmpRslt;

    curChange();

    return lastError;
}

// Get the Next record of the cursor. The two different
// signatures of the getRecord function are the following:
//
//   1. User-supplied record object.
//
//   2. Cursor's generic record object.

Retcode BCursor::getNextRecord(BRecord *rec) const
{
    int i;
    if (!isOpen)
    {
        return ( const_cast<BCursor*>(this)->lastError = PXERR_CURSORNOTOPEN);
    }

    if (curStatus == atEnd)
    {
        return (const_cast<BCursor*>(this)->lastError = PXERR_INVCURRRECORD);
    }

    if (rec->clear())
    {
        return rec->lastError;
    }

    if ((const_cast<BCursor*>(this)->lastError = DbiGetNextRecord(tabH, dbiNOLOCK, rec->recH, NULL))
        != DBIERR_NONE)
    {
        if (lastError == DBIERR_EOF)
        {
            const_cast<BCursor*>(this)->curStatus = atEnd;
        }

        return lastError;
    }

    const_cast<BCursor*>(this)->curStatus = atRecord;

    // Register the fact that the BLOBs in the record are now closed.

    recdef *ro = (recdef *) rec->recobj;
    for (i=0;i < ro->handleCnt; i++)
    {
        if (ro->recblb[i].blbRecH == rec->recH)
        {
            ro->recblb[i].state = blbClosed;
            const_cast<BCursor*>(this)->lastError = DbiFreeBlob(tabH, rec->recH, 0);
            if (lastError != DBIERR_NONE)
            {
                // If BLOB's previously closed, does not matter
                if (lastError == DBIERR_BLOBNOTOPENED)
                {
                    const_cast<BCursor*>(this)->lastError = DBIERR_NONE;
                }
            }
        }
    }

    if (!strcmp(rec->nameOf(), "BRecord"))     // Nothing else to do
    {
        const_cast<BCursor*>(this)->lastError = rec->postprocess();

        curChange();

        return lastError;  // for generic records.
    }

    // Transfer data to the custom record's fields.

    char *buf;
    try
    {
        buf = new char[256];
    }
    catch(xalloc)
    {
        return ( const_cast<BCursor*>(this)->lastError = DBIERR_NOMEMORY);
    }

    PXFieldType    fldType1, fldType2;
    PXFieldSubtype fldSubtype;
    int            fldLen1, fldLen2;
    int            tblFld;
    BOOL           fNull;

    int cnt = rec->getFieldCount();
    for (i=1; i <= cnt; i++)
    {
        if ((tblFld = rec->getTblFieldNumber(i)) > 0)
        {
            // Force getField to get data by calling the Paradox Engine.

            if (rec->BRecord::isNull(tblFld))
            {
                rec->setNull(i);
                continue;
            }
            rec->clearNull(i);

            // Get the Paradox table generic record and custom descriptors.

            rec->BRecord::getFieldDesc(tblFld,fldType2,fldSubtype,fldLen2);
            rec->getFieldDesc(i,fldType1,fldSubtype,fldLen1);
            if (fldType1 == fldBlob)
            {
                continue;     // BLOB handling is separate.
            }

            if (( const_cast<BCursor*>(this)->lastError = rec->BRecord::getField(tblFld, (void *) buf,
                255, fNull)) == DBIERR_NONE)
            {
                if (fldType1 != fldType2)
                {
                    const_cast<BCursor*>(this)->lastError = convertFld((void *)buf,fldType2,fldLen2,
                                           (void *)buf,fldType1,fldLen1);
                }
                if (!lastError)
                {
                    const_cast<BCursor*>(this)->lastError = rec->putField(i, (void *) buf);
                }
            }
            if (lastError)
            {
                delete buf;
                return lastError;
            }
        }
    }
    delete buf;

    const_cast<BCursor*>(this)->lastError = rec->postprocess();

    if (lastError == DBIERR_NONE)
    {
        curChange();
    }

    return lastError;
}

Retcode BCursor::getNextRecord() const
{
  return getNextRecord(genericRec);
}

// Get the Previous record of the cursor. The two different
// signatures of the getRecord function are the following:
//
//   1. User-supplied record object.
//
//   2. Cursor's generic record object.

Retcode BCursor::getPreviousRecord(BRecord *rec) const
{
    int i;
    if (!isOpen)
    {
        return ( const_cast<BCursor*>(this)->lastError = PXERR_CURSORNOTOPEN);
    }

    if (curStatus == atBegin) // 3/23/95
    {
        return (const_cast<BCursor*>(this)->lastError = PXERR_INVCURRRECORD);
    }

    if (rec->clear())
    {
        return rec->lastError;
    }

    if ((const_cast<BCursor*>(this)->lastError = DbiGetPriorRecord(tabH, dbiNOLOCK, rec->recH, NULL))
        != DBIERR_NONE)
    {
        if (lastError == DBIERR_BOF)
        {
            const_cast<BCursor*>(this)->curStatus = atEnd;
        }
        return lastError;
    }

    const_cast<BCursor*>(this)->curStatus = atRecord;

    // Register the fact that the BLOBs in the record are now closed.

    recdef *ro = (recdef *) rec->recobj;
    for (i=0;i < ro->handleCnt; i++)
    {
        if (ro->recblb[i].blbRecH == rec->recH)
        {
            ro->recblb[i].state = blbClosed;
            const_cast<BCursor*>(this)->lastError = DbiFreeBlob(tabH, rec->recH, 0);
            if (lastError != DBIERR_NONE)
            {
                // If BLOB's previously closed, does not matter
                if (lastError == DBIERR_BLOBNOTOPENED)
                {
                    const_cast<BCursor*>(this)->lastError = DBIERR_NONE;
                }
            }
        }
    }

    if (!strcmp(rec->nameOf(), "BRecord"))     // Nothing else to do
    {
        const_cast<BCursor*>(this)->lastError = rec->postprocess();

        if (lastError == DBIERR_NONE)
        {
            curChange();
        }

        return lastError;  // for generic records.
    }

    // Transfer data to the custom record's fields.

    char *buf;
    try
    {
        buf = new char[256];
    }
    catch(xalloc)
    {
        return (const_cast<BCursor*>(this)->lastError = DBIERR_NOMEMORY);
    }

    PXFieldType    fldType1, fldType2;
    PXFieldSubtype fldSubtype;
    int            fldLen1, fldLen2;
    int            tblFld;
    BOOL           fNull;

    int cnt = rec->getFieldCount();
    for (i=1; i <= cnt; i++)
    {
        if ((tblFld = rec->getTblFieldNumber(i)) > 0)
        {
            // Force getField to get data by calling the Paradox Engine.

            if (rec->BRecord::isNull(tblFld))
            {
                rec->setNull(i);
                continue;
            }
            rec->clearNull(i);

            // Get the Paradox table generic record and custom descriptors.

            rec->BRecord::getFieldDesc(tblFld,fldType2,fldSubtype,fldLen2);
            rec->getFieldDesc(i,fldType1,fldSubtype,fldLen1);
            if (fldType1 == fldBlob)
            {
                continue;     // BLOB handling is separate.
            }

            if ((const_cast<BCursor*>(this)->lastError = rec->BRecord::getField(tblFld, (void *) buf,
                255, fNull)) == DBIERR_NONE)
            {
                if (fldType1 != fldType2)
                {
                    const_cast<BCursor*>(this)->lastError = convertFld((void *)buf,fldType2,fldLen2,
                                           (void *)buf,fldType1,fldLen1);
                }
                if (!lastError)
                {
                    const_cast<BCursor*>(this)->lastError = rec->putField(i, (void *) buf);
                }
            }
            if (lastError)
            {
                delete buf;
                return lastError;
            }
        }
    }
    delete buf;

    const_cast<BCursor*>(this)->lastError = rec->postprocess();

    if (lastError == DBIERR_NONE)
    {
        curChange();
    }

    return lastError;
}

Retcode BCursor::getPreviousRecord() const
{
  return getPreviousRecord(genericRec);
}

// Lock the table in a shared environment by calling PXNetTblLock.

Retcode BCursor::lockTable(PXLockMode lockMode)
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    switch (lockMode)
    {
        case pxFL:
        case pxWL:
            lastError = DbiAcqTableLock(tabH, dbiWRITELOCK);
            break;
        case pxPWL:
        case pxPFL:
            lastError = DbiAcqTableLock(tabH, dbiREADLOCK);
            break;
    }

    return lastError;
}

// Release a previously acquired lock on a table.

Retcode BCursor::unlockTable(PXLockMode lockMode)
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    switch (lockMode)
    {
        case pxFL:
        case pxWL:
            lastError = DbiRelTableLock(tabH, FALSE, dbiWRITELOCK);
            break;
        case pxPWL:
        case pxPFL:
            lastError = DbiRelTableLock(tabH, FALSE, dbiREADLOCK);
            break;
    }

    return lastError;
}

// Get a lock for the current record of the cursor.

LOCKHANDLE BCursor::lockRecord()
{
    LOCKHANDLE lckH = 0;
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return 0;
    }

    if (curStatus != atRecord)
    {
        lastError = PXERR_INVCURRRECORD;
        return 0;
    }

    if ((lastError = DbiGetRecord(tabH, dbiWRITELOCK, NULL, NULL))
        != DBIERR_NONE)
    {
        return 0;
    }
    else
    {
        lckH = getCurRecNum();
        // Expect error if table type is not Paradox or dBASE
        if (lastError == DBIERR_NOTSUPPORTED)
        {
            lastError = DBIERR_NONE;
        }
        return lckH;
    }
}

// Release the previously acquired lock on a record.

Retcode BCursor::unlockRecord(LOCKHANDLE lckH)
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    gotoRec(lckH);
     
    return (lastError = DbiRelRecordLock(tabH, FALSE));
}

Retcode BCursor::unlockRecord()
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    return (lastError = DbiRelRecordLock(tabH, FALSE));
}

// Determine whether the current record of the cursor is 
// locked by another user.

BOOL BCursor::isLocked()
{   
    BOOL locked = 0;
     
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return FALSE;
    }

    if (curStatus != atRecord)
    {
        lastError = PXERR_INVCURRRECORD;
        return FALSE;
    }

    lastError = DbiIsRecordLocked(tabH, &locked);
    return (locked);
}

// Determine if the cursor table has been changed by any other user.
// Not yet implemented....

BOOL BCursor::hasChanged()
{
    // Note that this currenly doesn't do anything....
    //   Can add a call to refresh(), which would force the
    //   buffers to be refreshed, but this would be a performance hit....
    return FALSE;
}

// Refresh the cursor's buffer to reflect changes.

Retcode BCursor::refresh()
{

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiForceReread(tabH);

    return lastError;
}

// Find the number of records in the cursor (or table).

RECORDNUMBER BCursor::getRecCount()
{
    RECORDNUMBER nRecs = 0;
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return 0;
    }
    lastError = DbiGetRecordCount(tabH, (pUINT32)&nRecs);

    return nRecs;
}

//  Clones the cursor with its associated properties.

BCursor * BCursor::clone(BOOL stayCurrent)
{
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return 0;
    }

    curdef *co = (curdef *)curobj;

    BCursor *newcur;
    try
    {
        newcur = new BCursor(co->dbH, tabname,
                             co->indexID, co->saveEveryChange);
    }
    catch(xalloc)
    {
        lastError = DBIERR_NOMEMORY;
        return newcur;
    }

    if ((lastError = newcur->lastError) != DBIERR_NONE)
    {
        delete newcur;
        return 0;
    }

    if (curStatus == atBegin || ! stayCurrent)
    {
        newcur->curStatus = atBegin;
    }
    else
    {
        if (curStatus == atEnd)
        {
            newcur->curStatus = atEnd;
        }
        else
        {
            newcur->curStatus = curStatus;
        }

    }

    lastError = DbiCloseCursor(&(newcur->tabH));
    if (lastError != DBIERR_NONE)
    {
        delete newcur;
        return 0;
    }                                         

    lastError = DbiCloneCursor(tabH, FALSE, FALSE, &(newcur->tabH));
    if (lastError != DBIERR_NONE)
    {
        delete newcur;
        return 0;
    }

    return newcur;
}

/***********************************************************************
  The following four functions are used instead of the Paradox Engine's
  search functions and reflect the direction of new Borland database
  products.
*********************************************************************/

//  Position the cursor on the same record as the current record
//  of another cursor.

Retcode BCursor::setToCursor(BCursor *otherCursor)
{
    if (!otherCursor->isOpen || !isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (strcmp(tabname, otherCursor->tabname))
    {
        return (lastError = PXERR_TABLESDIFFER);
    }

    lastError = DbiSetToCursor(tabH, otherCursor->tabH);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    curStatus = otherCursor->curStatus;

    return (lastError);
}


// Search the table for the record that matches key values in keyRec; use
// the currently open index.

Retcode BCursor::searchIndex(const BRecord *keyRec,
                             PXSearchMode mode, int fldCnt)
{
    BRecord *rec = (BRecord *) keyRec;
    curdef  *co = (curdef *)curobj;
    int     lastFld = 0;

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (strcmp(rec->nameOf(),"BRecord"))
    {
        // Transfer data from the custom record's fields to record buffer.

        char *buf;
        try
        {
            buf = new char[256];
        }
        catch(xalloc)
        {
            lastError = DBIERR_NOMEMORY;
            return lastError;
        }

        BOOL fNull;

        int tblFld, i = 1;

        if (co->indexID == 0)
        {
            lastFld = (((curdef *)curobj)->dbH)->getNumPFields(tabname);
        }
        else
        {
            if (co->indexID <= 255)
            {
                i = lastFld = co->indexID;
            }
        }

        if (!lastFld)
        {
            lastFld = rec->getFieldCount();
        }

        for (; i <= lastFld; i++)
        {
            if ((tblFld = rec->getTblFieldNumber(i)) > 0)
            {
                // Force getField to get data by calling the Paradox Engine.

                if (rec->isNull(i))
                {
                    lastError = genericRec->setNull(tblFld);
                }
                else
                {
                    if ((lastError = rec->getField(i, (void *) buf,
                                                   255, fNull)) == DBIERR_NONE)
                    {
                        lastError = genericRec->putField(tblFld, (void *) buf);
                    }
                }
            }
        }
        delete buf;
        rec = genericRec;
    }

    if (mode == pxSearchNext)
    {
        gotoNext();
        if (lastError == PXSUCCESS)
        {
//BR BEG
#if 0//950515
            int CompResult = 0;
#else
            INT16 CompResult = 0;
#endif//950515
//BR END

            // If we still have the same key value, then use it.
            Retcode retVal = DbiCompareKeys(tabH, rec->recH, NULL,
                                            fldCnt, 0, &CompResult);
            if (CompResult == 0 && retVal == PXSUCCESS)
            {
                lastError = PXSUCCESS;
                curStatus = atRecord;
                return lastError;
            }
            else
            {
                // Restore to the previous record
                gotoPrev();
                lastError = DBIERR_RECNOTFOUND;
                return lastError;
            }
        }
        lastError = DBIERR_RECNOTFOUND;
        return lastError;
    }
    else
    {
        if (curStatus == atEnd)
        {
            if ((lastError = DbiSetToEnd(tabH)) != DBIERR_NONE)
            {
                return lastError;
            }
        }
    }

    if (co->indexID == 0)          // Primary key or no key.
    {
        if (fldCnt != lastFld)
        {
            lastError = DbiSetToKey(tabH, (DBISearchCond)mode, FALSE, fldCnt, 0,
                                    rec->recH);
        }
        else
        {
            // Search on entire key
            lastError = DbiSetToKey(tabH, (DBISearchCond)mode, FALSE, 0, 0,
                                    rec->recH);
        }
    }
    else
    {
        if (co->indexID < 256)
        {
            lastError = DbiSetToKey(tabH, (DBISearchCond)mode, FALSE, 1, 0,
                                    rec->recH);
        }
        else
        {
            lastError = DbiSetToKey(tabH, (DBISearchCond)mode, FALSE, fldCnt, 0,
                                    rec->recH);
        }
    }

    if (!lastError || (mode==pxClosestRecord && lastError==DBIERR_RECNOTFOUND))
    {
        DbiGetNextRecord(tabH, dbiNOLOCK, NULL, NULL);
        curStatus = atRecord;
    }

    return lastError;
}

// Search the table for a record that matches key values specified in the
// variable count argument list. Otherwise, its operation is the same
// as other search methods.

Retcode BCursor::searchIndex(PXSearchMode mode, int fldCnt, ...)
{
    int startFld, ind, fld;
    BDate dt;
    BTime tm;
    BTimeStamp ts;
    TIME Time;
//BR BEG
#if 0//950515
    DATE Date;
#else
    DBIDATE Date;
#endif//950515
//BR END
    TIMESTAMP TimeStamp;
    va_list ap;
    va_start(ap, fldCnt);

    curdef *co = (curdef *)curobj;
    engdef *eo = (engdef *) ((((dbdef *)co->dbH->dbobj)->engH)->engobj);

    lastError = DBIERR_NONE;
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (fldCnt < 1)
    {
        return (lastError = PXERR_INVKEYCOUNT);
    }

    if (co->indexID == 0)
    {
        startFld = 1;
    }
    else
    {
        if (co->indexID <= 255)
        {
            startFld = co->indexID;           // Single field secondary index.
            if (fldCnt > 1)
            {
                return (lastError = PXERR_INVKEYCOUNT);
            }
        }
        else
        {
            for (ind = 0; ind < eo->compIdxCnt; ind++)
            {
                if (eo->keymap[ind].indexId == co->indexID &&
                    ! strcmp(eo->keymap[ind].tableName,tabname))
                {
                    break;
                }
            }
        }

        if (! eo->compIdxCnt || ind == eo->compIdxCnt)
        {
            return (lastError = PXERR_NOKEYMAP);
        }

        if (fldCnt < 1 || fldCnt > eo->keymap[ind].keyCnt)
        {
            return (lastError = PXERR_INVKEYCOUNT);
        }
    }

    for (int i=0; i < fldCnt; i++)
    {
        if (co->indexID <= 255)
        {
            fld = startFld;
        }
        else
        {
            fld = eo->keymap[ind].fieldArray[i];
        }
        switch (co->desc[fld-1].fldType)
        {
            case fldChar:
                lastError = DbiPutField(tabH, fld, genericRec->recH,
                                        (pBYTE) (CHAR *)va_arg(ap, CHAR *));
                break;
            case fldBool:
            {
                BOOL temp = (BOOL)va_arg(ap, BOOL);
                lastError = DbiPutField(tabH, fld, genericRec->recH,
                                        (pBYTE) &temp);
                break;
            }
            case fldShort:
            {
                INT16 temp = (INT16)va_arg(ap, INT16);
                lastError = DbiPutField(tabH, fld, genericRec->recH,
                                        (pBYTE) &temp);
                break;
            }
            case fldUInt16:
            {
                UINT16 temp = (UINT16)va_arg(ap, UINT16);
                lastError = DbiPutField(tabH, fld, genericRec->recH,
                                        (pBYTE) &temp);
                break;
            }
            case fldLong:
            {
                INT32 temp = (INT32)va_arg(ap, INT32);
                lastError = DbiPutField(tabH, fld, genericRec->recH,
                                        (pBYTE) &temp);
                break;
            }
            case fldUInt32:
            {
                UINT32 temp = (UINT32)va_arg(ap, UINT32);
                lastError = DbiPutField(tabH, fld, genericRec->recH,
                                        (pBYTE) &temp);
                break;
            }
            case fldDouble:
            {
                FLOAT temp = (FLOAT)va_arg(ap, FLOAT);
                lastError = DbiPutField(tabH, fld, genericRec->recH,
                                        (pBYTE) &temp);
                break;
            }
            case fldDate:
                #ifdef _MSC_VER                      // Microsoft C++.
                    dt =  va_arg(ap, BDate);
                #else
                    dt =  (BDate) va_arg(ap, BDate);
                #endif

                if ((lastError = DbiDateEncode((UINT16)dt.month, (UINT16)dt.day,
                                                 dt.year, &Date)) == DBIERR_NONE)
                {
                    lastError = DbiPutField(tabH, fld, genericRec->recH,
                                            (pBYTE) &Date);
                }
                break;
            case fldTime:
                #ifdef _MSC_VER                      // Microsoft C++.
                    tm =  va_arg(ap, BTime);
                #else
                    tm =  (BTime) va_arg(ap, BTime);
                #endif

                if ((lastError = DbiTimeEncode(tm.hour, tm.minute,
                                               tm.milSec, &Time)) == DBIERR_NONE)
                {
                    lastError = DbiPutField(tabH, fld, genericRec->recH,
                                            (pBYTE) &Time);
                }
                break;
          case fldTimeStamp:
                #ifdef _MSC_VER                      // Microsoft C++.
                    ts =  va_arg(ap, BTimeStamp);
                #else
                    ts =  (BTimeStamp)va_arg(ap, BTimeStamp);
                #endif


                if ((lastError = DbiDateEncode((UINT16)ts.BDay.month,
                                               (UINT16)ts.BDay.day,
                                               ts.BDay.year, &Date))
                    == DBIERR_NONE)
                {
                    if ((lastError = DbiTimeEncode(ts.BHour.hour,
                                                   ts.BHour.minute,
                                                   ts.BHour.milSec, &Time))
                        == DBIERR_NONE)
                    {
                        if ((lastError = DbiTimeStampEncode(Date, Time,
                                                            &TimeStamp))
                            == DBIERR_NONE)
                        {
                            lastError = DbiPutField(tabH, fld, genericRec->recH,
                                                    (pBYTE) &TimeStamp);
                        }
                    }
                }
                break;
        }
        startFld += 1;
    }

    va_end(ap);

    if (lastError)
    {
        return lastError;
    }

    return (searchIndex(genericRec, mode, fldCnt));
}

Retcode BCursor::switchToIndex(const char *indexName, const char *tagName)
{
    IDXDesc         idxDesc;
//BR BEG
#if 0//950515
    unsigned int    indexSeqNo;
#else
    UINT16          indexSeqNo;
#endif//950515
//BR END
    
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiSwitchToIndex(&tabH, (pCHAR)indexName, (pCHAR)tagName,
                                 0, TRUE);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    lastError = DbiGetIndexSeqNo(tabH, (pCHAR)indexName, (pCHAR)tagName, 0,
                                 &indexSeqNo);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    curdef *co = (curdef *)curobj;

    co->indexID = idxDesc.iIndexId;
    strcpy(co->indexName, idxDesc.szName);
    strcpy(co->indexTag, idxDesc.szTagName);

    return lastError;
}

Retcode BCursor::switchToIndex(int indexID)
{
    IDXDesc         idxDesc;
//BR BEG
#if 0//950515
    unsigned int    indexSeqNo;
#else
    UINT16          indexSeqNo;
#endif//950515
//BR END

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiSwitchToIndex(&tabH, NULL, NULL, indexID, TRUE);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    lastError = DbiGetIndexSeqNo(tabH, NULL, NULL, indexID,
                                 &indexSeqNo);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    curdef *co = (curdef *)curobj;

    co->indexID = indexID;
    strcpy(co->indexName, idxDesc.szName);
    strcpy(co->indexTag, idxDesc.szTagName);

    return lastError;
}

Retcode BCursor::setRange(BRecord &highRecord, BRecord &lowRecord,
                          BOOL includeHigh, BOOL includeLow)
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (highRecord.recH == NULL)
    {
        return (lastError = PXERR_RECNOTATT);
    }

    if (lowRecord.recH == NULL)
    {
        return (lastError = PXERR_RECNOTATT);
    }
    
    lastError = DbiSetRange(tabH, FALSE, 0, 0, lowRecord.recH, includeLow, 0, 0,
                            highRecord.recH, includeHigh);

    return lastError;
}

Retcode BCursor::resetRange()
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiResetRange(tabH);

    return lastError;
}

Retcode BCursor::addFilter(pCANExpr canExpr, hDBIFilter &filterHandle)
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (canExpr == NULL)
    {
        return (lastError = DBIERR_INVALIDFILTER);
    }
    
    lastError = DbiAddFilter(tabH, 0L, 0, FALSE, (pCANExpr)canExpr,
                             NULL, &filterHandle);

    return lastError;
}

Retcode BCursor::activateFilter(hDBIFilter filterHandle)
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiActivateFilter(tabH, filterHandle);

    return lastError;
}

Retcode BCursor::deactivateFilter(hDBIFilter filterHandle)
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiDeactivateFilter(tabH, filterHandle);

    return lastError;
}

Retcode BCursor::dropFilter(hDBIFilter filterHandle)
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiDropFilter(tabH, filterHandle);

    return lastError;
}

Retcode BCursor::linkToCursor(BCursor &masterCursor, pUINT16 masterFields,
                               pUINT16 detailFields)
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (!masterCursor.isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (masterTabH != NULL)
    {
        return (lastError = DBIERR_FIELDMULTILINKED);
    }

    if (masterFields == NULL)
    {
        return (lastError = DBIERR_INVALIDPARAM);
    }

    if (detailFields == NULL)
    {
        return (lastError = DBIERR_INVALIDPARAM);
    }

    masterTabH = &(masterCursor.tabH);
    
    lastError = DbiBeginLinkMode(masterTabH);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    lastError = DbiBeginLinkMode(&tabH);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    // Link the two tables, specifying which fields
    // will be linked in the last two parameters.
    // Specifically, link the first field of Customers
    // to the indexed second field of Orders
    lastError = DbiLinkDetail(*masterTabH, tabH, 1, masterFields,
                              detailFields);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    return lastError;
}

Retcode BCursor::unlinkFromCursor()
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    if (masterTabH == NULL)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiUnlinkDetail(tabH);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    // Tell the master table to go out of link mode
    lastError = DbiEndLinkMode(masterTabH);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    // Tell the detail table to go out of link mode
    lastError = DbiEndLinkMode(&tabH);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    masterTabH = NULL;

    return lastError;
}

Retcode BCursor::setProp(UINT32 prop, UINT32 value)
{
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return lastError;
    }

    lastError = DbiSetProp((hDBIObj)tabH, prop, value);

    return lastError;
}

Retcode BCursor::getProp(UINT32 prop, pVOID value, UINT16 maxLen,
                         UINT16 &retLen)
{
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return lastError;
    }

    lastError = DbiGetProp((hDBIObj)tabH, prop, value, maxLen, &retLen);

    return lastError;
}

Retcode BCursor::getProperties(CURProps &curProps)
{
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return lastError;
    }

    lastError = DbiGetCursorProps(tabH, &curProps);

    return lastError;
}


Retcode BCursor::getBookMark(BOOKMARK& bookMark)
{
    CURProps    curProps;
    
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return lastError;
    }

    lastError = DbiGetCursorProps(tabH, &curProps);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    try
    {
        bookMark = new BYTE[curProps.iBookMarkSize];
    }
    catch (xalloc)
    {
        bookMark = NULL;
        lastError = DBIERR_NOMEMORY;
        return lastError;
    }
    
    lastError = DbiGetBookMark(tabH, bookMark);

    return lastError;
}

Retcode BCursor::setToBookMark(BOOKMARK bookMark)
{
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return lastError;
    }

    if (bookMark == NULL)
    {
        lastError = DBIERR_INVALIDBOOKMARK;
        return lastError;
    }

    lastError = DbiSetToBookMark(tabH, bookMark);

    if (lastError == DBIERR_NONE)
    {
        curStatus = atRecord;
    }

    return lastError;
}

Retcode BCursor::freeBookMark(BOOKMARK bookMark)
{
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return lastError;
    }

    if (bookMark == NULL)
    {
        lastError = DBIERR_INVALIDBOOKMARK;
        return lastError;
    }

    delete bookMark;

    return lastError;
}

Retcode BCursor::compareBookMarks(BOOKMARK bookMark1, BOOKMARK bookMark2,
                                  CMPBkMkRslt &rslt)
{
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return lastError;
    }

    if (bookMark1 == NULL)
    {
        lastError = DBIERR_INVALIDBOOKMARK;
        return lastError;
    }

    if (bookMark1 == NULL)
    {
        lastError = DBIERR_INVALIDBOOKMARK;
        return lastError;
    }

    lastError = DbiCompareBookMarks(tabH, bookMark1, bookMark2, &rslt);

    return lastError;
}

// Redefine pure virtuals from the BDbObject class.

char * BCursor::nameOf() const
{
    return ("BCursor");
}

void BCursor::printOn( ostream& os)
{
    os << nameOf() << "{ Table Name = " << tabname
       << ", Open Status = " << (int) isOpen << "}\n";
}

// Needs code to refresh any associated BRecord objects....

Retcode BCursor::setFieldMap(UINT16 numberOfFields, FLDDesc *fieldDesc)
{
    curdef          *co = (curdef *)curobj;

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiSetFieldMap(tabH, numberOfFields, fieldDesc);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    lastError = getDesc(tabH, co->fieldCnt, co->desc);

    return lastError;
}

// Needs code to refresh any associated BRecord objects....

Retcode BCursor::dropFieldMap()
{
    curdef          *co = (curdef *)curobj;

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiSetFieldMap(tabH, 0, 0);
    if (lastError != DBIERR_NONE)
    {
        return lastError;
    }

    lastError = getDesc(tabH, co->fieldCnt, co->desc);

    return lastError;
}

// Only supported for dBASE tables

Retcode BCursor::undeleteRecord()
{
    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiUndeleteRecord(tabH);

    return lastError;
}

// Only supported for dBASE tables

Retcode BCursor::packTable(BOOL regenIndexes)
{
    curdef      *co = (curdef *)curobj;

    if (!isOpen)
    {
        return (lastError = PXERR_CURSORNOTOPEN);
    }

    lastError = DbiPackTable((co->dbH)->hDb, tabH, NULL, NULL, regenIndexes);

    return lastError;
}

TABLEHANDLE BCursor::getHandle()
{
    if (!isOpen)
    {
        lastError = PXERR_CURSORNOTOPEN;
        return 0;
    }

    lastError = DBIERR_NONE;
    return tabH;
}

Retcode BCursor::openTable(BDatabase *db,
                           const char *tableName,
                           const char *tblType,
                           int indexID,
                           DBIOpenMode openMode,
                           DBIShareMode shareMode,
                           XLTMode xltMode)
{
    curdef      *co = (curdef *)curobj;
//BR BEG
#if 0//950609
    INT16       numFields = 0;
#else
    int         numFields = 0;
#endif//950609
//BR END
    FieldDesc   *fldDescs = NULL;
    CHAR        indexName[DBIMAXNAMELEN + 1];
    UINT16      indexSeqNo;
    IDXDesc     idxDesc;

    try
    {
        if (!strcmp(tblType, szPARADOX))
        {
            lastError = DbiOpenTable(db->hDb, (pCHAR)tableName, (pCHAR)tblType,
                                     NULL, NULL, indexID, openMode,
                                     shareMode, xltMode, FALSE, NULL, &tabH);
        }
        else if (!strcmp(tblType, szDBASE))
        {
            // If primary index
            if (indexID == 0)
            {
                // Attempt to open on simulated primary index
                lastError = DbiOpenTable(db->hDb, (pCHAR)tableName, (pCHAR)tblType,
                                         (pCHAR)tableName, "Primary", 0,
                                         openMode, shareMode, xltMode,
                                         FALSE, NULL, &tabH);
                if (lastError == DBIERR_NOSUCHINDEX)
                {
                    // On failure, open in natural order
                    lastError = DbiOpenTable(db->hDb, (pCHAR)tableName,
                                             (pCHAR)tblType, NULL, NULL, 0,
                                             openMode, shareMode, xltMode,
                                             FALSE, NULL, &tabH);
                    co->indexID = 0;
                    strcpy(co->indexName, "");
                    strcpy(co->indexTag, "");
                }
                else
                {
                    co->indexID = 0;
                    strcpy(co->indexName, (pCHAR)tableName);
                    strcpy(co->indexTag, "Primary");
                }
            }
            // attempt to open secondary index
            else
            {
                lastError = db->getDescVector((pCHAR)tableName, numFields,
                                               fldDescs);
                if (lastError != DBIERR_NONE)
                {
                    throw lastError;
                }

                if (indexID > numFields)
                {
                    lastError = DBIERR_NOSUCHINDEX;
                    throw lastError;
                }

                strncpy(indexName, tableName, 3);
                indexName[3] = 0;
                strncat(indexName, fldDescs[indexID-1].fldName, 8);
                indexName[8] = 0;
                strcat(indexName, ".NDX");
                // Check if the index exist as an .NDX index
                // This is our simulated non-maintained index
                if (!access(indexName, 00))
                {
                    lastError = DbiOpenTable(db->hDb, (pCHAR)tableName,
                                             (pCHAR)tblType,
                                             indexName, NULL, 0, openMode,
                                             shareMode, xltMode, FALSE,
                                             NULL, &tabH);
                    if (lastError == DBIERR_NONE)
                    {
                        co->indexID = indexID;
                        strcpy(co->indexName, (pCHAR)indexName);
                        strcpy(co->indexTag, "");
                    }
                }
                // This is our simulated maintained index
                else
                {
                    lastError = DbiOpenTable(db->hDb, (pCHAR)tableName,
                                             (pCHAR)tblType, (pCHAR)tableName,
                                             fldDescs[indexID-1].fldName, 0,
                                             openMode, shareMode,
                                             xltMode, FALSE, NULL, &tabH);
                    if (lastError == DBIERR_NONE)
                    {
                        co->indexID = indexID;
                        strcpy(co->indexName, fldDescs[indexID-1].fldName);
                        strcpy(co->indexTag, "");
                    }
                }
                delete fldDescs;
                fldDescs = 0;
            }
        }
        else if (!strcmp(tblType, szASCII))
        {
            // On failure, open in natural order
            lastError = DbiOpenTable(db->hDb, (pCHAR)tableName,
                                     (pCHAR)tblType, NULL, NULL, 0,
                                     openMode, shareMode,
                                     xltMode, FALSE, NULL, &tabH);
            if (lastError == DBIERR_NONE)
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
            }
        }
        else // if SQL Table
        {
            // If primary index
            if (indexID == 0)
            {
                strcpy(indexName, tableName);
                strncat(indexName, "_", DBIMAXNAMELEN);
                indexName[DBIMAXNAMELEN] = 0;
                strncat(indexName, "Primary", DBIMAXNAMELEN);
                indexName[DBIMAXNAMELEN] = 0;

                // Attempt to open on simulated primary index
                lastError = DbiOpenTable(db->hDb, (pCHAR)tableName,
                                         (pCHAR)tblType, (pCHAR)indexName, NULL,
                                         0, openMode, shareMode,
                                         xltMode, FALSE, NULL, &tabH);
                if ((lastError == DBIERR_NOSUCHINDEX) ||
                    (lastError == DBIERR_NOTINDEXED))
                {
                    // On failure, open in natural order
                    lastError = DbiOpenTable(db->hDb, (pCHAR)tableName,
                                             (pCHAR)tblType, NULL, NULL, 0,
                                             openMode, shareMode,
                                             xltMode, FALSE, NULL, &tabH);
                    if (lastError == DBIERR_NONE)
                    {
                        co->indexID = 0;
                        strcpy(co->indexName, "");
                        strcpy(co->indexTag, "");
                    }
                }
                else if (lastError == DBIERR_NONE)
                {
                    co->indexID = indexID;
                    strcpy(co->indexName, indexName);
                    strcpy(co->indexTag, "");
                }
                else
                {
                    co->indexID = 0;
                    strcpy(co->indexName, "");
                    strcpy(co->indexTag, "");
                }
            }
            else
            {
                lastError = db->getDescVector((pCHAR)tableName, numFields,
                                               fldDescs);
                if (lastError != DBIERR_NONE)
                {
                    throw lastError;
                }

                if (indexID > numFields)
                {
                    lastError = DBIERR_NOSUCHINDEX;
                    throw lastError;
                }

                strcpy(indexName, tableName);
                strncat(indexName, "_", DBIMAXNAMELEN);
                indexName[DBIMAXNAMELEN] = 0;
                strncat(indexName, fldDescs[indexID-1].fldName, DBIMAXNAMELEN);
                indexName[DBIMAXNAMELEN] = 0;

                lastError = DbiOpenTable(db->hDb, (pCHAR)tableName,
                                         (pCHAR)tblType, (pCHAR)indexName,
                                         NULL, 0, openMode, shareMode,
                                         xltMode, FALSE, NULL, &tabH);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = indexID;
                    strcpy(co->indexName, indexName);
                    strcpy(co->indexTag, "");
                }
            }
        }

        if (lastError != DBIERR_NONE)
        {
            throw lastError;
        }

        isOpen = TRUE;

        if (!strcmp(tblType, szPARADOX))
        {
            lastError = DbiGetIndexSeqNo(tabH, NULL, NULL, indexID,
                                         &indexSeqNo);
            if (lastError == DBIERR_NONE)
            {
                lastError = DbiGetIndexDesc(tabH, indexSeqNo, &idxDesc);
                if (lastError == DBIERR_NONE)
                {
                    co->indexID = idxDesc.iIndexId;
                    if (co->indexID != 0)
                    {
                        strcpy(co->indexName, idxDesc.szName);
                    }
                    else
                    {
                        strcpy(co->indexName, idxDesc.szName);
                    }

                    strcpy(co->indexTag, "");
                }
            }
            else
            {
                co->indexID = 0;
                strcpy(co->indexName, "");
                strcpy(co->indexTag, "");
                if ( (indexID == 0) && (lastError == DBIERR_NOSUCHINDEX))
                {
                    lastError = DBIERR_NONE;
                }
            }

        }
    }
    catch(...)
    {
        if (fldDescs)
        {
            delete fldDescs;
        }
    }

    return lastError;
}

// Return the status of the cursor - if on a atBegin, atRecord,
// atCrack, or atEnd.

PXCursorStatus
BCursor::getCurStatus()
{
    return curStatus;
}

//
//	Used to clear any open blobs. This function should be called
//	if any blobs have been written to a record, but appendRec(),
//	insertRec() or updateRec() was never called successfully.
//
//	For example, if there is a locking conflict, and a decision
//	is made not to post a record having had blobs written to its
//	record buffer, clearRec() should be called to free those blob
//	resources. clearRec() may be called even after the blobs have
//	already been closed by appendRec(), insertRec() or updateRec().
//
//	In summary, whenever a blob is written to a BRecord, it MUST
//	be followed by a successfull call to one of the following BCursor
//	functions, or	BLOB resources will not be freed:
//		appendRec()
//		clearRec()
//		insertRec()
//		updateRec()
//
Retcode
BCursor::clearRec (BRecord* rec)
{
    curdef *co = (curdef *)curobj;

    for (int i = 0; i < co->fieldCnt; i++)
    {
        if  (co->desc[i].fldType == fldBlob)
        {
            lastError = rec->closeBlob((i + 1), FALSE);
            switch (lastError)
            {
                case DBIERR_NONE:
                    break;
                case DBIERR_BLOBNOTOPENED: //appendRec(), insertRec() or
                                           // updateRec() must have already
                                           // been called, or this BLOB
                                           // was never opened
					lastError = DBIERR_NONE;
					break;
				default :
					return lastError;
			}
		}
	}

    if (rec->clear())
    {
        return rec->lastError;
    }

	lastError = DBIERR_NONE;
	return lastError;
}

Retcode
BCursor::clearRec ()
{
    curdef *co = (curdef *)curobj;

    for (int i = 0; i < co->fieldCnt; i++)
    {
        if  (co->desc[i].fldType == fldBlob)
        {
            lastError = genericRec->closeBlob((i + 1), FALSE);
            switch (lastError)
            {
                case DBIERR_NONE:
                    break;
                case DBIERR_BLOBNOTOPENED: //appendRec(), insertRec() or
                                           // updateRec() must have already
                                           // been called, or this BLOB
                                           // was never opened
					lastError = DBIERR_NONE;
					break;
				default :
					return lastError;
			}
		}
	}

    if (genericRec->clear())
    {
        return genericRec->lastError;
    }

	lastError = DBIERR_NONE;
	return lastError;
}

Retcode
BCursor::curChange()
{
    return DBIERR_NONE;
}

// The following two routines are used to maintain a list of cursors for
// a database. The Database Framework layer does not assume the presence
// of any Class library (not even Borland's container Classlib).
// Consequently, no List class is used.

Retcode addCursor(dbdef *db, BCursor *cur)
{
    // Add this Cursor object to the Cursor vector in the Database.
    int i;
    BCursor **newvec;
    for (i = 0; i < db->handleCnt; i++)
    {
        if (! db->curList[i])     // empty slot ?
        {
            db->curList[i] = cur;
            return DBIERR_NONE;
        }
    }
    try
    {
        // 4 more handles
        newvec = new BCursor *[db->handleCnt+4];
    }
    catch(xalloc)
    {
        return DBIERR_NOMEMORY;
    }

    for (i = 0; i < db->handleCnt; i++)
    {
        newvec[i] = db->curList[i];
    }

    newvec[i++] = cur;
    newvec[i] = newvec[i+1] = newvec[i+2] = 0;

    if (db->handleCnt)
    {
        delete [] db->curList;     // Delete old vector.
    }
    db->handleCnt += 4;
    db->curList = newvec;

    return DBIERR_NONE;
}

// Delete the cursor object from the known cursor list in its database.

void deleteCursor(dbdef *db, BCursor *cur)
{
    for (int i = 0; i < db->handleCnt; i++)
    {
        if (db->curList[i] == cur)
        {
            db->curList[i] = 0;
            return;
        }
    }
}

// Compute the total size of first numFields of the descriptor.
// This function is not used and has not been updated for IDAPI

int getPdxRecSize(FieldDesc far *desc, int numFields)
{
    int size = 0;
    for (int i = 0; i < numFields; i++)
    {
        if  (desc[i].fldType == fldBlob)
        {
            size += desc[i].fldLen + 10;   // BLOB field in Paradox is
                                           // 10 + header.
        }
        else if  (desc[i].fldType == fldShort)
        {
            size += 2;
        }
        else if  (desc[i].fldType == fldDate)
        {
            size += 4;
        }
        else if  (desc[i].fldType == fldDouble)
        {
            size += 8;
        }
        else
        {
            size += desc[i].fldLen;
        }
    }

    return size;
}


