/***********************************************************************                   
**                            INTSTRCT.H                                                         
**
** This file contains structure definitions used to keep track of          
** internal variables of each class. In each class of the Paradox 
** Engine library header (.H) files, only a void pointer is declared,
** even though each of those pointers points to a structure. That 
** way, the the class interface does not change at the application 
** level a user does not need to recompile their programs with every 
** new version of the Class library.      
**
** Example: engobj in the BEngine class is declared void * even though 
** it could be declared as engdef *.          
**
***********************************************************************/

// DBF - (C) Copyright 1994 by Borland International

#if !defined( INTSTRCT_H )
#define INTSTRCT_H

typedef struct {
               char *tableName;          // Structure to store key map.
               int   indexId;           // Information on composite keys. 
               int   keyCnt; 
               int  *fieldArray;
               } keyMapdef;           
 
typedef struct {  
               BEnv          engenv; 
               int           handleCnt;    // Number of databases.
               BDatabase   **dbList;        // Database handle array.
               int           compIdxCnt;   // Count of mapped composite
               keyMapdef    *keymap;          // indexes.
           } engdef;

typedef struct {
           char       errUser[MAXNAMELEN+1];  // Buffer used in getErrUser.
           BEngine   *engH;                        // Engine object of database. 
           int        handleCnt;                 // Number of cursors.
           BCursor  **curList;                   // Cursor handle array. 
           } dbdef;

typedef struct {
           BDatabase *dbH;                  // Cursor's database object.
           int        indexID;
           BOOL       saveEveryChange;
           int        handleCnt;           // Number of records in the cursor.
           BRecord  **recList;            // Record handle array.
           int        fieldCnt;       // Number of fields in the table.
           FieldDesc far *desc;       // Field descriptor array in far heap.
           char       indexName[DBIMAXNAMELEN];
           char       indexTag[DBIMAXNAMELEN];
           } curdef;

enum PXBlobState {blbClosed = 0, blbOpenRead=1, blbOpenWrite=2};

typedef struct {
               FIELDNUMBER    fldnbr;       // Field number of BLOB in record,
                                          // custom or generic. 
               BLOBHANDLE     blbH;
               BOOL           privateBlb; // Clone BLOB?; always true for 
                                          // Write, may be true for Read.   
               PXBlobState    state;      // Open or closed. 
               RECORDHANDLE   blbRecH;     // Record handle of the record that
                                          // owns the BLOB; used for case when
                                          // when an application uses same 
                                          // custom record with multiple 
                                          // Paradox tables).     
               } blbdef;   

typedef struct {
           int          handleCnt;      // Number of elements in BLOB array.
           blbdef      *recblb;         // BLOB handle array.
           } recdef;
               
#endif

