/*********************************************************************
**
**                          BRECORD.H
**
** This file defines the interface for the BRecord class. This class
** encapsulates the notion of a generic table's record. A record
** is created in the context of a cursor; multiple record objects
** can exist in memory corresponding to one or more records of the
** cursor.
**
*********************************************************************/

// DBF - (C) Copyright 1994 by Borland International

#ifndef BRECORD_H
#define BRECORD_H

#include "envdef.h"
#include "bdbobjec.h"

class BRecord : public BDbObject {

  friend class BCursor;
//BR BEG
#if 0//950707
#else
  friend class  TBRecord;
#endif//950707
//BR END
public:

  Retcode   lastError;
  BOOL      bLastNull;

public:

  // Constructor for making a generic record object for an open cursor.

  BRecord(BCursor *cursor = NULL);

//BR BEG
#if 0//950627
#else
                  BRecord( const BRecord& copyCur );
    // Don't allow the assignment opperator to be called unless specifically
    //   defined
    BRecord&      operator =( const BRecord& copyRec );
  private:
    void          CloneInternals( const BRecord& other );
  public:
#endif//950627
//BR END

  // Destructor; will close the record buffer associated with the record.

  virtual ~BRecord();  

  // Close the record buffer associated with the object and delete the  
  // record's association with its cursor.  

  virtual Retcode detach();

  // Establish an association with an open cursor.

  virtual Retcode attach(BCursor *cur);

  // Clear the record buffer; set fields to "empty" values.

  virtual Retcode clear();

  // Return the field number for a given field name.

  virtual FIELDNUMBER getFieldNumber(const char *fldName) const;

  // For a given field number in the record, return the field number in
  // the table it is derived from. For generic records, both these numbers
  // will be the same. For custom records they can be different.

  virtual FIELDNUMBER getTblFieldNumber(FIELDNUMBER fldnbr) const;

  // Return the count of fields in the record.

  virtual int getFieldCount() const;

  // Given a field number, return its field descriptor.

  virtual Retcode getFieldDesc(FIELDNUMBER fldnbr, FieldDesc& desc) const;

  // Given a field number, return its type, subtype and length.

  virtual Retcode getFieldDesc(FIELDNUMBER fldnbr,
                               PXFieldType &fldType,
                               PXFieldSubtype &fldSubtype, int &fldLen) const;

  // Copy the contents of the record one field at a time in an assignment
  // compatible way to another record.

  virtual Retcode copyTo(BRecord *destRec) const;

  // Copy the contents of srcRec one field at a time in an assignment
  // compatible way to this record.

  virtual Retcode copyFrom(BRecord *srcRec);

  // Obtaining values for a given field in the record, specified by number
  // or name. Data conversion will be applied as is necessary. Void pointer
  // returns value in a format native to the field type in the table.

  virtual Retcode getField(FIELDNUMBER fldnbr, char *buf,
                           int bufLen, BOOL& fNull) const;

  virtual Retcode getField(FIELDNUMBER fldnbr, void *buf,
                           int bufLen, BOOL& fNull) const;

  virtual Retcode getField(FIELDNUMBER fldnbr, double& val, BOOL& fNull) const;

  virtual Retcode getField(FIELDNUMBER fldnbr, INT16& val, BOOL& fNull) const;

  virtual Retcode getField(FIELDNUMBER fldnbr, INT32& val, BOOL& fNull) const;

  virtual Retcode getField(FIELDNUMBER fldnbr, UINT16& val, BOOL& fNull) const;

  virtual Retcode getField(FIELDNUMBER fldnbr, UINT32& val, BOOL& fNull) const;

  virtual Retcode getField(FIELDNUMBER fldnbr, FMTBcd& val, BOOL& fNull) const;

  virtual Retcode getField(FIELDNUMBER fldnbr, BDate& val, BOOL& fNull) const;

  virtual Retcode getField(FIELDNUMBER fldnbr, BTime& val, BOOL& fNull) const;

  virtual Retcode getField(FIELDNUMBER fldnbr, BTimeStamp& val, BOOL& fNull) const;

  virtual Retcode getField(char *fldName, char *buf, int bufLen,
                           BOOL& fNull) const;

  virtual Retcode getField(char *fldName, void *buf, int bufLen,
                           BOOL& fNull) const;

  virtual Retcode getField(char *fldName, double& val, BOOL& fNull) const;

  virtual Retcode getField(char *fldName, INT16& val, BOOL& fNull) const;

  virtual Retcode getField(char *fldName, INT32& val, BOOL& fNull) const;

  virtual Retcode getField(char *fldName, UINT16& val, BOOL& fNull) const;

  virtual Retcode getField(char *fldName, UINT32& val, BOOL& fNull) const;

  virtual Retcode getField(char *fldName, FMTBcd& val, BOOL& fNull) const;

  virtual Retcode getField(char *fldName, BDate& val, BOOL& fNull) const;

  virtual Retcode getField(char *fldName, BTime& val, BOOL& fNull) const;

  virtual Retcode getField(char *fldName, BTimeStamp& val, BOOL& fNull) const;
  

  // Put field values in a record, providing the counterpart
  // operations of getField functions. 

  virtual Retcode putField(FIELDNUMBER fldnbr, const char *buf);

  virtual Retcode putField(FIELDNUMBER fldnbr, const void *buf);

  virtual Retcode putField(FIELDNUMBER fldnbr, double val);

  virtual Retcode putField(FIELDNUMBER fldnbr, INT16 val);

  virtual Retcode putField(FIELDNUMBER fldnbr, INT32 val);

  virtual Retcode putField(FIELDNUMBER fldnbr, UINT16 val);

  virtual Retcode putField(FIELDNUMBER fldnbr, UINT32 val);

  virtual Retcode putField(FIELDNUMBER fldnbr, FMTBcd val);

  virtual Retcode putField(FIELDNUMBER fldnbr, const BDate& val);

  virtual Retcode putField(FIELDNUMBER fldnbr, const BTime& val);

  virtual Retcode putField(FIELDNUMBER fldnbr, const BTimeStamp& val);

  virtual Retcode putField(char *fldName, const char *buf);

  virtual Retcode putField(char *fldName, const void *buf);

  virtual Retcode putField(char *fldName, double val);

  virtual Retcode putField(char *fldName, INT16 val);

  virtual Retcode putField(char *fldName, INT32 val);

  virtual Retcode putField(char *fldName, UINT16 val);

  virtual Retcode putField(char *fldName, UINT32 val);

  virtual Retcode putField(char *fldName, FMTBcd val);

  virtual Retcode putField(char *fldName, const BDate& val);

  virtual Retcode putField(char *fldName, const BTime& val);

  virtual Retcode putField(char *fldName, const BTimeStamp& val);

  // Test if the field specified by number is null.

  virtual BOOL isNull(FIELDNUMBER fldnbr) const;

  // Test if the field specified by name is null.

  virtual BOOL isNull(const char *fldname) const;

  // Set the field specified by number to null.

  virtual Retcode setNull(FIELDNUMBER fldnbr);

  // Set the field specified by name to null.

  virtual Retcode setNull(const char *fldName);

  // Clear the field's null flag; used in custom records only.

  virtual Retcode clearNull(FIELDNUMBER fldnbr);

  // Clear the field's null flag; used in custom records only.

  virtual Retcode clearNull(const char *fldName);

  // Get the handle to the record. WARNING: be carefull when using the
  // handle outside the class.

  RECORDHANDLE getHandle() const;

  // Open a Blob field for subsequent read operations.

  Retcode openBlobRead(FIELDNUMBER fldnbr,
                       BOOL usePrivateCopy = FALSE) const;

  // Open a Blob field for subsequent write operations. Retain the first
  // size bytes of the current BLOB.

  Retcode openBlobWrite(FIELDNUMBER fldnbr,
                        long size, BOOL copyOld );

  // Get the header of the BLOB field.

  Retcode getBlobHeader(FIELDNUMBER fldnbr, int size,
                        void *buffer, int& bytesRead) const;

  // Get the size of an open BLOB.

  unsigned long getBlobSize(FIELDNUMBER fldnbr) const;

  // Read a segment of an open BLOB.

  Retcode getBlob(FIELDNUMBER fldnbr, unsigned int size,
                  long offset, void far *buffer) const;

  // Close an open BLOB.

  Retcode closeBlob(FIELDNUMBER fldnbr, BOOL accept = TRUE) const;

  // Write a segment into an open BLOB.

  Retcode putBlob(FIELDNUMBER fldnbr, unsigned long size,
                  unsigned long offset, void far *buffer);

  // Drop a Blob field from a Record.

  Retcode dropBlob(FIELDNUMBER fldnbr) const;

  virtual Retcode getField(FIELDNUMBER fldnbr, char *buf,
                           int bufLen) const;
  virtual Retcode getField(FIELDNUMBER fldnbr, void *buf,
                           int bufLen) const;
  virtual Retcode getField(FIELDNUMBER fldnbr, double& val) const;
  virtual Retcode getField(FIELDNUMBER fldnbr, INT16& val) const;
  virtual Retcode getField(FIELDNUMBER fldnbr, INT32& val) const;
  virtual Retcode getField(FIELDNUMBER fldnbr, UINT16& val) const;
  virtual Retcode getField(FIELDNUMBER fldnbr, UINT32& val) const;
  virtual Retcode getField(FIELDNUMBER fldnbr, FMTBcd& val) const;
  virtual Retcode getField(FIELDNUMBER fldnbr, BDate& val) const;
  virtual Retcode getField(FIELDNUMBER fldnbr, BTime& val) const;
  virtual Retcode getField(FIELDNUMBER fldnbr, BTimeStamp& val) const;
  virtual Retcode getField(const char *fldName, char *buf, int bufLen) const;
  virtual Retcode getField(const char *fldName, void *buf, int bufLen) const;
  virtual Retcode getField(const char *fldName, double& val) const;
  virtual Retcode getField(const char *fldName, INT16& val) const;
  virtual Retcode getField(const char *fldName, INT32& val) const;
  virtual Retcode getField(const char *fldName, UINT16& val) const;
  virtual Retcode getField(const char *fldName, UINT32& val) const;
  virtual Retcode getField(const char *fldName, FMTBcd& val) const;
  virtual Retcode getField(const char *fldName, BDate& val) const;
  virtual Retcode getField(const char *fldName, BTime& val) const;
  virtual Retcode getField(const char *fldName, BTimeStamp& val) const;

  virtual Retcode openBlobRead(const char* psFldName,
                               BOOL bUsePrivateCopy) const;

  virtual Retcode openBlobWrite(const char* psFldName,
                                long nSize,
                                BOOL bCopyOld);

  virtual Retcode getBlobHeader(const char* psFldName,
                                int nSize,
                                void* pvBuffer,
                                int& rnBytesRead) const;

  virtual unsigned long getBlobSize(const char* psFldName) const;

  virtual Retcode getBlob(const char* psFldName,
                          unsigned int nSize,
                          long nOffset,
                          void far *pvBuffer) const;

  virtual Retcode closeBlob(const char* psFldName,
                            BOOL bAccept) const;

  virtual Retcode putBlob(const char* psFldName,
                          unsigned long nSize,
                          unsigned long nOffset,
                          void far *pvBuffer);

  virtual Retcode dropBlob(const char* psFldName) const;


  // Place holder for user-defined preprocessing routine in a
  // custom record. Insert, update, and append routines will
  // call this routine before calling the Paradox Engine.

  virtual Retcode preprocess();

  // Place holder for user-defined postprocessing routine in
  // a custom record and called by getCurrent function after
  // fetching a record from a Paradox table.

  virtual Retcode postprocess();

  // Redefine pure virtuals from the BDbObject class.

  virtual char *nameOf() const;
  virtual void printOn( ostream& os);

protected:
    BCursor         *curH;                // Cursor for this record.
    RECORDHANDLE    recH;                 // IDAPI record handle.
    UINT16          iRecBufSize;

#if 0//950627
    // Don't allow the copy constructor to be called unless specifically
    //   defined
    BRecord(BRecord &copyCur);
    // Don't allow the assignment opperator to be called unless specifically
    //   defined
    BRecord& operator=(BRecord &copyRec);
#endif//950627
//BR BEG
#if 0//950531
#else
    UINT32          getBlob1( FIELDNUMBER fld, unsigned int size,
                              long offset, void far *buffer ) const;
#endif//950531
//BR END

private:
  void        *recobj;          // Variable used to keep track of
                                // a record's objects.
};

#endif

