/*
;;bdatabas.h
;;
;;  Changes and additions by //BR
;;
*/
/**********************************************************************
**
**                          BDATABASE.H
**
** This file defines the interface for the BDatabase class. This 
** class encapsulates the concept of a Database and defines
** database-level functions that operate on a defined collection 
** of persistent objects like tables, indexes, and so on. 
**
**********************************************************************/

// DBF - (C) Copyright 1994 by Borland International

#ifndef BDATABASE_H
#define BDATABASE_H

#include "envdef.h"
#include "bdbobjec.h"
#include "blistcur.h"

class BDatabase : public BDbObject {

    friend class BEngine;
    friend class BCursor;
    friend class BStatement;

public:
    Retcode lastError;
    BOOL    isOpen;

public:

    // Constructor that initializes fields and opens the universal database.

    BDatabase(BEngine *eng,
              DBIOpenMode openMode = dbiREADWRITE,
              DBIShareMode shareMode = dbiOPENSHARED);

    // Constructor that initializes fields and opens the specified database.

    BDatabase(BEngine *eng,
              const char *BDDriver,
              const char *BDAlias = "",
              const char *BDPassword  = "",
              DBIOpenMode openMode = dbiREADWRITE,
              DBIShareMode shareMode = dbiOPENSHARED);

//BR BEG
#if 0//950510
#else
    // Constructor with added username field

    BDatabase(BEngine *eng,
              const char *BDDriver,
              const char *BDAlias,
              const char *BDPassword,
              const char *BDUserName,
              DBIOpenMode openMode = dbiREADWRITE,
              DBIShareMode shareMode = dbiOPENSHARED);
#endif//950510
    // Destructor that closes a database if open.

    virtual ~BDatabase();             

    // Open the Universal database.

    virtual Retcode open(DBIOpenMode openMode = dbiREADWRITE,
                         DBIShareMode shareMode = dbiOPENSHARED);

    // Open a database for a given driver, alias and password.

    virtual Retcode open(const char *BDDriver,
                         const char *BDAlias = "",
                         const char *BDPassword = "",
                         DBIOpenMode openMode = dbiREADWRITE,
                         DBIShareMode shareMode = dbiOPENSHARED);

    // Close the database.

    virtual Retcode close(void);

    // See if a table exists in the database.

    BOOL tableExists(const char *tableName);

    // Create a table from the table descriptor(number of fields and the
    // field descriptor array).

    Retcode createTable(const char *tableName,
                        int numFields, const FieldDesc *desc,
                        ValidityDesc *valDesc = NULL,
                        RefDesc *refDesc = NULL);

    // Copy one table family to another.

    Retcode copyTable(const char *srcTable, const char *destTable,
                      const char *destType = NULL);

    // Append records of the source table to the destination table.

    Retcode appendTable(const char *srcTableName,
                        const char *destTableName,
                        const char *destType = NULL,
                        const BDatabase &db = NULL);

    // Rename a table and its family members.

    Retcode renameTable(const char *oldName, const char *newName);

    // Delete a table and its family.

    Retcode deleteTable(const char *tableName);

    // Encrypt a table based on a supplied password.

    Retcode encryptTable(const char *tableName, const char *password);

    // Decrypt a table using a password.

    Retcode decryptTable(const char *tableName);

    // Empty a table by deleting all its records.

    Retcode emptyTable(const char *tableName);

    // Upgrade the table from Paradox 3.5 to Paradox 4.0 format.

    Retcode upgradeTable(const char *tableName);

    // Restructure the table
    
    Retcode restructureTable(CRTblDesc &tblDesc,
                             const char *tableName);

    // Find out if the table is protected; if it is, return TRUE.
    // In all other cases, return FALSE.

    BOOL isProtected(const char *tableName);

    // Return the number of fields (columns) in the table. Return
    // zero if not successful.

    int getFieldCount(const char *tableName);

    // Given a table, return the number of fields and an array of
    // its field descriptors. The caller is responsible for
    // deleting the free store memory allocated for the field
    // descriptors. Descriptors are always allocated in the far
    // heap, even under Windows medium memory model.

    Retcode getDescVector(char *tableName,
                          int& numFields, FieldDesc *&desc);

    // Given a table, return the number of indexes and an array of
    // its index descriptors. The caller is responsible for
    // deleting the free store memory allocated for the index
    // descriptors. Descriptors are always allocated in the far
    // heap, even under Windows medium memory model.

    Retcode getIndexVector(char *tableName,
                           int& numIndexes,
                           IDXDesc *&desc);

    // Given an ordered list of fields in the table, create
    // a composite index on those fields. Returns an
    // indexID. Only valid for Paradox tables

    Retcode defineCompoundKey(const char *tableName,
                              int numFields,
                              const FIELDNUMBER *fldArray,
                              const char *indexName,
                              BOOL caseSen,
//BR BEG
#if 0//950609
                              FIELDNUMBER& outH);
#else
                              UINT16& outH);
#endif//950609
//BR END

    // Given an ordered list of fields in the table, create
    // a composite index on those fields

    Retcode defineCompoundKey(const char *tableName,
                              int numFields,
                              const FIELDNUMBER *fldArray,
                              const char *indexName,
                              BOOL caseSen = TRUE);

    // Create a secondary index on the table. If the field handle
    // passed is greater than 255, it must be a number obtained
    // from the defineCompoundKey function.

    Retcode createSIndex(const char *tableName,
                         FIELDNUMBER fieldH,
                         PXKeyCrtMode keyMode);

    // Create a primary key on the table using the first numFields
    // fields as the key.

    Retcode createPIndex(const char *tableName, int numFields);

    // Create an index using an index Descriptor
    
    Retcode createIndex(const char *tableName, IDXDesc &indexDesc);

    // Delete an index on the table. indexID must be zero for the
    // primary key.

    Retcode dropIndex(const char *tableName, FIELDNUMBER indexID);

    // Delete an index on the table. Uses the indexName  to specify the
    // index

    Retcode dropIndex(const char *tableName, const char *indexName);

    // Delete an index on the table. Uses the indexName and indexTagName
    // to specify the index

    Retcode dropIndex(const char *tableName, const char *indexName,
                      const char *indexTagName);

    // Return the number of primary key fields for the table; if a primary
    // key does not exist or under all other circumstances, returns zero.

    int getNumPFields(const char *tableName);

    // Given the name of a composite secondary index, return information
    // about it.

    Retcode getSKeyInfo(const char *indexName,
                        char *fldName, int& numFields,
                        BOOL& caseSen, FIELDNUMBER *fldArray,
                        FIELDNUMBER& indexID);

    // Return information on a single field secondary index.

    Retcode getSKeyInfo(const char *indexName,
                        char *fldName, BOOL& caseSen,
                        FIELDNUMBER& indexID);

    // Acquire a file name lock on the network; File need not
    // physically exist.

    Retcode lockNetFile(const char *fileName, PXLockMode lockMode);

    // Release a previously acquired lock on a file.

    Retcode unlockNetFile(const char *fileName, PXLockMode lockMode);

    // Write the changed record buffers associated with this
    // Engine instance to be written to disk.

    Retcode forceWrite(void);

    // Return the name of the user causing a locking error.

    char  *getNetErrUser(void);

    // Perform a query on the table

    Retcode query(const char *qryString, BCursor &answer,
                  DBIQryLang qryLang = qrylangSQL);

    // Get the type of the Database, i.e. dBASE, Paradox, Interbase, etc.

    const char *getDriver(void);

    // Start a transaction - Supported for SQL tables only
    
    Retcode beginTransaction(hDBIXact &tranHandle, eXILType tranType);

    // End a transaction - supported for SQL tables only
    
    Retcode endTransaction(eXEnd tranType);

    // Get information about a transaction - supported for SQL tables only
    
    Retcode getTransactionInfo(XInfo &tranInfo);

    // Set a property of the Database

    Retcode setProp(UINT32 prop, UINT32 value);

    // Get a property of the Database

    Retcode getProp(UINT32 prop, pVOID value, UINT16 maxLen,
                    UINT16 &retLen);

    // Get the ID for the specified indexName

    Retcode getIndexId(const char *tableName,
                       const char *indexName,
                       UINT16 &indexID);

    // Get the ID for the specified indexName

    Retcode getIndexId(const char *tableName,
                       const FIELDNUMBER *fldArray,
                       UINT16 &indexID);

    // Sets the working directory for the Database - only
    // supported for local tables
                                   
    Retcode setDirectory(const char *Directory);

    // Get the current working directory

    Retcode getDirectory(char *Directory);

    // Get the default directory

    Retcode getDefaultDirectory(char *Directory);

    // dBASE only. Pack the table. Regenerate indexes.

    Retcode packTable(const char *tableName, BOOL regenIndexes = TRUE);

    // Get the handle of the Database. WARNING: be carefull when
    // using the DATABASEHANDLE outside the class.

    DATABASEHANDLE getHandle(void);
    
    // Return an array of field descriptors. numFields needs to be
    // determined prior to calling this function. fldDescs needs to
    // be allocated before calling this function.

    Retcode getDesc(const char *tableName, int& numFields,
                    FieldDesc far *fldDescs);

    // Return an array of index Descriptors
    Retcode getIndexDesc(const char *tableName, int& numIndexes,
                         IDXDesc far *idxDescs);

    // Reset the list of valid tables for the database

    Retcode resetDBTableList();

    Retcode openTableList(BListCursor<TBLBaseDesc> &tableList,
                          const char *wildCard = "*.*",
                          BOOL system = TRUE);

    Retcode openTableList(BListCursor<TBLFullDesc> &tableList,
                          const char *wildCard = "*.*",
                          BOOL system = TRUE);

    Retcode openFileList(BListCursor<FILEDesc> &fileList,
                         const char *wildCard = "*.*");

    Retcode openIndexList(BListCursor<IDXDesc> &indexList,
                          const char *tableName,
                          const char *tableType = NULL);

    Retcode openFieldList(BListCursor<FLDDesc> &fieldList,
                          const char *tableName,
                          const char *tableType = NULL,
                          BOOL physicalTypes = FALSE);

    Retcode openFamilyList(BListCursor<FMLDesc> &familyList,
                           const char *tableName,
                           const char *tableType = NULL);

    Retcode openVchkList(BListCursor<VCHKDesc> &vchkList,
                         const char *tableName,
                         const char *tableType = NULL);

    Retcode openRintList(BListCursor<RINTDesc> &rintList,
                         const char *tableName,
                         const char *tableType = NULL);

    Retcode openSecurityList(BListCursor<SECDesc> &securityList,
                             const char *tableName,
                             const char *tableType = NULL);

    // Redefine pure virtuals from the BDbObject class.

    virtual char *nameOf() const;
    virtual void printOn(ostream& os);

protected:
    DATABASEHANDLE  hDb;
    BListCursor<TBLFullDesc> TableList;
    BOOL            isLocal;
    char            userName[DBIMAXUSERNAMELEN+1];
    char            Alias[DBIMAXNAMELEN+1];
    char            Driver[DBIMAXNAMELEN+1];
    char            Password[DBIMAXNAMELEN+1];

    // Don't allow the copy constructor to be called unless specifically
    //   defined
    BDatabase(BDatabase &copyCur);
    // Don't allow the assignment opperator to be called unless specifically
    //   defined

    BDatabase& operator=(BDatabase &copyDB);

private:
    void    *dbobj;             // Tracks objects of the database.
};

//BR BEG
#if 0//950523
#else
class
TReadCfgFileAliasInfo
{
  public:
              TReadCfgFileAliasInfo( const char* alias );
              ~TReadCfgFileAliasInfo();
    BOOL      GetParam( const char* prm, string& val );
    BOOL      PutParam( const char* prm, const char* val );
    //
    int       idxParams;
    Retcode   lastError;
    char*     prmBuf;
    FLDDesc*  prmFldDesc;
  protected:
    void      DeInit();
    Retcode   readCfgFile ( const string& CfgPath );
    //
    char*     idxBuf;
    int       idxOffset;
    const int maxBufVal;
    const int maxParams;
};
#endif//950523
//BR END

#endif

