/*
;;tbrecord.cpp
;;
;;  Design notes
;;    950609
;;      x const TBRecord& = NULL is supported in arglists for TBRecord class
;;          functions via protected constructor kluge
;;
*/

#pragma   hdrstop

//#include  <strstrea.h> //DBG
//#include  <tbrecord.hpp>
#include  <tdbf.hpp>

/*
;;TBRecord::TBRecord()
;;  : BRecord()
;;
*/
TBRecord::TBRecord()
  : BRecord(),
    csr( NULL )
{
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "TBRecord()", "BRecord constructor" );
  }
}

/*
;;TBRecord::TBRecord( TBCursor& cursor )
;;  : BRecord( &cursor )
;;
*/
TBRecord::TBRecord( TBCursor& cursor )
  : BRecord( &cursor ),
    csr( &cursor )
{
  if ( DBIERR_NONE != lastError )
  {
    throwExc( "TBRecord()", "BRecord constructor" );
  }
}

/*
;;
;;TBRecord::TBRecord( const TBRecord &copyCur )
;;     Copy Constructor
;;
;;    Record state is completely copied EXCEPT for any open BLOBs
;;
*/
TBRecord::TBRecord( const TBRecord &copyCur )
  : BRecord( copyCur ),
    //
    csr( copyCur.csr )
{
  if ( DBIERR_NONE != lastError )
  {
    TTdbfExc::ThrowExc( "TBRecord()", "BRecord constructor", NULL, "TBRecord",
                     lastError );
  }
  if ( recH != NULL )
  {
    copyCur.copyTo( *this ); //Copies BLOBs also, if any
  }
}

/*
;;
;;TBRecord::operator =( const TBRecord &copyCur )
;;     Assignment of records
;;
;;    Record state is completely copied EXCEPT for any open BLOBs
;;
*/
TBRecord&
TBRecord::operator =( const TBRecord &copyCur )
{
  if (this == &copyCur)
    return *this;

  BRecord::operator =( copyCur );
  csr = copyCur.csr;
  if ( DBIERR_NONE != lastError )
  {
    TTdbfExc::ThrowExc( "operator =", "BRecord constructor", NULL, "TBRecord",
                     lastError );
  }
  if ( recH != NULL )
  {
    copyCur.copyTo( *this ); //Copies BLOBs also, if any
  }
  return *this;
}

/*
;;virtual
;;TBRecord::~TBRecord()
;;
;;  Destructor; will close the record buffer associated with the record.
;;
*/
TBRecord::~TBRecord()
{
}

/*
;protected:
;Retcode
;TBRecord::attach( BCursor *curArg )
;
*/
Retcode
TBRecord::attach( BCursor *curArg )
{
  return ( BRecord::attach( curArg ) );
}

/*
;;Retcode
;;TBRecord::attach( TBCursor& curArg )
;;
*/
Retcode
TBRecord::attach( TBCursor& curArg )
{
  csr = &curArg;
  BRecord::attach( &curArg );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "attach()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::checkExc() const
;;
;;  Check if lastError is not DBIERR_NONE, throw (TTdbfExc) exception to app
;;    if so, otherwise return DBIERR_NONE
;;
*/
Retcode
TBRecord::checkExc() const
{
#if 0//950520
  if ( DBIERR_NONE != lastError ) //? Any error
  {
    throw ( lastError );          //Then throw to app
  }
  return ( lastError );           //(Always DBIERR_NONE)
#else
  return ( lastError );           //Any error or DBIERR_NONE
#endif//950520
}

/*
;;Retcode
;;TBRecord::clear()
;;
;;  Clear the record buffer and set fields to "empty" values.
;;  RecBufEmpty will fail if a BLOB is open. This function
;;  doesn't perform operations on BLOBs.
;;
*/
Retcode
TBRecord::clear()
{
  if ( BRecord::clear() != DBIERR_NONE )
  {
    throwExc( "clear()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::closeBlob(FIELDNUMBER fldnbr,
;;                    BOOL bAccept = TRUE) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::closeBlob(FIELDNUMBER fldnbr,
          BOOL bAccept) const
{
  BRecord::closeBlob( fldnbr, bAccept );
#if 0
  switch ( lastError )
  {
    case DBIERR_BLOBNOTOPENED :
    //case PXERR_BLOBNOTOPEN : //951114
      return ( lastError );
    default :
      break;
  }
#endif//0
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "closeBlob()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::closeBlob(const char* psFldName,
;;                    BOOL bAccept = TRUE) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::closeBlob(const char* psFldName,
                    BOOL bAccept ) const
{
  BRecord::closeBlob( psFldName, bAccept );
#if 0
  switch ( lastError )
  {
    case DBIERR_BLOBNOTOPENED :
    //case PXERR_BLOBNOTOPEN : //951114
      return ( lastError );
    default :
      break;
  }
#endif//0
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "closeBlob()", NULL, NULL, psFldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::copyTo( TBRecord& destRec, bool doBlobs = true ) const
;;
;;  Copies one rec to another (assumes all fields
;;    of source rec are same or comparable to first n fields
;;    in dest rec)
;;
;;  If doBlobs is true, then copies blob fields over, otherwise does not.
;;
;;  Performance can be substantially improved by NOT copying blob field
;;  contents over if they are not needed in the target record.
;;
*/
Retcode
TBRecord::copyTo( TBRecord& destRec, bool doBlobs ) const
{
#if 0//950704
  if ( BRecord::copyTo( &destRec ) != DBIERR_NONE )
  {
    throwExc( "copyTo()" );
  }
  return ( lastError );
#else
    //bool custom = strcmp(nameOf(), "TBRecord") ||
    //              strcmp(destRec.nameOf(), "TBRecord");

#if 0//950707
    if ( iRecBufSize > destRec.iRecBufSize )
    {
      string str;
      str += "iRecBufSize (";
      str += TIntString( iRecBufSize );
      str += ") > destRec.iRecBufSize (";
      str += TIntString( destRec.iRecBufSize );
      str += ")";
      throwExc( "copyTo()", str.c_str() );
    }
    _fmemcpy(destRec.recH, recH, iRecBufSize);
#endif//950707
    // custom record may have undefined recH and it is not fatal.
    if (! recH || ! destRec.recH )
    {
      const_cast<TBRecord*>( this )->lastError = DBIERR_INVALIDHNDL;
      throwExc( "copyTo()" );
    }
    destRec.clear(); //Clear target rec 1st

#if 1
    // Register the fact that the BLOBs in the destRec are now closed.
    recdef *ro = (recdef *)destRec.recobj;
    for (int i=0;i < ro->handleCnt; i++)
    {
        if (ro->recblb[i].blbRecH == destRec.recH)
        {
            ro->recblb[i].state = blbClosed;
            //const_cast<TBRecord*>( this )->lastError = DbiFreeBlob(curH->tabH, recH, 0);
            const_cast<TBRecord*>( this )->lastError = DbiFreeBlob(csr->tabH, recH, 0);
            if (lastError != DBIERR_NONE)
            {
                // If BLOB's previously closed, does not matter
                if (lastError == DBIERR_BLOBNOTOPENED)
                {
                    const_cast<TBRecord*>( this )->lastError = DBIERR_NONE;
                }
            }
        }
    }
#endif//1
#if 1
    //if (custom)
    //ALWAYS copy field by field ( incl. BLOBS if doBlobs )
    {
        char *buf;
        try
        {
            buf = new char[256];
        }
        catch(xalloc)
        {
            return ( const_cast<TBRecord*>( this )->lastError = DBIERR_NOMEMORY);
        }

        Retcode         ret;
        PXFieldType     fldType1, fldType2;
        PXFieldSubtype  fldSubtype;
        int             fldLen1, fldLen2;
        BOOL            fNull;

#if 0//950705
        int cnt = destRec.getFieldCount();
#else
        int cnt = getFieldCount(); //Use the source field count, not the dest.
#endif//950705
        for (int i=1; i <= cnt; i++)
        {
            getFieldDesc(i,fldType1,fldSubtype,fldLen1);
            destRec.getFieldDesc(i,fldType2,fldSubtype,fldLen2);
#if 0//950705
            if (fldType2 == fldBlob)
#else
            if ( fldType1 == fldBlob ) //Assume BLOB if source is BLOB
#endif//950705
            {
              if ( doBlobs )
              {
                TBlobRO blobRd( getFieldName( i ), *this );
                TBlobRW blobWr( getFieldName( i ), destRec );
                    //Assuming dest is BLOB is src is BLOB
                while ( true )
                    //Until entire blob read and written
                {
                  UINT16 n = blobRd.Read();
                  if ( n == 0 ) //? EOB
                  {
                    break;
                  }
                  blobWr.Write( blobRd.Data(), n );
                }
              }
              continue;                     // BLOB handling is separate.
            }
            //Else non-BLOB
            if (isNull(i))
            {
                destRec.setNull(i);
                continue;
            }
            destRec.clearNull(i);

            if ((ret = getField(i, (void *) buf, 255, fNull)) == DBIERR_NONE)
            {
                //if (fldType1 != fldType2)
                //Always do this
                {
                    ret = convertFld((void *)buf,fldType1, fldLen1,
                                     (void *)buf,fldType2, fldLen2);
                    if (ret == DBIERR_NONE)
                    {
                      try
                      {
                        ret = destRec.putField(i, (void *) buf);
                      }
                      catch ( const TTdbfExc& exc )
                      {
                        const_cast<TBRecord*>( this )->lastError = destRec.lastError;
                        throwExc( "copyTo()", NULL, "putField()", destRec.getFieldName( i ).c_str() );
                      }
                    }
                }
                if (ret)
                {
                    delete buf;
                    buf = NULL;
                    return ( const_cast<TBRecord*>( this )->lastError = ret);
                }
            }
        }
        delete buf;
        buf = NULL;
    }
#endif//1
    return ( const_cast<TBRecord*>( this )->lastError = DBIERR_NONE);
#endif//950704
}

/*
;;Retcode
;;TBRecord::copyToSimilar( TBRecord& ptRecDest ) const
;;
;;  Copy same-named fields only, whatever their position or type in dest.
;;
;;  Throws (TTdbfExc) exception on error
;;
*/
Retcode
TBRecord::copyToSimilar( TBRecord& ptRecDest ) const
{
  FIELDNUMBER h;
  FIELDNUMBER h1;
  FIELDNUMBER nFields = getFieldCount();
#if 0//950705
  char* ps = new char[ 8192 + 1 ];
#else
  const int maxBuf = 512 + 1;
  char* ps = new char[ maxBuf ]; //512 s/b enough for all non-BLOBs
#endif//950705
  FieldDesc tFldDesc;
  //
  ptRecDest.clear();
  for ( h = 1; nFields >= h; h++ )
  {
#if 0//950705
    if ( DBIERR_NONE != getFieldDesc( h, tFldDesc ) )
    {
      delete [] ps;
      throwExc( "copyToSimilar()" );
    }
    if ( tFldDesc.fldType == fldBlob && tFldDesc.fldSubtype != fldstMemo )
    {
      continue; //Not supported type to read (should chk to write also!)
    }
#else
    try
    {
      getFieldDesc( h, tFldDesc );
    }
    catch ( const TTdbfExc& exc )
    {
      string str = getFieldName( h );
      const_cast<TBRecord*>(this)->lastError = exc.lastError;
      delete [] ps;
      throwExc( "copyToSimilar()", exc.ErrMsg().c_str(), "getFieldDesc()",
          str.c_str() ); //Assume getFieldName doesn't throw its own
    }
#if 0//950705
    h1 = ptRecDest.getFieldNumber( tFldDesc.fldName );
    if ( 0 == h1 )
    {
      continue;
    }
#else
    try
    {
      h1 = ptRecDest.getFieldNumber( tFldDesc.fldName );
    }
    catch ( const TTdbfExc& exc )
    {
      continue; //Dest rec doesn't have this fldname, continue w/o warning
    }
#endif//950705
    if ( tFldDesc.fldType == fldBlob )
        //? Source field type is BLOB
    {
      TBlobRO blobRd( getFieldName( h ), *this );
      TBlobRW blobWr( ptRecDest.getFieldName( h1 ), ptRecDest );
      while ( true )
      {
        UINT16 n = blobRd.Read();
        if ( n == 0 ) //? EOB
        {
              break;
        }
        blobWr.Write( blobRd.Data(), n );
      }
      continue; //Done with BLOB processing
    }
    //Else non-BLOB, proceed
#endif//950705
    try
    {
      getField( h, ps, maxBuf );
    }
    catch ( const TTdbfExc& exc )
    {
      string str = getFieldName( h );
      const_cast<TBRecord*>(this)->lastError = exc.lastError;
      throwExc( "copyToSimilar()", exc.ErrMsg().c_str(), "getField()",
          str.c_str() ); //Assume getFieldName doesn't throw its own
    }
    if ( bLastNull ) //? NULL value for this field
    {
      continue;
    }
    try
    {
      ptRecDest.putField( h1, ps );
    }
    catch ( const TTdbfExc& exc )
    {
      string str = getFieldName( h );
      string str1;
      str1 += "putField(): ";
      str1 += ps;
      const_cast<TBRecord*>(this)->lastError = exc.lastError;
      throwExc( "copyToSimilar()", exc.ErrMsg().c_str(), str1.c_str(),
          str.c_str() ); //Assume getFieldName doesn't throw its own
    }
  }
  delete [] ps;
  return ( DBIERR_NONE );
}

/*
;;Retcode
;;TBRecord::dropBlob(FIELDNUMBER fldnbr) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::dropBlob(FIELDNUMBER fldnbr) const
{
  BRecord::dropBlob( fldnbr );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "dropBlob()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::dropBlob(const char* psFldName) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::dropBlob(const char* psFldName) const
{
  BRecord::dropBlob( psFldName );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "dropBlob()", NULL, NULL, psFldName );
  }
  return ( lastError );
}

/*
;;UINT32
;;TBRecord::getBlob(FIELDNUMBER fldnbr,
;;                  long nOffset,
;;                  string& buf,
;;                  UINT16 nSize = 0 ) const //0 means read up to 0xFFFF from blob
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
;;  Design notes:
;;    950523
;;      o Need to adapt to work with other than text blobs (embedded nulls)
;;
*/
UINT32
TBRecord::getBlob(FIELDNUMBER fldnbr,
                  long nOffset,
                  string& buf,
                  UINT16 nSize ) const
{
  UINT32 bytesRead;
  UINT16 maxBuf = 0xFFFF; //Default bufsize is max BLOB block read
  if ( 0 != nSize )
  {
    maxBuf = nSize;
  }
  FieldDesc tFldDesc;
  if ( DBIERR_NONE != getFieldDesc( fldnbr, tFldDesc ) )
  {
    throwExc( "getBlob()" );
  }
  if ( tFldDesc.fldType == fldBlob && tFldDesc.fldSubtype != fldstMemo )
  {
    throwExc( "getBlob(..., string& )", "Binary BLOB not supported" );
  }
  //Else have either a non-BLOB or a MEMO-type BLOB
  char* bufLoc = new char[ maxBuf ]; //Largest possible blob
  try
  {
    bytesRead = getBlob1( fldnbr, maxBuf, nOffset, bufLoc );
  }
  catch ( Retcode x )
  {
    delete [] bufLoc;
    throwExc( "getBlob()", "getBlob1()" );
  }
  buf.assign( bufLoc, 0, (UINT16) bytesRead );
  delete [] bufLoc;
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getBlob()" );
  }
  return ( bytesRead );
}

/*
;;Retcode
;;TBRecord::getBlob(FIELDNUMBER fldnbr,
;;                  unsigned int nSize,
;;                  long nOffset,
;;                  void far *pvBuffer) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getBlob(FIELDNUMBER fldnbr,
                  unsigned int nSize,
                  long nOffset,
                  void far *pvBuffer) const
{
  BRecord::getBlob( fldnbr, nSize, nOffset, pvBuffer );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getBlob()" );
  }
  return ( lastError );
}

/*
;;UINT32
;;TBRecord::getBlob(const char* psFldName,
;;                  long nOffset,
;;                  string& buf,
;;                  UINT16 nSize = 0 ) const //0 means read up to 0xFFFF from blob
;;
;;  Returns bytes read
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
;;  Design notes:
;;    950523
;;      o Need to adapt to work with other than text blobs (embedded nulls)
;;
*/
UINT32
TBRecord::getBlob(const char* psFldName,
                  long nOffset,
                  string& buf,
                  UINT16 nSize ) const
{
#if 0//950611
  UINT32 bytesRead;
  UINT16 maxBuf = 0xFFFF;
  if ( 0 != nSize )
  {
    maxBuf = nSize;
  }
  char* bufLoc = new char[ maxBuf ]; //Largest possible blob
	FIELDNUMBER hFld;
	if ((hFld = getFieldNumber(psFldName)) == 0)
	{
    delete [] bufLoc;
    throwExc( "getBlob()", NULL, NULL, psFldName );
	}
  try
  {
    bytesRead = getBlob1( hFld, maxBuf, nOffset, bufLoc );
  }
  catch ( Retcode x )
  {
    delete [] bufLoc;
    throwExc( "getBlob()", "getBlob1()" );
  }
  buf.assign( bufLoc, 0, (UINT16) bytesRead );
  delete [] bufLoc;
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getBlob()", NULL, NULL, psFldName );
  }
  return ( bytesRead );
#else
	FIELDNUMBER hFld;
	if ((hFld = getFieldNumber(psFldName)) == 0)
	{
    throwExc( "getBlob()", NULL, NULL, psFldName );
	}
  try
  {
    getBlob( hFld, nOffset, buf, nSize );
  }
  catch ( const TTdbfExc& exc )
  {
    throwExc( "getBlob()", exc.ErrMsg().c_str(), exc.ErrInfo().c_str(), psFldName );
  }
  return ( lastError );
#endif//950611
}

/*
;;Retcode
;;TBRecord::getBlob(const char* psFldName,
;;                  unsigned int nSize,
;;                  long nOffset,
;;                  void far *pvBuffer) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getBlob(const char* psFldName,
                  unsigned int nSize,
                  long nOffset,
                  void far *pvBuffer) const
{
  BRecord::getBlob( psFldName, nSize, nOffset, pvBuffer );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getBlob()", NULL, NULL, psFldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getBlobHeader(FIELDNUMBER fldnbr,
;;                        int nSize,
;;                        void* pvBuffer,
;;                        int& rnBytesRead) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getBlobHeader(FIELDNUMBER fldnbr,
                        int nSize,
                        void* pvBuffer,
                        int& rnBytesRead) const
{
  BRecord::getBlobHeader( fldnbr, nSize, pvBuffer, rnBytesRead );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getBlobHeader()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getBlobHeader(const char* psFldName,
;;                        int nSize,
;;                        void* pvBuffer,
;;                        int& rnBytesRead) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getBlobHeader(const char* psFldName,
                        int nSize,
                        void* pvBuffer,
                        int& rnBytesRead) const
{
  BRecord::getBlobHeader( psFldName, nSize, pvBuffer, rnBytesRead );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getBlobHeader()", NULL, NULL, psFldName );
  }
  return ( lastError );
}

/*
;;unsigned long
;;TBRecord::getBlobSize(FIELDNUMBER fldnbr) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
unsigned long
TBRecord::getBlobSize(FIELDNUMBER fldnbr) const
{
  unsigned long n;
  //
  n = BRecord::getBlobSize( fldnbr );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getBlobSize()" );
  }
  return ( n );
}

/*
;;unsigned long
;;TBRecord::getBlobSize(const char* psFldName) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
unsigned long
TBRecord::getBlobSize(const char* psFldName) const
{
  unsigned long n;
  //
  n = BRecord::getBlobSize( psFldName );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getBlobSize()", NULL, NULL, psFldName );
  }
  return ( n );
}

/*
;;Retcode
;;TBRecord::getField( FIELDNUMBER fldnbr, string& buf ) const
;;
;;  Note timestamp field types are returned formatted as follows:
;;    hh:mm:ss, mm/dd/yyyy
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, string& buf ) const
{
  FieldDesc tFldDesc;
  //
  if ( DBIERR_NONE != getFieldDesc( fldnbr, tFldDesc ) )
  {
    throwExc( "getField()" );
  }
  if ( tFldDesc.fldType == fldBlob ) //? Is BLOB type
  {
    getBlob( fldnbr, 0, buf ); //Use special call for BLOB type
  }
  else//Not BLOB
  {
    const UINT16 maxBuf = 255 + 1; //Default 255 limit on field size read
    char bufLoc[ maxBuf ];
    BRecord::getField( fldnbr, bufLoc, maxBuf, (BOOL) bLastNull );
    if ( DBIERR_NONE != checkExc() )
    {
      throwExc( "getField()" );
    }
    buf = bufLoc; //Assign returned string with val.
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField( FIELDNUMBER fldnbr, char *buf,
;;                    int bufLen ) const
;;
;;  Note timestamp field types are returned formatted as follows:
;;    hh:mm:ss, mm/dd/yyyy
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, char *buf,
                             int bufLen ) const
{
  BRecord::getField( fldnbr, buf, bufLen, (BOOL) bLastNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, void *buf,
;;                   int bufLen ) const
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, void *buf,
                             int bufLen ) const
{
  BRecord::getField( fldnbr, buf, bufLen, (BOOL) bLastNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, double& val ) const;
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, double& val ) const
{
  BRecord::getField( fldnbr, val, (BOOL) bLastNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, INT16& val ) const
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, INT16& val ) const
{
  BRecord::getField( fldnbr, val, (BOOL) bLastNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, INT32& val ) const
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, INT32& val ) const
{
  BRecord::getField( fldnbr, val, (BOOL) bLastNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, UINT16& val ) const
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, UINT16& val ) const
{
  BRecord::getField( fldnbr, val, (BOOL) bLastNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, UINT32& val ) const
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, UINT32& val ) const
{
  BRecord::getField( fldnbr, val, (BOOL) bLastNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, FMTBcd& val ) const
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, FMTBcd& val ) const
{
  BRecord::getField( fldnbr, val, (BOOL) bLastNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, BDate& val ) const
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, BDate& val ) const
{
  BRecord::getField( fldnbr, val, (BOOL) bLastNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, BTime& val ) const
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, BTime& val ) const
{
  BRecord::getField( fldnbr, val, (BOOL) bLastNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, BTimeStamp& val ) const
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, BTimeStamp& val ) const
{
  BRecord::getField( fldnbr, val, (BOOL) bLastNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, char *buf,
;;                             int bufLen, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, char *buf,
                             int bufLen, BOOL& fNull) const
{
  BRecord::getField( fldnbr, buf, bufLen, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, void *buf,
;;                             int bufLen, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, void *buf,
                             int bufLen, BOOL& fNull) const
{
  BRecord::getField( fldnbr, buf, bufLen, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, double& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, double& val, BOOL& fNull) const
{
  BRecord::getField( fldnbr, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, INT16& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, INT16& val, BOOL& fNull) const
{
  BRecord::getField( fldnbr, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, INT32& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, INT32& val, BOOL& fNull) const
{
  BRecord::getField( fldnbr, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, UINT16& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, UINT16& val, BOOL& fNull) const
{
  BRecord::getField( fldnbr, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, UINT32& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, UINT32& val, BOOL& fNull) const
{
  BRecord::getField( fldnbr, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, FMTBcd& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, FMTBcd& val, BOOL& fNull) const
{
  BRecord::getField( fldnbr, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, BDate& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, BDate& val, BOOL& fNull) const
{
  BRecord::getField( fldnbr, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, BTime& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, BTime& val, BOOL& fNull) const
{
  BRecord::getField( fldnbr, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(FIELDNUMBER fldnbr, BTimeStamp& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(FIELDNUMBER fldnbr, BTimeStamp& val, BOOL& fNull) const
{
  BRecord::getField( fldnbr, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(char *fldName, char *buf, int bufLen,
;;                               BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(char *fldName, char *buf, int bufLen,
                               BOOL& fNull) const
{
  BRecord::getField( fldName, buf, bufLen, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(char *fldName, void *buf, int bufLen,
;;                               BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(char *fldName, void *buf, int bufLen,
                               BOOL& fNull) const
{
  BRecord::getField( fldName, buf, bufLen, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(char *fldName, double& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(char *fldName, double& val, BOOL& fNull) const
{
  BRecord::getField( fldName, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(char *fldName, INT16& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(char *fldName, INT16& val, BOOL& fNull) const
{
  BRecord::getField( fldName, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(char *fldName, INT32& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(char *fldName, INT32& val, BOOL& fNull) const
{
  BRecord::getField( fldName, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(char *fldName, UINT16& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(char *fldName, UINT16& val, BOOL& fNull) const
{
  BRecord::getField( fldName, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(char *fldName, UINT32& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(char *fldName, UINT32& val, BOOL& fNull) const
{
  BRecord::getField( fldName, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(char *fldName, FMTBcd& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(char *fldName, FMTBcd& val, BOOL& fNull) const
{
  BRecord::getField( fldName, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(char *fldName, BDate& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(char *fldName, BDate& val, BOOL& fNull) const
{
  BRecord::getField( fldName, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(char *fldName, BTime& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(char *fldName, BTime& val, BOOL& fNull) const
{
  BRecord::getField( fldName, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(char *fldName, BTimeStamp& val, BOOL& fNull) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(char *fldName, BTimeStamp& val, BOOL& fNull) const
{
  BRecord::getField( fldName, val, fNull );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}


/*
;;Retcode
;;TBRecord::getField(const char *fldName, string& buf ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, string& buf ) const
{
#if 0//950611
  const int maxBuf = 255 + 1; //255 limit on field size read
                              //  (Should check if blob and expand if so)
  char bufLoc[ maxBuf ];
  BRecord::getField( fldName, bufLoc, maxBuf );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  buf = bufLoc; //Assign returned string with val.
  return ( lastError );
#else
	FIELDNUMBER hFld;
	if ((hFld = getFieldNumber( fldName ) ) == 0)
	{
    throwExc( "getBlob()", NULL, NULL, fldName );
	}
  try
  {
    getField( hFld, buf );
  }
  catch ( const TTdbfExc& exc )
  {
    throwExc( "getField()", exc.ErrMsg().c_str(), exc.ErrInfo().c_str(), fldName );
  }
  return ( lastError );
#endif//950611
}

/*
;;Retcode
;;TBRecord::getField(const char *fldName, char *buf, int bufLen ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, char *buf, int bufLen ) const
{
  BRecord::getField( fldName, buf, bufLen );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(const char *fldName, void *buf, int bufLen ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, void *buf, int bufLen ) const
{
  BRecord::getField( fldName, buf, bufLen );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(const char *fldName, double& val ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, double& val ) const
{
  BRecord::getField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(const char *fldName, INT16& val ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, INT16& val ) const
{
  BRecord::getField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(const char *fldName, INT32& val ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, INT32& val ) const
{
  BRecord::getField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(const char *fldName, UINT16& val ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, UINT16& val ) const
{
  BRecord::getField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(const char *fldName, UINT32& val ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, UINT32& val ) const
{
  BRecord::getField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(const char *fldName, FMTBcd& val ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, FMTBcd& val ) const
{
  BRecord::getField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(const char *fldName, BDate& val ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, BDate& val ) const
{
  BRecord::getField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(const char *fldName, BTime& val ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, BTime& val ) const
{
  BRecord::getField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::getField(const char *fldName, BTimeStamp& val ) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::getField(const char *fldName, BTimeStamp& val ) const
{
  BRecord::getField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "getField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;FIELDNUMBER
;;TBRecord::getFieldNumber( const char *fldName ) const
;;
;;  Return:
;;    Throws TTdbfExc object on any error
;;
*/
FIELDNUMBER
TBRecord::getFieldNumber( const char *fldName ) const
{
  FIELDNUMBER fldnum = BRecord::getFieldNumber( fldName );
  if ( lastError  != DBIERR_NONE )
  {
    throwExc( "getFieldNumber()" );
  }
  return ( fldnum );
}

/*
;;int
;;TBRecord::getFieldCount() const
;;
;;  For the generic table (and record) descriptor in use,
;;  return its field count.
;;
;;  Return:
;;    Throws TTdbfExc object on any error
;;
*/
int
TBRecord::getFieldCount() const
{
  int fldcnt = BRecord::getFieldCount();
  if ( lastError  != DBIERR_NONE )
  {
    throwExc( "getFieldCount()" );
  }
  return ( fldcnt );
}

/*
;;Retcode
;;TBRecord::getFieldDesc( FIELDNUMBER fldnbr,
;;                        FieldDesc& desc ) const
;;
;;  Given a field handle, return a field descriptor describing
;;  the field's name, type, length, and so on. For generic
;;  records, use the field descriptor in the cursor. (Table and
;;  record descriptors are the same).
;;
;;  Return:
;;    Throws TTdbfExc object on any error
;;
*/
Retcode
TBRecord::getFieldDesc( FIELDNUMBER fldnbr, FieldDesc& desc ) const
{
  BRecord::getFieldDesc( fldnbr, desc );
  if ( lastError  != DBIERR_NONE )
  {
    throwExc( "getFieldDesc()" );
  }
  return ( lastError );
}

/*
;;string
;;TBRecord::getFieldName( FIELDNUMBER h ) const
;;
;;  Return field name in string object
;;
;;  Return:
;;    Throws TTdbfExc object on any error
;;
*/
string
TBRecord::getFieldName( FIELDNUMBER h ) const
{
  FieldDesc descFld;
  //
  if ( DBIERR_NONE != getFieldDesc( h, descFld ) )
  {
    throwExc( "getFieldName()" );
  }
  return ( descFld.fldName );
}

/*
;;double
;;TBRecord::getFloat( const string& fldName ) const
;;
;;  Return: floating point (double) value from field in record
;;
;;  Error:  Throws TTdbfExc exception on any error
;;
*/
double
TBRecord::getFloat( const string& fldName ) const
{
  double n;
  try
  {
    getField( fldName.c_str(), n ); //Throws exception on any error
  }
  catch ( TTdbfExc& exc )
  {
    exc.fnName = "getFloat()";
    throw ( exc );
  }
  return ( n );
}

/*
;;INT32
;;TBRecord::getInt32( const string& fldName ) const
;;
;;  Return: integer (long) value from field in record
;;
;;  Error:  Throws TTdbfExc exception on any error
;;
*/
INT32
TBRecord::getInt32( const string& fldName ) const
{
  INT32 n;
  try
  {
    getField( fldName.c_str(), n ); //Throws exception on any error
  }
  catch ( TTdbfExc& exc )
  {
    exc.fnName = "getInt32()";
    throw ( exc );
  }
  return ( n );
}

/*
;;string
;;TBRecord::getString( const string& fldName ) const
;;
;;  Return: string value from field in record
;;
;;  Error:  Throws TTdbfExc exception on any error
;;
*/
string
TBRecord::getString( const string& fldName ) const
{
  string str;
  try
  {
    getField( fldName.c_str(), str ); //Throws exception on any error
  }
  catch ( TTdbfExc& exc )
  {
    exc.fnName = "getString()";
    throw ( exc );
  }
  return ( str );
}

/*
;;BTimeStamp
;;TBRecord::getTimestamp( const string& fldName ) const
;;
;;  Return: BTimeStamp value from field in record
;;
;;  Error:  Throws TTdbfExc exception on any error
;;
*/
BTimeStamp
TBRecord::getTimestamp( const string& fldName ) const
{
  BTimeStamp date;
  try
  {
    getField( fldName.c_str(), date ); //Throws exception on any error
  }
  catch ( TTdbfExc& exc )
  {
    exc.fnName = "getTimestamp()";
    throw ( exc );
  }
  return ( date );
}

/*
;;BOOL
;;TBRecord::isNull(FIELDNUMBER fldnbr) const
;;
*/
BOOL
TBRecord::isNull(FIELDNUMBER fldnbr) const
{
  BOOL b;
  //
  b = BRecord::isNull( fldnbr );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "isNull()" );
  }
  return ( b );
}

/*
;;TBool
;;TBRecord::isNull(const char *fldname) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
BOOL
TBRecord::isNull(const char *fldname) const
{
  BOOL b;
  //
  b = BRecord::isNull( fldname );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "isNull()", NULL, NULL, fldname );
  }
  return ( b );
}

/*
;;Retcode
;;TBRecord::openBlobRead(FIELDNUMBER fldnbr,
;;                       BOOL usePrivateCopy = FALSE) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::openBlobRead(FIELDNUMBER fldnbr,
                       BOOL usePrivateCopy) const
{
  BRecord::openBlobRead( fldnbr, usePrivateCopy );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "openBlobRead()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::openBlobRead(const char* psFldName,
;;                       BOOL usePrivateCopy = FALSE) const
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::openBlobRead(const char* psFldName,
                       BOOL usePrivateCopy) const
{
  BRecord::openBlobRead( psFldName, usePrivateCopy );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "openBlobRead()", NULL, NULL, psFldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::openBlobWrite(FIELDNUMBER fldnbr,
;;                        long nSize = 0,         //OBS PARAM
;;                        BOOL bCopyOld = FALSE)  //OBS PARAM
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::openBlobWrite(FIELDNUMBER fldnbr,
                        long nSize,
                        BOOL bCopyOld)
{
  BRecord::openBlobWrite( fldnbr, nSize, bCopyOld );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "openBlobWrite()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::openBlobWrite(const char* psFldName,
;;                        long nSize = 0,         //OBS PARAM
;;                        BOOL bCopyOld = FALSE)  //OBS PARAM
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::openBlobWrite(const char* psFldName,
                        long nSize,
                        BOOL bCopyOld)
{
  BRecord::openBlobWrite( psFldName, nSize, bCopyOld );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "openBlobWrite()", NULL, NULL, psFldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putBlob( FIELDNUMBER fldnbr,
;;                   unsigned long nOffset,
;;                   const string& buf )
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
;;  Design notes:
;;    950523
;;      o Need to adapt to work with other than null-terminated strings
;;          (string class supports this, but string::c_str() does not)
*/
Retcode
TBRecord::putBlob( FIELDNUMBER fldnbr,
                  unsigned long nOffset,
                  const string& buf )
{
  BRecord::putBlob( fldnbr, strlen( buf.c_str() ), nOffset, (char*) buf.c_str() );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putBlob()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putBlob(FIELDNUMBER fldnbr,
;;                  unsigned long nSize,
;;                  unsigned long nOffset,
;;                  void far *pvBuffer)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putBlob(FIELDNUMBER fldnbr,
                  unsigned long nSize,
                  unsigned long nOffset,
                  void far *pvBuffer)
{
  BRecord::putBlob( fldnbr, nSize, nOffset, pvBuffer );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putBlob()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putBlob( const char* psFldName,
;;                   unsigned long nOffset,
;;                   const string& buf )
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
;;  Design notes:
;;    950523
;;      o Need to adapt to work with other than null-terminated strings
;;          (string class supports this, but string::c_str() does not)
*/
Retcode
TBRecord::putBlob(const char* psFldName,
                  unsigned long nOffset,
                  const string& buf )
{
  BRecord::putBlob( psFldName, strlen( buf.c_str() ), nOffset, (char*) buf.c_str() );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putBlob()", NULL, NULL, psFldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putBlob(const char* psFldName,
;;                  unsigned long nSize,
;;                  unsigned long nOffset,
;;                  void far *pvBuffer)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putBlob(const char* psFldName,
                  unsigned long nSize,
                  unsigned long nOffset,
                  void far *pvBuffer)
{
  BRecord::putBlob( psFldName, nSize, nOffset, pvBuffer );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putBlob()", NULL, NULL, psFldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField( FIELDNUMBER fldnbr, const string& buf )
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField( FIELDNUMBER fldnbr, const string& buf )
{
  BRecord::putField( fldnbr, buf.c_str() );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(FIELDNUMBER fldnbr, const char *buf)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(FIELDNUMBER fldnbr, const char *buf)
{
  BRecord::putField( fldnbr, buf );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(FIELDNUMBER fldnbr, const void *buf)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(FIELDNUMBER fldnbr, const void *buf)
{
  BRecord::putField( fldnbr, buf );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(FIELDNUMBER fldnbr, double val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(FIELDNUMBER fldnbr, double val)
{
  BRecord::putField( fldnbr, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(FIELDNUMBER fldnbr, INT16 val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(FIELDNUMBER fldnbr, INT16 val)
{
  BRecord::putField( fldnbr, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(FIELDNUMBER fldnbr, INT32 val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(FIELDNUMBER fldnbr, INT32 val)
{
  BRecord::putField( fldnbr, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(FIELDNUMBER fldnbr, UINT16 val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(FIELDNUMBER fldnbr, UINT16 val)
{
  BRecord::putField( fldnbr, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(FIELDNUMBER fldnbr, UINT32 val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(FIELDNUMBER fldnbr, UINT32 val)
{
  BRecord::putField( fldnbr, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(FIELDNUMBER fldnbr, FMTBcd val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(FIELDNUMBER fldnbr, FMTBcd val)
{
  BRecord::putField( fldnbr, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(FIELDNUMBER fldnbr, const BDate& val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(FIELDNUMBER fldnbr, const BDate& val)
{
  BRecord::putField( fldnbr, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(FIELDNUMBER fldnbr, const BTime& val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(FIELDNUMBER fldnbr, const BTime& val)
{
  BRecord::putField( fldnbr, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(FIELDNUMBER fldnbr, const BTimeStamp& val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(FIELDNUMBER fldnbr, const BTimeStamp& val)
{
  BRecord::putField( fldnbr, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField( char *fldName, const string& buf )
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, const string& buf )
{
  BRecord::putField( fldName, buf.c_str() );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", "const string&", NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(char *fldName, const char *buf)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, const char *buf)
{
  BRecord::putField( fldName, buf );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(char *fldName, const void *buf)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, const void *buf)
{
  BRecord::putField( fldName, buf );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(char *fldName, double val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, double val)
{
  BRecord::putField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(char *fldName, INT16 val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, INT16 val)
{
  BRecord::putField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(char *fldName, INT32 val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, INT32 val)
{
  BRecord::putField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(char *fldName, UINT16 val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, UINT16 val)
{
  BRecord::putField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(char *fldName, UINT32 val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, UINT32 val)
{
  BRecord::putField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(char *fldName, FMTBcd val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, FMTBcd val)
{
  BRecord::putField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(char *fldName, const BDate& val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, const BDate& val)
{
  BRecord::putField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(char *fldName, const BTime& val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, const BTime& val)
{
  BRecord::putField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::putField(char *fldName, const BTimeStamp& val)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::putField(char *fldName, const BTimeStamp& val)
{
  BRecord::putField( fldName, val );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "putField()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::setNull(FIELDNUMBER fldnbr)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
;;  For BLOB fields, openBlobWrite() must have been called prior
;;
*/
Retcode
TBRecord::setNull(FIELDNUMBER fldnbr)
{
  BRecord::setNull( fldnbr );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "setNull()" );
  }
  return ( lastError );
}

/*
;;Retcode
;;TBRecord::setNull(const char *fldName)
;;
;;  Throws a (TTdbfExc) exception on error
;;    (otherwise returns DBIERR_NONE)
;;
*/
Retcode
TBRecord::setNull(const char *fldName)
{
  BRecord::setNull( fldName );
  if ( DBIERR_NONE != checkExc() )
  {
    throwExc( "setNull()", NULL, NULL, fldName );
  }
  return ( lastError );
}

/*
;;protected:
;;void
;;TBRecord::throwExc( const char* fnArg,
;;                    const char* errArg = NULL,
;;                    const char* infoArg = NULL,
;;                    const char* fldArg = NULL ) const
;;
*/
void
TBRecord::throwExc( const char* fnArg,
                    const char* errArg,
                    const char* infoArg,
                    const char* fldArg ) const
{
  const char* strAlias = NULL;
  const char* strTabname = NULL;
  if ( NULL != recH ) //Only if open
  {
    strAlias = csr->db->Alias;
    strTabname = csr->tabname;
  }
  TTdbfExc::ThrowExc( fnArg,
                   errArg,
                   infoArg,
                   getClassName(),
                   lastError,
                   strAlias,
                   strTabname,
                   fldArg );
}

