/*
;;example.cpp
;;950706
;;
;;  Example TDBF code
;;
;;  This is not a ready to run application--it offers only code examples for
;;  initializing and using the TDBF wrapper around the IDAPI engine.
;;
;;  Major sections are:
;;    TApp::Init()
;;      x Engine initialization
;;      x Callback registration
;;      x Private directory setting
;;      x Windows file handle setting
;;      x Databases opened on both shared database and private database
;;
;;    TApp::Run()
;;      x Opening a TBCursor and TBRecord on a table
;;      x Example query using TQueryNoAnswer
;;      x Example query using TQueryAnswerRO
;;      x Example query using TQueryAnswerRO, cloning result cursor
;;      x Example query using TQueryAnswerRO, saving result cursor to local
;;          table
;;      x Example query using TQueryAnswerRW, writing to result cursor then
;;          updating orig. table with it, and using TBlobRO and TBlobRW
;;
*/

//RTL includes

//3d-party includes
#define   WINDOWS     //Req'd for KDBF envdef.h
#include  <tdbf.hpp>
#pragma		hdrstop

//App includes
#include  "example.hpp"

/*
;;strstream*
;;winout
;;
;;  Output stream stub for example application
;;
*/
strstream*
winout;

/*
;;CBRType DBIFN
;;TApp::CallBackFunc( CBType ecbType, UINT32 iClientData, pVOID pCbInfo )
;;
*/
//======================================================================
//  Name:   CallBackFunc(ecbType, iClientData, pCbInfo)
//
//  Input:  ecbType     - Callback type
//          iClientData - Pointer to client information that is passed into
//                        the callback function
//          pCbInfo     - The callback structure that holds the information
//                        about the current state
//
//  Return: The action that should be taken
//
//  Description:
//          This function will be called from the BDE during the processing
//          of the restructure.
//======================================================================
CBRType DBIFN
TApp::CallBackFunc( CBType ecbType, UINT32 , pVOID )
{
    int percentDone = engine->rsltCallback.rsltUnion.rsltProgress.iPercentDone;
    const char* str = engine->rsltCallback.rsltUnion.rsltProgress.szMsg;
    if ( -1 == percentDone )
    {
      *winout << str << endl;
    }
    else
    {
      *winout << percentDone << endl;
    }

    switch ( ecbType )
    {
        case cbBATCHRESULT :
          break;

        // In case this is a restructure progress callback, display the
        //   information.
        case cbGENPROGRESS :
          break;

        case cbRESTRUCTURE:
#if 0//Example code from snipit disabled
            eCBRestDesc = (RESTCbDesc far *)pCbInfo;

            // Restructuring the old field.
            if(eCBRestDesc->eRestrObjType == restrOLDFLD)
            {
                pszMsg = (pCHAR)malloc(DBIMAXMSGLEN * sizeof(CHAR) + 1);
                if (!pszMsg)
                {
                    return cbrUSEDEF;
                }
                strcpy(pszMsg, eCBRestDesc->uObjDesc.fldDesc.szName);
                //Screen("\r\n### CallBack information:  Deleting the %s "
                //       "field...", pszMsg);
                *winout << "\r\n### CallBack information:  Deleting the " << pszMsg <<
                       " field...\n";

                free(pszMsg);
            }
            else
            {
                // Restructuring the new table's index.
                if(eCBRestDesc->eRestrObjType == restrNEWINDEX)
                {
                    //Screen("### CallBack information: Recreating the "
                    //       "Primary index...\r\n");
                  *winout << "### CallBack information: Recreating the "
                             "Primary index...\r\n";
                }

                // Not one we are expecting.
                else
                {
                    //Screen("### In the callback function");
                    *winout << "### In the callback function\n";
                }
            }
#endif//0
            break;
        case cbTABLECHANGED :
          break;
        default: //Unknown callback code
          break;
    }
    return ( cbrUSEDEF ); //Return one of the following:
                          //  cbrABORT
                          //  cbrCONTINUE
                          //  cbrUSEDEF
}

/*
;;void
;;TApp::DeInit()
;;
;;  Deallocate any dynamically allocated class member objects
;;
*/
void
TApp::DeInit()
{
  DELETE_SAFE( db );
  DELETE_SAFE( dbPriv );
  DELETE_SAFE( engine ); //Must delete engine after any db
}


/*
;;void
;;TApp::Init()
;;
;;      x Engine initialization
;;      x Callback registration
;;      x Private directory setting
;;      x Windows file handle setting
;;      x Databases opened on both shared database and private database
;;
*/
void
TApp::Init()
{
  db = NULL;
  dbPriv = NULL;
  engine = NULL;
  try
  {
    //Engine initialization and callback registration
		engine = new TBEngine( pxWin );
    engine->registerAllCallBacks( CallBackFunc );
		//Connect to a database (Works with either Pdox or SQL)
    const char* prmAlias =        "AliasName";
    const char* prmSqlPassword =  "SqlPassword";
    const char* prmSqlUserName =  "SqlUserName";
		db = new TBDatabase( *engine, "", prmAlias, prmSqlUserName, prmSqlPassword );
		//Set private directory to unique dir for this app, using an IDAPI alias
    //  to specify the directory to use
    //Also open a database on the private directory for the purpose of opening
    //  temp tables there
		Retcode	n;
		DBDesc 	desc;
		//
    const char* prmPrivAlias  = "PrivateAliasName";
		n = DbiGetDatabaseDesc( (char*) prmPrivAlias, &desc );
		if ( DBIERR_NONE != n )
		{
			throw ( n ); //Bad Alias name
		}
    engine->setPrivateDirAndCheck( desc.szPhyName );
    dbPriv = new TBDatabase( *engine, "", prmPrivAlias );
    //Set Windows filehandles for application to IDAPI setting plus some
    //  (per ti2761.zip)
    int nHandles = 20 + engine->maxSysFileHandles;
    if ( nHandles > (UINT16)_nfile )
    {
      *winout << "**Not enough RTL file handles available to application--\n";
      *winout << "  Asking for " << nHandles << ", RTL has " << (UINT16)_nfile << " available.\n";
      throw ( -1 );
    }
    if ( nHandles != SetHandleCount( nHandles ) )
    {
      throw ( -1 ); //Not enough file handles available to application
    }
	}
  catch ( const TTdbfExc& excTdbf )
  {
    ShowTdbfExc( excTdbf ); //TDBF exception object
  }
  catch ( Retcode x )
  {
    //IDAPI error code exception
    *winout << engine->getErrorMessage( x ) << endl;
  }
  catch ( ... )
  {
    //Other exception
    *winout << "Unknown exception in TApp::Init()" << endl;
  }
}

/*
;;void
;;TApp::Run()
;;
;;  Example app function including cursor and query examples
;;
*/
void
TApp::Run()
{
  string str;
  try
  {
    //Scan each record in TABLE1
    {
      TBCursor csr( *db, "TABLE1" );
      while ( true )
          //For each record in table
      {
        if ( DBIERR_NONE != csr.getNextRecord() )
        {
          break; //Assume EOF
        }
        //Else have valid record in rec
        csr.Rec().getField( "FIELD1", str );      //Read FIELD1 value
        *winout << "FIELD1: " << str << endl;
        csr.Rec().putField( "FIELD2", "NEWVAL" ); //Change FIELD2 value
        csr.updateRec();
      }
    }
    //Scan each record in TABLE11 using TBCursor's generic record,
    //  using a searchIndexRec() to find the first record
    {
      TBCursor csr( *db, "TABLE11" );
      csr.Rec().putField( "FIELD1", "VAL1" );
      if ( DBIERR_NONE != csr.searchIndexRec( (PXSearchMode) keySEARCHEQ, 1, true ) )
          //last arg == true means do getRecord() to csr.Rec() on successful find
      {
        *winout << "FIELD1: VAL1 not found\n";
      }
      else
      {
        *winout << "FIELD2: " << csr.Rec().getString( "FIELD2" ) << "\n";
            //csr.Rec() has record found by searchIndexRec() above
            //getString() returns string--alternative to getField() which
            //  returns a Retcode
        while ( true )
            //For each record in table
        {
          if ( DBIERR_NONE != csr.getNextRecord() )
          {
            break; //Assume EOF
          }
          //Else have valid record in rec
          csr.Rec().getField( "FIELD1", str );      //Read FIELD1 value
          *winout << "FIELD1: " << str << endl;
          csr.Rec().putField( "FIELD2", "NEWVAL" ); //Change FIELD2 value
          csr.updateRec();
        }
      }
    }
    //Query TABLE2 using TQueryNoAnswer (for delete/insert/update queries)
    {
      TQueryNoAnswer qry( *db );
      qry.Text() <<
  "update TABLE2 " <<
    "set " <<
      "FIELD1 = 1, " <<
      "FIELD2 = 2 " <<
    "where " <<
      "FIELD3 = 5 ";
      qry.Run(); //Throws exception on any error
    }
    //Query TABLE3 using TQueryAnswerRO, using the TQueryAnswerRO TBCursor and
    //  TBRecord objects
    {
      TQueryAnswerRO qry( *db );
      qry.Text() <<
  "select * from TABLE3 " <<
    "where " <<
      "FIELD4 = 4 ";
      qry.Run(); //Throws exception on any error
      //Scan result cursor
      while ( true )
      {
        if ( DBIERR_NONE != qry.Csr().getNextRecord() )
            //TQueryAnswerRO::Csr().Rec() == TQueryAnswerRO::Rec()
        {
          break; //Assume EOF
        }
        qry.Rec().getField( "FIELD1", str );      //Read FIELD1 value
        *winout << "FIELD1: " << str << endl;
      }
    }
    //Query TABLE40 using  TQueryAnswerRO, scanning through returned read-only
    //  cursor
    {
      TQueryAnswerRO qry( *db );
      qry.Text() <<
  "select * from TABLE40 " <<
    "where " <<
      "FIELD4 = 4 ";
      qry.Run(); //Throws exception on any error
      while ( true )
      {
        if ( qry.Csr().getNextRecord() != DBIERR_NONE )
        {
          break; //Assume EOF
        }
        qry.Rec().getField( "FIELD1", str );      //Read FIELD1 value
        *winout << "FIELD1: " << str << endl;
      }
    }
    //Query TABLE4 using  TQueryAnswerRO, cloning returned cursor back to
    //  the application (which can be used after TQueryAnswerRO object
    //  is destructed)
    const TBCursor* csrTable4;
        //Cloned cursor is const since is a TQueryAnswerRO returned one
    {
      TQueryAnswerRO qry( *db );
      qry.Text() <<
  "select * from TABLE4 " <<
    "where " <<
      "FIELD4 = 4 ";
      qry.Run(); //Throws exception on any error
      csrTable4 = new TBCursor( qry.CloneCursor() );
    }
    //TABLE4 qry object destructed, can still work with answer cursor (csrTable4)
    {
      //Scan answer cursor
      while ( true )
      {
        if ( DBIERR_NONE != csrTable4->getNextRecord() )
        {
          break; //Assume EOF
        }
        csrTable4->RecRO().getField( "FIELD1", str );
            //RecRO() used here to avoid compiler warning for const TBCursor object's
            //  Rec()
        *winout << "FIELD1: " << str << endl;
      }
      delete (TBCursor*)csrTable4;
    }
    //Query TABLE5 using  TQueryAnswerRO, saving query result to local private
    //directory
    {
      TQueryAnswerRO qry( *db );
      qry.Text() <<
  "select * from TABLE5 " <<
    "where " <<
      "FIELD4 = 4 ";
      qry.SetResultTbl( *dbPriv, "TEMP5" ); //Create TEMP5 table in app private dir.
      qry.Run(); //Throws exception on any error
    }
    //Query TABLE6 using  TQueryAnswerRW, writing then appending result
    {
      TBCursor csr( *db, "TABLE7" ); //Table having BLOB field to read from
      csr.getFirstRecord(); //Assume TABLE7 has at least 1 record
      TQueryAnswerRW qry( *db, *dbPriv, "TABLE6" );
      qry.Text() <<
  "select * from TABLE6 " <<
    "where " <<
      "FIELD4 = 6 ";
      qry.Run(); //Throws exception on any error
      while ( true )
      {
        if ( qry.Csr().getNextRecord() != DBIERR_NONE )
        {
          break; //Assume EOF
        }
        //Change this returned answer cursor record
        qry.Rec().putField( "FIELD1", "6" ); //Can write to TQueryAnswerRW cursor
        //Example TBlobRO and TBlobRW code
        TBlobRO blobRd( "BLOB_FIELD6", csr.Rec() );
        TBlobRW blobWr( "BLOB_FIELD7", qry.Rec() );
        while ( true )
            //Until source blob copyied to dest blob entirely
        {
          UINT16 n = blobRd.Read();
          if ( n == 0 ) //? EOB
          {
            break;
          }
          blobWr.Write( blobRd.Data(), n );
        }
        qry.Csr().updateRec();
      }
      //Update the originally queried table with changes to answer cursor
      //  made above
      qry.Update();
    }
  }
  catch ( const TTdbfExc& excTdbf )
  {
    ShowTdbfExc( excTdbf ); //TDBF exception object
  }
  catch ( ... )
  {
    //Other exception
    *winout << "Unknown exception in TApp::Run()" << endl;
  }
}

/*
;;void
;;TApp::ShowTdbfExc( const TTdbfExc& excTdbf )
;;
;;  Routine to put TDBF exception object to winout
;;
*/
void
TApp::ShowTdbfExc( const TTdbfExc& excTdbf )
{
    *winout <<
        "**TDBF error: " <<
        excTdbf.ClassName() << "::" <<
        excTdbf.FnName(); //fnName already has trailing "()"
        *winout << "\n";
    bool havPath = false;
    if ( 0 < excTdbf.AliasName().length() )
    {
      havPath = true;
      *winout <<
          ":" << excTdbf.AliasName() << ":";
    }
    if ( 0 < excTdbf.TblName().length() )
    {
      havPath = true;
      *winout <<
          excTdbf.TblName();
    }
    if ( 0 < excTdbf.FldName().length() )
    {
      havPath = true;
      *winout <<
          "." << excTdbf.FldName();
    }
    if ( havPath )
    {
      *winout << endl;
    }
    string str = excTdbf.IdapiMsg();
    if ( 0 != str.length() )
    {
      *winout << str << endl;
          //Put out IDAPI err msg (if avail.) just prior to specific tdbf err msg
    }
    if ( 0 < excTdbf.ErrMsg().length() )
    {
      *winout << excTdbf.ErrMsg() << endl;
          //Put out specific err msg last
    }
    if ( 0 < excTdbf.ErrInfo().length() )
    {
      *winout << excTdbf.ErrInfo() << endl; //Put out specific err msg last
    }
}

