/*
;;heapptr.h             Heap Smart Pointer Template
;;
*/
//
//
//  This is the source code from FAQ-460, found in chapter 41 of "C++ FAQs."
//  Copyright (C) 1994, Addison-Wesley Publishers, Inc.; All rights reserved.
//
//  The book, "C++ FAQs" is by Marshall P. Cline and Greg A. Lomow,
//  Copyright (C) 1994, Addison-Wesley Publishers, Inc.; All rights reserved.
//
//  This code is presented for its instructional value.  It has been tested with
//  care, but it is not guaranteed for any particular purpose.  Neither the
//  publisher nor the authors offer any warranties or representations, nor do
//  they accept any liabilities with respect to this code.

#ifndef __HEAPPTR_H__
#define __HEAPPTR_H__

#include <stdlib.h>
#include <assert.h>

/*
;;template<class T>
;;class THeapPtr
;;
;;  Automatic clean up of dynamically allocated object of type T
;;
;;  Accepts a pointer to a dyamically allocated object, which is dynamically
;;    deallocated ('deleted') by THeapPtr destructor
;;
*/
template<class T>
class THeapPtr
{
public:

  THeapPtr(T* ptr=NULL)  : ptr_(ptr) { }
 ~THeapPtr()             { deallocate(); }
  void deallocate()     { delete ptr_; ptr_ = NULL; }
  THeapPtr<T>& operator= (T* ptr)
    { deallocate(); ptr_ = ptr; return *this; }

  T* operator-> ()   { assert(ptr_ != NULL); return ptr_; }
  T& operator* ()    { assert(ptr_ != NULL); return *ptr_; }

  T* relinquishOwnership()
    { T* old = ptr_; ptr_ = NULL; return old; }
  bool isEmpty()
    { return (ptr_==NULL) ? true : false ; };

private:
  T* ptr_;
  THeapPtr<T>& operator= (const THeapPtr<T>&); //  unimplemented
  THeapPtr               (const THeapPtr<T>&); //  unimplemented
};

/*
;;template<class T>
;;class THeapPtrArray
;;
;;  Automatic clean up of dynamically allocated array of objects of type T
;;
;;  Accepts a pointer to a dyamically allocated object, which is dynamically
;;    deallocated ('deleted') by THeapPtr destructor
;;
*/
template<class T>
class THeapPtrArray
{
public:

  THeapPtrArray(T* ptr=NULL)  : ptr_(ptr) { }
 ~THeapPtrArray()             { deallocate(); }
  void deallocate()     { delete [] ptr_; ptr_ = NULL; }
  THeapPtrArray<T>& operator= (T* ptr)
    { deallocate(); ptr_ = ptr; return *this; }

#if 0
  T* operator-> ()   { assert(ptr_ != NULL); return ptr_; }
  T& operator* ()    { assert(ptr_ != NULL); return *ptr_; }
#else
  T& operator []( UINT16 ix ) const
                {
                  return ( *( ptr_ + ix ) );
                }
  T& operator []( UINT16 ix )
                {
                  return ( *( ptr_ + ix ) );
                }
#endif//0
  T* relinquishOwnership()
    { T* old = ptr_; ptr_ = NULL; return old; }
  bool isEmpty()
    { return (ptr_==NULL) ? true : false ; };

private:
  T* ptr_;
  THeapPtrArray<T>& operator= (const THeapPtrArray<T>&); //  unimplemented
  THeapPtrArray               (const THeapPtrArray<T>&); //  unimplemented
};

/*
;;class
;;TBuffer
;;
;;  Accepts a pointer to a dyamically allocated object, which is dynamically
;;    deallocated ('deleted') by TBuffer destructor
;;
*/
class
TBuffer
{
public:
    TBuffer( char * buf=NULL) : ptr_(buf) {};
   ~TBuffer()                 { deallocate(); };
    void deallocate()        { delete [] ptr_; ptr_ = NULL; };
    TBuffer &  operator = ( char * buf )
      { deallocate(); ptr_ = buf; return *this; };

    operator const char * ()
      { return ptr_; };
    char * relinquishOwnership()
      { char * old = ptr_; ptr_ = NULL; return old; }

private:
  char * ptr_;
  TBuffer & operator= (const TBuffer &); //  unimplemented
  TBuffer             (const TBuffer &); //  unimplemented
};
#endif//__HEAPPTR_H__

