/**********************************************************************
**
**                         BSTATMNT.CPP
**
** Member functions of the BStatement class.  
**
**********************************************************************/

// DBF - (C) Copyright 1994 by Borland International

#include "kdbf.h"
#pragma hdrstop

BStatement::BStatement(BDatabase *db)
{
    stmtDb = db;
    isOpen = FALSE;
    hStmt = 0;
    lastError = DBIERR_NONE;
}

BStatement::~BStatement()
{
    close();
}

Retcode BStatement::close(void)
{
    if (!isOpen)
    {
        return (lastError = PXERR_STATEMENTNOTOPEN);
    }

    if (hStmt)
    {
        lastError = DbiQFree(&hStmt);
    }

    hStmt = 0;
    isOpen = FALSE;

    return lastError;
}

Retcode BStatement::open(const char *QryString,
                         DBIQryLang QryLang)
{
    if (isOpen)
    {
        return (lastError = PXERR_STATEMENTOPEN);
    }

    lastError = DbiQPrepare(stmtDb->hDb, QryLang, (pCHAR)QryString, &hStmt);
    if (lastError)
    {
        hStmt = 0;
        return lastError;
    }

    isOpen = TRUE;

    return lastError;
}

Retcode BStatement::execute(BCursor &answer)
{
    TABLEHANDLE tabH = 0;

    if (!isOpen)
    {
        return (lastError = PXERR_STATEMENTNOTOPEN);
    }

    lastError = DbiQExec(hStmt, &tabH);
    if (lastError)
    {
        return lastError;
    }

    // Check if a Table Handle was returned (not returned for all
    //  queries, such as inserts.
    if (tabH)
    {
        lastError = answer.attach(stmtDb, tabH);
        DbiCloseCursor(&tabH);
    }

    return lastError;
}

Retcode BStatement::setProp(UINT32 prop, UINT32 value)
{
    if (!isOpen)
    {
        lastError = PXERR_STATEMENTNOTOPEN;
        return lastError;
    }

    lastError = DbiSetProp((hDBIObj)hStmt, prop, value);

    return lastError;
}

Retcode BStatement::setLive(LIVENESS live)
{
    if (!isOpen)
    {
        lastError = PXERR_STATEMENTNOTOPEN;
        return lastError;
    }

    lastError = DbiSetProp((hDBIObj)hStmt, stmtLIVENESS, live);

    return lastError;
}

Retcode BStatement::getProp(UINT32 prop, pVOID value, UINT16 maxLen,
                            UINT16 &retLen)
{
    if (!isOpen)
    {
        lastError = PXERR_STATEMENTNOTOPEN;
        return lastError;
    }

    lastError = DbiGetProp((hDBIObj)hStmt, prop, value, maxLen, &retLen);

    return lastError;
}

Retcode BStatement::setParameters(UINT16 numFields, pFLDDesc fldDescs,
                                  pBYTE recBuf)
{
    if (!isOpen)
    {
        lastError = PXERR_STATEMENTNOTOPEN;
        return lastError;
    }

    lastError = DbiQSetParams(hStmt, numFields, fldDescs, recBuf);

    return lastError;
}                                                               

hDBIStmt BStatement::getHandle(void)
{
    if (!isOpen)
    {
        lastError = PXERR_STATEMENTNOTOPEN;
        return 0;
    }

    lastError = DBIERR_NONE;
    
    return hStmt;
}

char * BStatement::nameOf() const
{
    return("BStatement");
}

void BStatement::printOn(ostream& os)
{
    os << nameOf()
       << "Open Status = "
       << (int) isOpen << endl;
}

