/*********************************************************************
**
**                          BDBOBJECT.H
**
** This file contains the definitions of the interface for the BDbObject
** class. This Abstract class is the root of all Database Framework
** classes and defines basic routines for object identification and 
** printing.    
**
*********************************************************************/

// DBF - (C) Copyright 1994 by Borland International

#ifndef BDBOBJECT_H
#define BDBOBJECT_H

#include "envdef.h"
#include <iostream.h>

class BDbObject {

public:

  // Pure virtual function that returns the name of the class.

  virtual char *nameOf() const = 0;

  // Pure virtual function that defines a basic printing routine. 

  virtual void printOn( ostream& os) = 0;

  friend ostream& operator << ( ostream&, const BDbObject& );
};

inline ostream& operator << ( ostream& out, BDbObject& obj )
{
    obj.printOn(out);
    return out;
}

#endif

