/* keydemo.c
 * Taken from 'The compleat keyboard: Retrieving Scan codes and extended
 * keys' by Richard Hale Shaw as published in 'Inside Turbo C', Special
 * Issue, The Cobb Group.
 * Demonstrate use of keyboard routines in TCKEY.C
*/

#include      <conio.h>
#include      <stdio.h>
#include      <dos.h>
#include      <ctype.h>
#include      "tckey.h"

#define CURSOR_OFF      0
#define CURSOR_ON       1
#define MSGCOL          10
#define VCOL            34
#define CROW            3

/* display control */
#define RIGHTSHIFTROW   6
#define LEFTSHIFTROW     	(RIGHTSHIFTROW+1)
#define CTRLKEYROW              (RIGHTSHIFTROW+2)
#define ALTKEYROW       	(RIGHTSHIFTROW+3)
#define SCROLLLOCKTOGGLEROW    	(RIGHTSHIFTROW+4)
#define NUMTOGGLEROW     	(RIGHTSHIFTROW+5)
#define CAPSTOGGLEROW     	(RIGHTSHIFTROW+6)
#define INSERTTOGGLEROW     	(RIGHTSHIFTROW+7)

/* Enhanced Keyboard Message positions: */
#define LEFTCTRLKEYROW     	(RIGHTSHIFTROW+8)
#define LEFTALTKEYROW       	(RIGHTSHIFTROW+9)
#define RIGHTCTRLKEYROW     	(RIGHTSHIFTROW+10)
#define RIGHTALTKEYROW       	(RIGHTSHIFTROW+11)
#define SCROLLLOCKROW     	(RIGHTSHIFTROW+12)
#define NUMLOCKROW      	(RIGHTSHIFTROW+13)
#define CAPSLOCKROW     	(RIGHTSHIFTROW+14)
#define SYSREQROW       	(RIGHTSHIFTROW+15)


void main(int argc, char **argv);
void cdecl atsay(unsigned row, unsigned col, char *fmt, ...);
void Cursor(int on_off);

void main(int argc, char **argv)
	{
	unsigned c, flags, enhancedkbd = FALSE;
	char *dn = "DOWN", *up = "UP  ",*on = "ON ", *off = "OFF";
 	if(argc > 1)				/* check for -E option */
		{
		argv++;
		if (((**argv) == '-') && (toupper(argv[0][1]) == 'E'))
			{
			enhancedkbd = TRUE;
			KbdEnhanced(TRUE);
			}
		}

clrscr();					   /* clear the screen */
Cursor(CURSOR_OFF);				/* turn off the cursor */
atsay(0, MSGCOL,"Press 'END' at any time to terminate "
	 "Program.");
atsay(2, MSGCOL,"    KbdCharIn returned:");
atsay(CROW,MSGCOL, "   Printable key value:");
atsay(4,MSGCOL, "Scan code for this key:");

atsay(RIGHTSHIFTROW,MSGCOL,       "    Right Shift Key is:");
atsay(LEFTSHIFTROW,MSGCOL,        "     Left Shift Key is:");
atsay(CTRLKEYROW,MSGCOL,          "    either Ctrl Key is:");
atsay(ALTKEYROW,MSGCOL,           "     either Alt Key is:");
atsay(SCROLLLOCKTOGGLEROW,MSGCOL, " Scroll Lock Toggle is:");
atsay(NUMTOGGLEROW,MSGCOL,        "    Num Lock Toggle is:");
atsay(CAPSTOGGLEROW,MSGCOL,       "   Caps Lock Toggle is:");
atsay(INSERTTOGGLEROW,MSGCOL,     "      Insert Toggle is:");

if(enhancedkbd)					/* if enhanced keyboard */
	{
atsay(LEFTCTRLKEYROW,MSGCOL,      "      Left Ctrl Key is:");
atsay(LEFTALTKEYROW,MSGCOL,       "       Left Alt Key is:");
atsay(RIGHTCTRLKEYROW,MSGCOL,     "     Right Ctrl Key is:");
atsay(RIGHTALTKEYROW,MSGCOL,      "      Right Alt Key is:");
atsay(SCROLLLOCKROW,MSGCOL,       "    Scroll Lock Key is:");
atsay(NUMLOCKROW,MSGCOL,          "       Num Lock Key is:");
atsay(CAPSLOCKROW,MSGCOL,         "      Caps Lock Key is:");
atsay(INSERTTOGGLEROW,MSGCOL,     "      Insert Toggle is:");
	}
while(TRUE)
	{			      /* wait for key, get char, flags */
	KbdCharIn(&c, &flags, TRUE);
	atsay(2,VCOL,"%05u (0x%04x)",c,c);
	atsay(CROW,VCOL,"%c       (0x%02x)",
		(KbdChar(c) ? KbdChar(c) : ' '), KbdChar(c));
	atsay(4,VCOL,"%3d     (0x%02x)", KbdNoScan(c), KbdNoScan(c));

	atsay(RIGHTSHIFTROW,VCOL,"%s",(RightShift(flags) ? dn : up));
	atsay(LEFTSHIFTROW,VCOL,"%s",(LeftShift(flags) ? dn : up));
	atsay(CTRLKEYROW,VCOL,"%s",(CtrlKey(flags) ? dn : up));
	atsay(ALTKEYROW,VCOL,"%s",(AltKey(flags) ? dn : up));
	atsay(SCROLLLOCKTOGGLEROW,VCOL,"%s",(ScrollLockToggle(flags)
		? on : off));
	atsay(NUMTOGGLEROW,VCOL,"%s",(NumLockToggle(flags)
		? on : off));
	atsay(CAPSTOGGLEROW,VCOL,"%s",(CapsLockToggle(flags)
		? on : off));
	atsay(INSERTTOGGLEROW,VCOL,"%s",(InsertToggle(flags)
		? on : off));

	if (enhancedkbd)
		{
		atsay(LEFTCTRLKEYROW,VCOL,"%s",(LeftCtrlKey(flags)
			 ? dn : up));
		atsay(LEFTALTKEYROW,VCOL,"%s",(LeftAltKey(flags)
			 ? dn : up));
		atsay(RIGHTCTRLKEYROW,VCOL,"%s",(RightCtrlKey(flags)
			 ? dn : up));
		atsay(RIGHTALTKEYROW,VCOL,"%s",(RightAltKey(flags)
			 ? dn : up));
		atsay(SCROLLLOCKROW,VCOL,"%s",(Scroll(flags)
			 ? dn : up));
		atsay(NUMLOCKROW,VCOL,"%s",(NumLock(flags)
			 ? dn : up));
		atsay(CAPSLOCKROW,VCOL,"%s",(CapsLock(flags)
			 ? dn : up));
		}

	switch(KbdScan(c))
		{
		case HOME:
			atsay(CROW,VCOL,"Home ");
			break;
		case END:
			atsay(CROW,VCOL,"End  ");
			break;
		case PGUP:
			atsay(CROW,VCOL,"PgUp ");
			break;
		case PGDN:
			atsay(CROW,VCOL,"PgDn ");
			break;
		case UPARROW:
			atsay(CROW,VCOL,"Up   ");
			break;
		case DOWNARROW:
			atsay(CROW,VCOL,"Down ");
			break;
		case LEFTARROW:
			atsay(CROW,VCOL,"Left ");
			break;
		case RIGHTARROW:
			atsay(CROW,VCOL,"Right");
			break;
		case F1:
			atsay(CROW,VCOL,"F1   ");
			break;
		case F2:
			atsay(CROW,VCOL,"F2   ");
			break;
		case F3:
			atsay(CROW,VCOL,"F3   ");
			break;
		case F4:
			atsay(CROW,VCOL,"F4   ");
			break;
		case F5:
			atsay(CROW,VCOL,"F5   ");
			break;
		case F6:
			atsay(CROW,VCOL,"F6   ");
			break;
		case F7:
			atsay(CROW,VCOL,"F7   ");
			break;
		case F8:
			atsay(CROW,VCOL,"F8   ");
			break;
		case F9:
			atsay(CROW,VCOL,"F9   ");
			break;
		case F10:
			atsay(CROW,VCOL,"F10  ");
			break;
		case F11:
			atsay(CROW,VCOL,"F11  ");
			break;
		case F12:
			atsay(CROW,VCOL,"F12  ");
			break;
		}
	if(c == END)
		break;
	}
Cursor(CURSOR_ON);				      /* turn on cursor */
clrscr();					    /* clear the screen */
}
				  /* printf with row/column positioning */
void cdecl atsay(unsigned row, unsigned col, char *fmt, ...)
	{
	char workbuffer[250];
	va_list argptr;
	gotoxy(col+1, row+1);			     /* position cursor */
	va_start(argptr, fmt);
	vsprintf(workbuffer, fmt, argptr);
	va_end(arg_ptr);
	puts(workbuffer);
	}

					     /* save and restore cursor */
#define VIDEOINT      0X10
void Cursor(int on_off)
	{
	static unsigned old_cursor = 0;
	if(on_off == CURSOR_OFF)
		{
		_AH = 3;			    /* get cursor info */
		geninterrupt(VIDEOINT);
		old_cursor = _CX;
		_CH = 0x20;
		_AH = 1;			    /* turn off cursor */
		geninterrupt(VIDEOINT);
		}
	else
		{
		_AH = 1;			     /* restore cursor */
		_CX = old_cursor;
		geninterrupt(VIDEOINT);
		}
	}


