/***************************************************************************
**                                                                        **
**  Module :  strfile.cpp                                                 **
**                                                                        **
**  Author :  David J. Yazel                                              **
**                                                                        **
**  Notice :  Copyright (c) 1992, Tracking Technologies, Inc,             **
**                                                                        **
**            All source code contained within this file is released      **
**            into the public domain for use in personal and professional **
**            projects.  Sale of this source code, in portion or whole,   **
**            without prior, written permission from Tracking             **
**            Technologies, Inc. is strictly prohibited.                  **
**                                                                        **
**  Notes  :                                                              **
**                                                                        **
****************************************************************************/

#include <stdio.h>
#include <stdlib.h>

#include "strings.h"
#include "strfile.h"

/*
 _____________________________________________________________________
[                                                                     ]
[ Name         > open()                                               ]
[ Object Type  > member function of StringFile                        ]
[ Date         > June 1992                                            ]
[ Notice       > Copyright (c) 1992 by Tracking Technologies, Inc.    ]
[ Notes        > Opens the string file in the mode specified, returns ]
[              > True if successful.                                  ]
[_____________________________________________________________________]
*/

Bool StringFile::open(String filename, Word mode )
{
   String strmode;

   switch (mode) {
      case READ_FILE   : strmode = "rt"; break;
      case WRITE_FILE  : strmode = "wt"; break;
      case APPEND_FILE : strmode = "at"; break;
   }
   stream = fopen(filename,strmode);
   if (stream) return True;
   else return False;
}

/*
 _____________________________________________________________________
[                                                                     ]
[ Name         > StringFile()                                         ]
[ Object Type  > Constructor for StringFile class                     ]
[ Date         > June 1992                                            ]
[ Notice       > Copyright (c) 1992 by Tracking Technologies, Inc.    ]
[ Notes        > Initializes the string file to closed.               ]
[_____________________________________________________________________]
*/

StringFile::StringFile()
{
   stream = NULL;
}

/*
 _____________________________________________________________________
[                                                                     ]
[ Name         > close()                                              ]
[ Object Type  > Member function of StringFile                        ]
[ Date         > June 1992                                            ]
[ Notice       > Copyright (c) 1992 by Tracking Technologies, Inc.    ]
[ Notes        > If the file is open then it is closed.  The file     ]
[              > can then be reopened by a open() call.               ]
[_____________________________________________________________________]
*/

void StringFile::close()
{
   if (stream) {
      fclose(stream);
      stream = NULL;
   }
}

/*
 _____________________________________________________________________
[                                                                     ]
[ Name         > StringFile()                                         ]
[ Object Type  > Constructor for class StringFile                     ]
[ Date         > June 1992                                            ]
[ Notice       > Copyright (c) 1992 by Tracking Technologies, Inc.    ]
[ Notes        > This constructor opens the specified file in the     ]
[              > specified mode.                                      ]
[_____________________________________________________________________]
*/

StringFile::StringFile(String filename, Word mode )
{
   open(filename,mode);
}

/*
 _____________________________________________________________________
[                                                                     ]
[ Name         > write()                                              ]
[ Object Type  > Member function of class StringFile                  ]
[ Date         > June 1992                                            ]
[ Notice       > Copyright (c) 1992 by Tracking Technologies, Inc.    ]
[ Notes        > Writes the specified string to the string file.      ]
[_____________________________________________________________________]
*/

void StringFile::write( String str )
{
   fputs( str, stream );
}

/*
 _____________________________________________________________________
[                                                                     ]
[ Name         > IsOpen()                                             ]
[ Object Type  > Member function of class StringFile                  ]
[ Date         > June 1992                                            ]
[ Notice       > Copyright (c) 1992 by Tracking Technologies, Inc.    ]
[ Notes        > Returns True if the string file is open and False    ]
[              > if it is not.                                        ]
[_____________________________________________________________________]
*/

Bool StringFile::IsOpen()
{
   if (stream) return True;
   else return False;
}

/*
 _____________________________________________________________________
[                                                                     ]
[ Name         > read()                                               ]
[ Object Type  > Member function of class StringFile                  ]
[ Date         > June 1992                                            ]
[ Notice       > Copyright (c) 1992 by Tracking Technologies, Inc.    ]
[ Notes        > Reads a single line from the string file no bigger   ]
[              > then 200 characters.                                 ]
[_____________________________________________________________________]
*/

String StringFile::read()
{
   char buffer[200];
   return fgets(buffer,200,stream);
}

/*
 _____________________________________________________________________
[                                                                     ]
[ Name         > eof()                                                ]
[ Object Type  > Member function of class StringFile                  ]
[ Date         > June 1992                                            ]
[ Notice       > Copyright (c) 1992 by Tracking Technologies, Inc.    ]
[ Notes        > Returns True if the file is at an end.               ]
[_____________________________________________________________________]
*/

Bool StringFile::eof()
{
   if (feof(stream)) return True;
   else return False;
}

/*
 _____________________________________________________________________
[                                                                     ]
[ Name         > ~StringFile()                                        ]
[ Object Type  > Destructor for class StringFile                      ]
[ Date         > June 1992                                            ]
[ Notice       > Copyright (c) 1992 by Tracking Technologies, Inc.    ]
[ Notes        > Closes the file if it is open.                       ]
[_____________________________________________________________________]
*/

StringFile::~StringFile()
{
   if (stream) fclose(stream);
}
