/*\t*******************************************************************
   Filename  ...........  SPLASHTS.CPP
   Project .............  Windows Support
   Author  .............  Matthew J. W. Ratcliff
   Language  ...........  C++
   Operating System  ...  Windows
   Function:    Splash class test program.  Will display a
        SPLASH bitmap screen while loading the NOTEPAD
        editor, as an example, then delete the SPLASH screen
        and terminate itself.

  (c) Ratware Softworks 1995 - Matthew J. W. Ratcliff - Free to use in your
  applications if this copyright notice remains in the source code.
 **\t******************************************************************/

/*\r********************** Revision History ****************************
   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
21-Jan-94  MJWR         Build code to test Splash.cpp.

**\r*/

/*\i******************** System Include Files *************************/
#include <windows.h>

/********************** Constant Include Files ************************/
#include "portable.h"

/***************** External Procedure Include Files *******************/
#include "splash.h"

/*\i*/

/*\p********************************************************************
**                                                                    **
    NAME:  WinMain

    PURPOSE:  to launch an application with a Splash screen.
      Tests Splash class in Splash.cpp.

**Matthew J. W. Ratcliff                                              **
**\p*******************************************************************/

int PASCAL WinMain( HANDLE pasHinstance,
                    HANDLE pasHprevInstance,
                    LPSTR  pasLpszCmdLine,
                    int    pasNcmdShow )
{
/*********** Local Constant & Variable Declarations *******************/
Splash          *splSplash;
int              splResult;

/************************* Procedure Body *****************************/
splSplash = new Splash( pasHinstance,
                        pasHprevInstance,
                        pasLpszCmdLine,
                        pasNcmdShow );

splResult = splSplash->Launch( 8000, // show for 4 seconds
                               "notepad.exe", // run notepad editor
                               FALSE ); // Don't extract path

LIMDEL(splSplash);
return( splResult );
} /* WinMain end */
