/*\t*******************************************************************
   Filename  ...........  SPLASH.H
   Project .............  Windows Support
   Author  .............  Matthew J. W. Ratcliff
   Language  ...........  C++
   Operating System  ...  Windows
   Function:    Prototype for SPLASH class.
     User implements WinMain by calling the Splash constructor.
     Then the user calls Splash.Launch() to execute the splash
     display and then execute the application it was supposed
     to LAUNCH.


  (c) Ratware Softworks 1995 - Matthew J. W. Ratcliff - Free to use in your
  applications if this copyright notice remains in the source code.
 **\t******************************************************************/

/*\r********************** Revision History ****************************
   Date    By           Change Description
dd-mmm-yy  nnn          text
---------  ----         -----------------------------------------------
21-Jan-94  MJWR         Design SPLASH application class.  Portable
                        to Borland or Microsoft compilers.  C++ code.
**\r*/
#ifndef _SPLASH_H_
#define _SPLASH_H_

/*\m******************** Include Requirements *************************
* List of files which must be included BEFORE this file can be included:
* #include <windows.h>
*/

/*\m******************** Definitions **********************************/

/*\p********************************************************************
**                                                                    **
    NAME:  Splash_class

    PURPOSE:  to display the "SPLASH" bitmap and then launch
      the specified application.
**                                                                    **
**\p*******************************************************************/

class  Splash

{
/********************** public declarations ***************************/
public:
        Splash ( HINSTANCE       pasHinst,
                 HINSTANCE       pasPrevHinstance,
                 LPSTR           pasLpCmdLine,
                 int             pasNcmdShow );

        ~Splash ();

        int Launch( int             pasShowTime, // Show time in milliseconds
                    const char     *pasAppName,   // Application name to run
                    BOOL            pasExtractAppPath=TRUE);

        /******************************************************************/
        // pasExtractAppPath - if TRUE then the path to the application
        // in pasAppName (this will be the full path to the launcher
        // program itself) is extracted and prepended to pasAppName before
        // passing it on to WinExec.  Why?  It is SAFE to assume you
        // know the NAME of the application you wish to run, but not
        // neccessarily the path to it.  However, it is also safe to
        // assume that the Splash launcher program and the application
        // you wish to execute reside in the same directory.  If these
        // assumptions are safe, use pasExtractPath default of TRUE. If
        // not (say you set working directory in attributes of icon in
        // app mananger) then set pasExtractAppPath to false.
        /******************************************************************/
}; /* Splash end class */
/*\m****************** END Definitions ********************************/
#endif

