/*\t*******************************************************************/
/*    Filename  ...........  portable.h                               */
/*    Project .............  Library                                  */
/*    Function:                                                       */
/*       Common type declarations and definitions,                    */
/*       for portability and reusability consideraitions.             */

/*
  (c) Ratware Softworks 1995 - Matthew J. W. Ratcliff - Free to use in your
  applications if this copyright notice remains in the source code.
*/
/*\t*******************************************************************/

/**********************************************************************/
/*                             Definitions                            */
/**********************************************************************/

#ifndef _PORTABLE_H_
#define _PORTABLE_H_

typedef  unsigned short     BOOLEAN_;
typedef  unsigned char      BITS;
typedef  char               CHAR;

// Character pointer, 'far' modifier
// for IBM PC's so they are stuck
// in separate segments, not in
// automatic data segment along with
// the stack.

#define CHARPTR char *

typedef  signed char        INT8;

/**** 'ifdef' and 'ifndef' only work
* on #define's, they don't work on typedef.
* So we use a separate #define to indicate
* that a particular type has been
* defined
*/

#ifndef INT16_DEF
#define INT16_DEF
typedef short               INT16;
#endif

#ifndef INT32_DEF
#define INT32_DEF
typedef  long int           INT32;
#endif

typedef  unsigned int       UINT;
typedef  unsigned char      UINT8;
typedef  unsigned int       UINT16;
typedef  unsigned long int  UINT32;
typedef  float              FLOAT32;
typedef  double             FLOAT64;
typedef  int                INT;
typedef  void               VOID_RTN;

#define  FALSE_             (0)
#define  TRUE_              (1)

#define  GLOBAL

enum STAT { SUCCEEDED_ = 1,
            FAILED_    = -1 };

typedef enum STAT STAT_TYPE;

/****************************************
* STAT_TYPE is the commonly used error
* (or status) return type. However,
* some older software used the two
* definitions below. Accomodate them too.
*/

#define STAT_TY     STAT_TYPE
#define STATUS_TYPE STAT_TYPE

#define  RET_CODE_TY        INT32
#define  RET_CODE_TYPE      INT32

#define VOID_TYPE         void

/******************************************
* C++ Support macros
*/

#define LIMDEL(A)  if (A) { delete A; A = NULL; }
#define LIMDELA(A) if (A) { delete [] A; A = NULL; }

#endif
