/*
 * TIMERTST.C
 * Example program using RTCHDW functions.
 *
 * Sample MAKE file:
 *
 * .c.obj:
 *    bcc -c $<
 *
 * timertst.exe: timertst.obj rtchdw.obj
 *    bcc timertst.obj rtchdw.obj
 */
#include <stdio.h>
#include <bios.h>
#include "rtc.h"

static volatile unsigned long TickCount = 0;
static volatile int SecCount = 0;
static volatile unsigned int MinCount = 0;
static volatile int Tick = 0;

/* Periodic ISR simply increments tick counter */
void far MyPeriodicISR (void) {
    TickCount++;
}

/*
 * Update ISR increments second count and
 * sets the tick flag
 */
void far MyUpdateISR (void) {
    SecCount++;
    Tick = 1;
}

/*
 * Alarm ISR increments minute count, clears second
 * count and sets the tick flag.
 */
void far MyAlarmISR (void) {
    MinCount++;
    SecCount = 0;
    Tick = 1;
}

/*
 * Enable a 4.096 KHz timer, the update interrupt
 * and a once-per-minute alarm ISR.
 * Each second, display the elapsed time and the
 * total number of timer ticks.
 */
void main (void) {
    struct RTCTIME Time = {0xff, 0xff, 0, 0};

    SetAlarmInt (&Time, MyAlarmISR);
    SetUpdateInt (MyUpdateISR);
    SetPeriodicInt (4, MyPeriodicISR);
    EnableRTCint (PIE+UIE+AIE);
    TimerOn ();
    do {                /* do until key pressed */
        if (Tick) {
            Tick = 0;
            printf ("%02d:%02d  Tick count = %ld\n",
                    MinCount, SecCount, TickCount);
        }
    } while (!bioskey (1));
    TimerOff ();
    ResetRTCint (PIE+UIE+AIE);
    bioskey (0);        /* read keyboard buffer */
}
