/* Driver for routine EVLMEM */

#include <stdio.h>
#include "nr.h"
#include "nrutil.h"

#define N 1000
#define M 10
#define NFDT 16

main()
{
	int i;
	float fdt,pm,*cof,*data;
	FILE *fp;

	cof=vector(1,M);
	data=vector(1,N);
	if ((fp = fopen("spctrl.dat","r")) == NULL)
		nrerror("Data file SPCTRL.DAT not found\n");
	for (i=1;i<=N;i++) fscanf(fp,"%f",&data[i]);
	fclose(fp);
	memcof(data,N,M,&pm,cof);
	printf("Power spectum estimate of data in SPCTRL.DAT\n");
	printf("     f*delta      power\n");
	for (fdt=0.0;fdt<=0.5;fdt += 0.5/NFDT)
		printf("%12.6f %12.6f\n",fdt,evlmem(fdt,cof,M,pm));
	free_vector(data,1,N);
	free_vector(cof,1,M);
}
