
//   Function to get an alphabetically sorted listing of available   //
//   drives, dir's, and files using dynamically allocated memory.    //
//   Files can be sorted by name or extension by setting sortorder   //
//   to 0 for name, or 1 for extension.                              //
//                                                                   //
//   By Jay Lewis,                                                   //
//   Compuserve:  102365,3264  (102365.3264@compuserve.com)          //
//   Alternate mail:  lewisj1@drum-emh1.army.mil                     //
//                                                                   //
//   Please write!                                                   //
//                                                                   //
//   Donated to the public domain.  Free for use.                    //
//   Written in Borland Turbo C++, ver 3.0 on 4 August 1995.         //                                         
//                                                                   //
//   Dedicated to helping the amateur programmer!                    //

// required include files //
#include <dir.h>
#include <dos.h>
#include <fcntl.h>
#include <stdio.h>
#include <dirent.h>
#include <stdlib.h>
#include <string.h>

// to use as string terminator //
#define NUL '\0'
// to chop one character off of a string //
#define LAST_CHAR(str) (str)[strlen(str) - 1]

// function declarations //
void read_dir(void); // function to read and store the list //
int sort_function(const void *a, const void *b); // function to sort //

   // global definitions //
   int i, dirnum;        // loop control integers //
   int sortorder;        // sort by name(0), or extension(1) //
   char **array;         // array of pointers to character pointers //

void read_dir(void)
{
   int save, disk;            // disk getting contol integers //
   unsigned attrib;           // for _dos_getfileattr() //
   DIR *directory;            // name of the directory //
   struct dirent *ent;        // structure to hold directory entries //
   char buffer[MAXPATH];      // to hold current directory name //
   char temp[15], string[15]; // for prep and fix during extension sort //

   // zero the entry counter //
   dirnum=0;

   // start disk drive scan //
   save = getdisk(); // save current disk drive for reset when done //
   for (disk=0; disk<26; ++disk) // for drives a thru z //
   { setdisk(disk); // try to set disk //
     if (disk == getdisk()) // if disk exists //
     { sprintf(array[dirnum], "a[-%c-]", disk + 'A'); // copy into array //
			    //  start with "a" to aid sorting later //
       dirnum++; // increment counter //
      }
    } setdisk(save); // set back to original disk //

   // start directory and file scan //
   if ((directory = opendir(getcwd(buffer, MAXPATH))) == NULL) // open //
   { perror("Unable to open directory");
     exit(1);
    }

   while ((ent = readdir(directory)) != NULL) // read current directory //
   { if(strcmp(ent->d_name,".") != 0) // skip parent directory (my choice) //
     { _dos_getfileattr(ent->d_name,&attrib); // get file attributes //
       if(attrib & _A_SUBDIR || strcmp(ent->d_name,"..")==0) // if it is a subdirectory //
       { sprintf(array[dirnum], "b%s\\", ent->d_name);
	 dirnum++;            //  start with "b" to aid sorting later //
	}
       else            // not system or hidden files //
       { if(!(attrib & _A_HIDDEN || attrib & _A_SYSTEM))
	 { sprintf(array[dirnum], "c%s", ent->d_name);
	   dirnum++;            //  start with "c" to aid sorting later //
	  }
	}
      }
    }
   closedir(directory); // close directory //

   // if sort by extension is requested, prepare entries by //
   // changing from cfname.ext to cext.cfname //
   if(sortorder==1) // if sort by extension is requested //
   { for(i=0; i<dirnum; i++)
     { if(array[i][0] == 'c')
       { char *dot = strchr(array[i], '.');
	 if(dot) // if file has an extension //
	 { // prep for extension sort //
	   strcpy(string, array[i]);
	   char *ext = strchr(string, '.');
	   if(ext)
	   ext++;
	   strncpy(temp, string, ext-string-1);
	   temp[ext-string-1] = NUL;
	   sprintf(array[i], "c%s.%s", ext, temp);
	  }
	 else // if file has no extension put a space as the extension //
	 { strcpy(temp, array[i]);
	   sprintf(array[i], "c .%s", temp);
	  } // no extension files now guaranteed to be first after sort //
	}
      }
    }

   // alhabetical sort by filename or extension as per request. //
   // always a's (drives), then b's (directories), then c's (files) //
   qsort((void *)array, dirnum, sizeof(array[0]), sort_function);

   // if sorted by extension, fix prepared entries by //
   // changing back from cext.cfname to cfname.ext //
   if(sortorder==1) // if sort by extension was requested //
   { for(i=0; i<dirnum; i++)
     { if(array[i][0] == 'c')
       { char *dot = strchr(array[i], '.');
	 if(dot)
	 { if(array[i][1] != ' ') // if file had an extension //
	   { strrev(array[i]);
	     LAST_CHAR(array[i]) = NUL;
	     char *ext = strchr(array[i], '.');
	     if(ext)
	     ext++;
	     strncpy(temp, array[i], ext-array[i]-1);
	     temp[ext-array[i]-1] = NUL;
	     sprintf(array[i], "%s.%s", strrev(temp), strrev(ext));
	    }
	   else // if file had no extension remove the sort aid space //
	   { strrev(array[i]);
	     strncpy(temp, array[i], strlen(array[i])-3);
	     temp[strlen(array[i])-3] = NUL;
	     sprintf(array[i], "%s", strrev(temp));
	    }
	  }
	}
      }
    }

   // remove sorting aids (a's, b's and c's) //
   for(i=0; i<=dirnum; i++)
   { strrev(array[i]); // turn it around backwards //
     LAST_CHAR(array[i]) = NUL; // wipe off sorting aid character //
     strrev(array[i]); // turn it back around forwards //
    }

   // You now have a sorted listing with drives, dir's, then files.    //
   // The entries are character strings so further processing is easy. //
   // Now you can do what ever you want to display the array to user.  //

   // drives look like:          [-A-]         //
   // directories look like:     TEMP\         //
   // files look like:           README.TXT    //
 }
int sort_function(const void *a, const void *b) // example from B TC 3.0 //
{  // modified to sort a list of pointers to string pointers //
   return strcmp(*(char **)a, *(char **)b);
}
// small demo program //
int main(int argc, char *argv[])
{
   // test command line arguments //
   if(argc < 2)
   { printf("\nUsage:  readdir [/n] [/e]");
     printf("\nWhere /n = sort by name or /e = sort by extension.");
     printf("\nExample:  readdir /e  (sort files by extension)\n");
     exit(1);
    }

   // dynamically allocate storage for 1001 pointers to string pointers //
   array=(char **)calloc(1001,sizeof(char *));

   // allocate for each entry except last to leave array null terminated //
   for(i=0; i<1000; i++)
   array[i]=(char *)calloc(13,sizeof(char));

   // test memory allocation //
   if(array==NULL)
   { printf("Error allocating memory.");
     exit(1);
    }

   // check command line for sort order requested //
   if(strcmp(strupr(argv[1]), "/N") == 0)
   sortorder=0;
   else if(strcmp(strupr(argv[1]), "/E") == 0)
   sortorder=1;
   else
   { printf("\nSyntax error.");
     printf("\nUsage:  readdir [/n] [/e]");
     printf("\nWhere /n = sort by name or /e = sort by extension.");
     printf("\nExample:  readdir /e  (sort files by extension)\n");
     exit(1);
    }

   // perform the read //
   read_dir();

   // show a sample of the results //
   printf("The first 15 entries follow (less if there are not 15):\n\n");
   for(i=0; i<15 ;i++) // change 15 to dirnum to see all entries //
   { if(i==dirnum)
     break;
     printf("%s\n",array[i]);
    }

   // free allocated memory //
   free(array);

   // exit //
   return 0;
 }