// =========================================================
// WIZARD.CPP
//
// Windows95-style wizard property dialog classes for OWL 2
//
// Author:  Steve Saxon (Compuserve: 100321,2355)
// Written: 15th October 1994
// =========================================================

#include <owl\owlpch.h>
#pragma hdrstop

#include <owl\button.h>

#include "wizard.h"
#include "proptab.h"
#include "wizard.rh"

// =========================================================
// TWizardDialog
//
// base class for wizard dialogs (page holder)
// =========================================================

DEFINE_RESPONSE_TABLE1(TWizardDialog, TPropertyDialog)
	EV_BN_CLICKED (IDC_WIZ_BACK, CmSelectPrevious),
	EV_BN_CLICKED (IDC_WIZ_NEXT, CmSelectNext),
END_RESPONSE_TABLE;

TWizardDialog::TWizardDialog (TWindow *pParent, TResId resID, Tab::Style style, TModule *module)
	:	TPropertyDialog (pParent, resID, style | Tab::WizardFrame, module)
{
	bEnableNext = bEnablePrev = TRUE;
}

TWizardDialog::~TWizardDialog ()
{
}

void TWizardDialog::SetupWindow ()
{
	TPropertyDialog::SetupWindow ();

	HWND hwndNext = GetDlgItem (IDC_WIZ_NEXT);

	if (hwndNext != NULL)
	{
		PostMessage (WM_NEXTDLGCTL, (WPARAM) hwndNext, TRUE);
	}

}

BOOL TWizardDialog::SelectNext ()
{
	// only allow next to be selected if we
	// aren't already on the last
	if (bEnableNext)
	{
		return TPropertyDialog::SelectNext ();
	}
	else
	{
		return FALSE;
	}
}

BOOL TWizardDialog::SelectPrevious ()
{
	// only allow previous to be selected if we
	// aren't already on the first
	if (bEnablePrev)
	{
		return TPropertyDialog::SelectPrevious ();
	}
	else
	{
		return FALSE;
	}
}

static BOOL IsLastTab (int nTab, TPropertyDialog& dlg)
{
	while (++nTab < dlg.GetEntryCount ())
	{
		if (dlg.GetPageRef (nTab).IsTabEnabled ())
		{
			return FALSE;
		}
	}

	return TRUE;
}

void TWizardDialog::AfterSelected (int nTab)
{
	// enable navigation buttons as necessary...

	// determine if this is the first enabled button
	BOOL	bFirstTab 	= TRUE;
	int		selId		= 0;

	for (int n = 0; n < nTab; n++)
	{
		if (GetPageRef (n).IsTabEnabled ())
		{
			bFirstTab = FALSE;
			break;
		}

	}

	HWND hwndBackBtn	= GetDlgItem (IDC_WIZ_BACK);
	HWND hwndNextBtn 	= GetDlgItem (IDC_WIZ_NEXT);
	HWND hwndOKBtn 		= GetDlgItem (IDOK);

	if (hwndBackBtn)
	{
		bEnablePrev = !bFirstTab;

		::EnableWindow (hwndBackBtn, bEnablePrev);
	}

	// determine if this is the last enabled button
	BOOL	bLastTab = IsLastTab (nTab, *this);

	if (hwndNextBtn)
	{
		if (!bLastTab)
		{
			SetDefaultId (selId = IDC_WIZ_NEXT);
		}

		bEnableNext = !bLastTab;

		::EnableWindow (GetDlgItem (IDC_WIZ_NEXT), bEnableNext);
	}

	if (hwndOKBtn)
	{
		::EnableWindow (GetDlgItem (IDOK), bLastTab);
	}

	if (bLastTab && hwndOKBtn)
	{
		SetDefaultId (selId = IDOK);
	}

	if (selId)
	{
		PostMessage (WM_NEXTDLGCTL, (WPARAM) GetDlgItem (selId), TRUE);
	}
	else
	{
		pTabs->SelectFirstControl ();
	}
}

// =========================================================
// TWizardPage
//
// base class for wizard pages
// =========================================================

DEFINE_RESPONSE_TABLE1(TWizardPage, TPropertyPage)
	EV_BN_CLICKED (IDC_WIZ_NEXT, CmSelectNext),
END_RESPONSE_TABLE;

TWizardPage::TWizardPage (TResId resID, int idBitmap, TBitmapControl::Style style, TModule *module)
	: TPropertyPage (resID, module)
{
	if (idBitmap)
	{
		bitmap = new TBitmapControl (this, idBitmap, style, module);
	}
	else
	{
		bitmap = NULL;
	}
}

TWizardPage::TWizardPage (TPropertyDialog *parent, TResId resID, int idBitmap, TBitmapControl::Style style, TModule *module)
	: TPropertyPage (parent, resID, module)
{
	if (idBitmap)
	{
		bitmap = new TBitmapControl (this, idBitmap, style, module);
	}
	else
	{
		bitmap = NULL;
	}
}

void TWizardPage::SetupWindow ()
{
	TPropertyPage::SetupWindow ();

	bHadNext = (GetDlgItem (IDC_WIZ_NEXT) != NULL);

	if (!bHadNext)
	{
		TButton* nextButton = new TButton (this, IDC_WIZ_NEXT, "Dummy Next", 0, 0, 60, 30, TRUE);

		nextButton->Attr.Style &= ~WS_VISIBLE;
		nextButton->Create ();
	}
}

void TWizardPage::AfterSelected ()
{
	if (!bHadNext)
	{
		BOOL bLastTab = IsLastTab (ThisTab (), GetPropertyDialog ());

		SetDefaultId (bLastTab ? IDOK : IDC_WIZ_NEXT);
	}
}
