// =========================================================
// PROPDLG.H
// header file for implementation of TPropertyDialog and
// TPropertyPage
// =========================================================
#ifndef __PROPERTY_DIALOGS
#define __PROPERTY_DIALOGS

#include <owl\owlpch.h>
#pragma hdrstop

#include <classlib\arrays.h>

#ifndef USETRANSFERARRAYS
  #define USETRANSFERARRAYS	FALSE
#endif

#define DEFTABWIDTH			64
#define DEFWIDEMARGIN		6

#define CURRENTPAGE			-1

#if defined (BUILDPROPDLGDLL)
  #define PROPDLGEXPORT	__export
#elif defined (PROPDLGDLL)
  #define PROPDLGEXPORT	__import
#else
  #define PROPDLGEXPORT
#endif

#if USETRANSFERARRAYS
  #include "tfarry.h"
#endif

class PROPDLGEXPORT TPropertyTab;
class PROPDLGEXPORT TPropertyPage;
class PROPDLGEXPORT TPropertyDialog;

typedef void (*TPageActionFunc)(TPropertyPage* page, void* param);
typedef BOOL (*TPageCondFunc)(TPropertyPage* page, void* param);

typedef void (TPropertyDialog::*TPageActionMemFunc)(TPropertyPage* page, void* param);
typedef BOOL (TPropertyDialog::*TPageCondMemFunc)(TPropertyPage* page, void* param);

void    CenterWindow (TWindow* wnd);
void	UseSmallFont (HWND HWindow);
BOOL 	DrawMaskedBitmap (HDC hdc, int x, int y, HBITMAP hbm, int XOrigin, int nWidth);

class PROPDLGEXPORT Tab
{

public:
	class PROPDLGEXPORT Style
	{
		DWORD	style;

	public:
		Style ()					{ style = 0x0L; }
		Style (DWORD dwOther)		{ style = dwOther; }

		operator DWORD () const		{ return style; }
	};

	static const Style	SingleHeight;
	static const Style	VariableWidth;
	static const Style	DoubleHeight;
	static const Style	FixedWidth;
	static const Style	ColorActive;
	static const Style	Collapsing;
	static const Style	Justified;
	static const Style	Stacked;
	static const Style	AllowDupPages;
	static const Style	CreateOnDemand;
	static const Style	WideMargins;
	static const Style	AutoTabResize;
	static const Style	ButtonsOnRight;
	static const Style	UseSmallFont;
	static const Style	SaveOnClosePage;
	static const Style	NoMDIClose;
	static const Style	WizardFrame;
	static const Style	UseTabBitmaps;
	static const Style  CenterDialog;
	static const Style  CreateOnDemandAndKeepIt;
	static const Style  FocusOnFirstControl;
};

class PROPDLGEXPORT TPropertyPage : public TDialog
{
	friend	TPropertyDialog;	// allows access to pdlgParent

	int 			nThisTab;

protected:
	TPropertyDialog	*pdlgParent;

	void    		CmOk ();      	// IDOK
	void    		CmCancel ();    // IDCANCEL
	void 			EvSysCommand (UINT cmdType, TPoint& pt);
	BOOL    		EvInitDialog (HWND hWndFocus);

	BOOL 			CheckHotKey (TDialog *dlg = NULL);

public:
	TPropertyPage (TResId resID, TModule *module = 0);
	TPropertyPage (TPropertyDialog *parent, TResId resID, TModule *module = 0);
	~TPropertyPage ();

	int             MessageBox (const char far* text,
								const char far* caption = 0,
								UINT            type = MB_OK);
	BOOL 			PreProcessMsg (MSG& msg);
	HBRUSH  		EvCtlColor (HDC hdc, HWND hwndCtl, uint ctlType);

	TPropertyDialog& GetPropertyDialog ()	{ return *pdlgParent; }
	TWindow			*GetParentWindow ();
	int				ThisTab ()				{ return nThisTab; }

	// tab selection
	virtual BOOL 	SelectTab (int nTab = CURRENTPAGE);
	virtual BOOL 	SelectNext ();
	virtual BOOL 	SelectPrevious ();

	// property functions
	string 			GetTabText (int nTab = CURRENTPAGE);
	void			SetTabText (int nTab, LPCSTR lpszText);
	void			EnableTab (int nTab = CURRENTPAGE, BOOL bEnable = TRUE);
	BOOL			IsTabEnabled (int nTab = CURRENTPAGE);

	// overridable functions
	virtual void	AfterSelected ()							{  }
	virtual BOOL	BeforeLeaving ()							{ return TRUE; }
	virtual BOOL	CanPageClose ()								{ return TRUE; }
	virtual void	AfterCantClose ()							{ SelectTab (); }
	virtual void	OnRightClick (UINT modKeys, TPoint& point)	{  }

	virtual BOOL	SaveData ();

#if USETRANSFERARRAYS
	DECLARE_USETRANSFERARRAY(TPropertyPage, TDialog);
#endif

	DECLARE_RESPONSE_TABLE (TPropertyPage);
};

class PROPDLGEXPORT TPropertyDialog : public TDialog
{

protected:
	TPropertyTab	*pTabs;
	Tab::Style 		styleTabs;
	static TBrush*	brushGray;

	int				DoExecute ();

	void			EvDestroy ();
	BOOL    		EvInitDialog (HWND hWndFocus);
	void 			SizeTabWnd (TRect& client);
	void 			EvSysCommand (UINT cmdType, TPoint& pt);

	virtual void	AdjustMargin (TRect& rc);

public:
	TPropertyDialog (TWindow *pParent, TResId resID, Tab::Style style = Tab::SingleHeight | Tab::VariableWidth, TModule *module = 0);
	TPropertyDialog (TWindow *pParent, TResId resID, Tab::Style style, TResId resBitmap, BOOL bUseMask = FALSE, TModule *module = 0);
	~TPropertyDialog ();

	static void		SetHookInstance (HINSTANCE hInstance);
	static void 	TabColorChange (TApplication *application = NULL);

	void			SetupWindow ();
	void 			Destroy (int retValue = 0);
	void			EvSize (UINT, TSize& size);
	HBRUSH  		EvCtlColor (HDC hdc, HWND hwndCtl, uint ctlType);

	// message routing
	BOOL 			Find (TEventInfo&, TEqualOperator = 0);
	LRESULT			EvCommand (UINT id, HWND hWndCtl, UINT notifyCode);

	// get reference to a particular page
	TPropertyPage&	GetPageRef (int nTab = CURRENTPAGE);
	int				GetEntryCount ();

	// function to add a new tab
	virtual void	Add (LPCSTR lpszTab, TPropertyPage *pPage, BOOL bEnabled = TRUE);

	virtual void	CmOk ();      	// IDOK
	virtual void	CmCancel ();    // IDCANCEL
	virtual void	CloseAction (int retValue);

	// tab selection
	virtual BOOL 	SelectTab (int nTab);
	virtual BOOL 	SelectNext ();
	virtual BOOL 	SelectPrevious ();
	virtual void	AfterSelected (int nTab)	{ /* you can override this -- */ }
	virtual BOOL	BeforeLeaving (int nTab)	{ return TRUE; /* you can override this -- */ }

	// global properties for every tab
	void 			SetActiveColor (TColor color = TColor::Black);
	void 			SetFixedTabWidth (int nWidth = DEFTABWIDTH);
	void 			SetWideMarginWidth (int nWidth = DEFWIDEMARGIN);

	// page iterators that take function pointers
	TPropertyPage*	FirstPageThat (TPageCondFunc test, void* paramList = 0);
	void            ForEachPage (TPageActionFunc action, void* paramList = 0);

	// page-iterators that take pointers to member functions
	TPropertyPage*	FirstPageThat (TPageCondMemFunc test, void* paramList = 0);
	void            ForEachPage (TPageActionMemFunc action, void* paramList = 0);

	// similar to ForEach - sends Windows message to each page
	LRESULT 		SendMsgToEachPage (UINT msg, WPARAM wParam = 0, LPARAM lParam = 0);

	// functions for changing the position of the tab control in the tabbing sequence
	void			MoveTabsAfterControl (HWND hwndControl, BOOL bMoveFocus = TRUE);
	void			MoveTabsAfterControl (TWindow* wndControl)	{ MoveTabsAfterControl (wndControl->HWindow); }

	// function to return a pointer to the actual tab object
	TPropertyTab*	GetTabControl ()							{ return pTabs; }

private:
	static TResponseTableEntry<TPropertyDialog> __RTFAR	__entries[];
	typedef TResponseTableEntry<TPropertyDialog>::PMF   TMyPMF;
	typedef TPropertyDialog								TMyClass;
};

#endif
