// =========================================================
// WIZARD.H
// header file for implementation of TWizardDialog and
// TWizardPage
// =========================================================
#ifndef __WIZARDPROPERTY_DIALOG
#define __WIZARDPROPERTY_DIALOG

#include <owl\owlpch.h>
#pragma hdrstop

#include "propdlg.h"

#ifndef __BITMAP_CONTROL_H
  #include "bmpctl.h"
#endif

class PROPDLGEXPORT TWizardDialog : public TPropertyDialog
{
	BOOL			bEnableNext;
	BOOL			bEnablePrev;

public:
	TWizardDialog (TWindow *pParent, TResId resID, Tab::Style style = Tab::UseSmallFont, TModule *module = 0);
	~TWizardDialog ();

	void			SetupWindow ();

	BOOL			SelectNext ();
	BOOL			SelectPrevious ();

	void			CmSelectNext ()			{ SelectNext (); }
	void			CmSelectPrevious ()		{ SelectPrevious (); }

	virtual void	AfterSelected (int nTab);

	DECLARE_RESPONSE_TABLE(TWizardDialog);
};

class PROPDLGEXPORT TWizardPage : public TPropertyPage
{
	TBitmapControl*	bitmap;
	BOOL			bHadNext;

public:
	TWizardPage (TResId resID, int idBitmap = NULL, TBitmapControl::Style style = TBitmapControl::Recessed, TModule *module = 0);
	TWizardPage (TPropertyDialog *parent, TResId resID, int idBitmap = NULL, TBitmapControl::Style style = TBitmapControl::Recessed, TModule *module = 0);

	void			SetupWindow ();

	virtual void	AfterSelected ();

	void			CmSelectNext ()			{ SelectNext (); }

	DECLARE_RESPONSE_TABLE(TWizardPage);
};

#endif
