#if !defined(__PRINTAPP_H)
#define __PRINTAPP_H

#if !defined(__PRINTQ_H)
#include "PrintQ.h"
#endif

class TPrintAppInit
	{
	public:

		TPrintAppInit(PrintQueue* (*fn)()) : createPrintQueue(fn)
			{}

	protected:

		PrintQueue* (*createPrintQueue)();
	};

class TEvent;

const ushort cmAddPrintJob = 50000U;

class TPrintApp : public TApplication, virtual public TPrintAppInit
	{
	public:

		TPrintApp();

		virtual void shutDown();
		virtual void idle();
		virtual void handleEvent(TEvent&);
		virtual Boolean valid(ushort);

		static PrintQueue* initPrintQueue();

		static PrintQueue* printQueue;
	};

class TPrintQueue : public PrintQueue
	{
	public:

		TPrintQueue() {}

	protected:

		virtual int printString(const char*, int) const;
	};

#endif	// __PRINTAPP_H
