#include <tv.h>
#include "PrintQ.h"
#include <mem.h>
#include <io.h>
#include <fcntl.h>
#include <share.h>

Boolean PrintQueue::insert(PrintJob* job)
	{
	if(job != 0)
		{
		job->reset();
		if(count >= limit && !setJobsSize((long)limit + PQDelta))
			return False;
		jobs[count++] = job;
		}
	return True;
	}

Boolean PrintQueue::kill(PrintJob* job)
	{
	int i;

	if(job != 0)
		{
		if(job == currentJob() && job->amountPrinted() > 0L)
			{
			printFormFeed();
			job->reset();
			}
		for(i = 0; i < count; i++)
			if(jobs[i] == job)
				{
				delete jobs[i];
				if(i < count-1)
					memmove(jobs+i, jobs+i+1, (count-i-1)*sizeof(PrintJob*));
				count--;
				return True;
				}
		return False;
		}
	return True;
	}

void PrintQueue::killAll()
	{
	while(count > 0)
		kill(jobs[count-1]);
	setJobsSize(0);
	}

Boolean PrintQueue::print()
	{
	char* buffer;
	int length, n;
	PrintJob* job;

	job = currentJob();
	if(job != 0)
		{
		length = job->getText(buffer);
		if(buffer != 0 && length > 0)
			{
			n = printString(buffer,length);
			job->skip(n);
			if(n != length)
				return False;
			}
		if(job->complete())
			kill(job);
		}
	return True;
	}

Boolean PrintQueue::setJobsSize(int sz)
	{
	PrintJob** aJobs;

	if(sz >= PQMaxSize || sz < count)
		return False;

	if(sz == 0)
		aJobs = 0;
	else
		{
		aJobs = new PrintJob* [sz];
		if(aJobs == 0)
			return False;
		if(count > 0)
			memcpy(aJobs, jobs, count*sizeof(PrintJob*));
		}
	delete [] jobs;
	jobs = aJobs;
	limit = sz;
	return True;
	}

// ------------------------------------------------------------------

PrintFile::PrintFile(const char* filespec, int aPrintSize) :
		PrintJob(aPrintSize),
		buffer(new char [aPrintSize]),
		handle(-1)
	{
	if(buffer == 0)
		size = 0;
	else
		{
		handle = sopen(filespec, O_BINARY|O_RDONLY, SH_DENYWR);
		if(handle < 0)
			{
			delete [] buffer;
			buffer = 0;
			size = 0;
			}
		else
			size = filelength(handle);
		}
	}

PrintFile::~PrintFile()
	{
	if(handle >= 0)
		close(handle);
	delete [] buffer;
	}

int PrintFile::getText(char*& buf)
	{
	if(complete())
		{
		buf = 0;
		return 0;
		}
	else
		{
		buf = buffer;
		lseek(handle, pos, SEEK_SET);
		return read(handle, buffer, printSize);
		}
	}

