/*  Project estprssp
	UBS Consultants Inc.
	Copyright  1994. All Rights Reserved.

	SUBSYSTEM:    estprssp.exe Application
	FILE:         tpxdialg.cpp
	AUTHOR:       Farley Carter


	OVERVIEW
	========
	Source file for implementation of TPXDialog (TDialog).
*/

#include <owl\owlpch.h>
#pragma hdrstop

#include "tpxdialg.h"


//
// Build a response table for all messages/commands handled
// by the application.
//
DEFINE_RESPONSE_TABLE1(TPXDialog, TDialog)
//{{TPXDialogRSP_TBL_BEGIN}}
	EV_COMMAND(PX_CLEAR, PxClear),
	EV_COMMAND(PX_DELETE, PxDelete),
	EV_COMMAND(PX_FIRST, PxFirst),
	EV_COMMAND(PX_INSERT, PxInsert),
	EV_COMMAND(PX_LAST, PxLast),
	EV_COMMAND(PX_NEXT, PxNext),
	EV_COMMAND(PX_PREVIOUS, PxPrevious),
	EV_COMMAND(PX_RECALL, PxRecall),
	EV_COMMAND(PX_SEARCH, PxSearch),
	EV_COMMAND(PX_UPDATE, PxUpdate),
//{{TPXDialogRSP_TBL_END}}
END_RESPONSE_TABLE;


//{{TPXDialog Implementation}}


TPXDialog::TPXDialog (TWindow* parent, TResId resId, TModule* module):
	TDialog(parent, resId, module)
	{ }

TPXDialog::~TPXDialog () {
	Destroy();
	}

void TPXDialog::PxClear () {
	HandleEvent(PX_CLEAR);
	}

void TPXDialog::PxDelete () {
	HandleEvent(PX_DELETE);
	}

void TPXDialog::PxFirst () {
	HandleEvent(PX_FIRST);
	}

void TPXDialog::PxInsert () {
	HandleEvent(PX_INSERT);
	}

void TPXDialog::PxLast () {
	HandleEvent(PX_LAST);
	}

void TPXDialog::PxNext () {
	HandleEvent(PX_NEXT);
	}

void TPXDialog::PxPrevious () {
	HandleEvent(PX_PREVIOUS);
	}

void TPXDialog::PxRecall () {
	HandleEvent(PX_RECALL);
	}

void TPXDialog::PxSearch () {
	HandleEvent(PX_SEARCH);
	}

void TPXDialog::PxUpdate () {
	HandleEvent(PX_UPDATE);
	}

BOOL TPXDialog::PreProcessMsg (MSG& msg) {
	BOOL result;

	if (msg.message == WM_KEYDOWN && msg.wParam != VK_SHIFT) {
		switch (msg.wParam) {
			case VK_RETURN:
				msg.wParam = VK_TAB;
				break;
			}
		}
	result = TDialog::PreProcessMsg(msg);
	return result;
	}


void TPXDialog::SetupWindow () {
	TDialog::SetupWindow();
	mb = (TMessageBar *) GetApplication()->MainWindow->ChildWithId(IDW_STATUSBAR);
	errorFld = 0;
	}

void TPXDialog::ErrorMsg(int msg) {
	MessageBeep(1);
	if (mb != NULL) {
		char buf[128];
		buf[0] = 0;
		GetModule()->LoadString(msg,buf,sizeof(buf));
		mb->SetText(buf);
		}
	}


