#include <stdio.h>
#include <dos.h>

#include "dpmish.h"
#include "dospool.h"

DosMemoryPool::DosMemoryPool(unsigned sz)
{
    int nSegs = sz/16;
    if (Dpmi.allocateDosMemory(nSegs, dosseg, selector)!=DPMI_OK) {
        Dpmi.fail("cannot allocate dos memory");
    }
	nextalloc = 0;
}
DosMemoryPool::~DosMemoryPool()
{
	if (selector)
        Dpmi.freeDosMemory(selector);
    selector = 0;
}


void *DosMemoryPool::allocate(size_t sz)
{
	void *p;
	FP_SEG(p) = selector;
	FP_OFF(p) = nextalloc;

    // round up to nearest longword
	sz += 3;
    sz -= (sz&3);
	nextalloc += sz;
    return p;
}
