//=====================================================================
//
//  init.cpp
//
//  initialization / cleanup handling for Borland C runtime
//
//  dos protected mode version
//
//  Copyright (c) 1994, Kevin Morgan, All rights reserved.
//
//=====================================================================
#include <stdio.h>
#include <dos.h>

extern "C" void Initialize(unsigned,unsigned,unsigned);
extern "C" void Cleanup(unsigned,unsigned,unsigned);

const unsigned char PNEAR = 0;
const unsigned char PFAR  = 1;
const unsigned char NOTUSED = 0xff;

struct startup_table {
    unsigned char calltype, priority;
    void (far *funcptr)();
};

void Initialize(unsigned ds, unsigned lo, unsigned hi)
{
//  printf("Initialize called...%04x %04x %04x\n", ds, lo, hi);
    startup_table *st;
    FP_SEG(st) = ds;

	for (;;) {
		startup_table *lowent = 0;
		unsigned i;
	    for (i = lo; i < hi; i+=sizeof(startup_table) ) {
    	    FP_OFF(st) = i;
			if (st->calltype==PFAR||st->calltype==PNEAR) {
				if (lowent==0)
					lowent = st;
				else if (st->priority<lowent->priority) 
					lowent = st;
			}
    	}
		if (lowent==0) break;
//      printf("Calling Startup entry: %02x %02x %08lx\n", lowent->calltype, lowent->priority, lowent->funcptr);
        switch (lowent->calltype) {
            case PFAR:
        		lowent->calltype = NOTUSED;
        		(*lowent->funcptr)();
                break;
            case PNEAR:
        		lowent->calltype = NOTUSED;
        		(*lowent->funcptr)();
                asm pop ax  // pop off extra word of CS info
                break;
			default:
				;
        }
	}
//  printf("...Initialize done\n");
}

void Cleanup(unsigned ds, unsigned lo, unsigned hi)
{
//  printf("Cleanup called...%04x %04x %04x\n", ds, lo, hi);
    startup_table *st;
    FP_SEG(st) = ds;

	for (;;) {
		startup_table *lowent = 0;
		unsigned i;
	    for (i = lo; i < hi; i+=sizeof(startup_table) ) {
    	    FP_OFF(st) = i;
			if (st->calltype==PFAR||st->calltype==PNEAR) {
				if (lowent==0)
					lowent = st;
				else if (st->priority>=lowent->priority) 
					lowent = st;
			}
    	}
		if (lowent==0) break;
//      printf("Calling Cleanup entry: %02x %02x %08lx\n", lowent->calltype, lowent->priority, lowent->funcptr);
        switch (lowent->calltype) {
            case PFAR:
        		lowent->calltype = NOTUSED;
        		(*lowent->funcptr)();
				break;
			case PNEAR:
				lowent->calltype = NOTUSED;
				(*lowent->funcptr)();
				asm pop ax  // pop off extra word of CS info
				break;
			default:
				;
        }
	}
//  printf("...Initialize done\n");
}

