//***************************************************************************
// Public Header file for Sounds class.
// Copyright 1993 Stephen. A. Edwards.

#ifndef __SOUNDSDEF
#define __SOUNDSDEF

enum IRQ  { BADIRQ = 0x00,
	    IRQ2 = 0x0A,
	    IRQ3 = 0x0B,
	    IRQ5 = 0x0D,
	    IRQ7 = 0x0F };

enum BASE { BADBASE = 0x00,
	    BASE210 = 0x210,
	    BASE220 = 0x220,
	    BASE230 = 0x230,
	    BASE240 = 0x240,
	    BASE250 = 0x250,
	    BASE260 = 0x260,
	    BASE270 = 0x270,
	    BASE280 = 0x280 };

enum SIZE { BADBUF = 0x00,
	    BUF1K  = 1000,
	    BUF4K  = 4000,
	    BUF8K  = 8000,
	    BUF16K = 16000,
	    BUF32K = 32000 };

#define FilePause	4
#define FileAbort	3
#define FileIsPlaying	2
#define FileEnd	       -9

class Sounds
{
public  :

long int		Play(char * FileName);
long int		Pause();
long int		Resume();
long int		Abort();
long int		GetPlayStatus();
long int 		GetMarkerStatus();
long int		Elapsed( double * seconds );
void			Error( long int status, char ** Cptr );
void			Report();

static long int		SpeakerOn();		// Turn speaker on.
static long int		SpeakerOff();		// Turn speaker off.
static long int 	Finished;

			Sounds(enum IRQ  I, enum BASE B, enum SIZE S);
			Sounds(enum IRQ  I, enum SIZE S);
			Sounds(enum SIZE S);
			~Sounds();

};


#endif
