/*
** comgets.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include "comlib.h"

/*
** Reads a '\r'-terminated string from the serial port.
** Returns 0 if successful, -1 if error.
*/
int comgets(char *buffer,int max)
{
	int i;

	for(i = 0;i < max;i++) {
		if(comgetc(&buffer[i])) {
			buffer[i] = '\0';
			return(-1);
		}
		if(buffer[i] == '\r') {
			i++;
			break;
		}
	}
	buffer[i] = '\0';
	return(0);

} /* comgets */
