/*
** pushcurs.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include "pictor.h"

#define STACK_SIZE   10
static struct {
	int ctype;
	int cpos;
} cstack[STACK_SIZE];

static int curr = 0;

/*
** Saves the cursor location and style so that it can later be
** restored using popcurs. Returns TRUE if successful, FALSE if
** the stack is full.
*/
int pushcurs(void)
{
	if(curr < STACK_SIZE) {
		cstack[curr].ctype = getcurstype();
		cstack[curr].cpos = getcurs();
		curr++;
		return(TRUE);
	}
	return(FALSE);

} /* pushcurs */

/*
** Restores the cursor saved by last call to pushcurs.
** Returns TRUE if successful, FALSE if stack is empty.
*/
int popcurs(void)
{
	if(curr > 0) {
		curr--;
		setcurstype(cstack[curr].ctype);
		setcurs(cstack[curr].cpos >> 8,cstack[curr].cpos & 0xFF);
		return(TRUE);
	}
	return(FALSE);

} /* popcurs */
