/*
** wtitle.c
**
** Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits
** Redistributed by permission.
*/

#include <stdio.h>
#include <stdlib.h>
#include "pictor.h"


struct {
	char left;
	char right;
	char top;
} border[2] = {
	{ '\xB5','\xC6','\xCD' },
	{ '\xB4','\xC3','\xC4' },
};

/*
** Prints a title at the top of the active window pane.
*/
void wtitle(char *buffer)
{
	int i,len,btype;

	if(_PL_winhead == NULL)
		return;

	vcolor(_PL_winhead->color);
	btype = (_CURR_WPANE.top == _PL_winhead->top) ? 0 : 1;

	/* clear any existing title */
	setvpos(_CURR_WPANE.top,_CURR_WPANE.left + 1);
	vrepc(border[btype].top,getwcols());

	/* print new title if one was specified */
	if(buffer != NULL) {
		if(strlen(buffer) < (unsigned)(getwcols() - 4))
			len = (strlen(buffer) + 4);
		else
			len = getwcols();
		setvpos(_CURR_WPANE.top,_CURR_WPANE.left + center(len,getwcols()));
		for(i = 0;i < len;i++) {
			if(i == 0)
				vputc(border[btype].left);
			else if(i == (len - 1))
				vputc(border[btype].right);
			else if(i == 1 || i == (len - 2))
				vputc(' ');
			else
				vputc(buffer[i - 2]);
		}
	}

} /* wtitle */
