;-----------------------------------------------------------------------;
; PRNWRITE.ASM								;
;									;
; Pictor, Version 1.51, Copyright (c) 1992-94 SoftCircuits.		;
; Redistributed by permission.						;
;-----------------------------------------------------------------------;
%	.MODEL	memmodel,c

	.CODE
	PUBLIC	prnwrite
;-----------------------------------------------------------------------;
; Writes the specified number of characters to the standard list	;
; device.								;
;									;
; Usage:	int prnwrite(char *buffer,int count);			;
; Returns:	0 if successful or a non-zero value if an error		;
;		occurred.						;
;-----------------------------------------------------------------------;
prnwrite	PROC buffer:PTR BYTE,count:WORD
	mov	ah,40h			;Write characters to the standard
	mov	bx,4			; list device
	mov	cx,count		;Number of characters to write
	IF	@DataSize
	push	ds
	lds	dx,buffer
	ELSE
	mov	dx,buffer
	ENDIF
	int	21h			;Call MS-DOS
	IF	@DataSize
	pop	ds
	ENDIF
	mov	dx,ax			;dx = number of characters written
	mov	ax,0			;Clear ax
	adc	ax,0			;Increment ax if carry set
	cmp	dx,count		;Increment ax if not all
	adc	ax,0			; characters were written
	ret
prnwrite	ENDP

	END
