/*----------------------------------------------------------------
            INVOICE.C Generated by PARAGen version 2.20          
------------------------------------------------------------------
  PROJECT         : Demo invoice program
  AUTHOR          : Innovative Data Solutions, Inc.
  DATE            : 03/14/1991
  TIME            : 07:05PM
  CODING STYLE    : 2  - [Standard C]
  TAB EXPANSION   : ON
  TABLE           : INVOICE.DB - [Fields: 7, Key Fields: 2]
  DATABASE FIELDS          PARADOX                   PARAGEN
                           -------                   -------
                    (01) - Catalog Number            CatalogNumber             
                    (02) - Invoice Number            InvoiceNumber             
                    (03) - Invoice Date              InvoiceDate               
                    (04) - Unit Price                UnitPrice                 
                    (05) - Amount                    Amount                    
                    (06) - Discount                  Discount                  
                    (07) - Ship Via                  ShipVia                   
  GENERATED BY    : Innovative Data Solutions, Inc. Paradox Code Generator
                    4318 Stewart Court
                    East Chicago, IN 46312
                    (219)-397-8952
-----------------------------------------------------------------*/

/*----------------------------------------------------------------
                        Global Defines                            
------------------------------------------------------------------
  BUFFERED - is used in the PXTblOpen call to establish whether 
             writes should be buffered or not (SEE engine manual)
             (TRUE)  - save records to disk as they are posted
             (FALSE) - buffer above records for speed purposes
  GLOBAL   - Global define used to declare global variables.  If it
             is defined variables are declared, otherwise they are
             external so you can reference them in another module
-----------------------------------------------------------------*/

#define BUFFERED FALSE
#define GLOBAL 1

/*----------------------------------------------------------------
                           Include Files                          
-----------------------------------------------------------------*/

#include "invoice.h"
#include "pxengine.h"

/*----------------------------------------------------------------
                           Code Starts                            
-----------------------------------------------------------------*/

int INVOICEError(int ErrCode)
{
	if (ErrCode)		
		return(ErrCode);
	return(PXSUCCESS);
}

int INVOICETblOpen(char *Password)
{
	if (Password)
		{
		INVOICERet = PXPswAdd(Password);
		INVOICERetMacro();
		}
	INVOICERet = PXTblOpen("INVOICE",&INVOICETable,0,BUFFERED);
	INVOICERetMacro();
	INVOICERet = PXRecBufOpen(INVOICETable,&INVOICERecord);
	INVOICERetMacro();
	INVOICERet = PXFldHandle(INVOICETable,"Catalog Number",&INVOICECatalogNumber);
	INVOICERetMacro();
	INVOICERet = PXFldHandle(INVOICETable,"Invoice Number",&INVOICEInvoiceNumber);
	INVOICERetMacro();
	INVOICERet = PXFldHandle(INVOICETable,"Invoice Date",&INVOICEInvoiceDate);
	INVOICERetMacro();
	INVOICERet = PXFldHandle(INVOICETable,"Unit Price",&INVOICEUnitPrice);
	INVOICERetMacro();
	INVOICERet = PXFldHandle(INVOICETable,"Amount",&INVOICEAmount);
	INVOICERetMacro();
	INVOICERet = PXFldHandle(INVOICETable,"Discount",&INVOICEDiscount);
	INVOICERetMacro();
	INVOICERet = PXFldHandle(INVOICETable,"Ship Via",&INVOICEShipVia);
	INVOICERetMacro();
	return(PXSUCCESS);
}

int INVOICETblClose(void)
{
	INVOICERet = PXTblClose(INVOICETable);
	INVOICERetMacro();
	return(PXSUCCESS);
}

int INVOICESrchFld(int SearchMode,char *FieldToSearch,INVOICETABLEENTRY *RecordVal)
{
	FIELDHANDLE FldHandle;
	long ParaDate;

	INVOICERet = PXFldHandle(INVOICETable,FieldToSearch,&FldHandle);
	INVOICERetMacro();
	INVOICERet = PXRecBufEmpty(INVOICERecord);
	INVOICERetMacro();
	switch (FldHandle)
		{
		case 7:			
			INVOICERet = PXPutAlpha(INVOICERecord,INVOICEShipVia,RecordVal->ShipVia);
			break;

		}
	INVOICERetMacro();
	INVOICERet = PXSrchFld(INVOICETable,INVOICERecord,FldHandle,SearchMode);
	INVOICERetMacro();
	INVOICERet = PXRecGet(INVOICETable,INVOICERecord);
	INVOICERetMacro();
	INVOICERet = PXGetDoub(INVOICERecord,INVOICECatalogNumber,&RecordVal->CatalogNumber);
	INVOICERetMacro();
	INVOICERet = PXGetDoub(INVOICERecord,INVOICEInvoiceNumber,&RecordVal->InvoiceNumber);
	INVOICERetMacro();
	INVOICERet = PXGetDate(INVOICERecord,INVOICEInvoiceDate,&ParaDate);
	INVOICERetMacro();
	INVOICERet = PXDateDecode(ParaDate,&RecordVal->InvoiceDateMonth,&RecordVal->InvoiceDateDay,&RecordVal->InvoiceDateYear);
	INVOICERetMacro();
	INVOICERet = PXGetDoub(INVOICERecord,INVOICEUnitPrice,&RecordVal->UnitPrice);
	INVOICERetMacro();
	INVOICERet = PXGetDoub(INVOICERecord,INVOICEAmount,&RecordVal->Amount);
	INVOICERetMacro();
	INVOICERet = PXGetDoub(INVOICERecord,INVOICEDiscount,&RecordVal->Discount);
	INVOICERetMacro();
	INVOICERet = PXGetAlpha(INVOICERecord,INVOICEShipVia,FSZSHIPVIA+1,RecordVal->ShipVia);
	INVOICERetMacro();
	return(PXSUCCESS);
}

