(*----------------------------------------------------------------
            INVOICE.PAS Generated by PARAGen version 2.20          
------------------------------------------------------------------
  PROJECT         : Demo invoice program
  AUTHOR          : Innovative Data Solutions, Inc.
  DATE            : 03/14/1991
  TIME            : 07:06PM
  CODING STYLE    : 2  - [Standard C]
  TAB EXPANSION   : ON
  TABLE           : INVOICE.DB - [Fields: 7, Key Fields: 2]
  DATABASE FIELDS          PARADOX                   PARAGEN
                           -------                   -------
                    (01) - Catalog Number            CatalogNumber             
                    (02) - Invoice Number            InvoiceNumber             
                    (03) - Invoice Date              InvoiceDate               
                    (04) - Unit Price                UnitPrice                 
                    (05) - Amount                    Amount                    
                    (06) - Discount                  Discount                  
                    (07) - Ship Via                  ShipVia                   
  GENERATED BY    : Innovative Data Solutions, Inc. Paradox Code Generator
                    4318 Stewart Court
                    East Chicago,  IN 46312
                    (219)-397-8952
-----------------------------------------------------------------*)

UNIT INVOICE;

(*----------------------------------------------------------------
                     Interface section of UNIT                      
-----------------------------------------------------------------*)

INTERFACE

USES
	PXEngine;

(*----------------------------------------------------------------
                       'Pascal' Access Structure                       
-----------------------------------------------------------------*)

TYPE

	INVOICETABLEENTRY = RECORD		
		CatalogNumber : Double;                           (* KEY FIELD *)
		InvoiceNumber : Double;                           (* KEY FIELD *)
		InvoiceDateMonth : Integer;                       
		InvoiceDateDay : Integer;                         
		InvoiceDateYear : Integer;                        
		UnitPrice : Double;                               
		Amount : Double;                                  
		Discount : Double;                                
		ShipVia : string;                                 
	END;


(*----------------------------------------------------------------
            Copy,Rename,Open,Get and Put Constants and Types                 
-----------------------------------------------------------------*)

	SrcOrDestType = (Source,Destination);
	GetOrPutType =  (Get,Put);

CONST

	NoPassword : String = 'None';
	Buffered : Boolean = False;

	INVOICEName : String = 'INVOICE';

	
(*----------------------------------------------------------------
	                        Field Size Constants                      
	-----------------------------------------------------------------*)

	FSZSHIPVIA : Integer =                  10;       
	
(*----------------------------------------------------------------
               Engine Handles and Global Variables                
-----------------------------------------------------------------*)

VAR
	INVOICETable : TableHandle;
	INVOICERecord : RecordHandle;
	INVOICECatalogNumber : FieldHandle;                    (* KEY FIELD *)
	INVOICEInvoiceNumber : FieldHandle;                    (* KEY FIELD *)
	INVOICEInvoiceDate : FieldHandle;                      
	INVOICEUnitPrice : FieldHandle;                        
	INVOICEAmount : FieldHandle;                           
	INVOICEDiscount : FieldHandle;                         
	INVOICEShipVia : FieldHandle;                          
	INVOICERet : Integer;

(*----------------------------------------------------------------
                       Function Prototypes                        
-----------------------------------------------------------------*)

FUNCTION INVOICEError(ErrCode:Integer):Integer;
FUNCTION INVOICETblOpen(Password:String):Integer;
FUNCTION INVOICETblClose:Integer;
FUNCTION INVOICESrchFld(SearchMode:Integer; FieldToSearch:String; var RecordVal:INVOICETABLEENTRY):Integer;

IMPLEMENTATION

(*----------------------------------------------------------------
                          Function Implementation                  
-----------------------------------------------------------------*)

FUNCTION INVOICEError(ErrCode:Integer):Integer;

BEGIN
	if (ErrCode > 0) then		
		INVOICEError := ErrCode
	else		
		INVOICEError := PXSUCCESS;
END;

FUNCTION INVOICETblOpen(Password:String):Integer;

BEGIN
	if (Password <> NoPassword) then		
		BEGIN
			INVOICERet := PXPswAdd(Password);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICERet := INVOICEError(INVOICERet);
					if (INVOICERet <> PXSUCCESS) then						
						BEGIN
							INVOICETblOpen := INVOICERet;
							Exit;
						END;
				END;
		END;
	INVOICERet := PXTblOpen('INVOICE',INVOICETable,0,Buffered);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICETblOpen := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXRecBufOpen(INVOICETable,INVOICERecord);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICETblOpen := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXFldHandle(INVOICETable,'Catalog Number',INVOICECatalogNumber);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICETblOpen := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXFldHandle(INVOICETable,'Invoice Number',INVOICEInvoiceNumber);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICETblOpen := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXFldHandle(INVOICETable,'Invoice Date',INVOICEInvoiceDate);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICETblOpen := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXFldHandle(INVOICETable,'Unit Price',INVOICEUnitPrice);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICETblOpen := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXFldHandle(INVOICETable,'Amount',INVOICEAmount);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICETblOpen := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXFldHandle(INVOICETable,'Discount',INVOICEDiscount);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICETblOpen := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXFldHandle(INVOICETable,'Ship Via',INVOICEShipVia);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICETblOpen := INVOICERet;
					Exit;
				END;
		END;
	INVOICETblOpen := PXSUCCESS;
END;

FUNCTION INVOICETblClose:Integer;

BEGIN
	INVOICERet := PXTblClose(INVOICETable);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICETblClose := INVOICERet;
					Exit;
				END;
		END;
	INVOICETblClose := PXSUCCESS;
END;

FUNCTION INVOICESrchFld(SearchMode:Integer; FieldToSearch:String; var RecordVal:INVOICETABLEENTRY):Integer;

VAR	
	FldHandle : FIELDHANDLE;
	Paradate : Longint;
BEGIN
	INVOICERet := PXFldHandle(INVOICETable,FieldToSearch,FldHandle);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXRecBufEmpty(INVOICERecord);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	case FldHandle of		
		7 :			
			INVOICERet := PXPutAlpha(INVOICERecord,INVOICEShipVia,RecordVal.ShipVia);
	END;
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXSrchFld(INVOICETable,INVOICERecord,FldHandle,SearchMode);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXRecGet(INVOICETable,INVOICERecord);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXGetDoub(INVOICERecord,INVOICECatalogNumber,RecordVal.CatalogNumber);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXGetDoub(INVOICERecord,INVOICEInvoiceNumber,RecordVal.InvoiceNumber);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXGetDate(INVOICERecord,INVOICEInvoiceDate,ParaDate);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXDateDecode(ParaDate,RecordVal.InvoiceDateMonth,RecordVal.InvoiceDateDay,RecordVal.InvoiceDateYear);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXGetDoub(INVOICERecord,INVOICEUnitPrice,RecordVal.UnitPrice);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXGetDoub(INVOICERecord,INVOICEAmount,RecordVal.Amount);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXGetDoub(INVOICERecord,INVOICEDiscount,RecordVal.Discount);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICERet := PXGetAlpha(INVOICERecord,INVOICEShipVia,RecordVal.ShipVia);
	if (INVOICERet <> PXSUCCESS) then		
		BEGIN
			INVOICERet := INVOICEError(INVOICERet);
			if (INVOICERet <> PXSUCCESS) then				
				BEGIN
					INVOICESrchFld := INVOICERet;
					Exit;
				END;
		END;
	INVOICESrchFld := PXSUCCESS;
END;

END.
