/*
	GETFNAME.C - Get a filename\path string from the user.

	Modified from ScrGetS() in SCR.C
*/

#include "scr.h"
#include "kbd.h"
#include <dos.h>

GetFname(char *Buffer, int Attr, int Col, int Row, int Length)
/*
	The function returns one of the following codes indicating the field
	exit key pressed by the user:

		-1	<Esc>
		 0	<CR>
		 1	<Left-Arrow>
		 2	<Right-Arrow>
*/
{
	register int CurCol, i;			/* current column/loop index            */
	int VideoSeg;					/* segment of video memory              */
	int far *Video;					/* far pointer to video memory          */
	int Key;						/* stores input key value               */
	int FirstChar = 1;				/* flag to indicate the first character */

	CurCol = Col;						/* Initialize current column        */
	if (*(char far *)0x00400049 == 7)
		VideoSeg = 0xb000;
	else
		VideoSeg = 0xb800;

	Video = MK_FP (VideoSeg, Row*160+Col*2);
	ScrPutAttr(Attr, CurCol, Row, CurCol, Row);

	if (*Buffer != '\0')	{
		CurCol += strlen(Buffer);
		while (*Buffer)
			*Video++ = (Attr << 8) | *Buffer++;
	}
	ScrSetCur(CurCol,Row,0);

	for (;;)				/* Keyboard read loop */
		switch (Key = KbdGetC ())
			{
			case 0x011b:		/* Escape 								   */
				return (-1);
			case 0x4b00:		/* Left-Arrow							   */
				return (1);
			case 0x4d00:		/* Right-Arrow							   */
				return (2);
			case 0x1c0d:		/* Return								   */
				*Buffer++ = '\0';
				return (0);
			case 0x0e08:		/* Backspace							   */
				if (CurCol > Col)	{
					FirstChar = 0;
					ScrSetCur (--CurCol,Row, 0);
					*--Video = (Attr << 8) | ' ';
					*--Buffer = ' ';
				}
				break;
			default:
				if (CurCol >= Col + Length - 1)		/* Test end of buffer   */
					break;
				if (Key&0x00ff == 0)			/* Test for non-ASCII char  */
					break;
				Key = toupper (Key&0x00ff);
				Key &= 0x00ff;					/* Remove extended code     */
									/* Place key in video memory & buffer   */
				*Video++ = (Attr << 8) | Key;
				*Buffer++ = Key;
				ScrSetCur (++CurCol, Row,0);	/* Update cursor position   */

				if (FirstChar)		/* Blank-fill buffer on first character */
				{
					FirstChar = 0;
					while(CurCol > Col)	{
						*Buffer = '\0';
						ScrSetCur(--CurCol, Row, 0);
						*--Video = (Attr << 8) | ' ';
						*--Buffer = ' ';
					}
					*Video++ = (Attr << 8) | Key;     /* ? */
					*Buffer++ = Key;
					ScrSetCur(++CurCol, Row, 0);
				}
			}
}