/*

	pckey.cpp
	3-24-91
	PC keyboard class for Borland C++

	Copyright 1991
	John W. Small
	All rights reserved
	Use freely but acknowledge authorship and copyright.
	CIS: 73757,2233


	PSW / Power SoftWare
	P.O. Box 10072
	McLean, Virginia 22102 8072
	(703) 759-3838

*/

#include <pckey.hpp>

PCKey::PCKey()
{
    enhancedKeyBrd = 0;
    flush();
    (void) putch(0x3B00);
    if (kbhit())  {
	(void) getch();
	enhancedKeyBrd = 0x10;
    }
    enhancedShiftMask = (enhancedKeyBrd)?
	0xFFFF : 0x00FF;
    asciiScan = 0;
}

void PCKey::flush(void)
{
    while (kbhit())
	(void) getch();
}

// PCKey static member definitions
unsigned PCKey::asciiScan;
unsigned char PCKey::enhancedKeyBrd;
unsigned PCKey::enhancedShiftMask;

PCKey PC;	// Only instance, do not instantiate!


// Define TEST_PCKEY_CPP to test pckey.cpp as a stand
// alone module.
//#define TEST_PCKEY_CPP

#ifdef TEST_PCKEY_CPP

#include <stdio.h>

main()
{
	int ch;
	unsigned lastShift = PC.shift();
	puts("\n\nPress ESC to continue, any other key"
		" to view ascii/scan code ...");
	while (!PC.kbhit())
		if (PC.shift() != lastShift)  {
			lastShift = PC.shift();
			printf("\n PC.shift(): %04x",
				PC.shift());
		}
	while ((ch = PC.getch()) != ESC)  {
		printf("\n PC.getch(): %1c%1c     "
			"PC.ascii():  %3d   "
			"PC.scan(): %3d",
			(ch <= 26 && ch)? '^':' ',
			(ch <= 26 && ch)? ch+'@':ch,
			PC.ascii(), PC.scan());
		while (!PC.kbhit())
			if (PC.shift() != lastShift)  {
				lastShift = PC.shift();
				printf("\n PC.shift(): "
					"%04x",PC.shift());
			}
	}
	if (PC.enhanced())  {
		puts("\n\nNow for the typematic test.  "
			"Hold down any key to view the ");
		puts("standard rates.  ESC for high "
			"speed.\n");
		ch = PC.getch();
		while (ch != ESC)
			putchar(ch = PC.getch());
		puts("\n\nNow for highest speed hold "
			"down any key.  ESC to quit.\n");
		PC.setTypeMatic(TMR300,TMD250);
		ch = PC.getch();
		while (ch != ESC)
			putchar(ch = PC.getch());
		PC.setTypeMatic(TMR109,TMD500);
	}
	else
		puts("\n\nKey board is not enhanced.");
	return 0;
}

#endif