//
//     W M S E R I A L - Windows Modem Example
//
// This is only part of a multiple source project.  To build the
// executable please use the makefile provided or construct
// a project file containing the files and settings listed in
// PROJECT.TXT.
//
// Remember to modify the directories to reflect your configuration.
//
//                                                     - J A A

// WNOTIFY.C

#include <windows.h>
#include "wmserial.h"


int ProcessCommNotify(HWND hWnd, int nComID, int nNotification)
   {
   HANDLE hBufferMem;
   LPSTR szData;
   int nResult;

   // Process Receive Notice    
   if ( nNotification & CN_RECEIVE )
       {
       // Get memory for data
       hBufferMem = GlobalAlloc( GMEM_MOVEABLE, QBUFFSIZE );
       if (!hBufferMem)
           {
           MessageBeep(MB_ICONEXCLAMATION);
           MessageBox(hWnd,"Not enough memory for initializing modem.","Example Windows Terminal",MB_ICONSTOP);
           PostMessage(hWnd,WM_CLOSE,0,0L);
           return NULL;
           }
       szData = (LPSTR) GlobalLock(hBufferMem);

       nResult = ReadComPort ( nComID, szData, QBUFFSIZE-1 );
       if (nResult > 0)
           {
           szData[nResult] = 0;
           TTYWriteScreen(szData);
           }
       else if (nResult < 0)
           {
           szData[-nResult] = 0;
           TTYWriteScreen(szData);
           GlobalUnlock(hBufferMem);       
           return nResult;
           }
       GlobalUnlock(hBufferMem);
       CheckComPort(nComID,NULL);
       }


   // Process Transmit Notice
   if ( nNotification & CN_TRANSMIT )
       nResult = WriteComPort(nComID, NULL, NULL);
       // Last Error is left for CheckComPort() call


   return nResult;
   }

