#include "serialw.h"

#include <windows.h>
#include "wmserial.h"

int nActiveComPort;
BOOL bConnected;
BOOL bEcho = FALSE;

TSerialWindow::TSerialWindow()
  : TFrameWindow( 0, "OWL 2 Serial", 0 )
{
}

void TSerialWindow::SetupWindow()
{
  TFrameWindow::SetupWindow();
  ::TTYInit( HWindow );
  PostMessage( WM_CONNECT, 0, 0L );
}

LRESULT TSerialWindow::EvConnect(WPARAM,LPARAM)
{
  if( !::Connect( HWindow ) )
	 CloseWindow();
}

void TSerialWindow::EvCommNotify( UINT idDevice, UINT NotifyStatus )
{
  ::ProcessCommNotify( HWindow, (int)idDevice, (int)NotifyStatus );
  ::CheckComPort( idDevice, NULL );
}

void TSerialWindow::EvUserDisconnect()
{
  CloseWindow();
}

void TSerialWindow::EvSetFocus(HWND)
{
  TTYSetFocus( );
}

void TSerialWindow::EvKillFocus(HWND)
{
  HideCaret( );
  DestroyCaret( );
}

void TSerialWindow::EvKeyDown(UINT key, UINT repeatCount, UINT flags)
{
  switch( key )
  {
	 case VK_RETURN:
	 {
		WriteComPort( nActiveComPort, "\r", 1 );
		CheckComPort( nActiveComPort, NULL );
		if( bEcho )
		  TTYWriteScreen( "\r\n" );
		break;
	 }
	 default: DefaultProcessing();
  }
}

void TSerialWindow::EvChar(UINT key,UINT repeatcount,UINT flags)
{
  char szTemp[2];
  
  switch( key )
  {
	 case '\r':
	 case '\n':
		break;
	 default:
		szTemp[0] = (char)key;
		szTemp[1] = '\0';
		WriteComPort( nActiveComPort, szTemp, 1 );
		CheckComPort( nActiveComPort, NULL );
		if( bEcho )
		  TTYWriteScreen( szTemp );
		break;
  }
}

void TSerialWindow::CleanupWindow()
{
  Disconnect();
}

DEFINE_RESPONSE_TABLE1( TSerialWindow, TFrameWindow )
  EV_WM_CHAR,
  EV_WM_COMMNOTIFY,
  EV_WM_KEYDOWN,
  EV_WM_KILLFOCUS,
  EV_WM_SETFOCUS,
  EV_MESSAGE( WM_CONNECT, EvConnect ),
  EV_COMMAND( USER_DISCONNECT, EvUserDisconnect ),
END_RESPONSE_TABLE;

